/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.keycloak.marshalling.Marshalling;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;

public class ReplaceFunction<K, T extends SessionEntity>
implements BiFunction<K, SessionEntityWrapper<T>, SessionEntityWrapper<T>> {
    public static final AdvancedExternalizer<ReplaceFunction> INSTANCE = new Externalizer();
    private final UUID expectedVersion;
    private final SessionEntityWrapper<T> newValue;

    public ReplaceFunction(UUID expectedVersion, SessionEntityWrapper<T> newValue) {
        this.expectedVersion = Objects.requireNonNull(expectedVersion);
        this.newValue = Objects.requireNonNull(newValue);
    }

    @Override
    public SessionEntityWrapper<T> apply(K key, SessionEntityWrapper<T> currentValue) {
        assert (currentValue != null);
        return this.expectedVersion.equals(currentValue.getVersion()) ? this.newValue : currentValue;
    }

    private static class Externalizer
    implements AdvancedExternalizer<ReplaceFunction> {
        private static final SessionEntityWrapper.ExternalizerImpl EXTERNALIZER = new SessionEntityWrapper.ExternalizerImpl();
        private static final byte VERSION_1 = 1;

        private Externalizer() {
        }

        public Set<Class<? extends ReplaceFunction>> getTypeClasses() {
            return Set.of(ReplaceFunction.class);
        }

        public Integer getId() {
            return Marshalling.REPLACE_FUNCTION_ID;
        }

        public void writeObject(ObjectOutput output, ReplaceFunction object) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallUUID((UUID)object.expectedVersion, (ObjectOutput)output, (boolean)false);
            EXTERNALIZER.writeObject(output, object.newValue);
        }

        public ReplaceFunction<?, ?> readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            byte version = input.readByte();
            if (version != 1) {
                throw new IOException("Invalid version: " + version);
            }
            return new ReplaceFunction(MarshallUtil.unmarshallUUID((ObjectInput)input, (boolean)false), EXTERNALIZER.readObject(input));
        }
    }
}

