[![Github Tag](https://img.shields.io/github/tag/Icinga/icinga2.svg)](https://github.com/Icinga/icinga2)

# Icinga 2

![Icinga Logo](https://icinga.com/wp-content/uploads/2014/06/icinga_logo.png)

#### Table of Contents

1. [About][About]
2. [Installation][Installation]
3. [Documentation][Documentation]
4. [Support][Support]
5. [License][License]
6. [Contributing][Contributing]

## About

[Icinga](https://icinga.com/products/) is a monitoring system which checks
the availability of your network resources, notifies users of outages, and generates
performance data for reporting.

Scalable and extensible, Icinga can monitor large, complex environments across
multiple locations.

Icinga 2 is the monitoring server and requires [Icinga Web 2](https://icinga.com/products/)
on top in your Icinga Stack. The [configuration](https://icinga.com/products/configuration/)
can be easily managed with either the [Icinga Director](https://icinga.com/docs/director/latest/),
config management tools or plain text within the [Icinga DSL](https://icinga.com/docs/icinga2/latest/doc/17-language-reference/).

![Icinga Dashboard](https://icinga.com/wp-content/uploads/2017/12/icingaweb2-2.5.0-dashboard.png)

## Installation

* [Installation](https://icinga.com/docs/icinga2/latest/doc/02-installation/)
* [Monitoring Basics](https://icinga.com/docs/icinga2/latest/doc/03-monitoring-basics/)
* [Configuration](https://icinga.com/docs/icinga2/latest/doc/04-configuration/)
* [Distributed Monitoring](https://icinga.com/docs/icinga2/latest/doc/06-distributed-monitoring/)
* [Addons, Integrations and Features](https://icinga.com/docs/icinga2/latest/doc/13-addons/)
* [Troubleshooting](https://icinga.com/docs/icinga2/latest/doc/15-troubleshooting/)
* [Upgrading](https://icinga.com/docs/icinga2/latest/doc/16-upgrading-icinga-2/)

Once Icinga Server and Web are running in your distributed environment,
make sure to check out the many [Icinga modules](https://icinga.com/docs/)
for even better monitoring.

## Documentation

The documentation is available on [icinga.com/docs](https://icinga.com/docs/icinga2/latest/).

## Support

Check the [project website](https://icinga.com) for status updates. Join the
[community channels](https://icinga.com/community/) for questions
or ask an Icinga partner for [professional support](https://icinga.com/support/).

## License

Icinga 2 and the Icinga 2 documentation are licensed under the terms of the GNU
General Public License Version 2, you will find a copy of this license in the
COPYING file included in the source package.

In addition, as a special exception, the copyright holders give
permission to link the code of portions of this program with the
OpenSSL library under certain conditions as described in each
individual source file, and distribute linked combinations including
the two.

You must obey the GNU General Public License in all respects for all
of the code used other than OpenSSL. If you modify file(s) with this
exception, you may extend this exception to your version of the
file(s), but you are not obligated to do so. If you do not wish to do
so, delete this exception statement from your version. If you delete
this exception statement from all source files in the program, then
also delete it here.

## Contributing

There are many ways to contribute to Icinga -- whether it be sending patches,
testing, reporting bugs, or reviewing and updating the documentation. Every
contribution is appreciated!

Please continue reading in the [contributing chapter](CONTRIBUTING.md).

If you are a packager, please read the [development chapter](https://icinga.com/docs/icinga2/latest/doc/21-development/)
for more details.

### Security Issues

For reporting security issues please visit [this page](https://icinga.com/contact/security/).

<!-- TOC URLs -->
[About]: #about
[License]: #license
[Installation]: #installation
[Documentation]: #documentation
[Support]: #support
[Contributing]: #contributing
