/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import net.i2p.I2PAppContext;
import net.i2p.crypto.Blinding;
import net.i2p.crypto.ChaCha20;
import net.i2p.crypto.DSAEngine;
import net.i2p.crypto.EncType;
import net.i2p.crypto.HKDF;
import net.i2p.crypto.KeyPair;
import net.i2p.crypto.SHA256Generator;
import net.i2p.crypto.SigType;
import net.i2p.crypto.x25519.X25519DH;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.Lease;
import net.i2p.data.LeaseSet2;
import net.i2p.data.MetaLeaseSet;
import net.i2p.data.PrivateKey;
import net.i2p.data.PublicKey;
import net.i2p.data.SessionKey;
import net.i2p.data.Signature;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.data.SimpleDataStructure;
import net.i2p.util.ByteArrayStream;
import net.i2p.util.Clock;
import net.i2p.util.HexDump;
import net.i2p.util.Log;

public class EncryptedLeaseSet
extends LeaseSet2 {
    private byte[] _encryptedData;
    private LeaseSet2 _decryptedLS2;
    private Hash __calculatedHash;
    private SigningPrivateKey _alpha;
    private SigningPublicKey _unblindedSPK;
    private String _secret;
    private PrivateKey _clientPrivateKey;
    private final Log _log = I2PAppContext.getGlobalContext().logManager().getLog(EncryptedLeaseSet.class);
    private int _authType;
    private int _numKeys;
    private static final int MIN_ENCRYPTED_SIZE = 24;
    private static final int MAX_ENCRYPTED_SIZE = 4096;
    private static final int SALT_LEN = 32;
    private static final byte[] CREDENTIAL = DataHelper.getASCII("credential");
    private static final byte[] SUBCREDENTIAL = DataHelper.getASCII("subcredential");
    private static final String ELS2L1K = "ELS2_L1K";
    private static final String ELS2L2K = "ELS2_L2K";
    private static final String ELS2_DH = "ELS2_XCA";
    private static final String ELS2_PSK = "ELS2PSKA";
    private static final int IV_LEN = 12;
    private static final int ID_LEN = 8;
    private static final int COOKIE_LEN = 32;
    private static final int CLIENT_LEN = 40;

    public LeaseSet2 getDecryptedLeaseSet() {
        return this._decryptedLS2;
    }

    public void setSecret(String secret) {
        if (this._signingKey != null && !DataHelper.eq(secret, this._secret) && this._log.shouldWarn()) {
            this._log.warn("setSecret() after setSigningKey() was: " + this._secret + " now: " + secret);
        }
        this._secret = secret;
    }

    public void setClientPrivateKey(PrivateKey privKey) {
        this._clientPrivateKey = privKey;
    }

    @Override
    public int getType() {
        return this._signature != null ? 5 : 3;
    }

    @Override
    public int getLeaseCount() {
        return this._decryptedLS2 != null ? this._decryptedLS2.getLeaseCount() : 0;
    }

    @Override
    public Lease getLease(int index) {
        return this._decryptedLS2 != null ? this._decryptedLS2.getLease(index) : null;
    }

    @Override
    public List<PublicKey> getEncryptionKeys() {
        if (this._decryptedLS2 != null) {
            return this._decryptedLS2.getEncryptionKeys();
        }
        return super.getEncryptionKeys();
    }

    @Override
    public PublicKey getEncryptionKey(Set<EncType> supported) {
        if (this._decryptedLS2 != null) {
            return this._decryptedLS2.getEncryptionKey(supported);
        }
        return super.getEncryptionKey(supported);
    }

    @Override
    public void setDestination(Destination dest) {
        if (this._signature != null && this._destination != null) {
            if (!dest.equals(this._destination)) {
                throw new IllegalStateException();
            }
        } else {
            this._destination = dest;
        }
        SigningPublicKey spk = dest.getSigningPublicKey();
        this.setSigningKey(spk);
    }

    @Override
    public void setSigningKey(SigningPublicKey spk) {
        SigType type = spk.getType();
        if (type != SigType.EdDSA_SHA512_Ed25519 && type != SigType.RedDSA_SHA512_Ed25519) {
            throw new IllegalArgumentException();
        }
        if (this._unblindedSPK != null) {
            if (!this._unblindedSPK.equals(spk)) {
                throw new IllegalArgumentException("unblinded pubkey mismatch");
            }
        } else {
            this._unblindedSPK = spk;
        }
        SigningPublicKey bpk = this.blind(spk);
        if (this._signingKey == null) {
            this._signingKey = bpk;
        } else if (!this._signingKey.equals(bpk)) {
            throw new IllegalArgumentException("blinded pubkey mismatch:\nas received:   " + this._signingKey + "\nas calculated: " + bpk);
        }
    }

    private SigningPublicKey blind(SigningPublicKey spk) {
        I2PAppContext ctx = I2PAppContext.getGlobalContext();
        this._alpha = this._published <= 0L ? Blinding.generateAlpha(ctx, spk, this._secret) : Blinding.generateAlpha(ctx, spk, this._secret, this._published);
        SigningPublicKey rv = Blinding.blind(spk, this._alpha);
        if (this._log.shouldDebug()) {
            this._log.debug("Blind:\norig:    " + spk + "\nsecret:  " + this._secret + "\nalpha:   " + this._alpha + "\nblinded: " + rv);
        }
        return rv;
    }

    @Override
    protected SigningPublicKey getSigningPublicKey() {
        return this._signingKey;
    }

    @Override
    public void readBytes(InputStream in) throws DataFormatException, IOException {
        if (this._signingKey != null) {
            throw new IllegalStateException();
        }
        this.readHeader(in);
        int encryptedSize = (int)DataHelper.readLong(in, 2);
        if (encryptedSize < 24 || encryptedSize > 4096) {
            throw new DataFormatException("bad LS size: " + encryptedSize);
        }
        this._encryptedData = new byte[encryptedSize];
        DataHelper.read(in, this._encryptedData);
        SigType type = this.isOffline() ? this._transientSigningPublicKey.getType() : this._signingKey.getType();
        this._signature = new Signature(type);
        this._signature.readBytes(in);
    }

    @Override
    protected void writeBytesWithoutSig(OutputStream out) throws DataFormatException, IOException {
        if (this._signingKey == null) {
            throw new DataFormatException("Not enough data to write out a LeaseSet");
        }
        if (this._encryptedData == null) {
            super.writeHeader(out);
            this.writeBody(out);
        } else {
            this.writeHeader(out);
            DataHelper.writeLong(out, 2, this._encryptedData.length);
            out.write(this._encryptedData);
        }
    }

    @Override
    public boolean verifyOfflineSignature() {
        return this.verifyOfflineSignature(this._signingKey);
    }

    @Override
    protected void readHeader(InputStream in) throws DataFormatException, IOException {
        int stype = (int)DataHelper.readLong(in, 2);
        SigType type = SigType.getByCode(stype);
        if (type == null) {
            throw new DataFormatException("unknown key type " + stype);
        }
        this._signingKey = new SigningPublicKey(type);
        this._signingKey.readBytes(in);
        this._published = DataHelper.readLong(in, 4) * 1000L;
        this._expires = this._published + DataHelper.readLong(in, 2) * 1000L;
        this._flags = (int)DataHelper.readLong(in, 2);
        if (this.isOffline()) {
            this.readOfflineBytes(in);
        }
    }

    @Override
    protected void writeHeader(OutputStream out) throws DataFormatException, IOException {
        DataHelper.writeLong(out, 2, this._signingKey.getType().getCode());
        this._signingKey.writeBytes(out);
        if (this._published <= 0L) {
            this._published = Clock.getInstance().now();
        }
        DataHelper.writeLong(out, 4, this._published / 1000L);
        DataHelper.writeLong(out, 2, (this._expires - this._published) / 1000L);
        DataHelper.writeLong(out, 2, this._flags);
        if (this.isOffline()) {
            this.writeOfflineBytes(out);
        }
    }

    @Override
    protected void readOfflineBytes(InputStream in) throws DataFormatException, IOException {
        this._transientExpires = DataHelper.readLong(in, 4) * 1000L;
        int itype = (int)DataHelper.readLong(in, 2);
        SigType type = SigType.getByCode(itype);
        if (type == null) {
            throw new DataFormatException("Unknown sig type " + itype);
        }
        this._transientSigningPublicKey = new SigningPublicKey(type);
        this._transientSigningPublicKey.readBytes(in);
        SigType stype = this._signingKey.getType();
        this._offlineSignature = new Signature(stype);
        this._offlineSignature.readBytes(in);
    }

    @Override
    protected void writeOfflineBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._transientSigningPublicKey == null || this._offlineSignature == null) {
            throw new DataFormatException("No offline key/sig");
        }
        DataHelper.writeLong(out, 4, this._transientExpires / 1000L);
        DataHelper.writeLong(out, 2, this._signingKey.getType().getCode());
        this._transientSigningPublicKey.writeBytes(out);
        this._offlineSignature.writeBytes(out);
    }

    @Override
    public int size() {
        int rv = this._signingKey.length() + 12;
        rv = this._encryptedData != null ? (rv += this._encryptedData.length) : (rv += 99);
        if (this.isOffline()) {
            rv += 6 + this._transientSigningPublicKey.length() + this._offlineSignature.length();
        }
        return rv;
    }

    @Override
    public Hash getHash() {
        if (this.__calculatedHash == null) {
            if (this._signingKey == null) {
                throw new IllegalStateException();
            }
            int len = this._signingKey.length();
            byte[] b = new byte[2 + len];
            DataHelper.toLong(b, 0, 2, this._signingKey.getType().getCode());
            System.arraycopy(this._signingKey.getData(), 0, b, 2, len);
            this.__calculatedHash = SHA256Generator.getInstance().calculateHash(b);
        }
        return this.__calculatedHash;
    }

    @Override
    public void encrypt(SessionKey skey) {
        this.encrypt(0, null);
    }

    public void encrypt(int authType, List<? extends SimpleDataStructure> clientKeys) {
        byte[] authInput;
        int authLen;
        if (this._encryptedData != null) {
            throw new IllegalStateException("already encrypted");
        }
        if (this._signature == null) {
            throw new IllegalStateException("not signed");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(3);
            super.writeHeader(baos);
            this.writeBody(baos);
            this._signature.writeBytes(baos);
        }
        catch (DataFormatException dfe) {
            throw new IllegalStateException("Error encrypting LS2", dfe);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Error encrypting LS2", ioe);
        }
        I2PAppContext ctx = I2PAppContext.getGlobalContext();
        byte[] salt = new byte[32];
        ctx.random().nextBytes(salt);
        HKDF hkdf = new HKDF(ctx);
        byte[] key = new byte[32];
        byte[] iv = new byte[32];
        this._authType = authType;
        if (authType == 0) {
            authLen = 1;
        } else if (authType == 1 || authType == 3) {
            if (clientKeys == null || clientKeys.isEmpty()) {
                throw new IllegalArgumentException("No client keys provided");
            }
            this._numKeys = clientKeys.size();
            authLen = 35 + clientKeys.size() * 40;
        } else {
            throw new IllegalArgumentException("Bad auth type " + authType);
        }
        byte[] authcookie = null;
        if (authType == 0) {
            authInput = this.getHKDFInput(ctx);
        } else {
            authcookie = new byte[32];
            ctx.random().nextBytes(authcookie);
            if (this._log.shouldDebug()) {
                this._log.debug("Auth Cookie:\n" + HexDump.dump(authcookie));
            }
            authInput = this.getHKDFInput(ctx, authcookie);
        }
        if (this._log.shouldDebug()) {
            this._log.debug("Inner HKDF salt:\n" + HexDump.dump(salt) + "Inner HKDF input:\n" + HexDump.dump(authInput));
        }
        hkdf.calculate(salt, authInput, ELS2L2K, key, iv, 0);
        byte[] plaintext = baos.toByteArray();
        byte[] ciphertext = new byte[authLen + 32 + plaintext.length];
        if (authType == 0) {
            ciphertext[0] = 0;
        } else {
            ciphertext[0] = (byte)(authType & 0xF);
            if (clientKeys.size() > 1) {
                Collections.shuffle(clientKeys);
            }
            if (authType == 1) {
                KeyPair encKeys = ctx.keyGenerator().generatePKIKeys(EncType.ECIES_X25519);
                PrivateKey esk = encKeys.getPrivate();
                PublicKey epk = encKeys.getPublic();
                byte[] clientAuthInput = new byte[32 + authInput.length];
                System.arraycopy(authInput, 32, clientAuthInput, 64, 36);
                System.arraycopy(epk.getData(), 0, ciphertext, 1, 32);
                DataHelper.toLong(ciphertext, 33, 2, clientKeys.size());
                int off = 35;
                byte[] byArray = new byte[32];
                byte[] clientIVandID = new byte[32];
                for (SimpleDataStructure simpleDataStructure : clientKeys) {
                    if (!(simpleDataStructure instanceof PublicKey)) {
                        throw new IllegalArgumentException("Bad DH client key type: " + simpleDataStructure);
                    }
                    PublicKey cpk = (PublicKey)simpleDataStructure;
                    if (cpk.getType() != EncType.ECIES_X25519) {
                        throw new IllegalArgumentException("Bad DH client key type: " + cpk);
                    }
                    SessionKey dh = X25519DH.dh(esk, cpk);
                    System.arraycopy(dh.getData(), 0, clientAuthInput, 0, 32);
                    System.arraycopy(cpk.getData(), 0, clientAuthInput, 32, 32);
                    hkdf.calculate(epk.getData(), clientAuthInput, ELS2_DH, byArray, clientIVandID, 0);
                    System.arraycopy(clientIVandID, 12, ciphertext, off, 8);
                    ChaCha20.encrypt(byArray, clientIVandID, authcookie, 0, ciphertext, off += 8, authcookie.length);
                    if (this._log.shouldDebug()) {
                        this._log.debug("DH: Added client ID/enc.cookie:\n" + HexDump.dump(clientIVandID, 12, 8) + HexDump.dump(ciphertext, off, 32) + "for client key:\n" + HexDump.dump(byArray));
                    }
                    off += 32;
                }
            } else {
                byte[] authsalt = new byte[32];
                ctx.random().nextBytes(authsalt);
                System.arraycopy(authsalt, 0, ciphertext, 1, 32);
                DataHelper.toLong(ciphertext, 33, 2, clientKeys.size());
                int off = 35;
                byte[] clientKey = new byte[32];
                byte[] clientIVandID = new byte[32];
                for (SimpleDataStructure simpleDataStructure : clientKeys) {
                    if (!(simpleDataStructure instanceof PrivateKey)) {
                        throw new IllegalArgumentException("Bad PSK client key type: " + simpleDataStructure);
                    }
                    PrivateKey csk = (PrivateKey)simpleDataStructure;
                    if (csk.getType() != EncType.ECIES_X25519) {
                        throw new IllegalArgumentException("Bad PSK client key type: " + csk);
                    }
                    System.arraycopy(csk.getData(), 0, authInput, 0, 32);
                    hkdf.calculate(authsalt, authInput, ELS2_PSK, clientKey, clientIVandID, 0);
                    System.arraycopy(clientIVandID, 12, ciphertext, off, 8);
                    ChaCha20.encrypt(clientKey, clientIVandID, authcookie, 0, ciphertext, off += 8, authcookie.length);
                    if (this._log.shouldDebug()) {
                        this._log.debug("PSK: Added client key:\n" + HexDump.dump(clientKey) + "client IV:\n:" + HexDump.dump(clientIVandID, 0, 12) + "client ID:\n:" + HexDump.dump(clientIVandID, 12, 8) + "client cookie:\n:" + HexDump.dump(ciphertext, off, 32));
                    }
                    off += 32;
                }
            }
        }
        System.arraycopy(salt, 0, ciphertext, authLen, 32);
        ChaCha20.encrypt(key, iv, plaintext, 0, ciphertext, authLen + 32, plaintext.length);
        if (this._log.shouldDebug()) {
            this._log.debug("Encrypt: inner plaintext:\n" + HexDump.dump(plaintext));
            this._log.debug("Encrypt: inner ciphertext:\n" + HexDump.dump(ciphertext));
        }
        ctx.random().nextBytes(salt);
        if (authType == 0) {
            hkdf.calculate(salt, authInput, ELS2L1K, key, iv, 0);
        } else {
            byte[] l1Input = new byte[36];
            System.arraycopy(authInput, 32, l1Input, 0, 36);
            hkdf.calculate(salt, l1Input, ELS2L1K, key, iv, 0);
        }
        plaintext = ciphertext;
        ciphertext = new byte[32 + plaintext.length];
        System.arraycopy(salt, 0, ciphertext, 0, 32);
        if (this._log.shouldDebug()) {
            this._log.debug("Encrypt: chacha20 key:\n" + HexDump.dump(key));
            this._log.debug("Encrypt: chacha20 IV:\n" + HexDump.dump(iv));
        }
        ChaCha20.encrypt(key, iv, plaintext, 0, ciphertext, 32, plaintext.length);
        if (this._log.shouldDebug()) {
            this._log.debug("Encrypt: outer ciphertext:\n" + HexDump.dump(ciphertext));
        }
        this._encryptedData = ciphertext;
    }

    private void decrypt(PrivateKey csk) throws DataFormatException, IOException {
        try {
            this.x_decrypt(csk);
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new DataFormatException("ioobe", ioobe);
        }
    }

    private void x_decrypt(PrivateKey csk) throws DataFormatException, IOException {
        LeaseSet2 innerLS2;
        ByteArrayInputStream bais;
        int type;
        int authLen;
        int authType;
        if (this._encryptedData == null) {
            throw new IllegalStateException("not encrypted");
        }
        if (this._decryptedLS2 != null) {
            return;
        }
        I2PAppContext ctx = I2PAppContext.getGlobalContext();
        byte[] authInput = this.getHKDFInput(ctx);
        HKDF hkdf = new HKDF(ctx);
        byte[] key = new byte[32];
        byte[] iv = new byte[32];
        byte[] ciphertext = this._encryptedData;
        byte[] plaintext = new byte[ciphertext.length - 32];
        hkdf.calculate(ciphertext, authInput, ELS2L1K, key, iv, 0);
        if (this._log.shouldDebug()) {
            this._log.debug("Decrypt: chacha20 key:\n" + HexDump.dump(key));
            this._log.debug("Decrypt: chacha20 IV:\n" + HexDump.dump(iv));
        }
        ChaCha20.decrypt(key, iv, ciphertext, 32, plaintext, 0, plaintext.length);
        if (this._log.shouldDebug()) {
            this._log.debug("Decrypt: outer ciphertext:\n" + HexDump.dump(ciphertext));
            this._log.debug("Decrypt: outer plaintext:\n" + HexDump.dump(plaintext));
        }
        this._authType = authType = plaintext[0] & 0xF;
        if (authType == 0) {
            authLen = 1;
        } else {
            int count;
            if (csk == null) {
                throw new DataFormatException("Per-client auth but no key");
            }
            if (authType != 1 && authType != 3) {
                throw new DataFormatException("Per-client auth unsupported type: " + authType);
            }
            if (csk.getType() != EncType.ECIES_X25519) {
                throw new DataFormatException("Bad PSK client key type: " + csk);
            }
            byte[] seed = new byte[32];
            System.arraycopy(plaintext, 1, seed, 0, 32);
            this._numKeys = count = (int)DataHelper.fromLong(plaintext, 33, 2);
            if (count == 0) {
                throw new DataFormatException("No client entries");
            }
            authLen = 35 + count * 40;
            if (this._log.shouldDebug()) {
                this._log.debug("Auth type " + authType + ", found " + count + " client entries, authsalt is:\n" + HexDump.dump(seed));
            }
            byte[] clientKey = new byte[32];
            byte[] clientIVandID = new byte[32];
            if (authType == 1) {
                PublicKey epk = new PublicKey(EncType.ECIES_X25519, seed);
                SessionKey dh = X25519DH.dh(csk, epk);
                byte[] clientAuthInput = new byte[64 + authInput.length];
                System.arraycopy(dh.getData(), 0, clientAuthInput, 0, 32);
                PublicKey cpk = csk.toPublic();
                System.arraycopy(cpk.getData(), 0, clientAuthInput, 32, 32);
                System.arraycopy(authInput, 0, clientAuthInput, 64, 36);
                hkdf.calculate(seed, clientAuthInput, ELS2_DH, clientKey, clientIVandID, 0);
            } else {
                byte[] clientAuthInput = new byte[32 + authInput.length];
                System.arraycopy(csk.getData(), 0, clientAuthInput, 0, 32);
                System.arraycopy(authInput, 0, clientAuthInput, 32, 36);
                hkdf.calculate(seed, clientAuthInput, ELS2_PSK, clientKey, clientIVandID, 0);
            }
            if (this._log.shouldDebug()) {
                this._log.debug("Looking for client ID:\n" + HexDump.dump(clientIVandID, 12, 8) + "for client key:\n" + HexDump.dump(clientKey));
            }
            int off = 35;
            byte[] clientCookie = null;
            for (int i = 0; i < count; ++i) {
                if (DataHelper.eq(clientIVandID, 12, plaintext, off, 8)) {
                    clientCookie = new byte[32];
                    System.arraycopy(plaintext, off + 8, clientCookie, 0, 32);
                    break;
                }
                off += 40;
            }
            if (clientCookie == null) {
                throw new DataFormatException("Our client auth entry not found");
            }
            if (this._log.shouldDebug()) {
                this._log.debug("Found client cookie:\n" + HexDump.dump(clientCookie));
            }
            byte[] clientAuthInput = new byte[32 + authInput.length];
            System.arraycopy(authInput, 0, clientAuthInput, 32, 36);
            ChaCha20.decrypt(clientKey, clientIVandID, clientCookie, 0, clientAuthInput, 0, 32);
            if (this._log.shouldDebug()) {
                this._log.debug("Decrypted client cookie:\n" + HexDump.dump(clientAuthInput, 0, 32));
            }
            authInput = clientAuthInput;
        }
        ciphertext = plaintext;
        plaintext = new byte[ciphertext.length - (authLen + 32)];
        byte[] salt = new byte[32];
        System.arraycopy(ciphertext, authLen, salt, 0, 32);
        if (this._log.shouldDebug()) {
            this._log.debug("Inner HKDF salt:\n" + HexDump.dump(salt) + "Inner HKDF input:\n" + HexDump.dump(authInput));
        }
        hkdf.calculate(salt, authInput, ELS2L2K, key, iv, 0);
        ChaCha20.decrypt(key, iv, ciphertext, authLen + 32, plaintext, 0, plaintext.length);
        if (this._log.shouldDebug()) {
            this._log.debug("Decrypt: inner plaintext:\n" + HexDump.dump(plaintext));
        }
        if ((type = (bais = new ByteArrayInputStream(plaintext)).read()) == 3) {
            innerLS2 = new LeaseSet2();
        } else if (type == 7) {
            innerLS2 = new MetaLeaseSet();
        } else {
            throw new DataFormatException("Bad decryption or unsupported LS type: " + type);
        }
        innerLS2.readBytes(bais);
        this._decryptedLS2 = innerLS2;
    }

    private byte[] getHKDFInput(I2PAppContext ctx) {
        byte[] subcredential = this.getSubcredential(ctx);
        byte[] rv = new byte[subcredential.length + 4];
        System.arraycopy(subcredential, 0, rv, 0, subcredential.length);
        DataHelper.toLong(rv, subcredential.length, 4, this._published / 1000L);
        return rv;
    }

    private byte[] getHKDFInput(I2PAppContext ctx, byte[] authcookie) {
        byte[] subcredential = this.getSubcredential(ctx);
        byte[] rv = new byte[authcookie.length + subcredential.length + 4];
        System.arraycopy(authcookie, 0, rv, 0, authcookie.length);
        System.arraycopy(subcredential, 0, rv, authcookie.length, subcredential.length);
        DataHelper.toLong(rv, authcookie.length + subcredential.length, 4, this._published / 1000L);
        return rv;
    }

    private byte[] getSubcredential(I2PAppContext ctx) {
        if (this._unblindedSPK == null) {
            throw new IllegalStateException("no known SPK to decrypt with");
        }
        int spklen = this._unblindedSPK.length();
        byte[] in = new byte[spklen + 4];
        System.arraycopy(this._unblindedSPK.getData(), 0, in, 0, spklen);
        DataHelper.toLong(in, spklen, 2, this._unblindedSPK.getType().getCode());
        DataHelper.toLong(in, spklen + 2, 2, SigType.RedDSA_SHA512_Ed25519.getCode());
        byte[] credential = EncryptedLeaseSet.hash(ctx, CREDENTIAL, in);
        byte[] spk = this._signingKey.getData();
        byte[] tmp = new byte[credential.length + spk.length];
        System.arraycopy(credential, 0, tmp, 0, credential.length);
        System.arraycopy(spk, 0, tmp, credential.length, spk.length);
        return EncryptedLeaseSet.hash(ctx, SUBCREDENTIAL, tmp);
    }

    private static byte[] hash(I2PAppContext ctx, byte[] p, byte[] d) {
        byte[] data = new byte[p.length + d.length];
        System.arraycopy(p, 0, data, 0, p.length);
        System.arraycopy(d, 0, data, p.length, d.length);
        byte[] rv = new byte[32];
        ctx.sha().calculateHash(data, 0, data.length, rv, 0);
        return rv;
    }

    @Override
    public void sign(SigningPrivateKey key) throws DataFormatException {
        this.sign(key, 0, null);
    }

    public void sign(SigningPrivateKey key, int authType, List<? extends SimpleDataStructure> clientKeys) throws DataFormatException {
        int saveFlags = this._flags;
        this.setUnpublished();
        this.setBlindedWhenPublished();
        super.sign(key);
        if (this._log.shouldDebug()) {
            this._log.debug("Created inner: " + super.toString());
            this._log.debug("Sign inner with key: " + (Object)((Object)key.getType()) + ' ' + key.toBase64());
            this._log.debug("Corresponding pubkey: " + key.toPublic());
            this._log.debug("Inner sig: " + (Object)((Object)this._signature.getType()) + ' ' + this._signature.toBase64());
        }
        this.encrypt(authType, clientKeys);
        this._flags = saveFlags;
        SigningPrivateKey bkey = Blinding.blind(key, this._alpha);
        int len = this.size();
        ByteArrayStream out = new ByteArrayStream(1 + len);
        try {
            out.write(this.getType());
            this.writeBytesWithoutSig(out);
        }
        catch (IOException ioe) {
            throw new DataFormatException("Signature failed", ioe);
        }
        byte[] data = out.toByteArray();
        this._signature = DSAEngine.getInstance().sign(data, bkey);
        if (this._signature == null) {
            throw new DataFormatException("Signature failed with " + (Object)((Object)key.getType()) + " key");
        }
        if (this._log.shouldDebug()) {
            this._log.debug("Sign outer with key: " + (Object)((Object)bkey.getType()) + ' ' + bkey.toBase64());
            this._log.debug("Corresponding pubkey: " + bkey.toPublic());
            this._log.debug("Outer sig: " + (Object)((Object)this._signature.getType()) + ' ' + this._signature.toBase64());
        }
    }

    @Override
    public boolean verifySignature() {
        return this.verifySignature(this._clientPrivateKey);
    }

    public boolean verifySignature(PrivateKey clientKey) {
        boolean rv;
        if (this._decryptedLS2 != null) {
            return this._decryptedLS2.verifySignature();
        }
        if (this._log.shouldDebug()) {
            this._log.debug("Sig verify outer with key: " + (Object)((Object)this._signingKey.getType()) + ' ' + this._signingKey.toBase64());
            this._log.debug("Outer sig: " + (Object)((Object)this._signature.getType()) + ' ' + this._signature.toBase64());
        }
        if (!super.verifySignature()) {
            this._log.warn("ELS2 outer sig verify fail");
            return false;
        }
        this._log.info("ELS2 outer sig verify success");
        if (this._unblindedSPK == null) {
            if (this._log.shouldWarn()) {
                this._log.warn("ELS2 no dest/SPK to decrypt with", new Exception("I did it"));
            }
            return true;
        }
        try {
            this.decrypt(clientKey);
        }
        catch (DataFormatException dfe) {
            this._log.warn("ELS2 decrypt fail", dfe);
            return false;
        }
        catch (IOException ioe) {
            this._log.warn("ELS2 decrypt fail", ioe);
            return false;
        }
        if (this._log.shouldDebug()) {
            this._log.debug("Decrypted inner LS2:\n" + this._decryptedLS2);
            this._log.debug("Sig verify inner with key: " + (Object)((Object)this._decryptedLS2.getDestination().getSigningPublicKey().getType()) + ' ' + this._decryptedLS2.getDestination().getSigningPublicKey().toBase64());
            this._log.debug("Inner sig: " + (Object)((Object)this._decryptedLS2.getSignature().getType()) + ' ' + this._decryptedLS2.getSignature().toBase64());
        }
        if (!(rv = this._decryptedLS2.verifySignature())) {
            this._log.warn("ELS2 inner sig verify fail");
        } else {
            this._log.info("ELS2 inner sig verify success");
        }
        return rv;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof EncryptedLeaseSet)) {
            return false;
        }
        EncryptedLeaseSet ls = (EncryptedLeaseSet)object;
        return DataHelper.eq(this._signature, ls.getSignature()) && DataHelper.eq(this._signingKey, ls.getSigningKey());
    }

    @Override
    public int hashCode() {
        if (this._encryptionKey == null) {
            return 0;
        }
        return this._encryptionKey.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("[EncryptedLeaseSet: ");
        if (this._signingKey != null) {
            buf.append("\n\tBlinded Key: ").append(this._signingKey);
            Hash h = this.getHash();
            buf.append("\n\tHash: ").append(h);
            buf.append("\n\tB32: ").append(h.toBase32());
        }
        if (this.isOffline()) {
            buf.append("\n\tTransient Key: ").append(this._transientSigningPublicKey);
            buf.append("\n\tTransient Expires: ").append(new Date(this._transientExpires));
            buf.append("\n\tOffline Signature: ").append(this._offlineSignature);
        }
        buf.append("\n\tUnpublished? ").append(this.isUnpublished());
        buf.append("\n\tLength: ").append(this._encryptedData.length);
        buf.append("\n\tSignature: ").append(this._signature);
        buf.append("\n\tPublished: ").append(new Date(this._published));
        buf.append("\n\tExpires: ").append(new Date(this._expires));
        buf.append("\n\tAuth Type: ").append(this._authType);
        buf.append("\n\tClient Keys: ").append(this._numKeys);
        if (this._decryptedLS2 != null) {
            if (this._secret != null) {
                buf.append("\n\tSecret: ").append(this._secret);
            }
            if (this._clientPrivateKey != null) {
                buf.append("\n\tClient Private Key: ").append(this._clientPrivateKey.toBase64());
            }
            buf.append("\n\tDecrypted LS:\n").append(this._decryptedLS2);
        } else if (this._destination != null) {
            buf.append("\n\tDestination: ").append(this._destination);
            buf.append("\n\tLeases: #").append(this.getLeaseCount());
            for (int i = 0; i < this.getLeaseCount(); ++i) {
                buf.append("\n\t\t").append(this.getLease(i));
            }
        } else {
            buf.append("\n\tNot decrypted");
        }
        buf.append("]");
        return buf.toString();
    }
}

