/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.vocab;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.messages.LocalizedMessages;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.vocab.EnumVocab;
import com.adobe.epubcheck.vocab.PrefixDeclarationParser;
import com.adobe.epubcheck.vocab.Property;
import com.adobe.epubcheck.vocab.UncheckedVocab;
import com.adobe.epubcheck.vocab.Vocab;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class VocabUtil {
    public static Vocab EMPTY_VOCAB = new EnumVocab<EMPTY>(EMPTY.class, "");
    private static Pattern propertyPattern = Pattern.compile("(([^:]*):)?(.*)");
    private static Splitter whitespaceSplitter = Splitter.onPattern((String)"\\s+").omitEmptyStrings();

    public static Optional<Property> parseProperty(String value, Map<String, Vocab> vocabs, ValidationContext context, EPUBLocation location) {
        return Optional.fromNullable((Object)((Property)Iterables.get(VocabUtil.parseProperties(value, vocabs, false, context, location), (int)0, null)));
    }

    public static Set<Property> parsePropertyList(String value, Map<String, ? extends Vocab> vocabs, ValidationContext context, EPUBLocation location) {
        return VocabUtil.parseProperties(value, vocabs, true, context, location);
    }

    private static Set<Property> parseProperties(String value, Map<String, ? extends Vocab> vocabs, boolean isList, ValidationContext context, EPUBLocation location) {
        Preconditions.checkNotNull(vocabs);
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)location);
        if (value == null) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Iterable properties = whitespaceSplitter.split((CharSequence)value);
        if (!isList && !Iterables.isEmpty((Iterable)Iterables.skip((Iterable)properties, (int)1))) {
            context.report.message(MessageId.OPF_025, location, value);
            return ImmutableSet.of();
        }
        for (String property : properties) {
            Matcher matcher = propertyPattern.matcher(property);
            matcher.matches();
            if (matcher.group(1) != null && (matcher.group(2).isEmpty() || matcher.group(3).isEmpty())) {
                context.report.message(MessageId.OPF_026, location, property);
                continue;
            }
            String prefix = Strings.nullToEmpty((String)matcher.group(2));
            String name = matcher.group(3);
            try {
                Optional<Property> found = vocabs.get(prefix).lookup(name);
                if (found.isPresent()) {
                    if (((Property)found.get()).isDeprecated()) {
                        MessageId messageId = "http://www.idpf.org/epub/vocab/structure/#".equals(((Property)found.get()).getVocabURI()) ? MessageId.OPF_086b : MessageId.OPF_086;
                        String suggestion = LocalizedMessages.getInstance(context.locale).getSuggestion(messageId, ((Property)found.get()).getName());
                        context.report.message(messageId, location, property, suggestion);
                    }
                    if (!((Property)found.get()).isAllowed(context)) {
                        context.report.message(MessageId.OPF_087, location, property, context.mimeType);
                    }
                    builder.add((Object)((Property)found.get()));
                    continue;
                }
                context.report.message(MessageId.OPF_027, location, property);
            }
            catch (NullPointerException e) {
                context.report.message(MessageId.OPF_028, location, prefix);
            }
        }
        return builder.build();
    }

    public static Map<String, Vocab> parsePrefixDeclaration(String value, Map<String, ? extends Vocab> predefined, Map<String, ? extends Vocab> known, Set<String> forbidden, Report report, EPUBLocation location) {
        HashMap vocabs = Maps.newHashMap(predefined);
        Map<String, String> mappings = PrefixDeclarationParser.parsePrefixMappings(value, report, location);
        for (Map.Entry<String, String> mapping : mappings.entrySet()) {
            Vocab vocab;
            String prefix = mapping.getKey();
            String uri = mapping.getValue();
            if ("_".equals(prefix)) {
                report.message(MessageId.OPF_007a, location, new Object[0]);
                continue;
            }
            if (forbidden.contains(uri)) {
                report.message(MessageId.OPF_007b, location, prefix);
                continue;
            }
            if (predefined.containsKey(prefix) && !Strings.nullToEmpty((String)predefined.get(prefix).getURI()).equals(uri)) {
                report.message(MessageId.OPF_007, location, prefix);
            }
            vocabs.put(mapping.getKey(), (vocab = known.get(uri)) == null ? new UncheckedVocab(uri, prefix) : vocab);
        }
        return ImmutableMap.copyOf((Map)vocabs);
    }

    private VocabUtil() {
    }

    private static final class EMPTY
    extends Enum<EMPTY> {
        private static final /* synthetic */ EMPTY[] $VALUES;

        public static EMPTY[] values() {
            return (EMPTY[])$VALUES.clone();
        }

        public static EMPTY valueOf(String name) {
            return Enum.valueOf(EMPTY.class, name);
        }

        private static /* synthetic */ EMPTY[] $values() {
            return new EMPTY[0];
        }

        static {
            $VALUES = EMPTY.$values();
        }
    }
}

