/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql;

import ca.sqlpower.sql.DBCSSource;
import ca.sqlpower.sql.DBCSSourceSupport;
import ca.sqlpower.sql.DatabaseListReadException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;

public class XMLRMIDBCSSource
implements DBCSSource,
Serializable {
    protected ServletContext servletContext = null;
    protected String rmiServerName = null;
    protected String xmlResourcePath = null;

    public XMLRMIDBCSSource(ServletContext servletContext, String rmiServerName, String xmlResourcePath) {
        this.servletContext = servletContext;
        this.rmiServerName = rmiServerName;
        this.xmlResourcePath = xmlResourcePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getDBCSList() throws IllegalStateException, DatabaseListReadException {
        ArrayList dbcsList = null;
        if (this.rmiServerName != null) {
            dbcsList = new ArrayList(DBCSSourceSupport.getListUsingRMI(this.rmiServerName));
        } else {
            if (this.xmlResourcePath != null) {
                InputStream dbXMLFile = this.servletContext.getResourceAsStream(this.xmlResourcePath);
                try {
                    dbcsList = new ArrayList(DBCSSourceSupport.getListUsingXMLStream(dbXMLFile));
                }
                finally {
                    try {
                        dbXMLFile.close();
                    }
                    catch (IOException e) {
                        throw new DatabaseListReadException(e);
                    }
                }
            }
            throw new IllegalStateException("At least one of rmiServerName or xmlResourcePath must have been specified.");
        }
        return dbcsList;
    }

    public boolean isUsingRmi() {
        return this.rmiServerName != null;
    }

    public String getRmiServerHostname() {
        return this.rmiServerName;
    }
}

