/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.analysis;

import com.android.tools.smali.dexlib2.AccessFlags;
import com.android.tools.smali.dexlib2.analysis.AnalyzedMethodUtil;
import com.android.tools.smali.dexlib2.analysis.ClassPath;
import com.android.tools.smali.dexlib2.analysis.TypeProto;
import com.android.tools.smali.dexlib2.analysis.UnresolvedClassException;
import com.android.tools.smali.dexlib2.analysis.util.TypeProtoUtils;
import com.android.tools.smali.dexlib2.iface.ClassDef;
import com.android.tools.smali.dexlib2.iface.Method;
import com.android.tools.smali.dexlib2.iface.reference.FieldReference;
import com.android.tools.smali.dexlib2.iface.reference.MethodReference;
import com.android.tools.smali.dexlib2.util.MethodUtil;
import com.android.tools.smali.util.SparseArray;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.LinkedHashMap;
import java.util.List;

public class ClassProto
implements TypeProto {
    protected final ClassPath classPath;
    protected final String type;
    protected boolean interfacesFullyResolved;
    private final Supplier<ClassDef> classDefSupplier;
    private final Supplier<LinkedHashMap<String, ClassDef>> preDefaultMethodInterfaceSupplier;
    private final Supplier<LinkedHashMap<String, ClassDef>> postDefaultMethodInterfaceSupplier;
    private final Supplier<SparseArray<FieldReference>> dalvikInstanceFieldsSupplier;
    private final Supplier<SparseArray<FieldReference>> artInstanceFieldsSupplier;
    private final Supplier<List<Method>> preDefaultMethodVtableSupplier;
    private final Supplier<List<Method>> buggyPostDefaultMethodVtableSupplier;
    private final Supplier<List<Method>> postDefaultMethodVtableSupplier;

    public String toString() {
        return this.type;
    }

    @Override
    public ClassPath getClassPath() {
        return this.classPath;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public ClassDef getClassDef() {
        return this.classDefSupplier.get();
    }

    @Override
    public boolean isInterface() {
        ClassDef classDef = this.getClassDef();
        return (classDef.getAccessFlags() & AccessFlags.INTERFACE.getValue()) != 0;
    }

    protected LinkedHashMap<String, ClassDef> getInterfaces() {
        if (!this.classPath.isArt() || this.classPath.oatVersion < 72) {
            return this.preDefaultMethodInterfaceSupplier.get();
        }
        return this.postDefaultMethodInterfaceSupplier.get();
    }

    @Override
    public boolean implementsInterface(String iface) {
        if (this.getInterfaces().containsKey(iface)) {
            return true;
        }
        if (!this.interfacesFullyResolved) {
            throw new UnresolvedClassException("Interfaces for class %s not fully resolved", this.getType());
        }
        return false;
    }

    @Override
    public String getSuperclass() {
        return this.getClassDef().getSuperclass();
    }

    private boolean checkInterface(ClassProto other) {
        block6: {
            boolean isResolved = true;
            boolean isInterface = true;
            try {
                isInterface = this.isInterface();
            }
            catch (UnresolvedClassException ex) {
                isResolved = false;
            }
            if (isInterface) {
                try {
                    if (other.implementsInterface(this.getType())) {
                        return true;
                    }
                }
                catch (UnresolvedClassException ex) {
                    if (!isResolved) break block6;
                    throw ex;
                }
            }
        }
        return false;
    }

    @Override
    public TypeProto getCommonSuperclass(TypeProto other) {
        if (!(other instanceof ClassProto)) {
            return other.getCommonSuperclass(this);
        }
        if (this == other || this.getType().equals(other.getType())) {
            return this;
        }
        if (this.getType().equals("Ljava/lang/Object;")) {
            return this;
        }
        if (other.getType().equals("Ljava/lang/Object;")) {
            return other;
        }
        boolean gotException = false;
        try {
            if (this.checkInterface((ClassProto)other)) {
                return this;
            }
        }
        catch (UnresolvedClassException ex) {
            gotException = true;
        }
        try {
            if (((ClassProto)other).checkInterface(this)) {
                return other;
            }
        }
        catch (UnresolvedClassException ex) {
            gotException = true;
        }
        if (gotException) {
            return this.classPath.getUnknownClass();
        }
        List<TypeProto> thisChain = Lists.newArrayList(this);
        Iterables.addAll(thisChain, TypeProtoUtils.getSuperclassChain(this));
        List<TypeProto> otherChain = Lists.newArrayList(other);
        Iterables.addAll(otherChain, TypeProtoUtils.getSuperclassChain(other));
        thisChain = Lists.reverse(thisChain);
        otherChain = Lists.reverse(otherChain);
        for (int i = Math.min(thisChain.size(), otherChain.size()) - 1; i >= 0; --i) {
            TypeProto typeProto = thisChain.get(i);
            if (!typeProto.getType().equals(otherChain.get(i).getType())) continue;
            return typeProto;
        }
        return this.classPath.getUnknownClass();
    }

    @Override
    public FieldReference getFieldByOffset(int fieldOffset) {
        if (this.getInstanceFields().size() == 0) {
            return null;
        }
        return this.getInstanceFields().get(fieldOffset);
    }

    @Override
    public Method getMethodByVtableIndex(int vtableIndex) {
        List<Method> vtable = this.getVtable();
        if (vtableIndex < 0 || vtableIndex >= vtable.size()) {
            return null;
        }
        return vtable.get(vtableIndex);
    }

    @Override
    public int findMethodIndexInVtable(MethodReference method) {
        return this.findMethodIndexInVtable(this.getVtable(), method);
    }

    private int findMethodIndexInVtable(List<Method> vtable, MethodReference method) {
        for (int i = 0; i < vtable.size(); ++i) {
            Method candidate = vtable.get(i);
            if (!MethodUtil.methodSignaturesMatch(candidate, method) || this.classPath.shouldCheckPackagePrivateAccess() && !AnalyzedMethodUtil.canAccess(this, candidate, true, false, false)) continue;
            return i;
        }
        return -1;
    }

    public SparseArray<FieldReference> getInstanceFields() {
        if (this.classPath.isArt()) {
            return this.artInstanceFieldsSupplier.get();
        }
        return this.dalvikInstanceFieldsSupplier.get();
    }

    public List<Method> getVtable() {
        if (!this.classPath.isArt() || this.classPath.oatVersion < 72) {
            return this.preDefaultMethodVtableSupplier.get();
        }
        if (this.classPath.oatVersion < 87) {
            return this.buggyPostDefaultMethodVtableSupplier.get();
        }
        return this.postDefaultMethodVtableSupplier.get();
    }
}

