"""Generated client library for cloudresourcemanager version v3."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.generated_clients.apis.cloudresourcemanager.v3 import cloudresourcemanager_v3_messages as messages


class CloudresourcemanagerV3(base_api.BaseApiClient):
  """Generated client library for service cloudresourcemanager version v3."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://cloudresourcemanager.googleapis.com/'
  MTLS_BASE_URL = 'https://cloudresourcemanager.mtls.googleapis.com/'

  _PACKAGE = 'cloudresourcemanager'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform', 'https://www.googleapis.com/auth/cloud-platform.read-only']
  _VERSION = 'v3'
  _CLIENT_ID = 'CLIENT_ID'
  _CLIENT_SECRET = 'CLIENT_SECRET'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'CloudresourcemanagerV3'
  _URL_VERSION = 'v3'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new cloudresourcemanager handle."""
    url = url or self.BASE_URL
    super(CloudresourcemanagerV3, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.effectiveTags = self.EffectiveTagsService(self)
    self.folders = self.FoldersService(self)
    self.liens = self.LiensService(self)
    self.operations = self.OperationsService(self)
    self.organizations = self.OrganizationsService(self)
    self.projects = self.ProjectsService(self)
    self.tagBindings = self.TagBindingsService(self)
    self.tagKeys = self.TagKeysService(self)
    self.tagValues_tagHolds = self.TagValuesTagHoldsService(self)
    self.tagValues = self.TagValuesService(self)

  class EffectiveTagsService(base_api.BaseApiService):
    """Service class for the effectiveTags resource."""

    _NAME = 'effectiveTags'

    def __init__(self, client):
      super(CloudresourcemanagerV3.EffectiveTagsService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Return a list of effective tags for the given Google Cloud resource, as specified in `parent`.

      Args:
        request: (CloudresourcemanagerEffectiveTagsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListEffectiveTagsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='cloudresourcemanager.effectiveTags.list',
        ordered_params=[],
        path_params=[],
        query_params=['pageSize', 'pageToken', 'parent'],
        relative_path='v3/effectiveTags',
        request_field='',
        request_type_name='CloudresourcemanagerEffectiveTagsListRequest',
        response_type_name='ListEffectiveTagsResponse',
        supports_download=False,
    )

  class FoldersService(base_api.BaseApiService):
    """Service class for the folders resource."""

    _NAME = 'folders'

    def __init__(self, client):
      super(CloudresourcemanagerV3.FoldersService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a folder in the resource hierarchy. Returns an `Operation` which can be used to track the progress of the folder creation workflow. Upon success, the `Operation.response` field will be populated with the created Folder. In order to succeed, the addition of this new folder must not violate the folder naming, height, or fanout constraints. + The folder's `display_name` must be distinct from all other folders that share its parent. + The addition of the folder must not cause the active folder hierarchy to exceed a height of 10. Note, the full active + deleted folder hierarchy is allowed to reach a height of 20; this provides additional headroom when moving folders that contain deleted folders. + The addition of the folder must not cause the total number of folders under its parent to exceed 300. If the operation fails due to a folder constraint violation, some errors may be returned by the `CreateFolder` request, with status code `FAILED_PRECONDITION` and an error description. Other folder constraint violations will be communicated in the `Operation`, with the specific `PreconditionFailure` returned in the details list in the `Operation.error` field. The caller must have `resourcemanager.folders.create` permission on the identified parent.

      Args:
        request: (Folder) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='cloudresourcemanager.folders.create',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path='v3/folders',
        request_field='<request>',
        request_type_name='Folder',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Requests deletion of a folder. The folder is moved into the DELETE_REQUESTED state immediately, and is deleted approximately 30 days later. This method may only be called on an empty folder, where a folder is empty if it doesn't contain any folders or projects in the ACTIVE state. If called on a folder in DELETE_REQUESTED state the operation will result in a no-op success. The caller must have `resourcemanager.folders.delete` permission on the identified folder.

      Args:
        request: (CloudresourcemanagerFoldersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3/folders/{foldersId}',
        http_method='DELETE',
        method_id='cloudresourcemanager.folders.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v3/{+name}',
        request_field='',
        request_type_name='CloudresourcemanagerFoldersDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves a folder identified by the supplied resource name. Valid folder resource names have the format `folders/{folder_id}` (for example, `folders/1234`). The caller must have `resourcemanager.folders.get` permission on the identified folder.

      Args:
        request: (CloudresourcemanagerFoldersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Folder) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3/folders/{foldersId}',
        http_method='GET',
        method_id='cloudresourcemanager.folders.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v3/{+name}',
        request_field='',
        request_type_name='CloudresourcemanagerFoldersGetRequest',
        response_type_name='Folder',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a folder. The returned policy may be empty if no such policy or resource exists. The `resource` field should be the folder's resource name, for example: "folders/1234". The caller must have `resourcemanager.folders.getIamPolicy` permission on the identified folder.

      Args:
        request: (CloudresourcemanagerFoldersGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3/folders/{foldersId}:getIamPolicy',
        http_method='POST',
        method_id='cloudresourcemanager.folders.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v3/{+resource}:getIamPolicy',
        request_field='getIamPolicyRequest',
        request_type_name='CloudresourcemanagerFoldersGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the folders that are direct descendants of supplied parent resource. `list()` provides a strongly consistent view of the folders underneath the specified parent resource. `list()` returns folders sorted based upon the (ascending) lexical ordering of their display_name. The caller must have `resourcemanager.folders.list` permission on the identified parent.

      Args:
        request: (CloudresourcemanagerFoldersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListFoldersResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='cloudresourcemanager.folders.list',
        ordered_params=[],
        path_params=[],
        query_params=['pageSize', 'pageToken', 'parent', 'showDeleted'],
        relative_path='v3/folders',
        request_field='',
        request_type_name='CloudresourcemanagerFoldersListRequest',
        response_type_name='ListFoldersResponse',
        supports_download=False,
    )

    def Move(self, request, global_params=None):
      r"""Moves a folder under a new resource parent. Returns an `Operation` which can be used to track the progress of the folder move workflow. Upon success, the `Operation.response` field will be populated with the moved folder. Upon failure, a `FolderOperationError` categorizing the failure cause will be returned - if the failure occurs synchronously then the `FolderOperationError` will be returned in the `Status.details` field. If it occurs asynchronously, then the FolderOperation will be returned in the `Operation.error` field. In addition, the `Operation.metadata` field will be populated with a `FolderOperation` message as an aid to stateless clients. Folder moves will be rejected if they violate either the naming, height, or fanout constraints described in the CreateFolder documentation. The caller must have `resourcemanager.folders.move` permission on the folder's current and proposed new parent.

      Args:
        request: (CloudresourcemanagerFoldersMoveRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Move')
      return self._RunMethod(
          config, request, global_params=global_params)

    Move.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3/folders/{foldersId}:move',
        http_method='POST',
        method_id='cloudresourcemanager.folders.move',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v3/{+name}:move',
        request_field='moveFolderRequest',
        request_type_name='CloudresourcemanagerFoldersMoveRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a folder, changing its `display_name`. Changes to the folder `display_name` will be rejected if they violate either the `display_name` formatting rules or the naming constraints described in the CreateFolder documentation. The folder's `display_name` must start and end with a letter or digit, may contain letters, digits, spaces, hyphens and underscores and can be between 3 and 30 characters. This is captured by the regular expression: `\p{L}\p{N}{1,28}[\p{L}\p{N}]`. The caller must have `resourcemanager.folders.update` permission on the identified folder. If the update fails due to the unique name constraint then a `PreconditionFailure` explaining this violation will be returned in the Status.details field.

      Args:
        request: (CloudresourcemanagerFoldersPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3/folders/{foldersId}',
        http_method='PATCH',
        method_id='cloudresourcemanager.folders.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v3/{+name}',
        request_field='folder',
        request_type_name='CloudresourcemanagerFoldersPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Search(self, request, global_params=None):
      r"""Search for folders that match specific filter criteria. `search()` provides an eventually consistent view of the folders a user has access to which meet the specified filter criteria. This will only return folders on which the caller has the permission `resourcemanager.folders.get`.

      Args:
        request: (CloudresourcemanagerFoldersSearchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SearchFoldersResponse) The response message.
      """
      config = self.GetMethodConfig('Search')
      return self._RunMethod(
          config, request, global_params=global_params)

    Search.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='cloudresourcemanager.folders.search',
        ordered_params=[],
        path_params=[],
        query_params=['pageSize', 'pageToken', 'query'],
        relative_path='v3/folders:search',
        request_field='',
        request_type_name='CloudresourcemanagerFoldersSearchRequest',
        response_type_name='SearchFoldersResponse',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on a folder, replacing any existing policy. The `resource` field should be the folder's resource name, for example: "folders/1234". The caller must have `resourcemanager.folders.setIamPolicy` permission on the identified folder.

      Args:
        request: (CloudresourcemanagerFoldersSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3/folders/{foldersId}:setIamPolicy',
        http_method='POST',
        method_id='cloudresourcemanager.folders.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v3/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='CloudresourcemanagerFoldersSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified folder. The `resource` field should be the folder's resource name, for example: "folders/1234". There are no permissions required for making this API call.

      Args:
        request: (CloudresourcemanagerFoldersTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3/folders/{foldersId}:testIamPermissions',
        http_method='POST',
        method_id='cloudresourcemanager.folders.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v3/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='CloudresourcemanagerFoldersTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

    def Undelete(self, request, global_params=None):
      r"""Cancels the deletion request for a folder. This method may be called on a folder in any state. If the folder is in the ACTIVE state the result will be a no-op success. In order to succeed, the folder's parent must be in the ACTIVE state. In addition, reintroducing the folder into the tree must not violate folder naming, height, and fanout constraints described in the CreateFolder documentation. The caller must have `resourcemanager.folders.undelete` permission on the identified folder.

      Args:
        request: (CloudresourcemanagerFoldersUndeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Undelete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Undelete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3/folders/{foldersId}:undelete',
        http_method='POST',
        method_id='cloudresourcemanager.folders.undelete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v3/{+name}:undelete',
        request_field='undeleteFolderRequest',
        request_type_name='CloudresourcemanagerFoldersUndeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class LiensService(base_api.BaseApiService):
    """Service class for the liens resource."""

    _NAME = 'liens'

    def __init__(self, client):
      super(CloudresourcemanagerV3.LiensService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Create a Lien which applies to the resource denoted by the `parent` field. Callers of this method will require permission on the `parent` resource. For example, applying to `projects/1234` requires permission `resourcemanager.projects.updateLiens`. NOTE: Some resources may limit the number of Liens which may be applied.

      Args:
        request: (Lien) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Lien) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='cloudresourcemanager.liens.create',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path='v3/liens',
        request_field='<request>',
        request_type_name='Lien',
        response_type_name='Lien',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Delete a Lien by `name`. Callers of this method will require permission on the `parent` resource. For example, a Lien with a `parent` of `projects/1234` requires permission `resourcemanager.projects.updateLiens`.

      Args:
        request: (CloudresourcemanagerLiensDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3/liens/{liensId}',
        http_method='DELETE',
        method_id='cloudresourcemanager.liens.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v3/{+name}',
        request_field='',
        request_type_name='CloudresourcemanagerLiensDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieve a Lien by `name`. Callers of this method will require permission on the `parent` resource. For example, a Lien with a `parent` of `projects/1234` requires permission `resourcemanager.projects.get`.

      Args:
        request: (CloudresourcemanagerLiensGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Lien) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3/liens/{liensId}',
        http_method='GET',
        method_id='cloudresourcemanager.liens.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v3/{+name}',
        request_field='',
        request_type_name='CloudresourcemanagerLiensGetRequest',
        response_type_name='Lien',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List all Liens applied to the `parent` resource. Callers of this method will require permission on the `parent` resource. For example, a Lien with a `parent` of `projects/1234` requires permission `resourcemanager.projects.get`.

      Args:
        request: (CloudresourcemanagerLiensListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLiensResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='cloudresourcemanager.liens.list',
        ordered_params=[],
        path_params=[],
        query_params=['pageSize', 'pageToken', 'parent'],
        relative_path='v3/liens',
        request_field='',
        request_type_name='CloudresourcemanagerLiensListRequest',
        response_type_name='ListLiensResponse',
        supports_download=False,
    )

  class OperationsService(base_api.BaseApiService):
    """Service class for the operations resource."""

    _NAME = 'operations'

    def __init__(self, client):
      super(CloudresourcemanagerV3.OperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.

      Args:
        request: (CloudresourcemanagerOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3/operations/{operationsId}',
        http_method='GET',
        method_id='cloudresourcemanager.operations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v3/{+name}',
        request_field='',
        request_type_name='CloudresourcemanagerOperationsGetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class OrganizationsService(base_api.BaseApiService):
    """Service class for the organizations resource."""

    _NAME = 'organizations'

    def __init__(self, client):
      super(CloudresourcemanagerV3.OrganizationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Fetches an organization resource identified by the specified resource name.

      Args:
        request: (CloudresourcemanagerOrganizationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Organization) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3/organizations/{organizationsId}',
        http_method='GET',
        method_id='cloudresourcemanager.organizations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v3/{+name}',
        request_field='',
        request_type_name='CloudresourcemanagerOrganizationsGetRequest',
        response_type_name='Organization',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for an organization resource. The policy may be empty if no such policy or resource exists. The `resource` field should be the organization's resource name, for example: "organizations/123". Authorization requires the IAM permission `resourcemanager.organizations.getIamPolicy` on the specified organization.

      Args:
        request: (CloudresourcemanagerOrganizationsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3/organizations/{organizationsId}:getIamPolicy',
        http_method='POST',
        method_id='cloudresourcemanager.organizations.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v3/{+resource}:getIamPolicy',
        request_field='getIamPolicyRequest',
        request_type_name='CloudresourcemanagerOrganizationsGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def Search(self, request, global_params=None):
      r"""Searches organization resources that are visible to the user and satisfy the specified filter. This method returns organizations in an unspecified order. New organizations do not necessarily appear at the end of the results, and may take a small amount of time to appear. Search will only return organizations on which the user has the permission `resourcemanager.organizations.get` or has super admin privileges.

      Args:
        request: (CloudresourcemanagerOrganizationsSearchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SearchOrganizationsResponse) The response message.
      """
      config = self.GetMethodConfig('Search')
      return self._RunMethod(
          config, request, global_params=global_params)

    Search.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='cloudresourcemanager.organizations.search',
        ordered_params=[],
        path_params=[],
        query_params=['pageSize', 'pageToken', 'query'],
        relative_path='v3/organizations:search',
        request_field='',
        request_type_name='CloudresourcemanagerOrganizationsSearchRequest',
        response_type_name='SearchOrganizationsResponse',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on an organization resource. Replaces any existing policy. The `resource` field should be the organization's resource name, for example: "organizations/123". Authorization requires the IAM permission `resourcemanager.organizations.setIamPolicy` on the specified organization.

      Args:
        request: (CloudresourcemanagerOrganizationsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3/organizations/{organizationsId}:setIamPolicy',
        http_method='POST',
        method_id='cloudresourcemanager.organizations.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v3/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='CloudresourcemanagerOrganizationsSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns the permissions that a caller has on the specified organization. The `resource` field should be the organization's resource name, for example: "organizations/123". There are no permissions required for making this API call.

      Args:
        request: (CloudresourcemanagerOrganizationsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3/organizations/{organizationsId}:testIamPermissions',
        http_method='POST',
        method_id='cloudresourcemanager.organizations.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v3/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='CloudresourcemanagerOrganizationsTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(CloudresourcemanagerV3.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Request that a new project be created. The result is an `Operation` which can be used to track the creation process. This process usually takes a few seconds, but can sometimes take much longer. The tracking `Operation` is automatically deleted after a few hours, so there is no need to call `DeleteOperation`.

      Args:
        request: (Project) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='cloudresourcemanager.projects.create',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path='v3/projects',
        request_field='<request>',
        request_type_name='Project',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Marks the project identified by the specified `name` (for example, `projects/415104041262`) for deletion. This method will only affect the project if it has a lifecycle state of ACTIVE. This method changes the Project's lifecycle state from ACTIVE to DELETE_REQUESTED. The deletion starts at an unspecified time, at which point the Project is no longer accessible. Until the deletion completes, you can check the lifecycle state checked by retrieving the project with GetProject, and the project remains visible to ListProjects. However, you cannot update the project. After the deletion completes, the project is not retrievable by the GetProject, ListProjects, and SearchProjects methods. This method behaves idempotently, such that deleting a `DELETE_REQUESTED` project will not cause an error, but also won't do anything. The caller must have `resourcemanager.projects.delete` permissions for this project.

      Args:
        request: (CloudresourcemanagerProjectsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3/projects/{projectsId}',
        http_method='DELETE',
        method_id='cloudresourcemanager.projects.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v3/{+name}',
        request_field='',
        request_type_name='CloudresourcemanagerProjectsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves the project identified by the specified `name` (for example, `projects/415104041262`). The caller must have `resourcemanager.projects.get` permission for this project.

      Args:
        request: (CloudresourcemanagerProjectsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Project) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3/projects/{projectsId}',
        http_method='GET',
        method_id='cloudresourcemanager.projects.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v3/{+name}',
        request_field='',
        request_type_name='CloudresourcemanagerProjectsGetRequest',
        response_type_name='Project',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Returns the IAM access control policy for the specified project, in the format `projects/{ProjectIdOrNumber}` e.g. projects/123. Permission is denied if the policy or the resource do not exist.

      Args:
        request: (CloudresourcemanagerProjectsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3/projects/{projectsId}:getIamPolicy',
        http_method='POST',
        method_id='cloudresourcemanager.projects.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v3/{+resource}:getIamPolicy',
        request_field='getIamPolicyRequest',
        request_type_name='CloudresourcemanagerProjectsGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists projects that are direct children of the specified folder or organization resource. `list()` provides a strongly consistent view of the projects underneath the specified parent resource. `list()` returns projects sorted based upon the (ascending) lexical ordering of their `display_name`. The caller must have `resourcemanager.projects.list` permission on the identified parent.

      Args:
        request: (CloudresourcemanagerProjectsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListProjectsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='cloudresourcemanager.projects.list',
        ordered_params=[],
        path_params=[],
        query_params=['pageSize', 'pageToken', 'parent', 'showDeleted'],
        relative_path='v3/projects',
        request_field='',
        request_type_name='CloudresourcemanagerProjectsListRequest',
        response_type_name='ListProjectsResponse',
        supports_download=False,
    )

    def Move(self, request, global_params=None):
      r"""Move a project to another place in your resource hierarchy, under a new resource parent. Returns an operation which can be used to track the process of the project move workflow. Upon success, the `Operation.response` field will be populated with the moved project. The caller must have `resourcemanager.projects.move` permission on the project, on the project's current and proposed new parent. If project has no current parent, or it currently does not have an associated organization resource, you will also need the `resourcemanager.projects.setIamPolicy` permission in the project. .

      Args:
        request: (CloudresourcemanagerProjectsMoveRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Move')
      return self._RunMethod(
          config, request, global_params=global_params)

    Move.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3/projects/{projectsId}:move',
        http_method='POST',
        method_id='cloudresourcemanager.projects.move',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v3/{+name}:move',
        request_field='moveProjectRequest',
        request_type_name='CloudresourcemanagerProjectsMoveRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the `display_name` and labels of the project identified by the specified `name` (for example, `projects/415104041262`). Deleting all labels requires an update mask for labels field. The caller must have `resourcemanager.projects.update` permission for this project.

      Args:
        request: (CloudresourcemanagerProjectsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3/projects/{projectsId}',
        http_method='PATCH',
        method_id='cloudresourcemanager.projects.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v3/{+name}',
        request_field='project',
        request_type_name='CloudresourcemanagerProjectsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Search(self, request, global_params=None):
      r"""Search for projects that the caller has the `resourcemanager.projects.get` permission on, and also satisfy the specified query. This method returns projects in an unspecified order. This method is eventually consistent with project mutations; this means that a newly created project may not appear in the results or recent updates to an existing project may not be reflected in the results. To retrieve the latest state of a project, use the GetProject method.

      Args:
        request: (CloudresourcemanagerProjectsSearchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SearchProjectsResponse) The response message.
      """
      config = self.GetMethodConfig('Search')
      return self._RunMethod(
          config, request, global_params=global_params)

    Search.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='cloudresourcemanager.projects.search',
        ordered_params=[],
        path_params=[],
        query_params=['pageSize', 'pageToken', 'query'],
        relative_path='v3/projects:search',
        request_field='',
        request_type_name='CloudresourcemanagerProjectsSearchRequest',
        response_type_name='SearchProjectsResponse',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the IAM access control policy for the specified project, in the format `projects/{ProjectIdOrNumber}` e.g. projects/123. CAUTION: This method will replace the existing policy, and cannot be used to append additional IAM settings. Note: Removing service accounts from policies or changing their roles can render services completely inoperable. It is important to understand how the service account is being used before removing or updating its roles. The following constraints apply when using `setIamPolicy()`: + Project does not support `allUsers` and `allAuthenticatedUsers` as `members` in a `Binding` of a `Policy`. + The owner role can be granted to a `user`, `serviceAccount`, or a group that is part of an organization. For example, group@myownpersonaldomain.com could be added as an owner to a project in the myownpersonaldomain.com organization, but not the examplepetstore.com organization. + Service accounts can be made owners of a project directly without any restrictions. However, to be added as an owner, a user must be invited using the Cloud Platform console and must accept the invitation. + A user cannot be granted the owner role using `setIamPolicy()`. The user must be granted the owner role using the Cloud Platform Console and must explicitly accept the invitation. + Invitations to grant the owner role cannot be sent using `setIamPolicy()`; they must be sent only using the Cloud Platform Console. + If the project is not part of an organization, there must be at least one owner who has accepted the Terms of Service (ToS) agreement in the policy. Calling `setIamPolicy()` to remove the last ToS-accepted owner from the policy will fail. This restriction also applies to legacy projects that no longer have owners who have accepted the ToS. Edits to IAM policies will be rejected until the lack of a ToS-accepting owner is rectified. If the project is part of an organization, you can remove all owners, potentially making the organization inaccessible.

      Args:
        request: (CloudresourcemanagerProjectsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3/projects/{projectsId}:setIamPolicy',
        http_method='POST',
        method_id='cloudresourcemanager.projects.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v3/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='CloudresourcemanagerProjectsSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified project, in the format `projects/{ProjectIdOrNumber}` e.g. projects/123..

      Args:
        request: (CloudresourcemanagerProjectsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3/projects/{projectsId}:testIamPermissions',
        http_method='POST',
        method_id='cloudresourcemanager.projects.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v3/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='CloudresourcemanagerProjectsTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

    def Undelete(self, request, global_params=None):
      r"""Restores the project identified by the specified `name` (for example, `projects/415104041262`). You can only use this method for a project that has a lifecycle state of DELETE_REQUESTED. After deletion starts, the project cannot be restored. The caller must have `resourcemanager.projects.undelete` permission for this project.

      Args:
        request: (CloudresourcemanagerProjectsUndeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Undelete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Undelete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3/projects/{projectsId}:undelete',
        http_method='POST',
        method_id='cloudresourcemanager.projects.undelete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v3/{+name}:undelete',
        request_field='undeleteProjectRequest',
        request_type_name='CloudresourcemanagerProjectsUndeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class TagBindingsService(base_api.BaseApiService):
    """Service class for the tagBindings resource."""

    _NAME = 'tagBindings'

    def __init__(self, client):
      super(CloudresourcemanagerV3.TagBindingsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a TagBinding between a TagValue and a Google Cloud resource.

      Args:
        request: (CloudresourcemanagerTagBindingsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='cloudresourcemanager.tagBindings.create',
        ordered_params=[],
        path_params=[],
        query_params=['validateOnly'],
        relative_path='v3/tagBindings',
        request_field='tagBinding',
        request_type_name='CloudresourcemanagerTagBindingsCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a TagBinding.

      Args:
        request: (CloudresourcemanagerTagBindingsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3/tagBindings/{tagBindingsId}',
        http_method='DELETE',
        method_id='cloudresourcemanager.tagBindings.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v3/{+name}',
        request_field='',
        request_type_name='CloudresourcemanagerTagBindingsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the TagBindings for the given Google Cloud resource, as specified with `parent`. NOTE: The `parent` field is expected to be a full resource name: https://cloud.google.com/apis/design/resource_names#full_resource_name.

      Args:
        request: (CloudresourcemanagerTagBindingsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListTagBindingsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='cloudresourcemanager.tagBindings.list',
        ordered_params=[],
        path_params=[],
        query_params=['pageSize', 'pageToken', 'parent'],
        relative_path='v3/tagBindings',
        request_field='',
        request_type_name='CloudresourcemanagerTagBindingsListRequest',
        response_type_name='ListTagBindingsResponse',
        supports_download=False,
    )

  class TagKeysService(base_api.BaseApiService):
    """Service class for the tagKeys resource."""

    _NAME = 'tagKeys'

    def __init__(self, client):
      super(CloudresourcemanagerV3.TagKeysService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new TagKey. If another request with the same parameters is sent while the original request is in process, the second request will receive an error. A maximum of 1000 TagKeys can exist under a parent at any given time.

      Args:
        request: (CloudresourcemanagerTagKeysCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='cloudresourcemanager.tagKeys.create',
        ordered_params=[],
        path_params=[],
        query_params=['validateOnly'],
        relative_path='v3/tagKeys',
        request_field='tagKey',
        request_type_name='CloudresourcemanagerTagKeysCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a TagKey. The TagKey cannot be deleted if it has any child TagValues.

      Args:
        request: (CloudresourcemanagerTagKeysDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3/tagKeys/{tagKeysId}',
        http_method='DELETE',
        method_id='cloudresourcemanager.tagKeys.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['etag', 'validateOnly'],
        relative_path='v3/{+name}',
        request_field='',
        request_type_name='CloudresourcemanagerTagKeysDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves a TagKey. This method will return `PERMISSION_DENIED` if the key does not exist or the user does not have permission to view it.

      Args:
        request: (CloudresourcemanagerTagKeysGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TagKey) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3/tagKeys/{tagKeysId}',
        http_method='GET',
        method_id='cloudresourcemanager.tagKeys.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v3/{+name}',
        request_field='',
        request_type_name='CloudresourcemanagerTagKeysGetRequest',
        response_type_name='TagKey',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a TagKey. The returned policy may be empty if no such policy or resource exists. The `resource` field should be the TagKey's resource name. For example, "tagKeys/1234". The caller must have `cloudresourcemanager.googleapis.com/tagKeys.getIamPolicy` permission on the specified TagKey.

      Args:
        request: (CloudresourcemanagerTagKeysGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3/tagKeys/{tagKeysId}:getIamPolicy',
        http_method='POST',
        method_id='cloudresourcemanager.tagKeys.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v3/{+resource}:getIamPolicy',
        request_field='getIamPolicyRequest',
        request_type_name='CloudresourcemanagerTagKeysGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def GetNamespaced(self, request, global_params=None):
      r"""Retrieves a TagKey by its namespaced name. This method will return `PERMISSION_DENIED` if the key does not exist or the user does not have permission to view it.

      Args:
        request: (CloudresourcemanagerTagKeysGetNamespacedRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TagKey) The response message.
      """
      config = self.GetMethodConfig('GetNamespaced')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetNamespaced.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='cloudresourcemanager.tagKeys.getNamespaced',
        ordered_params=[],
        path_params=[],
        query_params=['name'],
        relative_path='v3/tagKeys/namespaced',
        request_field='',
        request_type_name='CloudresourcemanagerTagKeysGetNamespacedRequest',
        response_type_name='TagKey',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all TagKeys for a parent resource.

      Args:
        request: (CloudresourcemanagerTagKeysListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListTagKeysResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='cloudresourcemanager.tagKeys.list',
        ordered_params=[],
        path_params=[],
        query_params=['pageSize', 'pageToken', 'parent'],
        relative_path='v3/tagKeys',
        request_field='',
        request_type_name='CloudresourcemanagerTagKeysListRequest',
        response_type_name='ListTagKeysResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the attributes of the TagKey resource.

      Args:
        request: (CloudresourcemanagerTagKeysPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3/tagKeys/{tagKeysId}',
        http_method='PATCH',
        method_id='cloudresourcemanager.tagKeys.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask', 'validateOnly'],
        relative_path='v3/{+name}',
        request_field='tagKey',
        request_type_name='CloudresourcemanagerTagKeysPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on a TagKey, replacing any existing policy. The `resource` field should be the TagKey's resource name. For example, "tagKeys/1234". The caller must have `resourcemanager.tagKeys.setIamPolicy` permission on the identified tagValue.

      Args:
        request: (CloudresourcemanagerTagKeysSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3/tagKeys/{tagKeysId}:setIamPolicy',
        http_method='POST',
        method_id='cloudresourcemanager.tagKeys.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v3/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='CloudresourcemanagerTagKeysSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified TagKey. The `resource` field should be the TagKey's resource name. For example, "tagKeys/1234". There are no permissions required for making this API call.

      Args:
        request: (CloudresourcemanagerTagKeysTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3/tagKeys/{tagKeysId}:testIamPermissions',
        http_method='POST',
        method_id='cloudresourcemanager.tagKeys.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v3/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='CloudresourcemanagerTagKeysTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

  class TagValuesTagHoldsService(base_api.BaseApiService):
    """Service class for the tagValues_tagHolds resource."""

    _NAME = 'tagValues_tagHolds'

    def __init__(self, client):
      super(CloudresourcemanagerV3.TagValuesTagHoldsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a TagHold. Returns ALREADY_EXISTS if a TagHold with the same resource and origin exists under the same TagValue.

      Args:
        request: (CloudresourcemanagerTagValuesTagHoldsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3/tagValues/{tagValuesId}/tagHolds',
        http_method='POST',
        method_id='cloudresourcemanager.tagValues.tagHolds.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['validateOnly'],
        relative_path='v3/{+parent}/tagHolds',
        request_field='tagHold',
        request_type_name='CloudresourcemanagerTagValuesTagHoldsCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a TagHold.

      Args:
        request: (CloudresourcemanagerTagValuesTagHoldsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3/tagValues/{tagValuesId}/tagHolds/{tagHoldsId}',
        http_method='DELETE',
        method_id='cloudresourcemanager.tagValues.tagHolds.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['validateOnly'],
        relative_path='v3/{+name}',
        request_field='',
        request_type_name='CloudresourcemanagerTagValuesTagHoldsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists TagHolds under a TagValue.

      Args:
        request: (CloudresourcemanagerTagValuesTagHoldsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListTagHoldsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3/tagValues/{tagValuesId}/tagHolds',
        http_method='GET',
        method_id='cloudresourcemanager.tagValues.tagHolds.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v3/{+parent}/tagHolds',
        request_field='',
        request_type_name='CloudresourcemanagerTagValuesTagHoldsListRequest',
        response_type_name='ListTagHoldsResponse',
        supports_download=False,
    )

  class TagValuesService(base_api.BaseApiService):
    """Service class for the tagValues resource."""

    _NAME = 'tagValues'

    def __init__(self, client):
      super(CloudresourcemanagerV3.TagValuesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a TagValue as a child of the specified TagKey. If a another request with the same parameters is sent while the original request is in process the second request will receive an error. A maximum of 1000 TagValues can exist under a TagKey at any given time.

      Args:
        request: (CloudresourcemanagerTagValuesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='cloudresourcemanager.tagValues.create',
        ordered_params=[],
        path_params=[],
        query_params=['validateOnly'],
        relative_path='v3/tagValues',
        request_field='tagValue',
        request_type_name='CloudresourcemanagerTagValuesCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a TagValue. The TagValue cannot have any bindings when it is deleted.

      Args:
        request: (CloudresourcemanagerTagValuesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3/tagValues/{tagValuesId}',
        http_method='DELETE',
        method_id='cloudresourcemanager.tagValues.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['etag', 'validateOnly'],
        relative_path='v3/{+name}',
        request_field='',
        request_type_name='CloudresourcemanagerTagValuesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves a TagValue. This method will return `PERMISSION_DENIED` if the value does not exist or the user does not have permission to view it.

      Args:
        request: (CloudresourcemanagerTagValuesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TagValue) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3/tagValues/{tagValuesId}',
        http_method='GET',
        method_id='cloudresourcemanager.tagValues.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v3/{+name}',
        request_field='',
        request_type_name='CloudresourcemanagerTagValuesGetRequest',
        response_type_name='TagValue',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a TagValue. The returned policy may be empty if no such policy or resource exists. The `resource` field should be the TagValue's resource name. For example: `tagValues/1234`. The caller must have the `cloudresourcemanager.googleapis.com/tagValues.getIamPolicy` permission on the identified TagValue to get the access control policy.

      Args:
        request: (CloudresourcemanagerTagValuesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3/tagValues/{tagValuesId}:getIamPolicy',
        http_method='POST',
        method_id='cloudresourcemanager.tagValues.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v3/{+resource}:getIamPolicy',
        request_field='getIamPolicyRequest',
        request_type_name='CloudresourcemanagerTagValuesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def GetNamespaced(self, request, global_params=None):
      r"""Retrieves a TagValue by its namespaced name. This method will return `PERMISSION_DENIED` if the value does not exist or the user does not have permission to view it.

      Args:
        request: (CloudresourcemanagerTagValuesGetNamespacedRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TagValue) The response message.
      """
      config = self.GetMethodConfig('GetNamespaced')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetNamespaced.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='cloudresourcemanager.tagValues.getNamespaced',
        ordered_params=[],
        path_params=[],
        query_params=['name'],
        relative_path='v3/tagValues/namespaced',
        request_field='',
        request_type_name='CloudresourcemanagerTagValuesGetNamespacedRequest',
        response_type_name='TagValue',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all TagValues for a specific TagKey.

      Args:
        request: (CloudresourcemanagerTagValuesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListTagValuesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='cloudresourcemanager.tagValues.list',
        ordered_params=[],
        path_params=[],
        query_params=['pageSize', 'pageToken', 'parent'],
        relative_path='v3/tagValues',
        request_field='',
        request_type_name='CloudresourcemanagerTagValuesListRequest',
        response_type_name='ListTagValuesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the attributes of the TagValue resource.

      Args:
        request: (CloudresourcemanagerTagValuesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3/tagValues/{tagValuesId}',
        http_method='PATCH',
        method_id='cloudresourcemanager.tagValues.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask', 'validateOnly'],
        relative_path='v3/{+name}',
        request_field='tagValue',
        request_type_name='CloudresourcemanagerTagValuesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on a TagValue, replacing any existing policy. The `resource` field should be the TagValue's resource name. For example: `tagValues/1234`. The caller must have `resourcemanager.tagValues.setIamPolicy` permission on the identified tagValue.

      Args:
        request: (CloudresourcemanagerTagValuesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3/tagValues/{tagValuesId}:setIamPolicy',
        http_method='POST',
        method_id='cloudresourcemanager.tagValues.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v3/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='CloudresourcemanagerTagValuesSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified TagValue. The `resource` field should be the TagValue's resource name. For example: `tagValues/1234`. There are no permissions required for making this API call.

      Args:
        request: (CloudresourcemanagerTagValuesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3/tagValues/{tagValuesId}:testIamPermissions',
        http_method='POST',
        method_id='cloudresourcemanager.tagValues.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v3/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='CloudresourcemanagerTagValuesTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )
