/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import jakarta.json.Json;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.io.Reader;
import java.io.StringReader;
import java.net.SocketAddress;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.traccar.BaseHttpProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.BufferUtil;
import org.traccar.helper.DataConverter;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.model.WifiAccessPoint;

public class SigfoxProtocolDecoder
extends BaseHttpProtocolDecoder {
    public SigfoxProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private boolean jsonContains(JsonObject json, String key) {
        if (json.containsKey((Object)key)) {
            JsonValue value = (JsonValue)json.get((Object)key);
            if (value.getValueType() == JsonValue.ValueType.STRING) {
                return !((JsonString)value).getString().equals("null");
            }
            return true;
        }
        return false;
    }

    private boolean getJsonBoolean(JsonObject json, String key) {
        JsonValue value = (JsonValue)json.get((Object)key);
        if (value != null) {
            if (value.getValueType() == JsonValue.ValueType.STRING) {
                return Boolean.parseBoolean(((JsonString)value).getString());
            }
            return value.getValueType() == JsonValue.ValueType.TRUE;
        }
        return false;
    }

    private int getJsonInt(JsonObject json, String key) {
        JsonValue value = (JsonValue)json.get((Object)key);
        if (value != null) {
            if (value.getValueType() == JsonValue.ValueType.NUMBER) {
                return ((JsonNumber)value).intValue();
            }
            if (value.getValueType() == JsonValue.ValueType.STRING) {
                return Integer.parseInt(((JsonString)value).getString());
            }
        }
        return 0;
    }

    private double getJsonDouble(JsonObject json, String key) {
        JsonValue value = (JsonValue)json.get((Object)key);
        if (value != null) {
            if (value.getValueType() == JsonValue.ValueType.NUMBER) {
                return ((JsonNumber)value).doubleValue();
            }
            if (value.getValueType() == JsonValue.ValueType.STRING) {
                return Double.parseDouble(((JsonString)value).getString());
            }
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        request = (FullHttpRequest)msg;
        content = request.content().toString(StandardCharsets.UTF_8);
        if (!content.startsWith("{")) {
            content = URLDecoder.decode(content.split("=")[0], StandardCharsets.UTF_8);
        }
        if ((deviceSession = this.getDeviceSession(channel, remoteAddress, new String[]{deviceId = (json = Json.createReader((Reader)new StringReader(content)).readObject()).containsKey((Object)"device") != false ? json.getString("device") : json.getString("deviceId")})) == null) {
            this.sendResponse(channel, HttpResponseStatus.BAD_REQUEST);
            return null;
        }
        position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        if (this.jsonContains(json, "time")) {
            position.setTime(new Date((long)this.getJsonInt(json, "time") * 1000L));
        } else if (this.jsonContains(json, "positionTime")) {
            position.setTime(new Date((long)this.getJsonInt(json, "positionTime") * 1000L));
        } else {
            position.setTime(new Date());
        }
        if (this.jsonContains(json, "lastSeen")) {
            position.setDeviceTime(new Date((long)this.getJsonInt(json, "lastSeen") * 1000L));
        }
        if (this.jsonContains(json, "location") || this.jsonContains(json, "lat") && this.jsonContains(json, "lng") && !this.jsonContains(json, "data") || this.jsonContains(json, "latitude") && this.jsonContains(json, "longitude") && !this.jsonContains(json, "data")) {
            location = this.jsonContains(json, "location") != false ? json.getJsonObject("location") : json;
            position.setValid(true);
            position.setLatitude(this.getJsonDouble(location, this.jsonContains(location, "lat") != false ? "lat" : "latitude"));
            position.setLongitude(this.getJsonDouble(location, this.jsonContains(location, "lng") != false ? "lng" : "longitude"));
        } else if (this.jsonContains(json, "data")) {
            buf = Unpooled.wrappedBuffer((byte[])DataConverter.parseHex(json.getString("data")));
            try {
                event = buf.readUnsignedByte();
                if (event == 15 || event == 31) {
                    position.setValid(event >> 4 > 0);
                    position.setLatitude((double)BufferUtil.readSignedMagnitudeInt(buf) * 1.0E-6);
                    position.setLongitude((double)BufferUtil.readSignedMagnitudeInt(buf) * 1.0E-6);
                    position.set("battery", Integer.valueOf(buf.readUnsignedByte()));
                }
                if (event >> 4 > 3 || buf.writerIndex() != 12) ** GOTO lbl102
                if (BitUtil.to(event, 4) == 0) {
                    position.setValid(true);
                    position.setLatitude((double)buf.readIntLE() * 1.0E-7);
                    position.setLongitude((double)buf.readIntLE() * 1.0E-7);
                    position.setCourse(buf.readUnsignedByte() * 2);
                    position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedByte()));
                    position.set("battery", (double)buf.readUnsignedByte() * 0.025);
                }
                var12_15 = null;
                return var12_15;
            }
            finally {
                buf.release();
            }
        } else if (this.jsonContains(json, "payload")) {
            buf = Unpooled.wrappedBuffer((byte[])DataConverter.parseHex(json.getString("payload")));
            try {
                event = buf.readUnsignedByte();
                position.set("event", Integer.valueOf(event));
                if (event == 34 || event == 98) {
                    position.set("alarm", "sos");
                }
                block17: while (buf.isReadable()) {
                    type = buf.readUnsignedByte();
                    switch (type) {
                        case 1: {
                            position.setValid(true);
                            position.setLatitude(buf.readMedium());
                            position.setLongitude(buf.readMedium());
                            continue block17;
                        }
                        case 2: {
                            position.setValid(true);
                            position.setLatitude(buf.readFloat());
                            position.setLongitude(buf.readFloat());
                            continue block17;
                        }
                        case 3: {
                            position.set("temp1", (double)buf.readByte() * 0.5);
                            continue block17;
                        }
                        case 4: {
                            position.set("battery", (double)buf.readUnsignedByte() * 0.1);
                            continue block17;
                        }
                        case 5: {
                            position.set("batteryLevel", buf.readUnsignedByte());
                            continue block17;
                        }
                        case 6: {
                            mac = ByteBufUtil.hexDump((ByteBuf)buf.readSlice(6)).replaceAll("(..)", "$1:");
                            position.setNetwork(new Network(WifiAccessPoint.from(mac.substring(0, mac.length() - 1), buf.readUnsignedByte())));
                            continue block17;
                        }
                        case 7: {
                            buf.skipBytes(10);
                            continue block17;
                        }
                        case 8: {
                            buf.skipBytes(6);
                            continue block17;
                        }
                        case 9: {
                            position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedByte()));
                            continue block17;
                        }
                    }
                    buf.readUnsignedByte();
                }
            }
            finally {
                buf.release();
            }
        }
        if (position.getLatitude() == 0.0 && position.getLongitude() == 0.0) {
            this.getLastLocation(position, position.getDeviceTime());
        }
        if (this.jsonContains(json, "moving")) {
            position.set("motion", this.getJsonBoolean(json, "moving"));
        }
        if (this.jsonContains(json, "magStatus")) {
            position.set("blocked", this.getJsonBoolean(json, "magStatus"));
        }
        if (this.jsonContains(json, "temperature")) {
            position.set("deviceTemp", this.getJsonDouble(json, "temperature"));
        }
        if (this.jsonContains(json, "rssi")) {
            position.set("rssi", this.getJsonDouble(json, "rssi"));
        }
        if (this.jsonContains(json, "seqNumber")) {
            position.set("index", this.getJsonInt(json, "seqNumber"));
        }
        this.sendResponse(channel, HttpResponseStatus.OK);
        return position;
    }
}

