/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import java.util.TimeZone;
import org.traccar.Protocol;
import org.traccar.StringProtocolEncoder;
import org.traccar.model.Command;

public class MiniFinderProtocolEncoder
extends StringProtocolEncoder
implements StringProtocolEncoder.ValueFormatter {
    public MiniFinderProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    public String formatValue(String key, Object value) {
        switch (key) {
            case "enable": {
                return (Boolean)value != false ? "1" : "0";
            }
            case "timezone": {
                return String.format("%+03d", TimeZone.getTimeZone((String)value).getRawOffset() / 3600000);
            }
            case "index": {
                switch (((Number)value).intValue()) {
                    case 0: {
                        return "A";
                    }
                    case 1: {
                        return "B";
                    }
                    case 2: {
                        return "C";
                    }
                }
                return null;
            }
        }
        return null;
    }

    @Override
    protected Object encodeCommand(Command command) {
        this.initDevicePassword(command, "123456");
        switch (command.getType()) {
            case "setTimezone": {
                return this.formatCommand(command, "%sL%s", this, "devicePassword", "timezone");
            }
            case "voiceMonitoring": {
                return this.formatCommand(command, "%sP%s", this, "devicePassword", "enable");
            }
            case "alarmSpeed": {
                return this.formatCommand(command, "%sJ1%s", "devicePassword", "data");
            }
            case "alarmGeofence": {
                return this.formatCommand(command, "%sR1%s", "devicePassword", "radius");
            }
            case "alarmVibration": {
                return this.formatCommand(command, "%sW1,%s", "devicePassword", "data");
            }
            case "setAgps": {
                return this.formatCommand(command, "%sAGPS%s", this, "devicePassword", "enable");
            }
            case "alarmFall": {
                return this.formatCommand(command, "%sF%s", this, "devicePassword", "enable");
            }
            case "modePowerSaving": {
                return this.formatCommand(command, "%sSP%s", this, "devicePassword", "enable");
            }
            case "modeDeepSleep": {
                return this.formatCommand(command, "%sDS%s", this, "devicePassword", "enable");
            }
            case "sosNumber": {
                return this.formatCommand(command, "%s%s1,%s", this, "devicePassword", "index", "phone");
            }
            case "setIndicator": {
                return this.formatCommand(command, "%sLED%s", "devicePassword", "data");
            }
        }
        return null;
    }
}

