/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.string.StringEncoder;
import jakarta.inject.Inject;
import org.traccar.BaseProtocol;
import org.traccar.PipelineBuilder;
import org.traccar.TrackerServer;
import org.traccar.config.Config;
import org.traccar.protocol.MeitrackFrameDecoder;
import org.traccar.protocol.MeitrackProtocolDecoder;
import org.traccar.protocol.MeitrackProtocolEncoder;

public class MeitrackProtocol
extends BaseProtocol {
    @Inject
    public MeitrackProtocol(Config config) {
        this.setSupportedDataCommands("positionSingle", "engineStop", "engineResume", "alarmArm", "alarmDisarm", "requestPhoto", "sendSms");
        this.addServer(new TrackerServer(config, this.getName(), false){

            @Override
            protected void addProtocolHandlers(PipelineBuilder pipeline, Config config) {
                pipeline.addLast((ChannelHandler)new MeitrackFrameDecoder());
                pipeline.addLast((ChannelHandler)new StringEncoder());
                pipeline.addLast((ChannelHandler)new MeitrackProtocolEncoder(MeitrackProtocol.this));
                pipeline.addLast((ChannelHandler)new MeitrackProtocolDecoder(MeitrackProtocol.this));
            }
        });
        this.addServer(new TrackerServer(config, this.getName(), true){

            @Override
            protected void addProtocolHandlers(PipelineBuilder pipeline, Config config) {
                pipeline.addLast((ChannelHandler)new StringEncoder());
                pipeline.addLast((ChannelHandler)new MeitrackProtocolEncoder(MeitrackProtocol.this));
                pipeline.addLast((ChannelHandler)new MeitrackProtocolDecoder(MeitrackProtocol.this));
            }
        });
    }
}

