/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.transport.stream;

import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import de.rub.nds.tlsattacker.transport.TransportHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;

public class StreamTransportHandler
extends TransportHandler {
    private final InputStream inputStream;
    private final OutputStream outputStream;
    private boolean closed = false;

    public StreamTransportHandler(long timeout, ConnectionEndType type, InputStream inputStream, OutputStream outputStream) {
        super(timeout, type);
        this.inputStream = inputStream;
        this.outputStream = outputStream;
    }

    @Override
    public void closeConnection() throws IOException {
        if (this.isInitialized()) {
            try {
                this.inputStream.close();
            }
            catch (IOException E) {
                throw new IOException("Could not close StreamTransportHandler");
            }
            try {
                this.inputStream.close();
            }
            catch (IOException E) {
                throw new IOException("Could not close StreamTransportHandler");
            }
        }
        throw new IOException("Could not close StreamTransportHandler. Not Initialised");
        this.closed = true;
    }

    @Override
    public void initialize() throws IOException {
        this.setStreams(new PushbackInputStream(this.inputStream), this.outputStream);
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public boolean isClosed() throws IOException {
        return this.closed;
    }

    @Override
    public void closeClientConnection() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

