/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSourceDropEvent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.DragDropUtilities;
import org.openide.explorer.view.DropGlassPane;
import org.openide.explorer.view.ExplorerDragSupport;
import org.openide.explorer.view.TreeView;
import org.openide.explorer.view.TreeViewCellEditor;
import org.openide.nodes.Node;

final class TreeViewDragSupport
extends ExplorerDragSupport {
    protected TreeView view;
    private JTree tree;

    public TreeViewDragSupport(TreeView treeView, JTree jTree) {
        this.view = treeView;
        this.comp = jTree;
        this.tree = jTree;
    }

    public int getAllowedDragActions() {
        return this.view.getAllowedDragActions();
    }

    int getAllowedDropActions() {
        return this.view.getAllowedDropActions();
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        TreeCellEditor treeCellEditor;
        super.dragGestureRecognized(dragGestureEvent);
        if (this.exDnD.isDnDActive() && (treeCellEditor = this.tree.getCellEditor()) instanceof TreeViewCellEditor) {
            ((TreeViewCellEditor)treeCellEditor).setDnDActive(true);
        }
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        Object object;
        Node[] nodeArray = this.exDnD.getDraggedNodes();
        super.dragDropEnd(dragSourceDropEvent);
        if (DropGlassPane.isOriginalPaneStored()) {
            DropGlassPane.putBackOriginal();
            this.exDnD.setDnDActive(false);
        }
        try {
            if (nodeArray != null && (object = (ExplorerManager.Provider)((Object)SwingUtilities.getAncestorOfClass(ExplorerManager.Provider.class, this.view))) != null) {
                object.getExplorerManager().setSelectedNodes(nodeArray);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = this.tree.getCellEditor();
        if (object instanceof TreeViewCellEditor) {
            ((TreeViewCellEditor)object).setDnDActive(false);
        }
    }

    Node[] obtainNodes(DragGestureEvent dragGestureEvent) {
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray == null) {
            return null;
        }
        Node[] nodeArray = new Node[treePathArray.length];
        int n = 0;
        for (int i = 0; i < treePathArray.length; ++i) {
            if (this.tree.getPathBounds(treePathArray[i]).contains(dragGestureEvent.getDragOrigin())) {
                ++n;
            }
            nodeArray[i] = DragDropUtilities.secureFindNode(treePathArray[i].getLastPathComponent());
        }
        return n == 0 ? null : nodeArray;
    }
}

