/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.router;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.api.visual.router.CollisionsCollector;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WidgetsCollisionCollector
implements CollisionsCollector {
    private LayerWidget[] layers;

    public WidgetsCollisionCollector(LayerWidget ... layerWidgetArray) {
        this.layers = layerWidgetArray;
    }

    @Override
    public void collectCollisions(List<Rectangle> list, List<Rectangle> list2) {
        for (Widget widget : this.getWidgets()) {
            Object object;
            Object object2;
            if (!widget.isValidated()) continue;
            if (widget instanceof ConnectionWidget) {
                object2 = (ConnectionWidget)widget;
                if (!((ConnectionWidget)object2).isRouted()) continue;
                object = ((ConnectionWidget)object2).getControlPoints();
                int n = object.size() - 1;
                for (int i = 0; i < n; ++i) {
                    Rectangle rectangle;
                    Point point = (Point)object.get(i);
                    Point point2 = (Point)object.get(i + 1);
                    if (point.x == point2.x) {
                        rectangle = new Rectangle(point.x, Math.min(point.y, point2.y), 0, Math.abs(point2.y - point.y));
                        rectangle.grow(8, 8);
                        list.add(rectangle);
                        continue;
                    }
                    if (point.y != point2.y) continue;
                    rectangle = new Rectangle(Math.min(point.x, point2.x), point.y, Math.abs(point2.x - point.x), 0);
                    rectangle.grow(8, 8);
                    list2.add(rectangle);
                }
                continue;
            }
            object2 = widget.getBounds();
            object = widget.convertLocalToScene((Rectangle)object2);
            ((Rectangle)object).grow(16, 16);
            list.add((Rectangle)object);
            list2.add((Rectangle)object);
        }
    }

    protected Collection<Widget> getWidgets() {
        ArrayList<Widget> arrayList = new ArrayList<Widget>();
        for (LayerWidget layerWidget : this.layers) {
            arrayList.addAll(layerWidget.getChildren());
        }
        return arrayList;
    }
}

