# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("comctl32.dll")
prototypes = \
    {
        #
        'CreatePropertySheetPageA': SimTypeFunction([SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "hInstance": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Anonymous1": SimUnion({"pszTemplate": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pResource": SimTypePointer(SimTypeBottom(label="DLGTEMPLATE"), offset=0)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"hIcon": SimTypeBottom(label="HICON"), "pszIcon": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None"), "pszTitle": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pfnDlgProc": SimTypeBottom(label="DLGPROC"), "lParam": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnCallback": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="PSPCB_MESSAGE"), SimTypePointer(SimTypeBottom(label="PROPSHEETPAGEA"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwnd", "uMsg", "ppsp"]), offset=0), "pcRefParent": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pszHeaderTitle": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pszHeaderSubTitle": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "hActCtx": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Anonymous3": SimUnion({"hbmHeader": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pszbmHeader": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None")}, name="PROPSHEETPAGEA", pack=False, align=None), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["constPropSheetPagePointer"]),
        #
        'CreatePropertySheetPageW': SimTypeFunction([SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "hInstance": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Anonymous1": SimUnion({"pszTemplate": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pResource": SimTypePointer(SimTypeBottom(label="DLGTEMPLATE"), offset=0)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"hIcon": SimTypeBottom(label="HICON"), "pszIcon": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None"), "pszTitle": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pfnDlgProc": SimTypeBottom(label="DLGPROC"), "lParam": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnCallback": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="PSPCB_MESSAGE"), SimTypePointer(SimTypeBottom(label="PROPSHEETPAGEW"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwnd", "uMsg", "ppsp"]), offset=0), "pcRefParent": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pszHeaderTitle": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pszHeaderSubTitle": SimTypePointer(SimTypeChar(label="Char"), offset=0), "hActCtx": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Anonymous3": SimUnion({"hbmHeader": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pszbmHeader": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="PROPSHEETPAGEW", pack=False, align=None), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["constPropSheetPagePointer"]),
        #
        'DestroyPropertySheetPage': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0"]),
        #
        'PropertySheetA': SimTypeFunction([SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "hwndParent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hInstance": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Anonymous1": SimUnion({"hIcon": SimTypeBottom(label="HICON"), "pszIcon": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None"), "pszCaption": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "nPages": SimTypeInt(signed=False, label="UInt32"), "Anonymous2": SimUnion({"nStartPage": SimTypeInt(signed=False, label="UInt32"), "pStartPage": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None"), "Anonymous3": SimUnion({"ppsp": SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "hInstance": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Anonymous1": SimUnion({"pszTemplate": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pResource": SimTypePointer(SimTypeBottom(label="DLGTEMPLATE"), offset=0)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"hIcon": SimTypeBottom(label="HICON"), "pszIcon": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None"), "pszTitle": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pfnDlgProc": SimTypeBottom(label="DLGPROC"), "lParam": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnCallback": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="PSPCB_MESSAGE"), SimTypePointer(SimTypeBottom(label="PROPSHEETPAGEA"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwnd", "uMsg", "ppsp"]), offset=0), "pcRefParent": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pszHeaderTitle": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pszHeaderSubTitle": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "hActCtx": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Anonymous3": SimUnion({"hbmHeader": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pszbmHeader": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None")}, name="PROPSHEETPAGEA", pack=False, align=None), offset=0), "phpage": SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)}, name="<anon>", label="None"), "pfnCallback": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2"]), offset=0), "Anonymous4": SimUnion({"hbmWatermark": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pszbmWatermark": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None"), "hplWatermark": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Anonymous5": SimUnion({"hbmHeader": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pszbmHeader": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None")}, name="PROPSHEETHEADERA_V2", pack=False, align=None), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["param0"]),
        #
        'PropertySheetW': SimTypeFunction([SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "hwndParent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hInstance": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Anonymous1": SimUnion({"hIcon": SimTypeBottom(label="HICON"), "pszIcon": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None"), "pszCaption": SimTypePointer(SimTypeChar(label="Char"), offset=0), "nPages": SimTypeInt(signed=False, label="UInt32"), "Anonymous2": SimUnion({"nStartPage": SimTypeInt(signed=False, label="UInt32"), "pStartPage": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None"), "Anonymous3": SimUnion({"ppsp": SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "hInstance": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Anonymous1": SimUnion({"pszTemplate": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pResource": SimTypePointer(SimTypeBottom(label="DLGTEMPLATE"), offset=0)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"hIcon": SimTypeBottom(label="HICON"), "pszIcon": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None"), "pszTitle": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pfnDlgProc": SimTypeBottom(label="DLGPROC"), "lParam": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnCallback": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="PSPCB_MESSAGE"), SimTypePointer(SimTypeBottom(label="PROPSHEETPAGEW"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwnd", "uMsg", "ppsp"]), offset=0), "pcRefParent": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pszHeaderTitle": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pszHeaderSubTitle": SimTypePointer(SimTypeChar(label="Char"), offset=0), "hActCtx": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Anonymous3": SimUnion({"hbmHeader": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pszbmHeader": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="PROPSHEETPAGEW", pack=False, align=None), offset=0), "phpage": SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)}, name="<anon>", label="None"), "pfnCallback": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2"]), offset=0), "Anonymous4": SimUnion({"hbmWatermark": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pszbmWatermark": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None"), "hplWatermark": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Anonymous5": SimUnion({"hbmHeader": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pszbmHeader": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="PROPSHEETHEADERW_V2", pack=False, align=None), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["param0"]),
        #
        'InitCommonControls': SimTypeFunction([], SimTypeBottom(label="Void")),
        #
        'InitCommonControlsEx': SimTypeFunction([SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwICC": SimTypeInt(signed=False, label="INITCOMMONCONTROLSEX_ICC")}, name="INITCOMMONCONTROLSEX", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["picce"]),
        #
        'ImageList_Create': SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="IMAGELIST_CREATION_FLAGS"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["cx", "cy", "flags", "cInitial", "cGrow"]),
        #
        'ImageList_Destroy': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["himl"]),
        #
        'ImageList_GetImageCount': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["himl"]),
        #
        'ImageList_SetImageCount': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["himl", "uNewCount"]),
        #
        'ImageList_Add': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["himl", "hbmImage", "hbmMask"]),
        #
        'ImageList_ReplaceIcon': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["himl", "i", "hicon"]),
        #
        'ImageList_SetBkColor': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["himl", "clrBk"]),
        #
        'ImageList_GetBkColor': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["himl"]),
        #
        'ImageList_SetOverlayImage': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["himl", "iImage", "iOverlay"]),
        #
        'ImageList_Draw': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="IMAGE_LIST_DRAW_STYLE")], SimTypeInt(signed=True, label="Int32"), arg_names=["himl", "i", "hdcDst", "x", "y", "fStyle"]),
        #
        'ImageList_Replace': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["himl", "i", "hbmImage", "hbmMask"]),
        #
        'ImageList_AddMasked': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["himl", "hbmImage", "crMask"]),
        #
        'ImageList_DrawEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="IMAGE_LIST_DRAW_STYLE")], SimTypeInt(signed=True, label="Int32"), arg_names=["himl", "i", "hdcDst", "x", "y", "dx", "dy", "rgbBk", "rgbFg", "fStyle"]),
        #
        'ImageList_DrawIndirect': SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "himl": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "i": SimTypeInt(signed=True, label="Int32"), "hdcDst": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32"), "cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32"), "xBitmap": SimTypeInt(signed=True, label="Int32"), "yBitmap": SimTypeInt(signed=True, label="Int32"), "rgbBk": SimTypeInt(signed=False, label="UInt32"), "rgbFg": SimTypeInt(signed=False, label="UInt32"), "fStyle": SimTypeInt(signed=False, label="UInt32"), "dwRop": SimTypeInt(signed=False, label="UInt32"), "fState": SimTypeInt(signed=False, label="UInt32"), "Frame": SimTypeInt(signed=False, label="UInt32"), "crEffect": SimTypeInt(signed=False, label="UInt32")}, name="IMAGELISTDRAWPARAMS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pimldp"]),
        #
        'ImageList_Remove': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["himl", "i"]),
        #
        'ImageList_GetIcon': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["himl", "i", "flags"]),
        #
        'ImageList_LoadImageA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="IMAGE_FLAGS")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hi", "lpbmp", "cx", "cGrow", "crMask", "uType", "uFlags"]),
        #
        'ImageList_LoadImageW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="IMAGE_FLAGS")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hi", "lpbmp", "cx", "cGrow", "crMask", "uType", "uFlags"]),
        #
        'ImageList_Copy': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="IMAGE_LIST_COPY_FLAGS")], SimTypeInt(signed=True, label="Int32"), arg_names=["himlDst", "iDst", "himlSrc", "iSrc", "uFlags"]),
        #
        'ImageList_BeginDrag': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["himlTrack", "iTrack", "dxHotspot", "dyHotspot"]),
        #
        'ImageList_EndDrag': SimTypeFunction([], SimTypeBottom(label="Void")),
        #
        'ImageList_DragEnter': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hwndLock", "x", "y"]),
        #
        'ImageList_DragLeave': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hwndLock"]),
        #
        'ImageList_DragMove': SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["x", "y"]),
        #
        'ImageList_SetDragCursorImage': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["himlDrag", "iDrag", "dxHotspot", "dyHotspot"]),
        #
        'ImageList_DragShowNolock': SimTypeFunction([SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["fShow"]),
        #
        'ImageList_GetDragImage': SimTypeFunction([SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["ppt", "pptHotspot"]),
        #
        'ImageList_Read': SimTypeFunction([SimTypeBottom(label="IStream")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["pstm"]),
        #
        'ImageList_Write': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeBottom(label="IStream")], SimTypeInt(signed=True, label="Int32"), arg_names=["himl", "pstm"]),
        #
        'ImageList_ReadEx': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeBottom(label="IStream"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwFlags", "pstm", "riid", "ppv"]),
        #
        'ImageList_WriteEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeBottom(label="IStream")], SimTypeInt(signed=True, label="Int32"), arg_names=["himl", "dwFlags", "pstm"]),
        #
        'ImageList_GetIconSize': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["himl", "cx", "cy"]),
        #
        'ImageList_SetIconSize': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["himl", "cx", "cy"]),
        #
        'ImageList_GetImageInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"hbmImage": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hbmMask": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Unused1": SimTypeInt(signed=True, label="Int32"), "Unused2": SimTypeInt(signed=True, label="Int32"), "rcImage": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None)}, name="IMAGEINFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["himl", "i", "pImageInfo"]),
        #
        'ImageList_Merge': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["himl1", "i1", "himl2", "i2", "dx", "dy"]),
        #
        'ImageList_Duplicate': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["himl"]),
        #
        'HIMAGELIST_QueryInterface': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["himl", "riid", "ppv"]),
        #
        'CreateToolbarEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"iBitmap": SimTypeInt(signed=True, label="Int32"), "idCommand": SimTypeInt(signed=True, label="Int32"), "fsState": SimTypeChar(label="Byte"), "fsStyle": SimTypeChar(label="Byte"), "bReserved": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "dwData": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "iString": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="TBBUTTON", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hwnd", "ws", "wID", "nBitmaps", "hBMInst", "wBMID", "lpButtons", "iNumButtons", "dxButton", "dyButton", "dxBitmap", "dyBitmap", "uStructSize"]),
        #
        'CreateMappedBitmap': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"from": SimTypeInt(signed=False, label="UInt32"), "to": SimTypeInt(signed=False, label="UInt32")}, name="COLORMAP", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hInstance", "idBitmap", "wFlags", "lpColorMap", "iNumMaps"]),
        #
        'DrawStatusTextA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["hDC", "lprc", "pszText", "uFlags"]),
        #
        'DrawStatusTextW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["hDC", "lprc", "pszText", "uFlags"]),
        #
        'CreateStatusWindowA': SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["style", "lpszText", "hwndParent", "wID"]),
        #
        'CreateStatusWindowW': SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["style", "lpszText", "hwndParent", "wID"]),
        #
        'MenuHelp': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeBottom(label="Void"), arg_names=["uMsg", "wParam", "lParam", "hMainMenu", "hInst", "hwndStatus", "lpwIDs"]),
        #
        'ShowHideMenuCtl': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hWnd", "uFlags", "lpInfo"]),
        #
        'GetEffectiveClientRect': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeBottom(label="Void"), arg_names=["hWnd", "lprc", "lpInfo"]),
        #
        'MakeDragList': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLB"]),
        #
        'DrawInsert': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeBottom(label="Void"), arg_names=["handParent", "hLB", "nItem"]),
        #
        'LBItemFromPt': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hLB", "pt", "bAutoScroll"]),
        #
        'CreateUpDownControl': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["dwStyle", "x", "y", "cx", "cy", "hParent", "nID", "hInst", "hBuddy", "nUpper", "nLower", "nPos"]),
        #
        'TaskDialogIndirect': SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "hwndParent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hInstance": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dwFlags": SimTypeInt(signed=False, label="TASKDIALOG_FLAGS"), "dwCommonButtons": SimTypeInt(signed=False, label="TASKDIALOG_COMMON_BUTTON_FLAGS"), "pszWindowTitle": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Anonymous1": SimUnion({"hMainIcon": SimTypeBottom(label="HICON"), "pszMainIcon": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None"), "pszMainInstruction": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pszContent": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cButtons": SimTypeInt(signed=False, label="UInt32"), "pButtons": SimTypePointer(SimStruct({"nButtonID": SimTypeInt(signed=True, label="Int32"), "pszButtonText": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="TASKDIALOG_BUTTON", pack=False, align=None), offset=0), "nDefaultButton": SimTypeInt(signed=True, label="Int32"), "cRadioButtons": SimTypeInt(signed=False, label="UInt32"), "pRadioButtons": SimTypePointer(SimStruct({"nButtonID": SimTypeInt(signed=True, label="Int32"), "pszButtonText": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="TASKDIALOG_BUTTON", pack=False, align=None), offset=0), "nDefaultRadioButton": SimTypeInt(signed=True, label="Int32"), "pszVerificationText": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pszExpandedInformation": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pszExpandedControlText": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pszCollapsedControlText": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Anonymous2": SimUnion({"hFooterIcon": SimTypeBottom(label="HICON"), "pszFooterIcon": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None"), "pszFooter": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pfCallback": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "msg", "wParam", "lParam", "lpRefData"]), offset=0), "lpCallbackData": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "cxWidth": SimTypeInt(signed=False, label="UInt32")}, name="TASKDIALOGCONFIG", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pTaskConfig", "pnButton", "pnRadioButton", "pfVerificationFlagChecked"]),
        #
        'TaskDialog': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="TASKDIALOG_COMMON_BUTTON_FLAGS"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hwndOwner", "hInstance", "pszWindowTitle", "pszMainInstruction", "pszContent", "dwCommonButtons", "pszIcon", "pnButton"]),
        #
        'InitMUILanguage': SimTypeFunction([SimTypeShort(signed=False, label="UInt16")], SimTypeBottom(label="Void"), arg_names=["uiLang"]),
        #
        'GetMUILanguage': SimTypeFunction([], SimTypeShort(signed=False, label="UInt16")),
        #
        'DSA_Create': SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypePointer(SimStruct({}, name="_DSA", pack=False, align=None), offset=0), arg_names=["cbItem", "cItemGrow"]),
        #
        'DSA_Destroy': SimTypeFunction([SimTypePointer(SimStruct({}, name="_DSA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdsa"]),
        #
        'DSA_DestroyCallback': SimTypeFunction([SimTypePointer(SimStruct({}, name="_DSA", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["p", "pData"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["hdsa", "pfnCB", "pData"]),
        #
        'DSA_DeleteItem': SimTypeFunction([SimTypePointer(SimStruct({}, name="_DSA", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdsa", "i"]),
        #
        'DSA_DeleteAllItems': SimTypeFunction([SimTypePointer(SimStruct({}, name="_DSA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdsa"]),
        #
        'DSA_EnumCallback': SimTypeFunction([SimTypePointer(SimStruct({}, name="_DSA", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["p", "pData"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["hdsa", "pfnCB", "pData"]),
        #
        'DSA_InsertItem': SimTypeFunction([SimTypePointer(SimStruct({}, name="_DSA", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdsa", "i", "pitem"]),
        #
        'DSA_GetItemPtr': SimTypeFunction([SimTypePointer(SimStruct({}, name="_DSA", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["hdsa", "i"]),
        #
        'DSA_GetItem': SimTypeFunction([SimTypePointer(SimStruct({}, name="_DSA", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdsa", "i", "pitem"]),
        #
        'DSA_SetItem': SimTypeFunction([SimTypePointer(SimStruct({}, name="_DSA", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdsa", "i", "pitem"]),
        #
        'DSA_Clone': SimTypeFunction([SimTypePointer(SimStruct({}, name="_DSA", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({}, name="_DSA", pack=False, align=None), offset=0), arg_names=["hdsa"]),
        #
        'DSA_GetSize': SimTypeFunction([SimTypePointer(SimStruct({}, name="_DSA", pack=False, align=None), offset=0)], SimTypeLongLong(signed=False, label="UInt64"), arg_names=["hdsa"]),
        #
        'DSA_Sort': SimTypeFunction([SimTypePointer(SimStruct({}, name="_DSA", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["p1", "p2", "lParam"]), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pdsa", "pfnCompare", "lParam"]),
        #
        'DPA_Create': SimTypeFunction([SimTypeInt(signed=True, label="Int32")], SimTypePointer(SimStruct({}, name="_DPA", pack=False, align=None), offset=0), arg_names=["cItemGrow"]),
        #
        'DPA_CreateEx': SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimStruct({}, name="_DPA", pack=False, align=None), offset=0), arg_names=["cpGrow", "hheap"]),
        #
        'DPA_Clone': SimTypeFunction([SimTypePointer(SimStruct({}, name="_DPA", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_DPA", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({}, name="_DPA", pack=False, align=None), offset=0), arg_names=["hdpa", "hdpaNew"]),
        #
        'DPA_Destroy': SimTypeFunction([SimTypePointer(SimStruct({}, name="_DPA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdpa"]),
        #
        'DPA_DestroyCallback': SimTypeFunction([SimTypePointer(SimStruct({}, name="_DPA", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["p", "pData"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["hdpa", "pfnCB", "pData"]),
        #
        'DPA_DeletePtr': SimTypeFunction([SimTypePointer(SimStruct({}, name="_DPA", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["hdpa", "i"]),
        #
        'DPA_DeleteAllPtrs': SimTypeFunction([SimTypePointer(SimStruct({}, name="_DPA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdpa"]),
        #
        'DPA_EnumCallback': SimTypeFunction([SimTypePointer(SimStruct({}, name="_DPA", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["p", "pData"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["hdpa", "pfnCB", "pData"]),
        #
        'DPA_Grow': SimTypeFunction([SimTypePointer(SimStruct({}, name="_DPA", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pdpa", "cp"]),
        #
        'DPA_InsertPtr': SimTypeFunction([SimTypePointer(SimStruct({}, name="_DPA", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdpa", "i", "p"]),
        #
        'DPA_SetPtr': SimTypeFunction([SimTypePointer(SimStruct({}, name="_DPA", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdpa", "i", "p"]),
        #
        'DPA_GetPtr': SimTypeFunction([SimTypePointer(SimStruct({}, name="_DPA", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["hdpa", "i"]),
        #
        'DPA_GetPtrIndex': SimTypeFunction([SimTypePointer(SimStruct({}, name="_DPA", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdpa", "p"]),
        #
        'DPA_GetSize': SimTypeFunction([SimTypePointer(SimStruct({}, name="_DPA", pack=False, align=None), offset=0)], SimTypeLongLong(signed=False, label="UInt64"), arg_names=["hdpa"]),
        #
        'DPA_Sort': SimTypeFunction([SimTypePointer(SimStruct({}, name="_DPA", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["p1", "p2", "lParam"]), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdpa", "pfnCompare", "lParam"]),
        #
        'DPA_LoadStream': SimTypeFunction([SimTypePointer(SimTypePointer(SimStruct({}, name="_DPA", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"iPos": SimTypeInt(signed=True, label="Int32"), "pvItem": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="DPASTREAMINFO", pack=False, align=None), offset=0), SimTypeBottom(label="IStream"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pinfo", "pstream", "pvInstData"]), offset=0), SimTypeBottom(label="IStream"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["phdpa", "pfn", "pstream", "pvInstData"]),
        #
        'DPA_SaveStream': SimTypeFunction([SimTypePointer(SimStruct({}, name="_DPA", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"iPos": SimTypeInt(signed=True, label="Int32"), "pvItem": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="DPASTREAMINFO", pack=False, align=None), offset=0), SimTypeBottom(label="IStream"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pinfo", "pstream", "pvInstData"]), offset=0), SimTypeBottom(label="IStream"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdpa", "pfn", "pstream", "pvInstData"]),
        #
        'DPA_Merge': SimTypeFunction([SimTypePointer(SimStruct({}, name="_DPA", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_DPA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["p1", "p2", "lParam"]), offset=0), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="DPAMM_MESSAGE"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["uMsg", "pvDest", "pvSrc", "lParam"]), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdpaDest", "hdpaSrc", "dwFlags", "pfnCompare", "pfnMerge", "lParam"]),
        #
        'DPA_Search': SimTypeFunction([SimTypePointer(SimStruct({}, name="_DPA", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["p1", "p2", "lParam"]), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdpa", "pFind", "iStart", "pfnCompare", "lParam", "options"]),
        #
        'Str_SetPtrW': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ppsz", "psz"]),
        #
        'FlatSB_EnableScrollBar': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2"]),
        #
        'FlatSB_ShowScrollBar': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="SCROLLBAR_CONSTANTS"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "code", "param2"]),
        #
        'FlatSB_GetScrollRange': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="SCROLLBAR_CONSTANTS"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "code", "param2", "param3"]),
        #
        'FlatSB_GetScrollInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="SCROLLBAR_CONSTANTS"), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "fMask": SimTypeInt(signed=False, label="SCROLLINFO_MASK"), "nMin": SimTypeInt(signed=True, label="Int32"), "nMax": SimTypeInt(signed=True, label="Int32"), "nPage": SimTypeInt(signed=False, label="UInt32"), "nPos": SimTypeInt(signed=True, label="Int32"), "nTrackPos": SimTypeInt(signed=True, label="Int32")}, name="SCROLLINFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "code", "param2"]),
        #
        'FlatSB_GetScrollPos': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="SCROLLBAR_CONSTANTS")], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "code"]),
        #
        'FlatSB_GetScrollProp': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="WSB_PROP"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "propIndex", "param2"]),
        #
        'FlatSB_SetScrollPos': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="SCROLLBAR_CONSTANTS"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "code", "pos", "fRedraw"]),
        #
        'FlatSB_SetScrollInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="SCROLLBAR_CONSTANTS"), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "fMask": SimTypeInt(signed=False, label="SCROLLINFO_MASK"), "nMin": SimTypeInt(signed=True, label="Int32"), "nMax": SimTypeInt(signed=True, label="Int32"), "nPage": SimTypeInt(signed=False, label="UInt32"), "nPos": SimTypeInt(signed=True, label="Int32"), "nTrackPos": SimTypeInt(signed=True, label="Int32")}, name="SCROLLINFO", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "code", "psi", "fRedraw"]),
        #
        'FlatSB_SetScrollRange': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="SCROLLBAR_CONSTANTS"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "code", "min", "max", "fRedraw"]),
        #
        'FlatSB_SetScrollProp': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="WSB_PROP"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "index", "newValue", "param3"]),
        #
        'InitializeFlatSB': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0"]),
        #
        'UninitializeFlatSB': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0"]),
        #
        'LoadIconMetric': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="_LI_METRIC"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hinst", "pszName", "lims", "phico"]),
        #
        'LoadIconWithScaleDown': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hinst", "pszName", "cx", "cy", "phico"]),
        #
        'DrawShadowText': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "pszText", "cch", "prc", "dwFlags", "crText", "crShadow", "ixOffset", "iyOffset"]),
        #
        'ImageList_CoCreateInstance': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeBottom(label="IUnknown"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["rclsid", "punkOuter", "riid", "ppv"]),
        #
        '_TrackMouseEvent': SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="TRACKMOUSEEVENT_FLAGS"), "hwndTrack": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dwHoverTime": SimTypeInt(signed=False, label="UInt32")}, name="TRACKMOUSEEVENT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpEventTrack"]),
        #
        'SetWindowSubclass': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hWnd", "uMsg", "wParam", "lParam", "uIdSubclass", "dwRefData"]), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hWnd", "pfnSubclass", "uIdSubclass", "dwRefData"]),
        #
        'GetWindowSubclass': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hWnd", "uMsg", "wParam", "lParam", "uIdSubclass", "dwRefData"]), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hWnd", "pfnSubclass", "uIdSubclass", "pdwRefData"]),
        #
        'RemoveWindowSubclass': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hWnd", "uMsg", "wParam", "lParam", "uIdSubclass", "dwRefData"]), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hWnd", "pfnSubclass", "uIdSubclass"]),
        #
        'DefSubclassProc': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hWnd", "uMsg", "wParam", "lParam"]),
    }

lib.set_prototypes(prototypes)
