/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.fill.JRComparableIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRDefaultIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRIncrementer;
import net.sf.jasperreports.engine.fill.JRIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRShortAverageIncrementer;
import net.sf.jasperreports.engine.fill.JRShortCountIncrementer;
import net.sf.jasperreports.engine.fill.JRShortStandardDeviationIncrementer;
import net.sf.jasperreports.engine.fill.JRShortSumIncrementer;
import net.sf.jasperreports.engine.fill.JRShortVarianceIncrementer;

public class JRShortIncrementerFactory
implements JRIncrementerFactory {
    protected static final Short ZERO = new Short(0);
    private static JRShortIncrementerFactory mainInstance = new JRShortIncrementerFactory();

    private JRShortIncrementerFactory() {
    }

    public static JRShortIncrementerFactory getInstance() {
        return mainInstance;
    }

    public JRIncrementer getIncrementer(byte calculation) {
        JRIncrementer incrementer = null;
        switch (calculation) {
            case 1: {
                incrementer = JRShortCountIncrementer.getInstance();
                break;
            }
            case 2: {
                incrementer = JRShortSumIncrementer.getInstance();
                break;
            }
            case 3: {
                incrementer = JRShortAverageIncrementer.getInstance();
                break;
            }
            case 4: 
            case 5: {
                incrementer = JRComparableIncrementerFactory.getInstance().getIncrementer(calculation);
                break;
            }
            case 6: {
                incrementer = JRShortStandardDeviationIncrementer.getInstance();
                break;
            }
            case 7: {
                incrementer = JRShortVarianceIncrementer.getInstance();
                break;
            }
            default: {
                incrementer = JRDefaultIncrementerFactory.getInstance().getIncrementer(calculation);
            }
        }
        return incrementer;
    }
}

