/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.nodes.TransportNodesAction;
import org.opensearch.ad.stats.ADStats;
import org.opensearch.ad.stats.InternalStatNames;
import org.opensearch.ad.task.ADTaskManager;
import org.opensearch.ad.transport.ADStatsNodeRequest;
import org.opensearch.ad.transport.ADStatsNodeResponse;
import org.opensearch.ad.transport.ADStatsNodesAction;
import org.opensearch.ad.transport.ADStatsNodesResponse;
import org.opensearch.ad.transport.ADStatsRequest;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.monitor.jvm.JvmService;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class ADStatsNodesTransportAction
extends TransportNodesAction<ADStatsRequest, ADStatsNodesResponse, ADStatsNodeRequest, ADStatsNodeResponse> {
    private ADStats adStats;
    private final JvmService jvmService;
    private final ADTaskManager adTaskManager;

    @Inject
    public ADStatsNodesTransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, ADStats adStats, JvmService jvmService, ADTaskManager adTaskManager) {
        super(ADStatsNodesAction.NAME, threadPool, clusterService, transportService, actionFilters, ADStatsRequest::new, ADStatsNodeRequest::new, "management", ADStatsNodeResponse.class);
        this.adStats = adStats;
        this.jvmService = jvmService;
        this.adTaskManager = adTaskManager;
    }

    protected ADStatsNodesResponse newResponse(ADStatsRequest request, List<ADStatsNodeResponse> responses, List<FailedNodeException> failures) {
        return new ADStatsNodesResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected ADStatsNodeRequest newNodeRequest(ADStatsRequest request) {
        return new ADStatsNodeRequest(request);
    }

    protected ADStatsNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new ADStatsNodeResponse(in);
    }

    protected ADStatsNodeResponse nodeOperation(ADStatsNodeRequest request) {
        return this.createADStatsNodeResponse(request.getADStatsRequest());
    }

    private ADStatsNodeResponse createADStatsNodeResponse(ADStatsRequest adStatsRequest) {
        HashMap<String, Object> statValues = new HashMap<String, Object>();
        Set<String> statsToBeRetrieved = adStatsRequest.getStatsToBeRetrieved();
        if (statsToBeRetrieved.contains(InternalStatNames.JVM_HEAP_USAGE.getName())) {
            long heapUsedPercent = this.jvmService.stats().getMem().getHeapUsedPercent();
            statValues.put(InternalStatNames.JVM_HEAP_USAGE.getName(), heapUsedPercent);
        }
        if (statsToBeRetrieved.contains(InternalStatNames.AD_USED_BATCH_TASK_SLOT_COUNT.getName())) {
            int usedTaskSlot = this.adTaskManager.getLocalAdUsedBatchTaskSlot();
            statValues.put(InternalStatNames.AD_USED_BATCH_TASK_SLOT_COUNT.getName(), usedTaskSlot);
        }
        if (statsToBeRetrieved.contains(InternalStatNames.AD_DETECTOR_ASSIGNED_BATCH_TASK_SLOT_COUNT.getName())) {
            int assignedBatchTaskSlot = this.adTaskManager.getLocalAdAssignedBatchTaskSlot();
            statValues.put(InternalStatNames.AD_DETECTOR_ASSIGNED_BATCH_TASK_SLOT_COUNT.getName(), assignedBatchTaskSlot);
        }
        for (String statName : this.adStats.getNodeStats().keySet()) {
            if (!statsToBeRetrieved.contains(statName)) continue;
            statValues.put(statName, this.adStats.getStats().get(statName).getValue());
        }
        return new ADStatsNodeResponse(this.clusterService.localNode(), statValues);
    }
}

