/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.transport;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRunnable;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchResponseSections;
import org.opensearch.action.search.ShardSearchFailure;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.search.internal.InternalSearchResponse;
import org.opensearch.securityanalytics.action.SearchRuleRequest;
import org.opensearch.securityanalytics.settings.SecurityAnalyticsSettings;
import org.opensearch.securityanalytics.util.RuleIndices;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportSearchRuleAction
extends HandledTransportAction<SearchRuleRequest, SearchResponse> {
    private static final Logger log = LogManager.getLogger(TransportSearchRuleAction.class);
    private final Client client;
    private final RuleIndices ruleIndices;
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final Settings settings;
    private volatile TimeValue indexTimeout;

    @Inject
    public TransportSearchRuleAction(TransportService transportService, Client client, ActionFilters actionFilters, ClusterService clusterService, RuleIndices ruleIndices, Settings settings) {
        super("cluster:admin/opensearch/securityanalytics/rule/search", transportService, actionFilters, SearchRuleRequest::new);
        this.client = client;
        this.ruleIndices = ruleIndices;
        this.threadPool = ruleIndices.getThreadPool();
        this.clusterService = clusterService;
        this.settings = settings;
        this.indexTimeout = (TimeValue)SecurityAnalyticsSettings.INDEX_TIMEOUT.get(this.settings);
    }

    protected void doExecute(Task task, SearchRuleRequest request, ActionListener<SearchResponse> listener) {
        AsyncSearchRulesAction asyncAction = new AsyncSearchRulesAction(task, request, listener);
        asyncAction.start();
    }

    class AsyncSearchRulesAction {
        private SearchRuleRequest request;
        private final ActionListener<SearchResponse> listener;
        private final AtomicReference<Object> response;
        private final AtomicBoolean counter = new AtomicBoolean();
        private final Task task;

        AsyncSearchRulesAction(Task task, SearchRuleRequest request, ActionListener<SearchResponse> listener) {
            this.task = task;
            this.request = request;
            this.listener = listener;
            this.response = new AtomicReference();
        }

        void start() {
            TransportSearchRuleAction.this.threadPool.getThreadContext().stashContext();
            if (this.request.isPrepackaged().booleanValue()) {
                TransportSearchRuleAction.this.ruleIndices.initPrepackagedRulesIndex(new ActionListener<CreateIndexResponse>(){

                    public void onResponse(CreateIndexResponse response) {
                        TransportSearchRuleAction.this.ruleIndices.onCreateMappingsResponse(response, true);
                        TransportSearchRuleAction.this.ruleIndices.importRules(WriteRequest.RefreshPolicy.IMMEDIATE, TransportSearchRuleAction.this.indexTimeout, new ActionListener<BulkResponse>(){

                            public void onResponse(BulkResponse response) {
                                if (!response.hasFailures()) {
                                    AsyncSearchRulesAction.this.search(AsyncSearchRulesAction.this.request.getSearchRequest());
                                } else {
                                    AsyncSearchRulesAction.this.onFailures((Exception)new OpenSearchStatusException(response.buildFailureMessage(), RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                                }
                            }

                            public void onFailure(Exception e) {
                                AsyncSearchRulesAction.this.onFailures(e);
                            }
                        });
                    }

                    public void onFailure(Exception e) {
                        AsyncSearchRulesAction.this.onFailures(e);
                    }
                }, new ActionListener<AcknowledgedResponse>(){

                    public void onResponse(AcknowledgedResponse response) {
                        TransportSearchRuleAction.this.ruleIndices.onUpdateMappingsResponse(response, true);
                        TransportSearchRuleAction.this.ruleIndices.deleteRules(new ActionListener<BulkByScrollResponse>(){

                            public void onResponse(BulkByScrollResponse response) {
                                TransportSearchRuleAction.this.ruleIndices.importRules(WriteRequest.RefreshPolicy.IMMEDIATE, TransportSearchRuleAction.this.indexTimeout, new ActionListener<BulkResponse>(){

                                    public void onResponse(BulkResponse response) {
                                        if (!response.hasFailures()) {
                                            AsyncSearchRulesAction.this.search(AsyncSearchRulesAction.this.request.getSearchRequest());
                                        } else {
                                            AsyncSearchRulesAction.this.onFailures((Exception)new OpenSearchStatusException(response.buildFailureMessage(), RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                                        }
                                    }

                                    public void onFailure(Exception e) {
                                        AsyncSearchRulesAction.this.onFailures(e);
                                    }
                                });
                            }

                            public void onFailure(Exception e) {
                                AsyncSearchRulesAction.this.onFailures(e);
                            }
                        });
                    }

                    public void onFailure(Exception e) {
                        AsyncSearchRulesAction.this.onFailures(e);
                    }
                }, new ActionListener<SearchResponse>(){

                    public void onResponse(SearchResponse response) {
                        long count = response.getHits().getTotalHits().value;
                        if (count == 0L) {
                            TransportSearchRuleAction.this.ruleIndices.importRules(WriteRequest.RefreshPolicy.IMMEDIATE, TransportSearchRuleAction.this.indexTimeout, new ActionListener<BulkResponse>(){

                                public void onResponse(BulkResponse response) {
                                    if (!response.hasFailures()) {
                                        AsyncSearchRulesAction.this.search(AsyncSearchRulesAction.this.request.getSearchRequest());
                                    } else {
                                        AsyncSearchRulesAction.this.onFailures(new RuntimeException(response.buildFailureMessage()));
                                    }
                                }

                                public void onFailure(Exception e) {
                                    AsyncSearchRulesAction.this.onFailures(e);
                                }
                            });
                        } else {
                            AsyncSearchRulesAction.this.search(AsyncSearchRulesAction.this.request.getSearchRequest());
                        }
                    }

                    public void onFailure(Exception e) {
                        AsyncSearchRulesAction.this.onFailures(e);
                    }
                });
            } else if (TransportSearchRuleAction.this.ruleIndices.ruleIndexExists(false)) {
                this.search(this.request.getSearchRequest());
            } else {
                this.listener.onResponse((Object)new SearchResponse((SearchResponseSections)InternalSearchResponse.empty(), null, 1, 1, 0, 1L, ShardSearchFailure.EMPTY_ARRAY, SearchResponse.Clusters.EMPTY));
            }
        }

        private void search(SearchRequest request) {
            TransportSearchRuleAction.this.client.search(request, (ActionListener)new ActionListener<SearchResponse>(){

                public void onResponse(SearchResponse response) {
                    AsyncSearchRulesAction.this.onOperation(response);
                }

                public void onFailure(Exception e) {
                    AsyncSearchRulesAction.this.onFailures(e);
                }
            });
        }

        private void onOperation(SearchResponse response) {
            this.response.set(response);
            if (this.counter.compareAndSet(false, true)) {
                this.finishHim(response, null);
            }
        }

        private void onFailures(Exception t) {
            if (this.counter.compareAndSet(false, true)) {
                this.finishHim(null, t);
            }
        }

        private void finishHim(SearchResponse response, Exception t) {
            TransportSearchRuleAction.this.threadPool.executor("generic").execute((Runnable)ActionRunnable.supply(this.listener, () -> {
                if (t != null) {
                    throw SecurityAnalyticsException.wrap(t);
                }
                return response;
            }));
        }
    }
}

