/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.transport;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.securityanalytics.action.GetDetectorRequest;
import org.opensearch.securityanalytics.action.GetDetectorResponse;
import org.opensearch.securityanalytics.model.Detector;
import org.opensearch.securityanalytics.settings.SecurityAnalyticsSettings;
import org.opensearch.securityanalytics.transport.SecureTransportAction;
import org.opensearch.securityanalytics.util.DetectorIndices;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportGetDetectorAction
extends HandledTransportAction<GetDetectorRequest, GetDetectorResponse>
implements SecureTransportAction {
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;
    private final DetectorIndices detectorIndices;
    private final ClusterService clusterService;
    private final Settings settings;
    private final ThreadPool threadPool;
    private volatile Boolean filterByEnabled;
    private static final Logger log = LogManager.getLogger(TransportGetDetectorAction.class);

    @Inject
    public TransportGetDetectorAction(TransportService transportService, ActionFilters actionFilters, DetectorIndices detectorIndices, ClusterService clusterService, NamedXContentRegistry xContentRegistry, Client client, Settings settings) {
        super("cluster:admin/opensearch/securityanalytics/detector/get", transportService, actionFilters, GetDetectorRequest::new);
        this.xContentRegistry = xContentRegistry;
        this.client = client;
        this.detectorIndices = detectorIndices;
        this.clusterService = clusterService;
        this.threadPool = this.detectorIndices.getThreadPool();
        this.settings = settings;
        this.filterByEnabled = (Boolean)SecurityAnalyticsSettings.FILTER_BY_BACKEND_ROLES.get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(SecurityAnalyticsSettings.FILTER_BY_BACKEND_ROLES, this::setFilterByEnabled);
    }

    protected void doExecute(Task task, GetDetectorRequest request, final ActionListener<GetDetectorResponse> actionListener) {
        final User user = this.readUserFromThreadContext(this.threadPool);
        String validateBackendRoleMessage = this.validateUserBackendRoles(user, this.filterByEnabled);
        if (!"".equals(validateBackendRoleMessage)) {
            actionListener.onFailure((Exception)new OpenSearchStatusException("Do not have permissions to resource", RestStatus.FORBIDDEN, new Object[0]));
            return;
        }
        this.threadPool.getThreadContext().stashContext();
        GetRequest getRequest = new GetRequest(".opensearch-sap-detectors-config", request.getDetectorId()).version(request.getVersion().longValue());
        this.client.get(getRequest, (ActionListener)new ActionListener<GetResponse>(){

            public void onResponse(GetResponse response) {
                try {
                    if (!response.isExists()) {
                        actionListener.onFailure((Exception)SecurityAnalyticsException.wrap((OpenSearchException)new OpenSearchStatusException("Detector not found.", RestStatus.NOT_FOUND, new Object[0])));
                        return;
                    }
                    Detector detector = null;
                    if (!response.isSourceEmpty()) {
                        XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)TransportGetDetectorAction.this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)response.getSourceAsBytesRef(), (MediaType)XContentType.JSON);
                        detector = Detector.docParse(xcp, response.getId(), response.getVersion());
                        assert (detector != null);
                        if (!TransportGetDetectorAction.this.checkUserPermissionsWithResource(user, detector.getUser(), "detector", detector.getId(), TransportGetDetectorAction.this.filterByEnabled)) {
                            actionListener.onFailure((Exception)new OpenSearchStatusException("Do not have permissions to resource", RestStatus.FORBIDDEN, new Object[0]));
                            return;
                        }
                    }
                    actionListener.onResponse((Object)new GetDetectorResponse(detector.getId(), detector.getVersion(), RestStatus.OK, detector));
                }
                catch (IOException ex) {
                    actionListener.onFailure((Exception)ex);
                }
            }

            public void onFailure(Exception e) {
                actionListener.onFailure(e);
            }
        });
    }

    private void setFilterByEnabled(boolean filterByEnabled) {
        this.filterByEnabled = filterByEnabled;
    }
}

