/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.transport;

import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionType;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.Client;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.index.reindex.DeleteByQueryAction;
import org.opensearch.index.reindex.DeleteByQueryRequestBuilder;
import org.opensearch.securityanalytics.action.DeleteCorrelationRuleRequest;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class TransportDeleteCorrelationRuleAction
extends HandledTransportAction<DeleteCorrelationRuleRequest, AcknowledgedResponse> {
    private static final Logger log = LogManager.getLogger(TransportDeleteCorrelationRuleAction.class);
    private final Client client;

    @Inject
    public TransportDeleteCorrelationRuleAction(TransportService transportService, Client client, ActionFilters actionFilters) {
        super("cluster:admin/index/correlation/rules/delete", transportService, actionFilters, DeleteCorrelationRuleRequest::new);
        this.client = client;
    }

    protected void doExecute(Task task, DeleteCorrelationRuleRequest request, final ActionListener<AcknowledgedResponse> listener) {
        final String correlationRuleId = request.getCorrelationRuleId();
        WriteRequest.RefreshPolicy refreshPolicy = request.getRefreshPolicy();
        log.debug("Deleting Correlation Rule with id: " + correlationRuleId);
        ((DeleteByQueryRequestBuilder)((DeleteByQueryRequestBuilder)((DeleteByQueryRequestBuilder)new DeleteByQueryRequestBuilder((OpenSearchClient)this.client, (ActionType)DeleteByQueryAction.INSTANCE).source(new String[]{".opensearch-sap-correlation-rules-config"})).filter((QueryBuilder)QueryBuilders.matchQuery((String)"_id", (Object)correlationRuleId))).refresh(true)).execute((ActionListener)new ActionListener<BulkByScrollResponse>(){

            public void onResponse(BulkByScrollResponse response) {
                if (response.isTimedOut()) {
                    listener.onFailure((Exception)new OpenSearchStatusException(String.format(Locale.getDefault(), "Request timed out. Correlation Rule with id %s cannot be deleted", correlationRuleId), RestStatus.REQUEST_TIMEOUT, new Object[0]));
                    return;
                }
                listener.onResponse((Object)new AcknowledgedResponse(true));
            }

            public void onFailure(Exception e) {
                listener.onFailure((Exception)SecurityAnalyticsException.wrap(e));
            }
        });
    }
}

