/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.indexmanagment;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.admin.cluster.state.ClusterStateRequest;
import org.opensearch.action.admin.cluster.state.ClusterStateResponse;
import org.opensearch.action.admin.indices.delete.DeleteIndexRequest;
import org.opensearch.action.admin.indices.rollover.RolloverRequest;
import org.opensearch.action.admin.indices.rollover.RolloverResponse;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.Client;
import org.opensearch.cluster.ClusterChangedEvent;
import org.opensearch.cluster.ClusterStateListener;
import org.opensearch.cluster.metadata.AliasMetadata;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.lifecycle.AbstractLifecycleComponent;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.securityanalytics.config.monitors.DetectorMonitorConfig;
import org.opensearch.securityanalytics.logtype.LogTypeService;
import org.opensearch.securityanalytics.settings.SecurityAnalyticsSettings;
import org.opensearch.securityanalytics.util.CorrelationIndices;
import org.opensearch.threadpool.Scheduler;
import org.opensearch.threadpool.ThreadPool;

public class DetectorIndexManagementService
extends AbstractLifecycleComponent
implements ClusterStateListener {
    private Logger logger = LogManager.getLogger(DetectorIndexManagementService.class);
    private final Client client;
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final LogTypeService logTypeService;
    private Settings settings;
    private volatile Boolean alertHistoryEnabled;
    private volatile Boolean findingHistoryEnabled;
    private volatile Long alertHistoryMaxDocs;
    private volatile Long findingHistoryMaxDocs;
    private volatile Long correlationHistoryMaxDocs;
    private volatile TimeValue alertHistoryMaxAge;
    private volatile TimeValue findingHistoryMaxAge;
    private volatile TimeValue correlationHistoryMaxAge;
    private volatile TimeValue alertHistoryRolloverPeriod;
    private volatile TimeValue findingHistoryRolloverPeriod;
    private volatile TimeValue correlationHistoryRolloverPeriod;
    private volatile TimeValue alertHistoryRetentionPeriod;
    private volatile TimeValue findingHistoryRetentionPeriod;
    private volatile TimeValue correlationHistoryRetentionPeriod;
    private volatile boolean isClusterManager = false;
    private Scheduler.Cancellable scheduledAlertsRollover = null;
    private Scheduler.Cancellable scheduledFindingsRollover = null;
    private Scheduler.Cancellable scheduledCorrelationHistoryRollover = null;
    List<HistoryIndexInfo> alertHistoryIndices = new ArrayList<HistoryIndexInfo>();
    List<HistoryIndexInfo> findingHistoryIndices = new ArrayList<HistoryIndexInfo>();
    HistoryIndexInfo correlationHistoryIndex = null;

    @Inject
    public DetectorIndexManagementService(Settings settings, Client client, ThreadPool threadPool, ClusterService clusterService, LogTypeService logTypeService) {
        this.settings = settings;
        this.client = client;
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.logTypeService = logTypeService;
        clusterService.addListener((ClusterStateListener)this);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SecurityAnalyticsSettings.ALERT_HISTORY_ENABLED, this::setAlertHistoryEnabled);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SecurityAnalyticsSettings.ALERT_HISTORY_MAX_DOCS, maxDocs -> {
            this.setAlertHistoryMaxDocs((Long)maxDocs);
            for (HistoryIndexInfo h : this.alertHistoryIndices) {
                h.maxDocs = maxDocs;
            }
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SecurityAnalyticsSettings.ALERT_HISTORY_INDEX_MAX_AGE, maxAge -> {
            this.setAlertHistoryMaxAge((TimeValue)maxAge);
            for (HistoryIndexInfo h : this.alertHistoryIndices) {
                h.maxAge = maxAge;
            }
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SecurityAnalyticsSettings.ALERT_HISTORY_ROLLOVER_PERIOD, timeValue -> {
            this.alertHistoryRolloverPeriod = timeValue;
            this.rescheduleAlertRollover();
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SecurityAnalyticsSettings.ALERT_HISTORY_RETENTION_PERIOD, this::setAlertHistoryRetentionPeriod);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SecurityAnalyticsSettings.FINDING_HISTORY_ENABLED, this::setFindingHistoryEnabled);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SecurityAnalyticsSettings.FINDING_HISTORY_MAX_DOCS, maxDocs -> {
            this.setFindingHistoryMaxDocs((Long)maxDocs);
            for (HistoryIndexInfo h : this.findingHistoryIndices) {
                h.maxDocs = maxDocs;
            }
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SecurityAnalyticsSettings.FINDING_HISTORY_INDEX_MAX_AGE, maxAge -> {
            this.setFindingHistoryMaxAge((TimeValue)maxAge);
            for (HistoryIndexInfo h : this.findingHistoryIndices) {
                h.maxAge = maxAge;
            }
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SecurityAnalyticsSettings.FINDING_HISTORY_ROLLOVER_PERIOD, timeValue -> {
            this.findingHistoryRolloverPeriod = timeValue;
            this.rescheduleFindingRollover();
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SecurityAnalyticsSettings.FINDING_HISTORY_RETENTION_PERIOD, this::setFindingHistoryRetentionPeriod);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SecurityAnalyticsSettings.CORRELATION_HISTORY_MAX_DOCS, maxDocs -> {
            this.setCorrelationHistoryMaxDocs((Long)maxDocs);
            if (this.correlationHistoryIndex != null) {
                this.correlationHistoryIndex.maxDocs = maxDocs;
            }
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SecurityAnalyticsSettings.CORRELATION_HISTORY_INDEX_MAX_AGE, maxAge -> {
            this.setCorrelationHistoryMaxAge((TimeValue)maxAge);
            if (this.correlationHistoryIndex != null) {
                this.correlationHistoryIndex.maxAge = maxAge;
            }
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SecurityAnalyticsSettings.CORRELATION_HISTORY_ROLLOVER_PERIOD, timeValue -> {
            this.correlationHistoryRolloverPeriod = timeValue;
            this.rescheduleCorrelationHistoryRollover();
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SecurityAnalyticsSettings.CORRELATION_HISTORY_RETENTION_PERIOD, this::setCorrelationHistoryRetentionPeriod);
        this.initFromClusterSettings();
    }

    private void populateAllIndexLists(List<String> logTypes) {
        this.alertHistoryIndices.clear();
        this.findingHistoryIndices.clear();
        logTypes.forEach(logType -> {
            String alertsHistoryIndex = DetectorMonitorConfig.getAlertsHistoryIndex(logType);
            String alertsHistoryIndexPattern = DetectorMonitorConfig.getAlertsHistoryIndexPattern(logType);
            this.alertHistoryIndices.add(new HistoryIndexInfo(alertsHistoryIndex, alertsHistoryIndexPattern, this.alertMapping(), this.alertHistoryMaxDocs, this.alertHistoryMaxAge, this.clusterService.state().metadata().hasAlias(alertsHistoryIndex)));
            String findingsIndex = DetectorMonitorConfig.getFindingsIndex(logType);
            String findingsIndexPattern = DetectorMonitorConfig.getFindingsIndexPattern(logType);
            this.findingHistoryIndices.add(new HistoryIndexInfo(findingsIndex, findingsIndexPattern, this.findingMapping(), this.findingHistoryMaxDocs, this.findingHistoryMaxAge, this.clusterService.state().metadata().hasAlias(findingsIndex)));
        });
    }

    private void initFromClusterSettings() {
        this.alertHistoryEnabled = (Boolean)SecurityAnalyticsSettings.ALERT_HISTORY_ENABLED.get(this.settings);
        this.findingHistoryEnabled = (Boolean)SecurityAnalyticsSettings.FINDING_HISTORY_ENABLED.get(this.settings);
        this.alertHistoryMaxDocs = (Long)SecurityAnalyticsSettings.ALERT_HISTORY_MAX_DOCS.get(this.settings);
        this.findingHistoryMaxDocs = (Long)SecurityAnalyticsSettings.FINDING_HISTORY_MAX_DOCS.get(this.settings);
        this.correlationHistoryMaxDocs = (Long)SecurityAnalyticsSettings.CORRELATION_HISTORY_MAX_DOCS.get(this.settings);
        this.alertHistoryMaxAge = (TimeValue)SecurityAnalyticsSettings.ALERT_HISTORY_INDEX_MAX_AGE.get(this.settings);
        this.findingHistoryMaxAge = (TimeValue)SecurityAnalyticsSettings.FINDING_HISTORY_INDEX_MAX_AGE.get(this.settings);
        this.correlationHistoryMaxAge = (TimeValue)SecurityAnalyticsSettings.CORRELATION_HISTORY_INDEX_MAX_AGE.get(this.settings);
        this.alertHistoryRolloverPeriod = (TimeValue)SecurityAnalyticsSettings.ALERT_HISTORY_ROLLOVER_PERIOD.get(this.settings);
        this.findingHistoryRolloverPeriod = (TimeValue)SecurityAnalyticsSettings.FINDING_HISTORY_ROLLOVER_PERIOD.get(this.settings);
        this.correlationHistoryRolloverPeriod = (TimeValue)SecurityAnalyticsSettings.CORRELATION_HISTORY_ROLLOVER_PERIOD.get(this.settings);
        this.alertHistoryRetentionPeriod = (TimeValue)SecurityAnalyticsSettings.ALERT_HISTORY_RETENTION_PERIOD.get(this.settings);
        this.findingHistoryRetentionPeriod = (TimeValue)SecurityAnalyticsSettings.FINDING_HISTORY_RETENTION_PERIOD.get(this.settings);
        this.correlationHistoryRetentionPeriod = (TimeValue)SecurityAnalyticsSettings.CORRELATION_HISTORY_RETENTION_PERIOD.get(this.settings);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        if (this.isClusterManager != event.localNodeClusterManager()) {
            this.isClusterManager = event.localNodeClusterManager();
            if (this.isClusterManager) {
                this.onMaster();
            } else {
                this.offMaster();
            }
        }
        for (HistoryIndexInfo h : this.alertHistoryIndices) {
            h.isInitialized = event.state().metadata().hasAlias(h.indexAlias);
        }
        for (HistoryIndexInfo h : this.findingHistoryIndices) {
            h.isInitialized = event.state().metadata().hasAlias(h.indexAlias);
        }
        if (this.correlationHistoryIndex != null && this.correlationHistoryIndex.indexAlias != null) {
            this.correlationHistoryIndex.isInitialized = event.state().metadata().hasAlias(this.correlationHistoryIndex.indexAlias);
        }
    }

    private void onMaster() {
        try {
            this.threadPool.schedule(() -> {
                this.rolloverAndDeleteAlertHistoryIndices();
                this.rolloverAndDeleteFindingHistoryIndices();
                this.rolloverAndDeleteCorrelationHistoryIndices();
            }, TimeValue.timeValueSeconds((long)1L), this.executorName());
            this.scheduledAlertsRollover = this.threadPool.scheduleWithFixedDelay(() -> this.rolloverAndDeleteAlertHistoryIndices(), this.alertHistoryRolloverPeriod, this.executorName());
            this.scheduledFindingsRollover = this.threadPool.scheduleWithFixedDelay(() -> this.rolloverAndDeleteFindingHistoryIndices(), this.findingHistoryRolloverPeriod, this.executorName());
            this.scheduledCorrelationHistoryRollover = this.threadPool.scheduleWithFixedDelay(() -> this.rolloverAndDeleteCorrelationHistoryIndices(), this.correlationHistoryRolloverPeriod, this.executorName());
        }
        catch (Exception e) {
            this.logger.error("Error creating alert/finding/correlation indices. Alerts/Findings/Correlations can't be recorded until master node is restarted.", (Throwable)e);
        }
    }

    private void offMaster() {
        if (this.scheduledAlertsRollover != null) {
            this.scheduledAlertsRollover.cancel();
        }
        if (this.scheduledFindingsRollover != null) {
            this.scheduledFindingsRollover.cancel();
        }
        if (this.scheduledCorrelationHistoryRollover != null) {
            this.scheduledCorrelationHistoryRollover.cancel();
        }
    }

    private String executorName() {
        return "management";
    }

    private void deleteOldIndices(final String tag, String ... indices) {
        ClusterStateRequest clusterStateRequest = ((ClusterStateRequest)new ClusterStateRequest().clear().indices(indices).metadata(true).local(true)).indicesOptions(IndicesOptions.strictExpand());
        this.client.admin().cluster().state(clusterStateRequest, (ActionListener)new ActionListener<ClusterStateResponse>(){

            public void onResponse(ClusterStateResponse clusterStateResponse) {
                if (!clusterStateResponse.getState().metadata().getIndices().isEmpty()) {
                    List<String> indicesToDelete = DetectorIndexManagementService.this.getIndicesToDelete(clusterStateResponse);
                    DetectorIndexManagementService.this.logger.info("Checking if we should delete " + tag + " indices: [" + indicesToDelete + "]");
                    DetectorIndexManagementService.this.deleteAllOldHistoryIndices(indicesToDelete);
                } else {
                    DetectorIndexManagementService.this.logger.info("No Old " + tag + " Indices to delete");
                }
            }

            public void onFailure(Exception e) {
                DetectorIndexManagementService.this.logger.error("Error fetching cluster state");
            }
        });
    }

    private List<String> getIndicesToDelete(ClusterStateResponse clusterStateResponse) {
        ArrayList<String> indicesToDelete = new ArrayList<String>();
        for (IndexMetadata indexMetadata : clusterStateResponse.getState().metadata().indices().values()) {
            IndexMetadata indexMetaData = indexMetadata;
            String indexToDelete = this.getHistoryIndexToDelete(indexMetaData, this.alertHistoryRetentionPeriod.millis(), this.alertHistoryIndices, this.alertHistoryEnabled);
            if (indexToDelete != null) {
                indicesToDelete.add(indexToDelete);
            }
            if ((indexToDelete = this.getHistoryIndexToDelete(indexMetaData, this.findingHistoryRetentionPeriod.millis(), this.findingHistoryIndices, this.findingHistoryEnabled)) != null) {
                indicesToDelete.add(indexToDelete);
            }
            if ((indexToDelete = this.getHistoryIndexToDelete(indexMetaData, this.correlationHistoryRetentionPeriod.millis(), this.correlationHistoryIndex != null ? List.of(this.correlationHistoryIndex) : List.of(), true)) == null) continue;
            indicesToDelete.add(indexToDelete);
        }
        return indicesToDelete;
    }

    private String getHistoryIndexToDelete(IndexMetadata indexMetadata, Long retentionPeriodMillis, List<HistoryIndexInfo> historyIndices, Boolean historyEnabled) {
        long creationTime = indexMetadata.getCreationDate();
        if (Instant.now().toEpochMilli() - creationTime > retentionPeriodMillis) {
            String alias = null;
            for (AliasMetadata aliasMetadata : indexMetadata.getAliases().values()) {
                Optional<HistoryIndexInfo> historyIndexInfoOptional = historyIndices.stream().filter(e -> e.indexAlias.equals(aliasMetadata.alias())).findFirst();
                if (!historyIndexInfoOptional.isPresent()) continue;
                alias = historyIndexInfoOptional.get().indexAlias;
                break;
            }
            if (alias != null && historyEnabled.booleanValue()) {
                return null;
            }
            return indexMetadata.getIndex().getName();
        }
        return null;
    }

    private void deleteAllOldHistoryIndices(final List<String> indicesToDelete) {
        if (indicesToDelete.size() > 0) {
            DeleteIndexRequest deleteIndexRequest = new DeleteIndexRequest(indicesToDelete.toArray(new String[0]));
            this.client.admin().indices().delete(deleteIndexRequest, (ActionListener)new ActionListener<AcknowledgedResponse>(){

                public void onResponse(AcknowledgedResponse deleteIndicesResponse) {
                    if (!deleteIndicesResponse.isAcknowledged()) {
                        DetectorIndexManagementService.this.logger.error("Could not delete one or more Alerting/Finding/Correlation history indices: [" + indicesToDelete + "]. Retrying one by one.");
                        DetectorIndexManagementService.this.deleteOldHistoryIndex(indicesToDelete);
                    } else {
                        DetectorIndexManagementService.this.logger.info("Succsessfuly deleted indices: [" + indicesToDelete + "]");
                    }
                }

                public void onFailure(Exception e) {
                    DetectorIndexManagementService.this.logger.error("Delete for Alerting/Finding/Correlation History Indices failed: [" + indicesToDelete + "]. Retrying one By one.");
                    DetectorIndexManagementService.this.deleteOldHistoryIndex(indicesToDelete);
                }
            });
        }
    }

    private void deleteOldHistoryIndex(List<String> indicesToDelete) {
        for (final String index : indicesToDelete) {
            DeleteIndexRequest singleDeleteRequest = new DeleteIndexRequest(indicesToDelete.toArray(new String[0]));
            this.client.admin().indices().delete(singleDeleteRequest, (ActionListener)new ActionListener<AcknowledgedResponse>(){

                public void onResponse(AcknowledgedResponse acknowledgedResponse) {
                    if (!acknowledgedResponse.isAcknowledged()) {
                        DetectorIndexManagementService.this.logger.error("Could not delete one or more Alerting/Finding/Correlation history indices: " + index);
                    }
                }

                public void onFailure(Exception e) {
                    DetectorIndexManagementService.this.logger.debug("Exception: [" + e.getMessage() + "] while deleting the index " + index);
                }
            });
        }
    }

    private void rolloverAndDeleteAlertHistoryIndices() {
        this.logTypeService.getAllLogTypes((ActionListener<List<String>>)ActionListener.wrap(logTypes -> {
            if (logTypes == null || logTypes.isEmpty()) {
                return;
            }
            this.populateAllIndexLists((List<String>)logTypes);
            if (this.alertHistoryEnabled.booleanValue()) {
                this.rolloverAlertHistoryIndices();
            }
            this.deleteOldIndices("Alert", this.getAllAlertsIndicesPatternForAllTypes((List<String>)logTypes).toArray(new String[0]));
        }, e -> {}));
    }

    private void rolloverAndDeleteFindingHistoryIndices() {
        this.logTypeService.getAllLogTypes((ActionListener<List<String>>)ActionListener.wrap(logTypes -> {
            if (logTypes == null || logTypes.isEmpty()) {
                return;
            }
            this.populateAllIndexLists((List<String>)logTypes);
            if (this.findingHistoryEnabled.booleanValue()) {
                this.rolloverFindingHistoryIndices();
            }
            this.deleteOldIndices("Finding", this.getAllFindingsIndicesPatternForAllTypes((List<String>)logTypes).toArray(new String[0]));
        }, e -> {}));
    }

    private void rolloverAndDeleteCorrelationHistoryIndices() {
        try {
            this.correlationHistoryIndex = new HistoryIndexInfo(".opensearch-sap-correlation-history-write", "<.opensearch-sap-correlation-history-{now/d}-1>", CorrelationIndices.correlationMappings(), this.correlationHistoryMaxDocs, this.correlationHistoryMaxAge, this.clusterService.state().metadata().hasAlias(".opensearch-sap-correlation-history-write"));
            this.rolloverCorrelationHistoryIndices();
            this.deleteOldIndices("Correlation", ".opensearch-sap-correlation-history*");
        }
        catch (Exception ex) {
            this.logger.error("failed to construct correlation history index info");
        }
    }

    private List<String> getAllAlertsIndicesPatternForAllTypes(List<String> logTypes) {
        return logTypes.stream().map(logType -> DetectorMonitorConfig.getAllAlertsIndicesPattern(logType)).collect(Collectors.toList());
    }

    private List<String> getAllFindingsIndicesPatternForAllTypes(List<String> logTypes) {
        return logTypes.stream().map(logType -> DetectorMonitorConfig.getAllFindingsIndicesPattern(logType)).collect(Collectors.toList());
    }

    private void rolloverIndex(Boolean initialized, final String index, String pattern, String map, Long docsCondition, TimeValue ageCondition, Boolean isCorrelation) {
        if (!initialized.booleanValue()) {
            return;
        }
        RolloverRequest request = new RolloverRequest(index, null);
        request.getCreateIndexRequest().index(pattern).mapping(map).settings(isCorrelation != false ? Settings.builder().put("index.hidden", true).put("index.correlation", true).build() : Settings.builder().put("index.hidden", true).build());
        request.addMaxIndexDocsCondition(docsCondition.longValue());
        request.addMaxIndexAgeCondition(ageCondition);
        this.client.admin().indices().rolloverIndex(request, (ActionListener)new ActionListener<RolloverResponse>(){

            public void onResponse(RolloverResponse rolloverResponse) {
                if (!rolloverResponse.isRolledOver()) {
                    DetectorIndexManagementService.this.logger.info(index + "not rolled over. Conditions were: " + rolloverResponse.getConditionStatus());
                }
            }

            public void onFailure(Exception e) {
                DetectorIndexManagementService.this.logger.error("rollover failed for index [" + index + "].");
            }
        });
    }

    private void rolloverAlertHistoryIndices() {
        for (HistoryIndexInfo h : this.alertHistoryIndices) {
            this.rolloverIndex(h.isInitialized, h.indexAlias, h.indexPattern, h.indexMappings, h.maxDocs, h.maxAge, false);
        }
    }

    private void rolloverFindingHistoryIndices() {
        for (HistoryIndexInfo h : this.findingHistoryIndices) {
            this.rolloverIndex(h.isInitialized, h.indexAlias, h.indexPattern, h.indexMappings, h.maxDocs, h.maxAge, false);
        }
    }

    private void rolloverCorrelationHistoryIndices() {
        if (this.correlationHistoryIndex != null) {
            this.rolloverIndex(this.correlationHistoryIndex.isInitialized, this.correlationHistoryIndex.indexAlias, this.correlationHistoryIndex.indexPattern, this.correlationHistoryIndex.indexMappings, this.correlationHistoryIndex.maxDocs, this.correlationHistoryIndex.maxAge, true);
        }
    }

    private void rescheduleAlertRollover() {
        if (this.clusterService.state().getNodes().isLocalNodeElectedClusterManager()) {
            if (this.scheduledAlertsRollover != null) {
                this.scheduledAlertsRollover.cancel();
            }
            this.scheduledAlertsRollover = this.threadPool.scheduleWithFixedDelay(() -> this.rolloverAndDeleteAlertHistoryIndices(), this.alertHistoryRolloverPeriod, this.executorName());
        }
    }

    private void rescheduleFindingRollover() {
        if (this.clusterService.state().getNodes().isLocalNodeElectedClusterManager()) {
            if (this.scheduledFindingsRollover != null) {
                this.scheduledFindingsRollover.cancel();
            }
            this.scheduledFindingsRollover = this.threadPool.scheduleWithFixedDelay(() -> this.rolloverAndDeleteFindingHistoryIndices(), this.findingHistoryRolloverPeriod, this.executorName());
        }
    }

    private void rescheduleCorrelationHistoryRollover() {
        if (this.clusterService.state().getNodes().isLocalNodeElectedClusterManager()) {
            if (this.scheduledCorrelationHistoryRollover != null) {
                this.scheduledCorrelationHistoryRollover.cancel();
            }
            this.scheduledCorrelationHistoryRollover = this.threadPool.scheduleWithFixedDelay(() -> this.rolloverAndDeleteCorrelationHistoryIndices(), this.correlationHistoryRolloverPeriod, this.executorName());
        }
    }

    private String alertMapping() {
        String alertMapping = null;
        try (InputStream is = DetectorIndexManagementService.class.getClassLoader().getResourceAsStream("mappings/alert_mapping.json");){
            alertMapping = new String(Objects.requireNonNull(is).readAllBytes(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
        }
        return alertMapping;
    }

    private String findingMapping() {
        String findingMapping = null;
        try (InputStream is = DetectorIndexManagementService.class.getClassLoader().getResourceAsStream("mappings/finding_mapping.json");){
            findingMapping = new String(Objects.requireNonNull(is).readAllBytes(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
        }
        return findingMapping;
    }

    public void setAlertHistoryEnabled(Boolean alertHistoryEnabled) {
        this.alertHistoryEnabled = alertHistoryEnabled;
    }

    public void setFindingHistoryEnabled(Boolean findingHistoryEnabled) {
        this.findingHistoryEnabled = findingHistoryEnabled;
    }

    public void setAlertHistoryMaxDocs(Long alertHistoryMaxDocs) {
        this.alertHistoryMaxDocs = alertHistoryMaxDocs;
    }

    public void setFindingHistoryMaxDocs(Long findingHistoryMaxDocs) {
        this.findingHistoryMaxDocs = findingHistoryMaxDocs;
    }

    public void setCorrelationHistoryMaxDocs(Long correlationHistoryMaxDocs) {
        this.correlationHistoryMaxDocs = correlationHistoryMaxDocs;
    }

    public void setAlertHistoryMaxAge(TimeValue alertHistoryMaxAge) {
        this.alertHistoryMaxAge = alertHistoryMaxAge;
    }

    public void setFindingHistoryMaxAge(TimeValue findingHistoryMaxAge) {
        this.findingHistoryMaxAge = findingHistoryMaxAge;
    }

    public void setCorrelationHistoryMaxAge(TimeValue correlationHistoryMaxAge) {
        this.correlationHistoryMaxAge = correlationHistoryMaxAge;
    }

    public void setAlertHistoryRolloverPeriod(TimeValue alertHistoryRolloverPeriod) {
        this.alertHistoryRolloverPeriod = alertHistoryRolloverPeriod;
    }

    public void setFindingHistoryRolloverPeriod(TimeValue findingHistoryRolloverPeriod) {
        this.findingHistoryRolloverPeriod = findingHistoryRolloverPeriod;
    }

    public void setCorrelationHistoryRolloverPeriod(TimeValue correlationHistoryRolloverPeriod) {
        this.correlationHistoryRolloverPeriod = correlationHistoryRolloverPeriod;
    }

    public void setAlertHistoryRetentionPeriod(TimeValue alertHistoryRetentionPeriod) {
        this.alertHistoryRetentionPeriod = alertHistoryRetentionPeriod;
    }

    public void setFindingHistoryRetentionPeriod(TimeValue findingHistoryRetentionPeriod) {
        this.findingHistoryRetentionPeriod = findingHistoryRetentionPeriod;
    }

    public void setCorrelationHistoryRetentionPeriod(TimeValue correlationHistoryRetentionPeriod) {
        this.correlationHistoryRetentionPeriod = correlationHistoryRetentionPeriod;
    }

    public void setClusterManager(boolean clusterManager) {
        this.isClusterManager = clusterManager;
    }

    protected void doStart() {
    }

    protected void doStop() {
        if (this.scheduledAlertsRollover != null) {
            this.scheduledAlertsRollover.cancel();
        }
        if (this.scheduledFindingsRollover != null) {
            this.scheduledFindingsRollover.cancel();
        }
        if (this.scheduledCorrelationHistoryRollover != null) {
            this.scheduledCorrelationHistoryRollover.cancel();
        }
    }

    protected void doClose() {
        if (this.scheduledAlertsRollover != null) {
            this.scheduledAlertsRollover.cancel();
        }
        if (this.scheduledFindingsRollover != null) {
            this.scheduledFindingsRollover.cancel();
        }
        if (this.scheduledCorrelationHistoryRollover != null) {
            this.scheduledCorrelationHistoryRollover.cancel();
        }
    }

    private static class HistoryIndexInfo {
        String indexAlias;
        String indexPattern;
        String indexMappings;
        Long maxDocs;
        TimeValue maxAge;
        boolean isInitialized;

        public HistoryIndexInfo(String indexAlias, String indexPattern, String indexMappings, Long maxDocs, TimeValue maxAge, boolean isInitialized) {
            this.indexAlias = indexAlias;
            this.indexPattern = indexPattern;
            this.indexMappings = indexMappings;
            this.maxDocs = maxDocs;
            this.maxAge = maxAge;
            this.isInitialized = isInitialized;
        }
    }
}

