/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.correlation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.join.ScoreMode;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.search.MultiSearchRequest;
import org.opensearch.action.search.MultiSearchResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.Client;
import org.opensearch.cluster.routing.Preference;
import org.opensearch.common.document.DocumentField;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.alerting.action.PublishFindingsRequest;
import org.opensearch.commons.alerting.model.DocLevelQuery;
import org.opensearch.commons.alerting.model.Finding;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.MatchQueryBuilder;
import org.opensearch.index.query.NestedQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.RangeQueryBuilder;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.securityanalytics.config.monitors.DetectorMonitorConfig;
import org.opensearch.securityanalytics.logtype.LogTypeService;
import org.opensearch.securityanalytics.model.CorrelationQuery;
import org.opensearch.securityanalytics.model.CorrelationRule;
import org.opensearch.securityanalytics.model.Detector;
import org.opensearch.securityanalytics.transport.TransportCorrelateFindingAction;
import org.opensearch.securityanalytics.util.AutoCorrelationsRepo;

public class JoinEngine {
    private final Client client;
    private final PublishFindingsRequest request;
    private final NamedXContentRegistry xContentRegistry;
    private volatile long corrTimeWindow;
    private final TransportCorrelateFindingAction.AsyncCorrelateFindingAction correlateFindingAction;
    private final LogTypeService logTypeService;
    private static final Logger log = LogManager.getLogger(JoinEngine.class);

    public JoinEngine(Client client, PublishFindingsRequest request, NamedXContentRegistry xContentRegistry, long corrTimeWindow, TransportCorrelateFindingAction.AsyncCorrelateFindingAction correlateFindingAction, LogTypeService logTypeService) {
        this.client = client;
        this.request = request;
        this.xContentRegistry = xContentRegistry;
        this.corrTimeWindow = corrTimeWindow;
        this.correlateFindingAction = correlateFindingAction;
        this.logTypeService = logTypeService;
    }

    public void onSearchDetectorResponse(Detector detector, Finding finding) {
        try {
            this.generateAutoCorrelations(detector, finding);
        }
        catch (IOException ex) {
            this.correlateFindingAction.onFailures(ex);
        }
    }

    private void generateAutoCorrelations(final Detector detector, final Finding finding) throws IOException {
        final Map<String, Set<String>> autoCorrelations = AutoCorrelationsRepo.autoCorrelationsAsMap();
        final long findingTimestamp = finding.getTimestamp().toEpochMilli();
        final HashSet<String> tags = new HashSet<String>();
        for (DocLevelQuery query : finding.getDocLevelQueries()) {
            tags.addAll(query.getTags().stream().filter(tag -> tag.startsWith("attack.")).collect(Collectors.toList()));
        }
        final Set<String> validIntrusionSets = AutoCorrelationsRepo.validIntrusionSets(autoCorrelations, tags);
        MatchQueryBuilder queryBuilder = QueryBuilders.matchQuery((String)"source", (Object)"Sigma");
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchSourceBuilder.size(100);
        SearchRequest request = new SearchRequest();
        request.source(searchSourceBuilder);
        this.logTypeService.searchLogTypes(request, new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse response) {
                MultiSearchRequest mSearchRequest = new MultiSearchRequest();
                SearchHit[] logTypes = response.getHits().getHits();
                final ArrayList<String> logTypeNames = new ArrayList<String>();
                for (SearchHit logType : logTypes) {
                    String logTypeName = logType.getSourceAsMap().get("name").toString();
                    logTypeNames.add(logTypeName);
                    RangeQueryBuilder queryBuilder = QueryBuilders.rangeQuery((String)"timestamp").gte((Object)(findingTimestamp - JoinEngine.this.corrTimeWindow)).lte((Object)(findingTimestamp + JoinEngine.this.corrTimeWindow));
                    SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
                    searchSourceBuilder.query((QueryBuilder)queryBuilder);
                    searchSourceBuilder.size(10000);
                    searchSourceBuilder.fetchField("queries");
                    SearchRequest searchRequest = new SearchRequest();
                    searchRequest.indices(new String[]{DetectorMonitorConfig.getAllFindingsIndicesPattern(logTypeName)});
                    searchRequest.source(searchSourceBuilder);
                    searchRequest.preference(Preference.PRIMARY_FIRST.type());
                    mSearchRequest.add(searchRequest);
                }
                if (!mSearchRequest.requests().isEmpty()) {
                    JoinEngine.this.client.multiSearch(mSearchRequest, (ActionListener)new ActionListener<MultiSearchResponse>(){

                        public void onResponse(MultiSearchResponse items) {
                            MultiSearchResponse.Item[] responses = items.getResponses();
                            HashMap<String, List<String>> autoCorrelationsMap = new HashMap<String, List<String>>();
                            int idx = 0;
                            for (MultiSearchResponse.Item response : responses) {
                                SearchHit[] findings;
                                if (response.isFailure()) {
                                    log.info(response.getFailureMessage());
                                    continue;
                                }
                                String logTypeName = (String)logTypeNames.get(idx);
                                for (SearchHit foundFinding : findings = response.getResponse().getHits().getHits()) {
                                    Object query2;
                                    if (foundFinding.getId().equals(finding.getId())) continue;
                                    HashSet<String> findingTags = new HashSet<String>();
                                    List queries = (List)foundFinding.getSourceAsMap().get("queries");
                                    for (Object query2 : queries) {
                                        List queryTags = (List)query2.get("tags");
                                        findingTags.addAll(queryTags.stream().filter(queryTag -> queryTag.startsWith("attack.")).collect(Collectors.toList()));
                                    }
                                    boolean canCorrelate = false;
                                    query2 = tags.iterator();
                                    while (query2.hasNext()) {
                                        String tag = (String)query2.next();
                                        if (!findingTags.contains(tag)) continue;
                                        canCorrelate = true;
                                        break;
                                    }
                                    Set<String> foundIntrusionSets = AutoCorrelationsRepo.validIntrusionSets(autoCorrelations, findingTags);
                                    for (String validIntrusionSet : validIntrusionSets) {
                                        if (!foundIntrusionSets.contains(validIntrusionSet)) continue;
                                        canCorrelate = true;
                                        break;
                                    }
                                    if (!canCorrelate) continue;
                                    if (autoCorrelationsMap.containsKey(logTypeName)) {
                                        ((List)autoCorrelationsMap.get(logTypeName)).add(foundFinding.getId());
                                        continue;
                                    }
                                    ArrayList<String> autoCorrelatedFindings = new ArrayList<String>();
                                    autoCorrelatedFindings.add(foundFinding.getId());
                                    autoCorrelationsMap.put(logTypeName, autoCorrelatedFindings);
                                }
                                ++idx;
                            }
                            JoinEngine.this.onAutoCorrelations(detector, finding, autoCorrelationsMap);
                        }

                        public void onFailure(Exception e) {
                            JoinEngine.this.correlateFindingAction.onFailures(e);
                        }
                    });
                }
            }

            public void onFailure(Exception e) {
                JoinEngine.this.correlateFindingAction.onFailures(e);
            }
        });
    }

    private void onAutoCorrelations(Detector detector, Finding finding, final Map<String, List<String>> autoCorrelations) {
        final String detectorType = detector.getDetectorType().toLowerCase(Locale.ROOT);
        final List<String> indices = detector.getInputs().get(0).getIndices();
        final List relatedDocIds = finding.getCorrelatedDocIds();
        NestedQueryBuilder queryBuilder = QueryBuilders.nestedQuery((String)"correlate", (QueryBuilder)QueryBuilders.matchQuery((String)"correlate.category", (Object)detectorType), (ScoreMode)ScoreMode.None);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchSourceBuilder.fetchSource(true);
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.indices(new String[]{".opensearch-sap-correlation-rules-config"});
        searchRequest.source(searchSourceBuilder);
        searchRequest.preference(Preference.PRIMARY_FIRST.type());
        this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse response) {
                if (response.isTimedOut()) {
                    JoinEngine.this.correlateFindingAction.onFailures((Exception)new OpenSearchStatusException("Search request timed out", RestStatus.REQUEST_TIMEOUT, new Object[0]));
                }
                Iterator hits = response.getHits().iterator();
                ArrayList<CorrelationRule> correlationRules = new ArrayList<CorrelationRule>();
                while (hits.hasNext()) {
                    try {
                        SearchHit hit = (SearchHit)hits.next();
                        XContentParser xcp = XContentType.JSON.xContent().createParser(JoinEngine.this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, hit.getSourceAsString());
                        CorrelationRule rule = CorrelationRule.parse(xcp, hit.getId(), hit.getVersion());
                        correlationRules.add(rule);
                    }
                    catch (IOException e) {
                        JoinEngine.this.correlateFindingAction.onFailures(e);
                    }
                }
                JoinEngine.this.getValidDocuments(detectorType, indices, correlationRules, relatedDocIds, autoCorrelations);
            }

            public void onFailure(Exception e) {
                JoinEngine.this.getValidDocuments(detectorType, indices, List.of(), List.of(), autoCorrelations);
            }
        });
    }

    private void getValidDocuments(final String detectorType, List<String> indices, List<CorrelationRule> correlationRules, List<String> relatedDocIds, final Map<String, List<String>> autoCorrelations) {
        MultiSearchRequest mSearchRequest = new MultiSearchRequest();
        final ArrayList<CorrelationRule> validCorrelationRules = new ArrayList<CorrelationRule>();
        for (CorrelationRule rule : correlationRules) {
            Optional<CorrelationQuery> query = rule.getCorrelationQueries().stream().filter(correlationQuery -> correlationQuery.getCategory().equals(detectorType)).findFirst();
            if (!query.isPresent()) continue;
            BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termsQuery((String)"_id", relatedDocIds)).must((QueryBuilder)QueryBuilders.queryStringQuery((String)query.get().getQuery()));
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)queryBuilder);
            searchSourceBuilder.fetchSource(false);
            searchSourceBuilder.size(10000);
            SearchRequest searchRequest = new SearchRequest();
            searchRequest.indices(indices.toArray(new String[0]));
            searchRequest.source(searchSourceBuilder);
            searchRequest.preference(Preference.PRIMARY_FIRST.type());
            validCorrelationRules.add(rule);
            mSearchRequest.add(searchRequest);
        }
        if (!mSearchRequest.requests().isEmpty()) {
            this.client.multiSearch(mSearchRequest, (ActionListener)new ActionListener<MultiSearchResponse>(){

                public void onResponse(MultiSearchResponse items) {
                    MultiSearchResponse.Item[] responses = items.getResponses();
                    ArrayList<CorrelationRule> filteredCorrelationRules = new ArrayList<CorrelationRule>();
                    int idx = 0;
                    for (MultiSearchResponse.Item response : responses) {
                        if (response.isFailure()) {
                            log.info(response.getFailureMessage());
                            continue;
                        }
                        if (response.getResponse().getHits().getTotalHits().value > 0L) {
                            filteredCorrelationRules.add((CorrelationRule)validCorrelationRules.get(idx));
                        }
                        ++idx;
                    }
                    HashMap<String, List<CorrelationQuery>> categoryToQueriesMap = new HashMap<String, List<CorrelationQuery>>();
                    for (CorrelationRule rule : filteredCorrelationRules) {
                        List<CorrelationQuery> queries = rule.getCorrelationQueries();
                        for (CorrelationQuery query : queries) {
                            List<CorrelationQuery> correlationQueries = categoryToQueriesMap.containsKey(query.getCategory()) ? (List)categoryToQueriesMap.get(query.getCategory()) : new ArrayList<CorrelationQuery>();
                            correlationQueries.add(query);
                            categoryToQueriesMap.put(query.getCategory(), correlationQueries);
                        }
                    }
                    JoinEngine.this.searchFindingsByTimestamp(detectorType, categoryToQueriesMap, filteredCorrelationRules.stream().map(CorrelationRule::getId).collect(Collectors.toList()), autoCorrelations);
                }

                public void onFailure(Exception e) {
                    JoinEngine.this.correlateFindingAction.onFailures(e);
                }
            });
        } else if (!autoCorrelations.isEmpty()) {
            this.correlateFindingAction.getTimestampFeature(detectorType, autoCorrelations, null, List.of());
        } else {
            this.correlateFindingAction.getTimestampFeature(detectorType, null, this.request.getFinding(), List.of());
        }
    }

    private void searchFindingsByTimestamp(final String detectorType, Map<String, List<CorrelationQuery>> categoryToQueriesMap, final List<String> correlationRules, final Map<String, List<String>> autoCorrelations) {
        long findingTimestamp = this.request.getFinding().getTimestamp().toEpochMilli();
        MultiSearchRequest mSearchRequest = new MultiSearchRequest();
        final ArrayList<Pair> categoryToQueriesPairs = new ArrayList<Pair>();
        for (Map.Entry<String, List<CorrelationQuery>> categoryToQueries : categoryToQueriesMap.entrySet()) {
            RangeQueryBuilder queryBuilder = QueryBuilders.rangeQuery((String)"timestamp").gte((Object)(findingTimestamp - this.corrTimeWindow)).lte((Object)(findingTimestamp + this.corrTimeWindow));
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)queryBuilder);
            searchSourceBuilder.fetchSource(false);
            searchSourceBuilder.size(10000);
            searchSourceBuilder.fetchField("correlated_doc_ids");
            SearchRequest searchRequest = new SearchRequest();
            searchRequest.indices(new String[]{DetectorMonitorConfig.getAllFindingsIndicesPattern(categoryToQueries.getKey())});
            searchRequest.source(searchSourceBuilder);
            searchRequest.preference(Preference.PRIMARY_FIRST.type());
            mSearchRequest.add(searchRequest);
            categoryToQueriesPairs.add(new Pair((Object)categoryToQueries.getKey(), categoryToQueries.getValue()));
        }
        if (!mSearchRequest.requests().isEmpty()) {
            this.client.multiSearch(mSearchRequest, (ActionListener)new ActionListener<MultiSearchResponse>(){

                public void onResponse(MultiSearchResponse items) {
                    MultiSearchResponse.Item[] responses = items.getResponses();
                    HashMap<String, DocSearchCriteria> relatedDocsMap = new HashMap<String, DocSearchCriteria>();
                    int idx = 0;
                    for (MultiSearchResponse.Item response : responses) {
                        SearchHit[] hits;
                        if (response.isFailure()) {
                            log.info(response.getFailureMessage());
                            continue;
                        }
                        ArrayList<String> relatedDocIds = new ArrayList<String>();
                        for (SearchHit hit : hits = response.getResponse().getHits().getHits()) {
                            relatedDocIds.addAll(((DocumentField)hit.getFields().get("correlated_doc_ids")).getValues().stream().map(Object::toString).collect(Collectors.toList()));
                        }
                        List correlationQueries = (List)((Pair)categoryToQueriesPairs.get(idx)).getSecond();
                        List<String> indices = correlationQueries.stream().map(CorrelationQuery::getIndex).collect(Collectors.toList());
                        List<String> queries = correlationQueries.stream().map(CorrelationQuery::getQuery).collect(Collectors.toList());
                        relatedDocsMap.put((String)((Pair)categoryToQueriesPairs.get(idx)).getFirst(), new DocSearchCriteria(indices, queries, relatedDocIds));
                        ++idx;
                    }
                    JoinEngine.this.searchDocsWithFilterKeys(detectorType, relatedDocsMap, correlationRules, autoCorrelations);
                }

                public void onFailure(Exception e) {
                    JoinEngine.this.correlateFindingAction.onFailures(e);
                }
            });
        } else if (!autoCorrelations.isEmpty()) {
            this.correlateFindingAction.getTimestampFeature(detectorType, autoCorrelations, null, List.of());
        } else {
            this.correlateFindingAction.getTimestampFeature(detectorType, null, this.request.getFinding(), correlationRules);
        }
    }

    private void searchDocsWithFilterKeys(final String detectorType, Map<String, DocSearchCriteria> relatedDocsMap, final List<String> correlationRules, final Map<String, List<String>> autoCorrelations) {
        MultiSearchRequest mSearchRequest = new MultiSearchRequest();
        final ArrayList<String> categories = new ArrayList<String>();
        for (Map.Entry<String, DocSearchCriteria> docSearchCriteria : relatedDocsMap.entrySet()) {
            BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termsQuery((String)"_id", docSearchCriteria.getValue().relatedDocIds));
            for (String query : docSearchCriteria.getValue().queries) {
                queryBuilder = queryBuilder.should((QueryBuilder)QueryBuilders.queryStringQuery((String)query));
            }
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)queryBuilder);
            searchSourceBuilder.fetchSource(false);
            searchSourceBuilder.size(10000);
            SearchRequest searchRequest = new SearchRequest();
            searchRequest.indices(docSearchCriteria.getValue().indices.toArray(new String[0]));
            searchRequest.source(searchSourceBuilder);
            searchRequest.preference(Preference.PRIMARY_FIRST.type());
            categories.add(docSearchCriteria.getKey());
            mSearchRequest.add(searchRequest);
        }
        if (!mSearchRequest.requests().isEmpty()) {
            this.client.multiSearch(mSearchRequest, (ActionListener)new ActionListener<MultiSearchResponse>(){

                public void onResponse(MultiSearchResponse items) {
                    MultiSearchResponse.Item[] responses = items.getResponses();
                    HashMap<String, List<String>> filteredRelatedDocIds = new HashMap<String, List<String>>();
                    int idx = 0;
                    for (MultiSearchResponse.Item response : responses) {
                        if (response.isFailure()) {
                            log.info(response.getFailureMessage());
                            continue;
                        }
                        SearchHit[] hits = response.getResponse().getHits().getHits();
                        ArrayList<String> docIds = new ArrayList<String>();
                        for (SearchHit hit : hits) {
                            docIds.add(hit.getId());
                        }
                        filteredRelatedDocIds.put((String)categories.get(idx), docIds);
                        ++idx;
                    }
                    JoinEngine.this.getCorrelatedFindings(detectorType, filteredRelatedDocIds, correlationRules, autoCorrelations);
                }

                public void onFailure(Exception e) {
                    JoinEngine.this.correlateFindingAction.onFailures(e);
                }
            });
        } else if (!autoCorrelations.isEmpty()) {
            this.correlateFindingAction.getTimestampFeature(detectorType, autoCorrelations, null, List.of());
        } else {
            this.correlateFindingAction.getTimestampFeature(detectorType, null, this.request.getFinding(), correlationRules);
        }
    }

    private void getCorrelatedFindings(final String detectorType, Map<String, List<String>> filteredRelatedDocIds, final List<String> correlationRules, final Map<String, List<String>> autoCorrelations) {
        long findingTimestamp = this.request.getFinding().getTimestamp().toEpochMilli();
        MultiSearchRequest mSearchRequest = new MultiSearchRequest();
        final ArrayList<String> categories = new ArrayList<String>();
        for (Map.Entry<String, List<String>> relatedDocIds : filteredRelatedDocIds.entrySet()) {
            BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.rangeQuery((String)"timestamp").gte((Object)(findingTimestamp - this.corrTimeWindow)).lte((Object)(findingTimestamp + this.corrTimeWindow))).must((QueryBuilder)QueryBuilders.termsQuery((String)"correlated_doc_ids", (Collection)relatedDocIds.getValue()));
            if (relatedDocIds.getKey().equals(detectorType)) {
                queryBuilder = queryBuilder.mustNot((QueryBuilder)QueryBuilders.matchQuery((String)"_id", (Object)this.request.getFinding().getId()));
            }
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)queryBuilder);
            searchSourceBuilder.fetchSource(false);
            searchSourceBuilder.size(10000);
            SearchRequest searchRequest = new SearchRequest();
            searchRequest.indices(new String[]{DetectorMonitorConfig.getAllFindingsIndicesPattern(relatedDocIds.getKey())});
            searchRequest.source(searchSourceBuilder);
            searchRequest.preference(Preference.PRIMARY_FIRST.type());
            categories.add(relatedDocIds.getKey());
            mSearchRequest.add(searchRequest);
        }
        if (!mSearchRequest.requests().isEmpty()) {
            this.client.multiSearch(mSearchRequest, (ActionListener)new ActionListener<MultiSearchResponse>(){

                public void onResponse(MultiSearchResponse items) {
                    MultiSearchResponse.Item[] responses = items.getResponses();
                    HashMap<String, List<String>> correlatedFindings = new HashMap<String, List<String>>();
                    int idx = 0;
                    for (MultiSearchResponse.Item response : responses) {
                        if (response.isFailure()) {
                            log.info(response.getFailureMessage());
                            ++idx;
                            continue;
                        }
                        SearchHit[] hits = response.getResponse().getHits().getHits();
                        ArrayList<String> findings = new ArrayList<String>();
                        for (SearchHit hit : hits) {
                            findings.add(hit.getId());
                        }
                        if (!findings.isEmpty()) {
                            correlatedFindings.put((String)categories.get(idx), findings);
                        }
                        ++idx;
                    }
                    for (Map.Entry entry : autoCorrelations.entrySet()) {
                        if (correlatedFindings.containsKey(entry.getKey())) {
                            HashSet alreadyCorrelatedFindings = new HashSet((Collection)correlatedFindings.get(entry.getKey()));
                            alreadyCorrelatedFindings.addAll((Collection)entry.getValue());
                            correlatedFindings.put((String)entry.getKey(), new ArrayList(alreadyCorrelatedFindings));
                            continue;
                        }
                        correlatedFindings.put((String)entry.getKey(), (List)entry.getValue());
                    }
                    JoinEngine.this.correlateFindingAction.initCorrelationIndex(detectorType, correlatedFindings, correlationRules);
                }

                public void onFailure(Exception e) {
                    JoinEngine.this.correlateFindingAction.onFailures(e);
                }
            });
        } else if (!autoCorrelations.isEmpty()) {
            this.correlateFindingAction.getTimestampFeature(detectorType, autoCorrelations, null, List.of());
        } else {
            this.correlateFindingAction.getTimestampFeature(detectorType, null, this.request.getFinding(), correlationRules);
        }
    }

    static class DocSearchCriteria {
        List<String> indices;
        List<String> queries;
        List<String> relatedDocIds;

        public DocSearchCriteria(List<String> indices, List<String> queries, List<String> relatedDocIds) {
            this.indices = indices;
            this.queries = queries;
            this.relatedDocIds = relatedDocIds;
        }
    }

    static class ParentJoinCriteria {
        String category;
        String index;
        String parentJoinQuery;

        public ParentJoinCriteria(String category, String index, String parentJoinQuery) {
            this.category = category;
            this.index = index;
            this.parentJoinQuery = parentJoinQuery;
        }
    }
}

