/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.cluster;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.ClusterChangedEvent;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateListener;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.ml.autoredeploy.MLModelAutoReDeployer;
import org.opensearch.ml.model.MLModelCacheHelper;
import org.opensearch.ml.model.MLModelManager;
import org.opensearch.ml.settings.MLCommonsSettings;
import org.opensearch.ml.task.MLTaskManager;

public class MLCommonsClusterEventListener
implements ClusterStateListener {
    @Generated
    private static final Logger log = LogManager.getLogger(MLCommonsClusterEventListener.class);
    private final ClusterService clusterService;
    private final MLModelManager mlModelManager;
    private final MLTaskManager mlTaskManager;
    private final MLModelCacheHelper modelCacheHelper;
    private final MLModelAutoReDeployer mlModelAutoReDeployer;

    public MLCommonsClusterEventListener(ClusterService clusterService, MLModelManager mlModelManager, MLTaskManager mlTaskManager, MLModelCacheHelper modelCacheHelper, MLModelAutoReDeployer mlModelAutoReDeployer) {
        this.clusterService = clusterService;
        this.clusterService.addListener((ClusterStateListener)this);
        this.mlModelManager = mlModelManager;
        this.mlTaskManager = mlTaskManager;
        this.modelCacheHelper = modelCacheHelper;
        this.mlModelAutoReDeployer = mlModelAutoReDeployer;
    }

    public void clusterChanged(ClusterChangedEvent event) {
        DiscoveryNodes.Delta delta;
        long monitoringReqCount;
        ClusterState previousState = event.previousState();
        ClusterState state = event.state();
        Settings previousSettings = previousState.getMetadata().settings();
        Settings settings = state.getMetadata().settings();
        long previousMonitoringReqCount = (Long)MLCommonsSettings.ML_COMMONS_MONITORING_REQUEST_COUNT.get(previousSettings);
        if (previousMonitoringReqCount > (monitoringReqCount = ((Long)MLCommonsSettings.ML_COMMONS_MONITORING_REQUEST_COUNT.get(settings)).longValue())) {
            this.modelCacheHelper.resizeMonitoringQueue(monitoringReqCount);
        }
        if ((delta = event.nodesDelta()).removed()) {
            Set<String> removedNodeIds = delta.removedNodes().stream().map(DiscoveryNode::getId).collect(Collectors.toSet());
            this.mlModelManager.removeWorkerNodes(removedNodeIds, false);
        } else if (delta.added()) {
            List<String> addedNodesIds = delta.addedNodes().stream().map(DiscoveryNode::getId).collect(Collectors.toList());
            this.mlModelManager.addModelWorkerNodes(addedNodesIds);
            this.mlModelAutoReDeployer.buildAutoReloadArrangement(addedNodesIds, state.getNodes().getClusterManagerNodeId());
        }
    }
}

