/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.profile;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.nodes.TransportNodesAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.env.Environment;
import org.opensearch.ml.action.profile.MLProfileAction;
import org.opensearch.ml.action.profile.MLProfileNodeRequest;
import org.opensearch.ml.action.profile.MLProfileNodeResponse;
import org.opensearch.ml.action.profile.MLProfileRequest;
import org.opensearch.ml.action.profile.MLProfileResponse;
import org.opensearch.ml.common.MLTask;
import org.opensearch.ml.model.MLModelManager;
import org.opensearch.ml.profile.MLModelProfile;
import org.opensearch.ml.profile.MLProfileInput;
import org.opensearch.ml.task.MLTaskManager;
import org.opensearch.monitor.jvm.JvmService;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class MLProfileTransportAction
extends TransportNodesAction<MLProfileRequest, MLProfileResponse, MLProfileNodeRequest, MLProfileNodeResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(MLProfileTransportAction.class);
    private MLTaskManager mlTaskManager;
    private final JvmService jvmService;
    private final MLModelManager mlModelManager;

    @Inject
    public MLProfileTransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, MLTaskManager mlTaskManager, Environment environment, MLModelManager mlModelManager) {
        super(MLProfileAction.NAME, threadPool, clusterService, transportService, actionFilters, MLProfileRequest::new, MLProfileNodeRequest::new, "management", MLProfileNodeResponse.class);
        this.mlTaskManager = mlTaskManager;
        this.jvmService = new JvmService(environment.settings());
        this.mlModelManager = mlModelManager;
    }

    protected MLProfileResponse newResponse(MLProfileRequest request, List<MLProfileNodeResponse> responses, List<FailedNodeException> failures) {
        return new MLProfileResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected MLProfileNodeRequest newNodeRequest(MLProfileRequest request) {
        return new MLProfileNodeRequest(request);
    }

    protected MLProfileNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new MLProfileNodeResponse(in);
    }

    protected MLProfileNodeResponse nodeOperation(MLProfileNodeRequest request) {
        return this.createMLProfileNodeResponse(request.getMlProfileRequest());
    }

    private MLProfileNodeResponse createMLProfileNodeResponse(MLProfileRequest mlProfileRequest) {
        log.debug("Calculating ml profile response on node id:{}", (Object)this.clusterService.localNode().getId());
        HashMap<String, MLTask> mlLocalTasks = new HashMap<String, MLTask>();
        HashMap<String, MLModelProfile> mlLocalModels = new HashMap<String, MLModelProfile>();
        MLProfileInput mlProfileInput = mlProfileRequest.getMlProfileInput();
        Set<String> targetModelIds = mlProfileInput.getModelIds();
        Arrays.stream(this.mlTaskManager.getAllTaskIds()).forEach(taskId -> {
            MLTask mlTask = this.mlTaskManager.getMLTask((String)taskId);
            if (mlProfileInput.isReturnAllTasks() || !mlProfileInput.emptyTasks() && mlProfileInput.getTaskIds().contains(taskId)) {
                log.debug("Runtime task profile is found for model {}", (Object)mlTask.getModelId());
                mlLocalTasks.put((String)taskId, mlTask);
            }
            if (mlProfileInput.isReturnAllTasks() || !mlProfileInput.emptyModels() && targetModelIds.contains(mlTask.getModelId())) {
                log.debug("Runtime task profile is found for model {}", (Object)mlTask.getModelId());
                mlLocalTasks.put((String)taskId, mlTask);
            }
        });
        Arrays.stream(this.mlModelManager.getAllModelIds()).forEach(modelId -> {
            if (mlProfileInput.isReturnAllModels() || !mlProfileInput.emptyModels() && targetModelIds.contains(modelId)) {
                log.debug("Runtime model profile is found for model {}", modelId);
                MLModelProfile modelProfile = this.mlModelManager.getModelProfile((String)modelId);
                if (modelProfile != null) {
                    mlLocalModels.put((String)modelId, modelProfile);
                }
            }
        });
        return new MLProfileNodeResponse(this.clusterService.localNode(), mlLocalTasks, mlLocalModels);
    }
}

