/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.models;

import com.google.common.annotations.VisibleForTesting;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.ResourceNotFoundException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.TermsQueryBuilder;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.index.reindex.DeleteByQueryAction;
import org.opensearch.index.reindex.DeleteByQueryRequest;
import org.opensearch.ml.common.MLModel;
import org.opensearch.ml.common.exception.MLValidationException;
import org.opensearch.ml.common.model.MLModelState;
import org.opensearch.ml.common.transport.model.MLModelDeleteRequest;
import org.opensearch.ml.common.transport.model.MLModelGetRequest;
import org.opensearch.ml.helper.ModelAccessControlHelper;
import org.opensearch.ml.utils.MLNodeUtils;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class DeleteModelTransportAction
extends HandledTransportAction<ActionRequest, DeleteResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(DeleteModelTransportAction.class);
    static final String TIMEOUT_MSG = "Timeout while deleting model of ";
    static final String BULK_FAILURE_MSG = "Bulk failure while deleting model of ";
    static final String SEARCH_FAILURE_MSG = "Search failure while deleting model of ";
    static final String OS_STATUS_EXCEPTION_MESSAGE = "Failed to delete all model chunks";
    private Client client;
    private NamedXContentRegistry xContentRegistry;
    private ClusterService clusterService;
    private ModelAccessControlHelper modelAccessControlHelper;

    @Inject
    public DeleteModelTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, NamedXContentRegistry xContentRegistry, ClusterService clusterService, ModelAccessControlHelper modelAccessControlHelper) {
        super("cluster:admin/opensearch/ml/models/delete", transportService, actionFilters, MLModelDeleteRequest::new);
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
        this.modelAccessControlHelper = modelAccessControlHelper;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<DeleteResponse> actionListener) {
        MLModelDeleteRequest mlModelDeleteRequest = MLModelDeleteRequest.fromActionRequest((ActionRequest)request);
        String modelId = mlModelDeleteRequest.getModelId();
        MLModelGetRequest mlModelGetRequest = new MLModelGetRequest(modelId, false);
        FetchSourceContext fetchSourceContext = RestActionUtils.getFetchSourceContext(mlModelGetRequest.isReturnContent());
        GetRequest getRequest = new GetRequest(".plugins-ml-model").id(modelId).fetchSourceContext(fetchSourceContext);
        User user = RestActionUtils.getUserContext(this.client);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListener.runBefore(actionListener, () -> context.restore());
            this.client.get(getRequest, ActionListener.wrap(r -> {
                if (r != null && r.isExists()) {
                    try (XContentParser parser = MLNodeUtils.createXContentParserFromRegistry(this.xContentRegistry, r.getSourceAsBytesRef());){
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                        GetResponse getResponse = r;
                        String algorithmName = "";
                        if (getResponse.getSource() != null && getResponse.getSource().get("algorithm") != null) {
                            algorithmName = getResponse.getSource().get("algorithm").toString();
                        }
                        MLModel mlModel = MLModel.parse((XContentParser)parser, (String)algorithmName);
                        MLModelState mlModelState = mlModel.getModelState();
                        this.modelAccessControlHelper.validateModelGroupAccess(user, mlModel.getModelGroupId(), this.client, (ActionListener<Boolean>)ActionListener.wrap(access -> {
                            if (!access.booleanValue()) {
                                wrappedListener.onFailure((Exception)new MLValidationException("User doesn't have privilege to perform this operation on this model"));
                            } else if (mlModelState.equals((Object)MLModelState.LOADED) || mlModelState.equals((Object)MLModelState.LOADING) || mlModelState.equals((Object)MLModelState.PARTIALLY_LOADED) || mlModelState.equals((Object)MLModelState.DEPLOYED) || mlModelState.equals((Object)MLModelState.DEPLOYING) || mlModelState.equals((Object)MLModelState.PARTIALLY_DEPLOYED)) {
                                wrappedListener.onFailure(new Exception("Model cannot be deleted in deploying or deployed state. Try undeploy model first then delete"));
                            } else {
                                this.deleteModel(modelId, actionListener);
                            }
                        }, e -> {
                            log.error("Failed to validate Access for Model Id " + modelId, (Throwable)e);
                            wrappedListener.onFailure(e);
                        }));
                    }
                    catch (Exception e2) {
                        log.error("Failed to parse ml model " + r.getId(), (Throwable)e2);
                        wrappedListener.onFailure(e2);
                    }
                } else {
                    wrappedListener.onFailure((Exception)new OpenSearchStatusException("Failed to find model", RestStatus.NOT_FOUND, new Object[0]));
                }
            }, e -> wrappedListener.onFailure(e)));
        }
        catch (Exception e2) {
            log.error("Failed to delete ML model " + modelId, (Throwable)e2);
            actionListener.onFailure(e2);
        }
    }

    @VisibleForTesting
    void deleteModelChunks(String modelId, DeleteResponse deleteResponse, ActionListener<DeleteResponse> actionListener) {
        DeleteByQueryRequest deleteModelsRequest = new DeleteByQueryRequest(new String[]{".plugins-ml-model"});
        deleteModelsRequest.setQuery((QueryBuilder)new TermsQueryBuilder("model_id", new String[]{modelId}));
        this.client.execute((ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)deleteModelsRequest, ActionListener.wrap(r -> {
            if (!(r.getBulkFailures() != null && r.getBulkFailures().size() != 0 || r.getSearchFailures() != null && r.getSearchFailures().size() != 0)) {
                log.debug("All model chunks are deleted for model {}", (Object)modelId);
                if (deleteResponse != null) {
                    actionListener.onResponse((Object)deleteResponse);
                }
            } else {
                this.returnFailure((BulkByScrollResponse)r, modelId, actionListener);
            }
        }, e -> {
            log.error("Failed to delete ML model for " + modelId, (Throwable)e);
            actionListener.onFailure(e);
        }));
    }

    private void returnFailure(BulkByScrollResponse response, String modelId, ActionListener<DeleteResponse> actionListener) {
        Object errorMessage = "";
        errorMessage = response.isTimedOut() ? "Failed to delete all model chunks, Timeout while deleting model of " + modelId : (!response.getBulkFailures().isEmpty() ? "Failed to delete all model chunks, Bulk failure while deleting model of " + modelId : "Failed to delete all model chunks, Search failure while deleting model of " + modelId);
        log.debug(response.toString());
        actionListener.onFailure((Exception)new OpenSearchStatusException((String)errorMessage, RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
    }

    private void deleteModel(final String modelId, final ActionListener<DeleteResponse> actionListener) {
        DeleteRequest deleteRequest = new DeleteRequest(".plugins-ml-model", modelId);
        this.client.delete(deleteRequest, (ActionListener)new ActionListener<DeleteResponse>(){

            public void onResponse(DeleteResponse deleteResponse) {
                DeleteModelTransportAction.this.deleteModelChunks(modelId, deleteResponse, (ActionListener<DeleteResponse>)actionListener);
            }

            public void onFailure(Exception e) {
                log.error("Failed to delete model meta data for model: " + modelId, (Throwable)e);
                if (e instanceof ResourceNotFoundException) {
                    DeleteModelTransportAction.this.deleteModelChunks(modelId, null, (ActionListener<DeleteResponse>)actionListener);
                }
                actionListener.onFailure(e);
            }
        });
    }
}

