/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.algorithms.remote;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.connector.Connector;
import org.opensearch.ml.common.dataset.MLInputDataset;
import org.opensearch.ml.common.dataset.TextDocsInputDataSet;
import org.opensearch.ml.common.dataset.remote.RemoteInferenceInputDataSet;
import org.opensearch.ml.common.input.MLInput;
import org.opensearch.ml.common.output.model.ModelTensorOutput;
import org.opensearch.ml.common.output.model.ModelTensors;
import org.opensearch.ml.engine.algorithms.remote.ConnectorUtils;
import org.opensearch.script.ScriptService;

public interface RemoteConnectorExecutor {
    default public ModelTensorOutput executePredict(MLInput mlInput) {
        ArrayList<ModelTensors> tensorOutputs = new ArrayList<ModelTensors>();
        if (mlInput.getInputDataset() instanceof TextDocsInputDataSet) {
            TextDocsInputDataSet textDocsInputDataSet = (TextDocsInputDataSet)mlInput.getInputDataset();
            int processedDocs = 0;
            while (processedDocs < textDocsInputDataSet.getDocs().size()) {
                Map parameters;
                List textDocs = textDocsInputDataSet.getDocs().subList(processedDocs, textDocsInputDataSet.getDocs().size());
                ArrayList<ModelTensors> tempTensorOutputs = new ArrayList<ModelTensors>();
                this.preparePayloadAndInvokeRemoteModel(MLInput.builder().algorithm(FunctionName.TEXT_EMBEDDING).inputDataset((MLInputDataset)TextDocsInputDataSet.builder().docs(textDocs).build()).build(), tempTensorOutputs);
                int tensorCount = 0;
                if (tempTensorOutputs.size() > 0 && ((ModelTensors)tempTensorOutputs.get(0)).getMlModelTensors() != null) {
                    tensorCount = ((ModelTensors)tempTensorOutputs.get(0)).getMlModelTensors().size();
                }
                if ((parameters = this.getConnector().getParameters()) != null && parameters.containsKey("input_docs_processed_step_size")) {
                    int stepSize = Integer.parseInt((String)parameters.get("input_docs_processed_step_size"));
                    if (stepSize <= 0) {
                        throw new IllegalArgumentException("Invalid parameter: input_docs_processed_step_size. It must be positive integer.");
                    }
                    processedDocs += stepSize;
                } else {
                    processedDocs += Math.max(tensorCount, 1);
                }
                tensorOutputs.addAll(tempTensorOutputs);
            }
        } else {
            this.preparePayloadAndInvokeRemoteModel(mlInput, tensorOutputs);
        }
        return new ModelTensorOutput(tensorOutputs);
    }

    default public void setScriptService(ScriptService scriptService) {
    }

    public ScriptService getScriptService();

    public Connector getConnector();

    default public void setClient(Client client) {
    }

    default public void setXContentRegistry(NamedXContentRegistry xContentRegistry) {
    }

    default public void setClusterService(ClusterService clusterService) {
    }

    default public void preparePayloadAndInvokeRemoteModel(MLInput mlInput, List<ModelTensors> tensorOutputs) {
        RemoteInferenceInputDataSet inputData;
        MLInputDataset inputDataset;
        Connector connector = this.getConnector();
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (connector.getParameters() != null) {
            parameters.putAll(connector.getParameters());
        }
        if ((inputDataset = mlInput.getInputDataset()) instanceof RemoteInferenceInputDataSet && ((RemoteInferenceInputDataSet)inputDataset).getParameters() != null) {
            parameters.putAll(((RemoteInferenceInputDataSet)inputDataset).getParameters());
        }
        if ((inputData = ConnectorUtils.processInput(mlInput, connector, parameters, this.getScriptService())).getParameters() != null) {
            parameters.putAll(inputData.getParameters());
        }
        String payload = (String)connector.createPredictPayload(parameters);
        connector.validatePayload(payload);
        this.invokeRemoteModel(mlInput, parameters, payload, tensorOutputs);
    }

    public void invokeRemoteModel(MLInput var1, Map<String, String> var2, String var3, List<ModelTensors> var4);
}

