/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.integration.beans;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.mina.integration.beans.AbstractPropertyEditor;

public class DateEditor
extends AbstractPropertyEditor {
    private static final Pattern MILLIS = Pattern.compile("[0-9][0-9]*");
    private final DateFormat[] formats;

    public DateEditor() {
        for (DateFormat f : this.formats = new DateFormat[]{new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.ENGLISH), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z", Locale.ENGLISH), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH), new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH), new SimpleDateFormat("yyyy-MM", Locale.ENGLISH), new SimpleDateFormat("yyyy", Locale.ENGLISH)}) {
            f.setLenient(true);
        }
    }

    @Override
    protected String toText(Object value) {
        if (value instanceof Number) {
            long time = ((Number)value).longValue();
            if (time <= 0L) {
                return null;
            }
            value = new Date(time);
        }
        return this.formats[0].format((Date)value);
    }

    @Override
    protected Object toValue(String text) {
        if (MILLIS.matcher(text).matches()) {
            long time = Long.parseLong(text);
            if (time <= 0L) {
                return null;
            }
            return new Date(time);
        }
        int n = 0;
        DateFormat[] dateFormatArray = this.formats;
        int n2 = dateFormatArray.length;
        if (n < n2) {
            DateFormat f = dateFormatArray[n];
            try {
                return f.parse(text);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Wrong date: " + text);
            }
        }
        throw new IllegalArgumentException("Wrong date: " + text);
    }
}

