/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.attributes;

import jadx.api.plugins.input.data.annotations.IAnnotation;
import jadx.api.plugins.input.data.attributes.IJadxAttrType;
import jadx.api.plugins.input.data.attributes.IJadxAttribute;
import jadx.api.plugins.input.data.attributes.JadxAttrType;
import jadx.api.plugins.input.data.attributes.types.AnnotationsAttr;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AttrList;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AttributeStorage {
    private final Set<AFlag> flags = EnumSet.noneOf(AFlag.class);
    private Map<IJadxAttrType<?>, IJadxAttribute> attributes = Collections.emptyMap();

    public AttributeStorage() {
    }

    public AttributeStorage(List<IJadxAttribute> attributesList) {
        this();
        this.add(attributesList);
    }

    public void add(AFlag flag) {
        this.flags.add(flag);
    }

    public void add(IJadxAttribute attr) {
        this.writeAttributes().put(attr.getAttrType(), attr);
    }

    public void add(List<IJadxAttribute> list) {
        Map<IJadxAttrType<?>, IJadxAttribute> map = this.writeAttributes();
        for (IJadxAttribute attr : list) {
            map.put(attr.getAttrType(), attr);
        }
    }

    public <T> void add(IJadxAttrType<AttrList<T>> type, T obj) {
        AttrList<T> list = this.get(type);
        if (list == null) {
            list = new AttrList<T>(type);
            this.add(list);
        }
        list.getList().add(obj);
    }

    public void addAll(AttributeStorage otherList) {
        this.flags.addAll(otherList.flags);
        this.writeAttributes().putAll(otherList.attributes);
    }

    public boolean contains(AFlag flag) {
        return this.flags.contains((Object)flag);
    }

    public <T extends IJadxAttribute> boolean contains(IJadxAttrType<T> type) {
        return this.attributes.containsKey(type);
    }

    public <T extends IJadxAttribute> T get(IJadxAttrType<T> type) {
        return (T)this.attributes.get(type);
    }

    public IAnnotation getAnnotation(String cls) {
        AnnotationsAttr aList = (AnnotationsAttr)this.get((IJadxAttrType)JadxAttrType.ANNOTATION_LIST);
        return aList == null ? null : aList.get(cls);
    }

    public <T> List<T> getAll(IJadxAttrType<AttrList<T>> type) {
        AttrList<T> attrList = this.get(type);
        if (attrList == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(attrList.getList());
    }

    public void remove(AFlag flag) {
        this.flags.remove((Object)flag);
    }

    public <T extends IJadxAttribute> void remove(IJadxAttrType<T> type) {
        if (!this.attributes.isEmpty()) {
            this.attributes.remove(type);
        }
    }

    public void remove(IJadxAttribute attr) {
        IJadxAttrType type;
        IJadxAttribute a;
        if (!this.attributes.isEmpty() && (a = this.attributes.get(type = attr.getAttrType())) == attr) {
            this.attributes.remove(type);
        }
    }

    private Map<IJadxAttrType<?>, IJadxAttribute> writeAttributes() {
        if (this.attributes.isEmpty()) {
            this.attributes = new IdentityHashMap(5);
        }
        return this.attributes;
    }

    public void clear() {
        this.flags.clear();
        if (!this.attributes.isEmpty()) {
            this.attributes.clear();
        }
    }

    public synchronized void unloadAttributes() {
        if (this.attributes.isEmpty()) {
            return;
        }
        this.attributes.entrySet().removeIf(entry -> !((IJadxAttribute)entry.getValue()).keepLoaded());
    }

    public List<String> getAttributeStrings() {
        int size = this.flags.size() + this.attributes.size() + this.attributes.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(size);
        for (AFlag aFlag : this.flags) {
            list.add(aFlag.toString());
        }
        for (IJadxAttribute iJadxAttribute : this.attributes.values()) {
            list.add(iJadxAttribute.toAttrString());
        }
        return list;
    }

    public boolean isEmpty() {
        return this.flags.isEmpty() && this.attributes.isEmpty();
    }

    public String toString() {
        List<String> list = this.getAttributeStrings();
        if (list.isEmpty()) {
            return "";
        }
        list.sort(String::compareTo);
        return "A[" + Utils.listToString(list) + ']';
    }

    static {
        int flagsCount = AFlag.values().length;
        if (flagsCount >= 64) {
            throw new JadxRuntimeException("Try to reduce flags count to 64 for use one long in EnumSet, now " + flagsCount);
        }
    }
}

