/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.xslt;

import java.io.File;
import java.io.FileInputStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.xslt.Messages;
import org.pentaho.di.trans.steps.xslt.XsltData;
import org.pentaho.di.trans.steps.xslt.XsltMeta;

public class Xslt
extends BaseStep
implements StepInterface {
    private XsltMeta meta;
    private XsltData data;
    static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";

    public Xslt(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (XsltMeta)smi;
        this.data = (XsltData)sdi;
        Object[] row = this.getRow();
        if (row == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
            if (Const.isEmpty((String)this.meta.getResultfieldname())) {
                this.logError(Messages.getString("Xslt.Log.ErrorResultFieldMissing"));
                throw new KettleStepException(Messages.getString("Xslt.Exception.ErrorResultFieldMissing"));
            }
            if (Const.isEmpty((String)this.meta.getFieldname())) {
                this.logError(Messages.getString("Xslt.Exception.ErrorXMLFieldMissing"));
                throw new KettleStepException(Messages.getString("Xslt.Exception.ErrorXMLFieldMissing"));
            }
            this.data.fieldposition = this.getInputRowMeta().indexOfValue(this.meta.getFieldname());
            if (this.data.fieldposition < 0) {
                this.logError(Messages.getString("Xslt.Log.ErrorFindingField") + "[" + this.meta.getFieldname() + "]");
                throw new KettleStepException(Messages.getString("Xslt.Exception.CouldnotFindField", this.meta.getFieldname()));
            }
            if (this.meta.useXSLFileFieldUse()) {
                if (Const.isEmpty((String)this.meta.getXSLFileField())) {
                    this.logError(Messages.getString("Xslt.Log.ErrorXSLFileFieldMissing"));
                    throw new KettleStepException(Messages.getString("Xslt.Exception.ErrorXSLFileFieldMissing"));
                }
                this.data.fielxslfiledposition = this.getInputRowMeta().indexOfValue(this.meta.getXSLFileField());
                if (this.data.fielxslfiledposition < 0) {
                    this.logError(Messages.getString("Xslt.Log.ErrorXSLFileFieldFinding") + "[" + this.meta.getXSLFileField() + "]");
                    throw new KettleStepException(Messages.getString("Xslt.Exception.ErrorXSLFileFieldFinding", this.meta.getXSLFileField()));
                }
            } else {
                if (Const.isEmpty((String)this.meta.getXslFilename())) {
                    this.logError(Messages.getString("Xslt.Log.ErrorXSLFile"));
                    throw new KettleStepException(Messages.getString("Xslt.Exception.ErrorXSLFile"));
                }
                this.data.xslfilename = this.environmentSubstitute(this.meta.getXslFilename());
                File file = new File(this.data.xslfilename);
                if (!file.exists()) {
                    this.logError(Messages.getString("Xslt.Log.ErrorXSLFileNotExists", this.data.xslfilename));
                    throw new KettleStepException(Messages.getString("Xslt.Exception.ErrorXSLFileNotExists", this.data.xslfilename));
                }
                if (!file.isFile()) {
                    this.logError(Messages.getString("Xslt.Log.ErrorXSLNotAFile", this.data.xslfilename));
                    throw new KettleStepException(Messages.getString("Xslt.Exception.ErrorXSLNotAFile", this.data.xslfilename));
                }
            }
        }
        String Fieldvalue = this.getInputRowMeta().getString(row, this.data.fieldposition);
        String xmlString = null;
        if (this.meta.useXSLFileFieldUse()) {
            this.data.xslfilename = this.getInputRowMeta().getString(row, this.data.fielxslfiledposition);
            if (this.log.isDetailed()) {
                this.logDetailed(Messages.getString("Xslt.Log.XslfileNameFromFied", this.data.xslfilename, this.meta.getXSLFileField()));
            }
        }
        boolean sendToErrorRow = false;
        String errorMessage = null;
        try {
            if (this.log.isDetailed()) {
                this.logDetailed(Messages.getString("Xslt.Log.Filexsl") + this.data.xslfilename);
            }
            TransformerFactory factory = TransformerFactory.newInstance();
            if (this.meta.getXSLFactory().equals("SAXON")) {
                factory = new TransformerFactoryImpl();
            }
            Templates template = factory.newTemplates(new StreamSource(new FileInputStream(this.data.xslfilename)));
            Transformer xformer = template.newTransformer();
            StreamSource source = new StreamSource(new StringReader(Fieldvalue));
            StreamResult resultat = new StreamResult(new StringWriter());
            xformer.transform(source, resultat);
            xmlString = resultat.getWriter().toString();
            if (this.log.isDetailed()) {
                this.logDetailed(Messages.getString("Xslt.Log.FileResult"));
                this.logDetailed(xmlString);
            }
            Object[] outputRowData = RowDataUtil.addValueData((Object[])row, (int)this.getInputRowMeta().size(), (Object)xmlString);
            if (this.log.isRowLevel()) {
                this.logRowlevel(Messages.getString("Xslt.Log.ReadRow") + " " + this.getInputRowMeta().getString(row));
            }
            this.putRow(this.data.outputRowMeta, outputRowData);
        }
        catch (Exception e) {
            if (this.getStepMeta().isDoingErrorHandling()) {
                sendToErrorRow = true;
                errorMessage = e.getMessage();
            }
            if (sendToErrorRow) {
                this.putError(this.getInputRowMeta(), row, 1L, errorMessage, this.meta.getResultfieldname(), "XSLT01");
            }
            this.logError(Messages.getString("Xslt.ErrorProcesing : " + e.getMessage()));
            throw new KettleStepException(Messages.getString("Xslt.ErrorProcesing"), (Throwable)e);
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (XsltMeta)smi;
        this.data = (XsltData)sdi;
        return super.init(smi, sdi);
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

