/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.layout.LayoutEdge;
import ca.sqlpower.architect.layout.LayoutNode;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.BasicRelationshipUI;
import ca.sqlpower.architect.swingui.IERelationshipUI;
import ca.sqlpower.architect.swingui.Messages;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.PlayPenContentPane;
import ca.sqlpower.architect.swingui.RelationshipUI;
import ca.sqlpower.architect.swingui.TablePane;
import ca.sqlpower.architect.swingui.event.SelectionEvent;
import ca.sqlpower.object.AbstractSPListener;
import ca.sqlpower.object.SPChildEvent;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.annotation.Accessor;
import ca.sqlpower.object.annotation.Constructor;
import ca.sqlpower.object.annotation.ConstructorParameter;
import ca.sqlpower.object.annotation.Mutator;
import ca.sqlpower.object.annotation.NonBound;
import ca.sqlpower.object.annotation.Transient;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLRelationship;
import ca.sqlpower.swingui.ColorIcon;
import ca.sqlpower.swingui.ColourScheme;
import ca.sqlpower.util.TransactionEvent;
import ca.sqlpower.util.WebColour;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import org.apache.log4j.Logger;

public class Relationship
extends PlayPenComponent
implements SPListener,
LayoutEdge {
    private static final Logger logger = Logger.getLogger(Relationship.class);
    public static final List<Class<? extends SPObject>> allowedChildTypes = PlayPenComponent.allowedChildTypes;
    public static final String PARENT_TO_CHILD = "receives";
    public static final String CHILD_TO_PARENT = "is received by";
    public static final Vector<Color> SUGGESTED_COLOURS = new Vector();
    private SQLRelationship model;
    private TablePane pkTable;
    private TablePane fkTable;
    private double pkConnection;
    private double fkConnection;
    protected int orientation;
    public static final int NO_FACING_EDGES = 0;
    public static final int PARENT_FACES_RIGHT = 1;
    public static final int PARENT_FACES_LEFT = 2;
    public static final int PARENT_FACES_BOTTOM = 4;
    public static final int PARENT_FACES_TOP = 8;
    public static final int CHILD_FACES_RIGHT = 16;
    public static final int CHILD_FACES_LEFT = 32;
    public static final int CHILD_FACES_BOTTOM = 64;
    public static final int CHILD_FACES_TOP = 128;
    public static final int CHILD_MASK = 240;
    public static final int PARENT_MASK = 15;
    private JPopupMenu popup;
    private boolean selected;
    private final TablePaneBehaviourListener tpbListener = new TablePaneBehaviourListener();
    private Color columnHighlightColour = ColourScheme.SQLPOWER_ORANGE;
    private final AbstractSPListener containerPaneListener = new AbstractSPListener(){

        public void childRemoved(SPChildEvent e) {
            if (e.getChild() == Relationship.this) {
                Relationship.this.destroy();
            }
        }
    };
    private final AbstractSPListener labelListener = new AbstractSPListener(){

        public void propertyChanged(PropertyChangeEvent evt) {
            Relationship.this.repaint();
        }
    };

    Relationship(Relationship r, PlayPenContentPane contentPane) {
        super(r, contentPane);
        this.setParent((SPObject)contentPane);
        this.model = r.model;
        this.setName(r.getName());
        this.pkTable = r.pkTable;
        this.fkTable = r.fkTable;
        this.pkConnection = r.getPkConnection();
        this.fkConnection = r.getFkConnection();
        this.selected = false;
        this.columnHighlightColour = r.columnHighlightColour;
        this.foregroundColor = r.getForegroundColor();
        this.backgroundColor = r.getBackgroundColor();
        this.orientation = r.getOrientation();
        if (this.isMagicEnabled() != r.isMagicEnabled()) {
            this.setMagicEnabled(r.isMagicEnabled());
        }
        try {
            RelationshipUI ui = (RelationshipUI)r.getUI().getClass().newInstance();
            ui.installUI(this);
            this.setUI(ui);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Woops, couldn't invoke no-args constructor of " + r.getUI().getClass().getName());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Woops, couldn't access no-args constructor of " + r.getUI().getClass().getName());
        }
    }

    public Relationship(SQLRelationship model, PlayPenContentPane parent) throws SQLObjectException {
        this(model, parent.getPlayPen().findTablePane(model.getPkTable()), parent.getPlayPen().findTablePane(model.getFkTable()), parent);
    }

    public Relationship(SQLRelationship model, TablePane pkTable, TablePane fkTable, PlayPenContentPane parent) throws SQLObjectException {
        this(model, pkTable, fkTable, parent, 0.0, 0.0, 0);
    }

    @Constructor
    public Relationship(@ConstructorParameter(propertyName="model") SQLRelationship model, @ConstructorParameter(propertyName="pkTable") TablePane pkTable, @ConstructorParameter(propertyName="fkTable") TablePane fkTable, @ConstructorParameter(propertyName="parent") PlayPenContentPane parent, @ConstructorParameter(propertyName="pkConnection") double pkConnection, @ConstructorParameter(propertyName="fkConnection") double fkConnection, @ConstructorParameter(propertyName="orientation") int orientation) throws SQLObjectException {
        super(model.getName());
        this.model = model;
        this.setPkTable(pkTable);
        this.setFkTable(fkTable);
        this.pkConnection = pkConnection;
        this.fkConnection = fkConnection;
        this.orientation = orientation;
        this.setParent((SPObject)parent);
        this.setup();
    }

    protected void setup() {
        this.updateUI();
        this.setOpaque(false);
        this.setBackgroundColor(Color.green);
        this.model.addSPListener((SPListener)this);
        this.setToolTipText(this.model.getName());
    }

    protected void createPopup() {
        ArchitectFrame af = this.getPlayPen().getSession().getArchitectFrame();
        this.popup = new JPopupMenu();
        JMenu setFocusToRelatedTables = new JMenu(Messages.getString("Relationship.setFocusMenu"));
        JMenuItem mi = new JMenuItem();
        mi.setAction(af.getFocusToParentAction());
        mi.setActionCommand("PlayPen");
        setFocusToRelatedTables.add(mi);
        mi = new JMenuItem();
        mi.setAction(af.getFocusToChildAction());
        mi.setActionCommand("PlayPen");
        setFocusToRelatedTables.add(mi);
        this.popup.add(setFocusToRelatedTables);
        JMenu setRelationshipLineColor = new JMenu(Messages.getString("Relationship.relationshipLineColor"));
        for (final Color color : SUGGESTED_COLOURS) {
            ColorIcon icon = new ColorIcon(60, 25, color);
            mi = new JMenuItem((Icon)icon);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Relationship.this.getPlayPen().startCompoundEdit("Set relationship line colour");
                    for (Relationship r : Relationship.this.getPlayPen().getSelectedRelationShips()) {
                        r.setForegroundColor(color);
                    }
                    Relationship.this.getPlayPen().endCompoundEdit("Set relationship line colour");
                }
            });
            setRelationshipLineColor.add(mi);
        }
        this.popup.add(setRelationshipLineColor);
        mi = new JMenuItem(af.getReverseRelationshipAction());
        this.popup.add(mi);
        mi = new JMenuItem(af.getEditRelationshipAction());
        mi.setActionCommand("PlayPen");
        this.popup.add(mi);
        if (logger.isDebugEnabled()) {
            this.popup.addSeparator();
            mi = new JMenuItem(new AbstractAction("Show Mappings"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StringBuffer componentList = new StringBuffer();
                    for (SQLRelationship.ColumnMapping columnMap : Relationship.this.getModel().getChildren(SQLRelationship.ColumnMapping.class)) {
                        componentList.append(columnMap).append("\n");
                    }
                    JOptionPane.showMessageDialog(Relationship.this.getPlayPen(), new JScrollPane(new JTextArea(componentList.toString())));
                }
            });
            this.popup.add(mi);
        }
        this.popup.addSeparator();
        mi = new JMenuItem(af.getDeleteSelectedAction());
        mi.setActionCommand("PlayPen");
        this.popup.add(mi);
    }

    @Override
    @Transient
    @Accessor
    public Point getPreferredLocation() {
        return ((RelationshipUI)this.getUI()).getPreferredLocation();
    }

    public String toString() {
        return "Relationship: " + this.model;
    }

    @Override
    public void connect() {
        this.destroy();
        if (this.pkTable != null) {
            this.pkTable.addSPListener((SPListener)this.tpbListener);
        }
        if (this.fkTable != null) {
            this.fkTable.addSPListener((SPListener)this.tpbListener);
        }
        this.getParent().addSPListener((SPListener)this.containerPaneListener);
        this.model.addSPListener((SPListener)this.labelListener);
    }

    private void destroy() {
        if (this.pkTable != null) {
            this.pkTable.removeSPListener((SPListener)this.tpbListener);
        }
        if (this.fkTable != null) {
            this.fkTable.removeSPListener((SPListener)this.tpbListener);
        }
        this.getParent().removeSPListener((SPListener)this.containerPaneListener);
        this.model.removeSPListener((SPListener)this.labelListener);
    }

    public void updateUI() {
        RelationshipUI ui = (RelationshipUI)IERelationshipUI.createUI(this);
        ui.installUI(this);
        this.setUI(ui);
        this.updateLengths(false);
        if (this.isMagicEnabled()) {
            ui.bestConnectionPoints();
        }
        this.revalidate();
    }

    @Override
    @Transient
    @Mutator
    public void setSelected(boolean isSelected, int multiSelectType) {
        if (this.selected != isSelected) {
            for (SQLRelationship.ColumnMapping m : this.getModel().getChildren(SQLRelationship.ColumnMapping.class)) {
                if (isSelected) {
                    this.pkTable.addColumnHighlight(m.getPkColumn(), this.columnHighlightColour);
                    this.fkTable.addColumnHighlight(m.getFkColumn(), this.columnHighlightColour);
                    continue;
                }
                this.pkTable.removeColumnHighlight(m.getPkColumn(), this.columnHighlightColour);
                this.fkTable.removeColumnHighlight(m.getFkColumn(), this.columnHighlightColour);
            }
            this.selected = isSelected;
            this.fireSelectionEvent(new SelectionEvent(this, this.selected ? 1 : 2, 4));
            this.repaint();
        }
    }

    @Override
    @Transient
    @Accessor
    public boolean isSelected() {
        return this.selected;
    }

    @Transient
    @Accessor
    public String getUIClassID() {
        return "RelationshipUI";
    }

    public SQLRelationship getModel() {
        return this.model;
    }

    @Override
    public String getModelName() {
        return this.model.getName();
    }

    @Mutator
    public void setPkTable(TablePane tp) {
        TablePane oldPk = this.pkTable;
        if (this.pkTable != null) {
            this.pkTable.removeSPListener((SPListener)this.tpbListener);
        }
        this.pkTable = tp;
        this.pkTable.addSPListener((SPListener)this.tpbListener);
        this.firePropertyChange("pkTable", oldPk, this.pkTable);
    }

    @Accessor
    public TablePane getPkTable() {
        return this.pkTable;
    }

    @Mutator
    public void setFkTable(TablePane tp) {
        TablePane oldFk = this.fkTable;
        if (this.fkTable != null) {
            this.fkTable.removeSPListener((SPListener)this.tpbListener);
        }
        this.fkTable = tp;
        this.fkTable.addSPListener((SPListener)this.tpbListener);
        this.firePropertyChange("fkTable", oldFk, this.fkTable);
    }

    @Accessor
    public TablePane getFkTable() {
        return this.fkTable;
    }

    @Accessor(isInteresting=true)
    public double getPkConnection() {
        return this.pkConnection;
    }

    @Accessor(isInteresting=true)
    public double getFkConnection() {
        return this.fkConnection;
    }

    public BasicRelationshipUI.ImmutablePoint createPkConnectionPoint() {
        TablePane pane = this.getPkTable();
        Point p = (this.getOrientation() & 4) != 0 ? new Point((int)((double)pane.getWidth() * this.getPkConnection()), pane.getHeight()) : ((this.getOrientation() & 8) != 0 ? new Point((int)((double)pane.getWidth() * this.getPkConnection()), 0) : ((this.getOrientation() & 2) != 0 ? new Point(0, (int)((double)pane.getHeight() * this.getPkConnection())) : new Point(pane.getWidth(), (int)((double)pane.getHeight() * this.getPkConnection()))));
        return new BasicRelationshipUI.ImmutablePoint(p);
    }

    public BasicRelationshipUI.ImmutablePoint createFkConnectionPoint() {
        TablePane pane = this.getFkTable();
        Point p = (this.getOrientation() & 0x40) != 0 ? new Point((int)((double)pane.getWidth() * this.getFkConnection()), pane.getHeight()) : ((this.getOrientation() & 0x80) != 0 ? new Point((int)((double)pane.getWidth() * this.getFkConnection()), 0) : ((this.getOrientation() & 0x20) != 0 ? new Point(0, (int)((double)pane.getHeight() * this.getFkConnection())) : new Point(pane.getWidth(), (int)((double)pane.getHeight() * this.getFkConnection()))));
        return new BasicRelationshipUI.ImmutablePoint(p);
    }

    @Transient
    @Mutator
    public void setFkConnectionPoint(Point p) {
        if ((this.getOrientation() & 0x40) != 0) {
            this.setFkConnection(p.getX() / (double)this.getFkTable().getWidth());
        } else if ((this.getOrientation() & 0x80) != 0) {
            this.setFkConnection(p.getX() / (double)this.getFkTable().getWidth());
        } else if ((this.getOrientation() & 0x20) != 0) {
            this.setFkConnection(p.getY() / (double)this.getFkTable().getHeight());
        } else {
            this.setFkConnection(p.getY() / (double)this.getFkTable().getHeight());
        }
    }

    @Transient
    @Mutator
    public void setPkConnectionPoint(Point p) {
        if ((this.getOrientation() & 4) != 0) {
            this.setPkConnection(p.getX() / (double)this.getPkTable().getWidth());
        } else if ((this.getOrientation() & 8) != 0) {
            this.setPkConnection(p.getX() / (double)this.getPkTable().getWidth());
        } else if ((this.getOrientation() & 2) != 0) {
            this.setPkConnection(p.getY() / (double)this.getPkTable().getHeight());
        } else {
            this.setPkConnection(p.getY() / (double)this.getPkTable().getHeight());
        }
    }

    @Accessor(isInteresting=true)
    public int getOrientation() {
        return this.orientation;
    }

    @Mutator
    public void setOrientation(int orientation) {
        int oldValue = this.orientation;
        this.orientation = orientation;
        this.firePropertyChange("orientation", oldValue, orientation);
        this.repaint();
    }

    @Mutator
    public void setPkConnection(double pk) {
        double oldValue = this.pkConnection;
        this.pkConnection = pk;
        this.firePropertyChange("pkConnection", oldValue, pk);
    }

    @Mutator
    public void setFkConnection(double fk) {
        double oldValue = this.fkConnection;
        this.fkConnection = fk;
        this.firePropertyChange("fkConnection", oldValue, fk);
    }

    @Transient
    @Accessor
    public Color getColumnHighlightColour() {
        return this.columnHighlightColour;
    }

    public void childAdded(SPChildEvent e) {
        if (this.isSelected()) {
            SQLRelationship.ColumnMapping cm = (SQLRelationship.ColumnMapping)e.getChild();
            this.pkTable.addColumnHighlight(cm.getPkColumn(), this.columnHighlightColour);
            this.fkTable.addColumnHighlight(cm.getFkColumn(), this.columnHighlightColour);
        }
    }

    public void childRemoved(SPChildEvent e) {
        if (this.isSelected()) {
            SQLRelationship.ColumnMapping cm = (SQLRelationship.ColumnMapping)e.getChild();
            this.pkTable.removeColumnHighlight(cm.getPkColumn(), this.columnHighlightColour);
            this.fkTable.removeColumnHighlight(cm.getFkColumn(), this.columnHighlightColour);
        }
    }

    public void propertyChanged(PropertyChangeEvent e) {
        if (e.getPropertyName() != null) {
            if (e.getPropertyName().equals("name")) {
                this.setToolTipText(this.model.getName());
            } else if (e.getPropertyName().equals("identifying") || e.getPropertyName().equals("pkCardinality") || e.getPropertyName().equals("fkCardinality")) {
                this.repaint();
            }
        }
    }

    public void transactionStarted(TransactionEvent e) {
    }

    public void transactionEnded(TransactionEvent e) {
    }

    public void transactionRollback(TransactionEvent e) {
    }

    public boolean intersects(Rectangle region) {
        return ((RelationshipUI)this.getUI()).intersects(region);
    }

    @Override
    @Transient
    @Accessor
    public LayoutNode getHeadNode() {
        return this.fkTable;
    }

    @Override
    @Transient
    @Accessor
    public LayoutNode getTailNode() {
        return this.pkTable;
    }

    @Override
    @Transient
    @Accessor
    public JPopupMenu getPopup(Point p) {
        if (this.popup == null) {
            this.createPopup();
        }
        return this.popup;
    }

    @Transient
    @Accessor
    public boolean isStraightLine() {
        ArchitectSwingSession session;
        PlayPen pp = this.getPlayPen();
        if (pp != null && (session = pp.getSession()) != null) {
            return session.getRelationshipLinesDirect();
        }
        return false;
    }

    public boolean displayRelationshipLabel() {
        ArchitectSwingSession session;
        PlayPen pp = this.getPlayPen();
        if (pp != null && (session = pp.getSession()) != null) {
            return session.isDisplayRelationshipLabel();
        }
        return false;
    }

    @Override
    public void handleMouseEvent(MouseEvent evt) {
        PlayPen pp = this.getPlayPen();
        Point p = evt.getPoint();
        pp.unzoomPoint(p);
        p.translate(-this.getX(), -this.getY());
        if (evt.getID() == 500) {
            ArchitectSwingSession session = pp.getSession();
            if (evt.getClickCount() == 2) {
                session.getArchitectFrame().getEditRelationshipAction().actionPerformed(new ActionEvent(evt.getSource(), 1001, "PlayPen"));
            } else if (evt.getClickCount() == 1 && evt.getButton() == 1 && this.isSelected() && this.componentPreviouslySelected) {
                this.setSelected(false, 4);
            }
            session.getArchitectFrame().getCreateIdentifyingRelationshipAction().cancel();
            session.getArchitectFrame().getCreateNonIdentifyingRelationshipAction().cancel();
        } else if (evt.getID() == 501) {
            this.componentPreviouslySelected = false;
            if (pp.getMouseMode() != PlayPen.MouseModeType.CREATING_RELATIONSHIP) {
                if ((evt.getModifiersEx() & 0xC0) != 0) {
                    pp.setMouseMode(PlayPen.MouseModeType.MULTI_SELECT);
                } else {
                    pp.setMouseMode(PlayPen.MouseModeType.SELECT_RELATIONSHIP);
                    if (!this.isSelected()) {
                        pp.selectNone();
                    }
                }
            }
            if (this.isSelected()) {
                this.componentPreviouslySelected = true;
            } else {
                this.setSelected(true, 4);
            }
            boolean overPkDec = ((RelationshipUI)this.getUI()).isOverPkDecoration(p);
            boolean overFkDec = ((RelationshipUI)this.getUI()).isOverFkDecoration(p);
            if (overPkDec || overFkDec && SwingUtilities.isLeftMouseButton(evt)) {
                new RelationshipDecorationMover(this, overPkDec);
            }
        } else if (evt.getID() == 503 || evt.getID() == 506) {
            this.setSelected(this.intersects(pp.rubberBand), 4);
        }
    }

    @Transient
    @Mutator
    public void setTextForParentLabel(String textForParentLabel) {
        this.model.setTextForParentLabel(textForParentLabel);
    }

    @Transient
    @Accessor
    public String getTextForParentLabel() {
        return this.model.getTextForParentLabel();
    }

    @Transient
    @Mutator
    public void setTextForChildLabel(String textForChildLabel) {
        this.model.setTextForChildLabel(textForChildLabel);
    }

    @Transient
    @Accessor
    public String getTextForChildLabel() {
        return this.model.getTextForChildLabel();
    }

    @Override
    @NonBound
    public List<? extends SPObject> getDependencies() {
        ArrayList<Object> dependencies = new ArrayList<Object>();
        dependencies.add(this.getModel());
        dependencies.add(this.getFkTable());
        dependencies.add(this.getPkTable());
        return dependencies;
    }

    @Override
    public void removeDependency(SPObject dependency) {
        if (dependency == this.getModel()) {
            super.removeDependency(dependency);
        } else if (dependency == this.getPkTable()) {
            this.setPkTable(null);
        } else if (dependency == this.getFkTable()) {
            this.setFkTable(null);
        } else {
            throw new IllegalArgumentException("This Relationship is not dependant on " + dependency);
        }
    }

    static {
        SUGGESTED_COLOURS.addAll(ColourScheme.BREWER_SET19);
        SUGGESTED_COLOURS.add((Color)new WebColour(0, 0, 0));
    }

    protected static class RelationshipDecorationMover
    extends MouseInputAdapter {
        protected Relationship r;
        protected Point startingPk;
        protected Point startingFk;
        protected boolean movingPk;

        public RelationshipDecorationMover(Relationship r, boolean movePk) {
            this.r = r;
            this.movingPk = movePk;
            this.startingPk = new Point(r.createPkConnectionPoint().getX(), r.createPkConnectionPoint().getY());
            this.startingFk = new Point(r.createFkConnectionPoint().getX(), r.createFkConnectionPoint().getY());
            r.startedDragging();
            r.getPlayPen().addMouseMotionListener(this);
            r.getPlayPen().addMouseListener(this);
            r.getPlayPen().setCursor(Cursor.getPredefinedCursor(13));
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Point p = new Point(e.getPoint());
            this.r.getPlayPen().unzoomPoint(p);
            if (this.movingPk) {
                this.r.setPkConnectionPoint(this.translatePoint(p));
            } else {
                this.r.setFkConnectionPoint(this.translatePoint(p));
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.mouseMoved(e);
        }

        protected Point translatePoint(Point p) {
            if (this.movingPk) {
                p.x -= this.r.getPkTable().getX();
                p.y -= this.r.getPkTable().getY();
                p = ((RelationshipUI)this.r.getUI()).closestEdgePoint(this.movingPk, p);
            } else {
                p.x -= this.r.getFkTable().getX();
                p.y -= this.r.getFkTable().getY();
                p = ((RelationshipUI)this.r.getUI()).closestEdgePoint(this.movingPk, p);
            }
            return p;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.r.getPlayPen().removeMouseMotionListener(this);
            this.r.getPlayPen().removeMouseListener(this);
            this.r.getPlayPen().setCursor(null);
            this.r.doneDragging();
        }
    }

    private class TablePaneBehaviourListener
    extends AbstractSPListener {
        private TablePaneBehaviourListener() {
        }

        public void propertyChanged(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("topLeftCorner") || evt.getPropertyName().equals("lengths")) {
                Point newVal;
                Point oldVal;
                logger.debug((Object)("Component " + ((PlayPenComponent)evt.getSource()).getName() + " changed size"));
                if (evt.getPropertyName().equals("lengths")) {
                    Dimension oldDim = (Dimension)evt.getOldValue();
                    Dimension newDim = (Dimension)evt.getNewValue();
                    oldVal = new Point(oldDim.width, oldDim.height);
                    newVal = new Point(newDim.width, newDim.height);
                } else {
                    oldVal = (Point)evt.getOldValue();
                    newVal = (Point)evt.getNewValue();
                }
                if (oldVal.x != newVal.x || oldVal.y != newVal.y) {
                    logger.debug((Object)("Component " + ((PlayPenComponent)evt.getSource()).getName() + " changed"));
                    if ((PlayPenComponent)evt.getSource() == Relationship.this.pkTable || (PlayPenComponent)evt.getSource() == Relationship.this.fkTable) {
                        ((BasicRelationshipUI)Relationship.this.getUI()).revalidate();
                    }
                }
            }
        }
    }
}

