/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;

public class LazyExpression
extends UnaryExpression {
    public LazyExpression(Expression operand) {
        super(operand);
    }

    public static Expression makeLazyExpression(Expression operand) {
        if (operand instanceof LazyExpression || operand instanceof Literal) {
            return operand;
        }
        return new LazyExpression(operand);
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.operand = visitor.typeCheck(this.operand, contextItemType);
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.operand = visitor.optimize(this.operand, contextItemType);
        return this;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        return this.operand.evaluateItem(context);
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        return this.operand.iterate(context);
    }

    public void process(XPathContext context) throws XPathException {
        this.operand.process(context);
    }

    public Expression copy() {
        return new LazyExpression(this.getBaseExpression().copy());
    }

    protected String displayExpressionName() {
        return "lazy";
    }
}

