/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.i18n;

import de.escape.quincunx.i18n.I18n;
import de.escape.quincunx.i18n.Localizable;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Label;
import java.util.Locale;

public class RLabel
extends Label
implements Localizable {
    protected boolean localeUnknown = true;
    protected String textResource;
    protected String addText;

    public RLabel(String textRes) {
        this.setText(I18n.getString(textRes, this.getLocale()));
        this.textResource = textRes;
    }

    public RLabel(String textRes, int align) {
        super("", align);
        this.setText(I18n.getString(textRes, this.getLocale()));
        this.textResource = textRes;
    }

    public RLabel(String textRes, String add) {
        this.setText(String.valueOf(I18n.getString(textRes, this.getLocale())) + add);
        this.textResource = textRes;
        this.addText = add;
    }

    public RLabel(String textRes, String add, int align) {
        super("", align);
        this.setText(String.valueOf(I18n.getString(textRes, this.getLocale())) + add);
        this.textResource = textRes;
        this.addText = add;
    }

    public void setLocale(Locale l) {
        super.setLocale(l);
        if (this.addText == null) {
            this.setText(I18n.getString(this.textResource, l));
        } else {
            this.setText(String.valueOf(I18n.getString(this.textResource, l)) + this.addText);
        }
        this.invalidate();
    }

    public Locale getLocale() {
        try {
            this.localeUnknown = false;
            return super.getLocale();
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            this.localeUnknown = true;
            return null;
        }
    }

    public void update(Graphics g) {
        if (this.localeUnknown) {
            this.setLocale(this.getLocale());
        } else {
            super.update(g);
        }
    }
}

