/*
 * Decompiled with CFR 0.152.
 */
package liquibase.configuration;

import liquibase.configuration.AbstractConfigurationContainer;

public class GlobalConfiguration
extends AbstractConfigurationContainer {
    public static final String SHOULD_RUN = "shouldRun";
    public static final String DATABASECHANGELOG_TABLE_NAME = "databaseChangeLogTableName";
    public static final String DATABASECHANGELOGLOCK_TABLE_NAME = "databaseChangeLogLockTableName";
    public static final String LIQUIBASE_TABLESPACE_NAME = "tablespaceName";
    public static final String LIQUIBASE_CATALOG_NAME = "catalogName";
    public static final String LIQUIBASE_SCHEMA_NAME = "schemaName";
    public static final String OUTPUT_LINE_SEPARATOR = "outputLineSeparator";
    public static final String OUTPUT_ENCODING = "outputFileEncoding";
    public static final String CHANGELOGLOCK_WAIT_TIME = "changeLogLockWaitTimeInMinutes";
    public static final String CHANGELOGLOCK_POLL_RATE = "changeLogLockPollRate";
    public static final String CONVERT_DATA_TYPES = "convertDataTypes";
    public static final String GENERATE_CHANGESET_CREATED_VALUES = "generateChangeSetCreatedValues";
    public static final String AUTO_REORG = "autoReorg";

    public GlobalConfiguration() {
        super("liquibase");
        this.getContainer().addProperty(SHOULD_RUN, Boolean.class).setDescription("Should Liquibase commands execute").setDefaultValue(true).addAlias("should.run");
        this.getContainer().addProperty(DATABASECHANGELOG_TABLE_NAME, String.class).setDescription("Name of table to use for tracking change history").setDefaultValue("DATABASECHANGELOG");
        this.getContainer().addProperty(DATABASECHANGELOGLOCK_TABLE_NAME, String.class).setDescription("Name of table to use for tracking concurrent liquibase usage").setDefaultValue("DATABASECHANGELOGLOCK");
        this.getContainer().addProperty(CHANGELOGLOCK_WAIT_TIME, Long.class).setDescription("Number of minutes to wait for the changelog lock to be available before giving up").setDefaultValue(5);
        this.getContainer().addProperty(CHANGELOGLOCK_POLL_RATE, Long.class).setDescription("Number of seconds wait between checks to the changelog lock when it is locked").setDefaultValue(10);
        this.getContainer().addProperty(LIQUIBASE_TABLESPACE_NAME, String.class).setDescription("Tablespace to use for liquibase objects");
        this.getContainer().addProperty(LIQUIBASE_CATALOG_NAME, String.class).setDescription("Catalog to use for liquibase objects");
        this.getContainer().addProperty(LIQUIBASE_SCHEMA_NAME, String.class).setDescription("Schema to use for liquibase objects");
        this.getContainer().addProperty(OUTPUT_LINE_SEPARATOR, String.class).setDescription("Line separator for output. Defaults to OS default").setDefaultValue(System.getProperty("line.separator"));
        this.getContainer().addProperty(OUTPUT_ENCODING, String.class).setDescription("Encoding to output text in. Defaults to file.encoding system property or UTF-8").setDefaultValue("UTF-8").addAlias("file.encoding");
        this.getContainer().addProperty(CONVERT_DATA_TYPES, Boolean.class).setDescription("Should Liquibase convert to/from standard data types. Applies to both snapshot and update commands.").setDefaultValue(true);
        this.getContainer().addProperty(GENERATE_CHANGESET_CREATED_VALUES, Boolean.class).setDescription("Should Liquibase include a 'created' attribute in diff/generateChangeLog changeSets with the current datetime").setDefaultValue(false);
        this.getContainer().addProperty(AUTO_REORG, Boolean.class).setDescription("Should Liquibase automatically include REORG TABLE commands when needed?").setDefaultValue(true);
    }

    public boolean getShouldRun() {
        return this.getContainer().getValue(SHOULD_RUN, Boolean.class);
    }

    public GlobalConfiguration setShouldRun(boolean shouldRun) {
        this.getContainer().setValue(SHOULD_RUN, shouldRun);
        return this;
    }

    public String getDatabaseChangeLogTableName() {
        return this.getContainer().getValue(DATABASECHANGELOG_TABLE_NAME, String.class);
    }

    public GlobalConfiguration setDatabaseChangeLogTableName(String name) {
        this.getContainer().setValue(DATABASECHANGELOG_TABLE_NAME, name);
        return this;
    }

    public String getDatabaseChangeLogLockTableName() {
        return this.getContainer().getValue(DATABASECHANGELOGLOCK_TABLE_NAME, String.class);
    }

    public GlobalConfiguration setDatabaseChangeLogLockTableName(String name) {
        this.getContainer().setValue(DATABASECHANGELOGLOCK_TABLE_NAME, name);
        return this;
    }

    public Long getDatabaseChangeLogLockWaitTime() {
        return this.getContainer().getValue(CHANGELOGLOCK_WAIT_TIME, Long.class);
    }

    public GlobalConfiguration setDatabaseChangeLogLockWaitTime(Long minutes) {
        this.getContainer().setValue(CHANGELOGLOCK_WAIT_TIME, minutes);
        return this;
    }

    public Long getDatabaseChangeLogLockPollRate() {
        return this.getContainer().getValue(CHANGELOGLOCK_POLL_RATE, Long.class);
    }

    public GlobalConfiguration setDatabaseChangeLogLockPollRate(Long seconds) {
        this.getContainer().setValue(CHANGELOGLOCK_POLL_RATE, seconds);
        return this;
    }

    public String getLiquibaseTablespaceName() {
        return this.getContainer().getValue(LIQUIBASE_TABLESPACE_NAME, String.class);
    }

    public GlobalConfiguration setLiquibaseTablespaceName(String name) {
        this.getContainer().setValue(LIQUIBASE_TABLESPACE_NAME, name);
        return this;
    }

    public String getLiquibaseCatalogName() {
        return this.getContainer().getValue(LIQUIBASE_CATALOG_NAME, String.class);
    }

    public GlobalConfiguration setLiquibaseCatalogName(String name) {
        this.getContainer().setValue(LIQUIBASE_CATALOG_NAME, name);
        return this;
    }

    public String getLiquibaseSchemaName() {
        return this.getContainer().getValue(LIQUIBASE_SCHEMA_NAME, String.class);
    }

    public GlobalConfiguration setLiquibaseSchemaName(String name) {
        this.getContainer().setValue(LIQUIBASE_SCHEMA_NAME, name);
        return this;
    }

    public String getOutputLineSeparator() {
        return this.getContainer().getValue(OUTPUT_LINE_SEPARATOR, String.class);
    }

    public GlobalConfiguration setOutputLineSeparator(String name) {
        this.getContainer().setValue(OUTPUT_LINE_SEPARATOR, name);
        return this;
    }

    public String getOutputEncoding() {
        return this.getContainer().getValue(OUTPUT_ENCODING, String.class);
    }

    public GlobalConfiguration setOutputEncoding(String name) {
        this.getContainer().setValue(OUTPUT_ENCODING, name);
        return this;
    }
}

