// ----------------------------------------------------------------------------
//
//     ***     AUTO GENERATED CODE    ***    Type: MMv1     ***
//
// ----------------------------------------------------------------------------
//
//     This file is automatically generated by Magic Modules and manual
//     changes will be clobbered when the file is regenerated.
//
//     Please read more about how to change this file in
//     .github/CONTRIBUTING.md.
//
// ----------------------------------------------------------------------------

package google

import (
	"fmt"
	"log"
	"reflect"
	"strings"
	"time"

	"github.com/hashicorp/terraform-plugin-sdk/v2/helper/schema"
)

const notebooksRuntimeGoogleProvidedLabel = "goog-caip-managed-notebook"

func NotebooksRuntimeLabelDiffSuppress(k, old, new string, d *schema.ResourceData) bool {
	// Suppress diffs for the label provided by Google
	if strings.Contains(k, notebooksRuntimeGoogleProvidedLabel) && new == "" {
		return true
	}

	// Let diff be determined by labels (above)
	if strings.Contains(k, "labels.%") {
		return true
	}

	// For other keys, don't suppress diff.
	return false
}

// NotReturnedByAPIDiffSuppress
func NotReturnedByAPIDiffSuppress(k, old, new string, d *schema.ResourceData) bool {
	return true
}

func resourceNotebooksRuntime() *schema.Resource {
	return &schema.Resource{
		Create: resourceNotebooksRuntimeCreate,
		Read:   resourceNotebooksRuntimeRead,
		Update: resourceNotebooksRuntimeUpdate,
		Delete: resourceNotebooksRuntimeDelete,

		Importer: &schema.ResourceImporter{
			State: resourceNotebooksRuntimeImport,
		},

		Timeouts: &schema.ResourceTimeout{
			Create: schema.DefaultTimeout(20 * time.Minute),
			Update: schema.DefaultTimeout(20 * time.Minute),
			Delete: schema.DefaultTimeout(20 * time.Minute),
		},

		Schema: map[string]*schema.Schema{
			"location": {
				Type:             schema.TypeString,
				Required:         true,
				ForceNew:         true,
				DiffSuppressFunc: compareSelfLinkOrResourceName,
				Description:      `A reference to the zone where the machine resides.`,
			},
			"name": {
				Type:        schema.TypeString,
				Required:    true,
				ForceNew:    true,
				Description: `The name specified for the Notebook runtime.`,
			},
			"access_config": {
				Type:        schema.TypeList,
				Optional:    true,
				Description: `The config settings for accessing runtime.`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"access_type": {
							Type:     schema.TypeString,
							Optional: true,
							Description: `The type of access mode this instance. For valid values, see
'https://cloud.google.com/vertex-ai/docs/workbench/reference/
rest/v1/projects.locations.runtimes#RuntimeAccessType'.`,
						},
						"runtime_owner": {
							Type:     schema.TypeString,
							Optional: true,
							Description: `The owner of this runtime after creation. Format: 'alias@example.com'.
Currently supports one owner only.`,
						},
						"proxy_uri": {
							Type:        schema.TypeString,
							Computed:    true,
							Description: `The proxy endpoint that is used to access the runtime.`,
						},
					},
				},
			},
			"software_config": {
				Type:        schema.TypeList,
				Computed:    true,
				Optional:    true,
				Description: `The config settings for software inside the runtime.`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"custom_gpu_driver_path": {
							Type:     schema.TypeString,
							Optional: true,
							Description: `Specify a custom Cloud Storage path where the GPU driver is stored.
If not specified, we'll automatically choose from official GPU drivers.`,
						},
						"enable_health_monitoring": {
							Type:        schema.TypeBool,
							Optional:    true,
							Description: `Verifies core internal services are running. Default: True.`,
							Default:     true,
						},
						"idle_shutdown": {
							Type:     schema.TypeBool,
							Optional: true,
							Description: `Runtime will automatically shutdown after idle_shutdown_time.
Default: True`,
							Default: true,
						},
						"idle_shutdown_timeout": {
							Type:     schema.TypeInt,
							Optional: true,
							Description: `Time in minutes to wait before shuting down runtime.
Default: 180 minutes`,
						},
						"install_gpu_driver": {
							Type:        schema.TypeBool,
							Optional:    true,
							Description: `Install Nvidia Driver automatically.`,
						},
						"kernels": {
							Type:        schema.TypeList,
							Optional:    true,
							Description: `Use a list of container images to use as Kernels in the notebook instance.`,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"repository": {
										Type:     schema.TypeString,
										Required: true,
										Description: `The path to the container image repository.
For example: gcr.io/{project_id}/{imageName}`,
									},
									"tag": {
										Type:        schema.TypeString,
										Optional:    true,
										Description: `The tag of the container image. If not specified, this defaults to the latest tag.`,
									},
								},
							},
						},
						"notebook_upgrade_schedule": {
							Type:     schema.TypeString,
							Optional: true,
							Description: `Cron expression in UTC timezone for schedule instance auto upgrade.
Please follow the [cron format](https://en.wikipedia.org/wiki/Cron).`,
						},
						"post_startup_script": {
							Type:     schema.TypeString,
							Optional: true,
							Description: `Path to a Bash script that automatically runs after a notebook instance
fully boots up. The path must be a URL or
Cloud Storage path (gs://path-to-file/file-name).`,
						},
						"post_startup_script_behavior": {
							Type:         schema.TypeString,
							Optional:     true,
							ValidateFunc: validateEnum([]string{"POST_STARTUP_SCRIPT_BEHAVIOR_UNSPECIFIED", "RUN_EVERY_START", "DOWNLOAD_AND_RUN_EVERY_START", ""}),
							Description:  `Behavior for the post startup script. Possible values: ["POST_STARTUP_SCRIPT_BEHAVIOR_UNSPECIFIED", "RUN_EVERY_START", "DOWNLOAD_AND_RUN_EVERY_START"]`,
						},
						"upgradeable": {
							Type:        schema.TypeBool,
							Computed:    true,
							Description: `Bool indicating whether an newer image is available in an image family.`,
						},
					},
				},
			},
			"virtual_machine": {
				Type:        schema.TypeList,
				Optional:    true,
				Description: `Use a Compute Engine VM image to start the managed notebook instance.`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"virtual_machine_config": {
							Type:        schema.TypeList,
							Optional:    true,
							Description: `Virtual Machine configuration settings.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"data_disk": {
										Type:        schema.TypeList,
										Required:    true,
										Description: `Data disk option configuration settings.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"initialize_params": {
													Type:     schema.TypeList,
													Optional: true,
													ForceNew: true,
													Description: `Input only. Specifies the parameters for a new disk that will
be created alongside the new instance. Use initialization
parameters to create boot disks or local SSDs attached to the
new instance. This property is mutually exclusive with the
source property; you can only define one or the other, but not
both.`,
													MaxItems: 1,
													Elem: &schema.Resource{
														Schema: map[string]*schema.Schema{
															"description": {
																Type:        schema.TypeString,
																Optional:    true,
																Description: `Provide this property when creating the disk.`,
															},
															"disk_name": {
																Type:     schema.TypeString,
																Optional: true,
																Description: `Specifies the disk name. If not specified, the default is
to use the name of the instance. If the disk with the
instance name exists already in the given zone/region, a
new name will be automatically generated.`,
															},
															"disk_size_gb": {
																Type:     schema.TypeInt,
																Optional: true,
																Description: `Specifies the size of the disk in base-2 GB. If not
specified, the disk will be the same size as the image
(usually 10GB). If specified, the size must be equal to
or larger than 10GB. Default 100 GB.`,
															},
															"disk_type": {
																Type:     schema.TypeString,
																Optional: true,
																Description: `The type of the boot disk attached to this runtime,
defaults to standard persistent disk. For valid values,
see 'https://cloud.google.com/vertex-ai/docs/workbench/
reference/rest/v1/projects.locations.runtimes#disktype'`,
															},
															"labels": {
																Type:     schema.TypeMap,
																Computed: true,
																Optional: true,
																Description: `Labels to apply to this disk. These can be later modified
by the disks.setLabels method. This field is only
applicable for persistent disks.`,
																Elem: &schema.Schema{Type: schema.TypeString},
															},
														},
													},
												},
												"interface": {
													Type:     schema.TypeString,
													Optional: true,
													Description: `"Specifies the disk interface to use for attaching this disk,
which is either SCSI or NVME. The default is SCSI. Persistent
disks must always use SCSI and the request will fail if you attempt
to attach a persistent disk in any other format than SCSI. Local SSDs
can use either NVME or SCSI. For performance characteristics of SCSI
over NVMe, see Local SSD performance. Valid values: * NVME * SCSI".`,
												},
												"mode": {
													Type:     schema.TypeString,
													Optional: true,
													Description: `The mode in which to attach this disk, either READ_WRITE
or READ_ONLY. If not specified, the default is to attach
the disk in READ_WRITE mode.`,
												},
												"source": {
													Type:     schema.TypeString,
													Optional: true,
													Description: `Specifies a valid partial or full URL to an existing
Persistent Disk resource.`,
												},
												"type": {
													Type:     schema.TypeString,
													Optional: true,
													Description: `Specifies the type of the disk, either SCRATCH or PERSISTENT.
If not specified, the default is PERSISTENT.`,
												},
												"auto_delete": {
													Type:     schema.TypeBool,
													Computed: true,
													Description: `Optional. Specifies whether the disk will be auto-deleted
when the instance is deleted (but not when the disk is
detached from the instance).`,
												},
												"boot": {
													Type:     schema.TypeBool,
													Computed: true,
													Description: `Optional. Indicates that this is a boot disk. The virtual
machine will use the first partition of the disk for its
root filesystem.`,
												},
												"device_name": {
													Type:     schema.TypeString,
													Computed: true,
													Description: `Optional. Specifies a unique device name of your choice
that is reflected into the /dev/disk/by-id/google-* tree
of a Linux operating system running within the instance.
This name can be used to reference the device for mounting,
resizing, and so on, from within the instance.
If not specified, the server chooses a default device name
to apply to this disk, in the form persistent-disk-x, where
x is a number assigned by Google Compute Engine. This field
is only applicable for persistent disks.`,
												},
												"guest_os_features": {
													Type:     schema.TypeList,
													Computed: true,
													Description: `Indicates a list of features to enable on the guest operating
system. Applicable only for bootable images. To see a list of
available features, read 'https://cloud.google.com/compute/docs/
images/create-delete-deprecate-private-images#guest-os-features'
options. ''`,
													Elem: &schema.Schema{
														Type: schema.TypeString,
													},
												},
												"index": {
													Type:     schema.TypeInt,
													Computed: true,
													Description: `Output only. A zero-based index to this disk, where 0 is
reserved for the boot disk. If you have many disks attached
to an instance, each disk would have a unique index number.`,
												},
												"kind": {
													Type:     schema.TypeString,
													Computed: true,
													Description: `Type of the resource. Always compute#attachedDisk for attached
disks.`,
												},
												"licenses": {
													Type:        schema.TypeList,
													Computed:    true,
													Description: `Output only. Any valid publicly visible licenses.`,
													Elem: &schema.Schema{
														Type: schema.TypeString,
													},
												},
											},
										},
									},
									"machine_type": {
										Type:        schema.TypeString,
										Required:    true,
										Description: `The Compute Engine machine type used for runtimes.`,
									},
									"accelerator_config": {
										Type:        schema.TypeList,
										Optional:    true,
										Description: `The Compute Engine accelerator configuration for this runtime.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"core_count": {
													Type:        schema.TypeInt,
													Optional:    true,
													Description: `Count of cores of this accelerator.`,
												},
												"type": {
													Type:     schema.TypeString,
													Optional: true,
													Description: `Accelerator model. For valid values, see
'https://cloud.google.com/vertex-ai/docs/workbench/reference/
rest/v1/projects.locations.runtimes#AcceleratorType'`,
												},
											},
										},
									},
									"container_images": {
										Type:        schema.TypeList,
										Computed:    true,
										Optional:    true,
										ForceNew:    true,
										Description: `Use a list of container images to start the notebook instance.`,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"repository": {
													Type:     schema.TypeString,
													Required: true,
													Description: `The path to the container image repository.
For example: gcr.io/{project_id}/{imageName}`,
												},
												"tag": {
													Type:        schema.TypeString,
													Optional:    true,
													Description: `The tag of the container image. If not specified, this defaults to the latest tag.`,
												},
											},
										},
									},
									"encryption_config": {
										Type:        schema.TypeList,
										Optional:    true,
										ForceNew:    true,
										Description: `Encryption settings for virtual machine data disk.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"kms_key": {
													Type:     schema.TypeString,
													Optional: true,
													Description: `The Cloud KMS resource identifier of the customer-managed
encryption key used to protect a resource, such as a disks.
It has the following format:
'projects/{PROJECT_ID}/locations/{REGION}/keyRings/
{KEY_RING_NAME}/cryptoKeys/{KEY_NAME}'`,
												},
											},
										},
									},
									"internal_ip_only": {
										Type:     schema.TypeBool,
										Optional: true,
										ForceNew: true,
										Description: `If true, runtime will only have internal IP addresses. By default,
runtimes are not restricted to internal IP addresses, and will
have ephemeral external IP addresses assigned to each vm. This
'internal_ip_only' restriction can only be enabled for subnetwork
enabled networks, and all dependencies must be configured to be
accessible without external IP addresses.`,
									},
									"labels": {
										Type:             schema.TypeMap,
										Computed:         true,
										Optional:         true,
										DiffSuppressFunc: NotebooksRuntimeLabelDiffSuppress,
										Description: `The labels to associate with this runtime. Label **keys** must
contain 1 to 63 characters, and must conform to [RFC 1035]
(https://www.ietf.org/rfc/rfc1035.txt). Label **values** may be
empty, but, if present, must contain 1 to 63 characters, and must
conform to [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt). No
more than 32 labels can be associated with a cluster.`,
										Elem: &schema.Schema{Type: schema.TypeString},
									},
									"metadata": {
										Type:     schema.TypeMap,
										Computed: true,
										Optional: true,
										Description: `The Compute Engine metadata entries to add to virtual machine.
(see [Project and instance metadata](https://cloud.google.com
/compute/docs/storing-retrieving-metadata#project_and_instance
_metadata)).`,
										Elem: &schema.Schema{Type: schema.TypeString},
									},
									"network": {
										Type:     schema.TypeString,
										Optional: true,
										ForceNew: true,
										Description: `The Compute Engine network to be used for machine communications.
Cannot be specified with subnetwork. If neither 'network' nor
'subnet' is specified, the "default" network of the project is
used, if it exists. A full URL or partial URI. Examples:
  * 'https://www.googleapis.com/compute/v1/projects/[project_id]/
  regions/global/default'
  * 'projects/[project_id]/regions/global/default'
Runtimes are managed resources inside Google Infrastructure.
Runtimes support the following network configurations:
  * Google Managed Network (Network & subnet are empty)
  * Consumer Project VPC (network & subnet are required). Requires
  configuring Private Service Access.
  * Shared VPC (network & subnet are required). Requires
  configuring Private Service Access.`,
									},
									"nic_type": {
										Type:         schema.TypeString,
										Optional:     true,
										ForceNew:     true,
										ValidateFunc: validateEnum([]string{"UNSPECIFIED_NIC_TYPE", "VIRTIO_NET", "GVNIC", ""}),
										Description: `The type of vNIC to be used on this interface. This may be gVNIC
or VirtioNet. Possible values: ["UNSPECIFIED_NIC_TYPE", "VIRTIO_NET", "GVNIC"]`,
									},
									"reserved_ip_range": {
										Type:     schema.TypeString,
										Optional: true,
										ForceNew: true,
										Description: `Reserved IP Range name is used for VPC Peering. The
subnetwork allocation will use the range *name* if it's assigned.`,
									},
									"shielded_instance_config": {
										Type:        schema.TypeList,
										Optional:    true,
										ForceNew:    true,
										Description: `Shielded VM Instance configuration settings.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"enable_integrity_monitoring": {
													Type:     schema.TypeBool,
													Optional: true,
													Description: `Defines whether the instance has integrity monitoring enabled.
Enables monitoring and attestation of the boot integrity of
the instance. The attestation is performed against the
integrity policy baseline. This baseline is initially derived
from the implicitly trusted boot image when the instance is
created. Enabled by default.`,
												},
												"enable_secure_boot": {
													Type:     schema.TypeBool,
													Optional: true,
													Description: `Defines whether the instance has Secure Boot enabled.Secure
Boot helps ensure that the system only runs authentic software
by verifying the digital signature of all boot components, and
halting the boot process if signature verification fails.
Disabled by default.`,
												},
												"enable_vtpm": {
													Type:     schema.TypeBool,
													Optional: true,
													Description: `Defines whether the instance has the vTPM enabled. Enabled by
default.`,
												},
											},
										},
									},
									"subnet": {
										Type:     schema.TypeString,
										Optional: true,
										ForceNew: true,
										Description: `The Compute Engine subnetwork to be used for machine
communications. Cannot be specified with network. A full URL or
partial URI are valid. Examples:
  * 'https://www.googleapis.com/compute/v1/projects/[project_id]/
  regions/us-east1/subnetworks/sub0'
  * 'projects/[project_id]/regions/us-east1/subnetworks/sub0'`,
									},
									"tags": {
										Type:     schema.TypeList,
										Computed: true,
										Optional: true,
										Description: `The Compute Engine tags to add to runtime (see [Tagging instances]
(https://cloud.google.com/compute/docs/
label-or-tag-resources#tags)).`,
										Elem: &schema.Schema{
											Type: schema.TypeString,
										},
									},
									"guest_attributes": {
										Type:     schema.TypeMap,
										Computed: true,
										Description: `The Compute Engine guest attributes. (see [Project and instance
guest attributes](https://cloud.google.com/compute/docs/
storing-retrieving-metadata#guest_attributes)).`,
										Elem: &schema.Schema{Type: schema.TypeString},
									},
									"zone": {
										Type:        schema.TypeString,
										Computed:    true,
										Description: `The zone where the virtual machine is located.`,
									},
								},
							},
						},
						"instance_id": {
							Type:        schema.TypeString,
							Computed:    true,
							Description: `The unique identifier of the Managed Compute Engine instance.`,
						},
						"instance_name": {
							Type:        schema.TypeString,
							Computed:    true,
							Description: `The user-friendly name of the Managed Compute Engine instance.`,
						},
					},
				},
				ExactlyOneOf: []string{"virtual_machine"},
			},
			"health_state": {
				Type:     schema.TypeString,
				Computed: true,
				Description: `The health state of this runtime. For a list of possible output
values, see 'https://cloud.google.com/vertex-ai/docs/workbench/
reference/rest/v1/projects.locations.runtimes#healthstate'.`,
			},
			"metrics": {
				Type:     schema.TypeList,
				Computed: true,
				Description: `Contains Runtime daemon metrics such as Service status and JupyterLab
status`,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"system_metrics": {
							Type:     schema.TypeMap,
							Computed: true,
							Description: `Contains runtime daemon metrics, such as OS and kernels and
sessions stats.`,
							Elem: &schema.Schema{Type: schema.TypeString},
						},
					},
				},
			},
			"state": {
				Type:        schema.TypeString,
				Computed:    true,
				Description: `The state of this runtime.`,
			},
			"project": {
				Type:     schema.TypeString,
				Optional: true,
				Computed: true,
				ForceNew: true,
			},
		},
		UseJSONNumber: true,
	}
}

func resourceNotebooksRuntimeCreate(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	obj := make(map[string]interface{})
	virtualMachineProp, err := expandNotebooksRuntimeVirtualMachine(d.Get("virtual_machine"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("virtual_machine"); !isEmptyValue(reflect.ValueOf(virtualMachineProp)) && (ok || !reflect.DeepEqual(v, virtualMachineProp)) {
		obj["virtualMachine"] = virtualMachineProp
	}
	accessConfigProp, err := expandNotebooksRuntimeAccessConfig(d.Get("access_config"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("access_config"); !isEmptyValue(reflect.ValueOf(accessConfigProp)) && (ok || !reflect.DeepEqual(v, accessConfigProp)) {
		obj["accessConfig"] = accessConfigProp
	}
	softwareConfigProp, err := expandNotebooksRuntimeSoftwareConfig(d.Get("software_config"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("software_config"); !isEmptyValue(reflect.ValueOf(softwareConfigProp)) && (ok || !reflect.DeepEqual(v, softwareConfigProp)) {
		obj["softwareConfig"] = softwareConfigProp
	}

	url, err := replaceVars(d, config, "{{NotebooksBasePath}}projects/{{project}}/locations/{{location}}/runtimes?runtimeId={{name}}")
	if err != nil {
		return err
	}

	log.Printf("[DEBUG] Creating new Runtime: %#v", obj)
	billingProject := ""

	project, err := getProject(d, config)
	if err != nil {
		return fmt.Errorf("Error fetching project for Runtime: %s", err)
	}
	billingProject = project

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequestWithTimeout(config, "POST", billingProject, url, userAgent, obj, d.Timeout(schema.TimeoutCreate))
	if err != nil {
		return fmt.Errorf("Error creating Runtime: %s", err)
	}

	// Store the ID now
	id, err := replaceVars(d, config, "projects/{{project}}/locations/{{location}}/runtimes/{{name}}")
	if err != nil {
		return fmt.Errorf("Error constructing id: %s", err)
	}
	d.SetId(id)

	// Use the resource in the operation response to populate
	// identity fields and d.Id() before read
	var opRes map[string]interface{}
	err = notebooksOperationWaitTimeWithResponse(
		config, res, &opRes, project, "Creating Runtime", userAgent,
		d.Timeout(schema.TimeoutCreate))
	if err != nil {
		// The resource didn't actually create
		d.SetId("")
		return fmt.Errorf("Error waiting to create Runtime: %s", err)
	}

	// This may have caused the ID to update - update it if so.
	id, err = replaceVars(d, config, "projects/{{project}}/locations/{{location}}/runtimes/{{name}}")
	if err != nil {
		return fmt.Errorf("Error constructing id: %s", err)
	}
	d.SetId(id)

	log.Printf("[DEBUG] Finished creating Runtime %q: %#v", d.Id(), res)

	return resourceNotebooksRuntimeRead(d, meta)
}

func resourceNotebooksRuntimeRead(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	url, err := replaceVars(d, config, "{{NotebooksBasePath}}projects/{{project}}/locations/{{location}}/runtimes/{{name}}")
	if err != nil {
		return err
	}

	billingProject := ""

	project, err := getProject(d, config)
	if err != nil {
		return fmt.Errorf("Error fetching project for Runtime: %s", err)
	}
	billingProject = project

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequest(config, "GET", billingProject, url, userAgent, nil)
	if err != nil {
		return handleNotFoundError(err, d, fmt.Sprintf("NotebooksRuntime %q", d.Id()))
	}

	if err := d.Set("project", project); err != nil {
		return fmt.Errorf("Error reading Runtime: %s", err)
	}

	if err := d.Set("virtual_machine", flattenNotebooksRuntimeVirtualMachine(res["virtualMachine"], d, config)); err != nil {
		return fmt.Errorf("Error reading Runtime: %s", err)
	}
	if err := d.Set("state", flattenNotebooksRuntimeState(res["state"], d, config)); err != nil {
		return fmt.Errorf("Error reading Runtime: %s", err)
	}
	if err := d.Set("health_state", flattenNotebooksRuntimeHealthState(res["healthState"], d, config)); err != nil {
		return fmt.Errorf("Error reading Runtime: %s", err)
	}
	if err := d.Set("access_config", flattenNotebooksRuntimeAccessConfig(res["accessConfig"], d, config)); err != nil {
		return fmt.Errorf("Error reading Runtime: %s", err)
	}
	if err := d.Set("software_config", flattenNotebooksRuntimeSoftwareConfig(res["softwareConfig"], d, config)); err != nil {
		return fmt.Errorf("Error reading Runtime: %s", err)
	}
	if err := d.Set("metrics", flattenNotebooksRuntimeMetrics(res["metrics"], d, config)); err != nil {
		return fmt.Errorf("Error reading Runtime: %s", err)
	}

	return nil
}

func resourceNotebooksRuntimeUpdate(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	billingProject := ""

	project, err := getProject(d, config)
	if err != nil {
		return fmt.Errorf("Error fetching project for Runtime: %s", err)
	}
	billingProject = project

	obj := make(map[string]interface{})
	virtualMachineProp, err := expandNotebooksRuntimeVirtualMachine(d.Get("virtual_machine"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("virtual_machine"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, virtualMachineProp)) {
		obj["virtualMachine"] = virtualMachineProp
	}
	accessConfigProp, err := expandNotebooksRuntimeAccessConfig(d.Get("access_config"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("access_config"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, accessConfigProp)) {
		obj["accessConfig"] = accessConfigProp
	}
	softwareConfigProp, err := expandNotebooksRuntimeSoftwareConfig(d.Get("software_config"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("software_config"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, softwareConfigProp)) {
		obj["softwareConfig"] = softwareConfigProp
	}

	url, err := replaceVars(d, config, "{{NotebooksBasePath}}projects/{{project}}/locations/{{location}}/runtimes/{{name}}")
	if err != nil {
		return err
	}

	log.Printf("[DEBUG] Updating Runtime %q: %#v", d.Id(), obj)
	updateMask := []string{}

	if d.HasChange("virtual_machine") {
		updateMask = append(updateMask, "virtualMachine")
	}

	if d.HasChange("access_config") {
		updateMask = append(updateMask, "accessConfig")
	}

	if d.HasChange("software_config") {
		updateMask = append(updateMask, "softwareConfig.idleShutdown",
			"softwareConfig.idleShutdownTimeout",
			"softwareConfig.customGpuDriverPath",
			"softwareConfig.postStartupScript")
	}
	// updateMask is a URL parameter but not present in the schema, so replaceVars
	// won't set it
	url, err = addQueryParams(url, map[string]string{"updateMask": strings.Join(updateMask, ",")})
	if err != nil {
		return err
	}

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequestWithTimeout(config, "PATCH", billingProject, url, userAgent, obj, d.Timeout(schema.TimeoutUpdate))

	if err != nil {
		return fmt.Errorf("Error updating Runtime %q: %s", d.Id(), err)
	} else {
		log.Printf("[DEBUG] Finished updating Runtime %q: %#v", d.Id(), res)
	}

	err = notebooksOperationWaitTime(
		config, res, project, "Updating Runtime", userAgent,
		d.Timeout(schema.TimeoutUpdate))

	if err != nil {
		return err
	}

	return resourceNotebooksRuntimeRead(d, meta)
}

func resourceNotebooksRuntimeDelete(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	billingProject := ""

	project, err := getProject(d, config)
	if err != nil {
		return fmt.Errorf("Error fetching project for Runtime: %s", err)
	}
	billingProject = project

	url, err := replaceVars(d, config, "{{NotebooksBasePath}}projects/{{project}}/locations/{{location}}/runtimes/{{name}}")
	if err != nil {
		return err
	}

	var obj map[string]interface{}
	log.Printf("[DEBUG] Deleting Runtime %q", d.Id())

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequestWithTimeout(config, "DELETE", billingProject, url, userAgent, obj, d.Timeout(schema.TimeoutDelete))
	if err != nil {
		return handleNotFoundError(err, d, "Runtime")
	}

	err = notebooksOperationWaitTime(
		config, res, project, "Deleting Runtime", userAgent,
		d.Timeout(schema.TimeoutDelete))

	if err != nil {
		return err
	}

	log.Printf("[DEBUG] Finished deleting Runtime %q: %#v", d.Id(), res)
	return nil
}

func resourceNotebooksRuntimeImport(d *schema.ResourceData, meta interface{}) ([]*schema.ResourceData, error) {
	config := meta.(*Config)
	if err := parseImportId([]string{
		"projects/(?P<project>[^/]+)/locations/(?P<location>[^/]+)/runtimes/(?P<name>[^/]+)",
		"(?P<project>[^/]+)/(?P<location>[^/]+)/(?P<name>[^/]+)",
		"(?P<location>[^/]+)/(?P<name>[^/]+)",
	}, d, config); err != nil {
		return nil, err
	}

	// Replace import id for the resource id
	id, err := replaceVars(d, config, "projects/{{project}}/locations/{{location}}/runtimes/{{name}}")
	if err != nil {
		return nil, fmt.Errorf("Error constructing id: %s", err)
	}
	d.SetId(id)

	return []*schema.ResourceData{d}, nil
}

func flattenNotebooksRuntimeVirtualMachine(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["instance_name"] =
		flattenNotebooksRuntimeVirtualMachineInstanceName(original["instanceName"], d, config)
	transformed["instance_id"] =
		flattenNotebooksRuntimeVirtualMachineInstanceId(original["instanceId"], d, config)
	transformed["virtual_machine_config"] =
		flattenNotebooksRuntimeVirtualMachineVirtualMachineConfig(original["virtualMachineConfig"], d, config)
	return []interface{}{transformed}
}
func flattenNotebooksRuntimeVirtualMachineInstanceName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeVirtualMachineInstanceId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeVirtualMachineVirtualMachineConfig(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["zone"] =
		flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigZone(original["zone"], d, config)
	transformed["machine_type"] =
		flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigMachineType(original["machineType"], d, config)
	transformed["data_disk"] =
		flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDisk(original["dataDisk"], d, config)
	transformed["container_images"] =
		flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigContainerImages(original["containerImages"], d, config)
	transformed["encryption_config"] =
		flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigEncryptionConfig(original["encryptionConfig"], d, config)
	transformed["shielded_instance_config"] =
		flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfig(original["shieldedInstanceConfig"], d, config)
	transformed["accelerator_config"] =
		flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigAcceleratorConfig(original["acceleratorConfig"], d, config)
	transformed["network"] =
		flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigNetwork(original["network"], d, config)
	transformed["subnet"] =
		flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigSubnet(original["subnet"], d, config)
	transformed["internal_ip_only"] =
		flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigInternalIpOnly(original["internalIpOnly"], d, config)
	transformed["tags"] =
		flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigTags(original["tags"], d, config)
	transformed["guest_attributes"] =
		flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigGuestAttributes(original["guestAttributes"], d, config)
	transformed["metadata"] =
		flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigMetadata(original["metadata"], d, config)
	transformed["labels"] =
		flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigLabels(original["labels"], d, config)
	transformed["nic_type"] =
		flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigNicType(original["nicType"], d, config)
	transformed["reserved_ip_range"] =
		flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigReservedIpRange(original["reservedIpRange"], d, config)
	return []interface{}{transformed}
}
func flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigZone(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigMachineType(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDisk(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["auto_delete"] =
		flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskAutoDelete(original["autoDelete"], d, config)
	transformed["boot"] =
		flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskBoot(original["boot"], d, config)
	transformed["device_name"] =
		flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskDeviceName(original["deviceName"], d, config)
	transformed["guest_os_features"] =
		flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskGuestOsFeatures(original["guestOsFeatures"], d, config)
	transformed["index"] =
		flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskIndex(original["index"], d, config)
	transformed["initialize_params"] =
		flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParams(original["initializeParams"], d, config)
	transformed["interface"] =
		flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInterface(original["interface"], d, config)
	transformed["kind"] =
		flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskKind(original["kind"], d, config)
	transformed["licenses"] =
		flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskLicenses(original["licenses"], d, config)
	transformed["mode"] =
		flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskMode(original["mode"], d, config)
	transformed["source"] =
		flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskSource(original["source"], d, config)
	transformed["type"] =
		flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskType(original["type"], d, config)
	return []interface{}{transformed}
}
func flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskAutoDelete(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskBoot(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskDeviceName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskGuestOsFeatures(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskIndex(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := stringToFixed64(strVal); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParams(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["description"] =
		flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParamsDescription(original["description"], d, config)
	transformed["disk_name"] =
		flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParamsDiskName(original["diskName"], d, config)
	transformed["disk_size_gb"] =
		flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParamsDiskSizeGb(original["diskSizeGb"], d, config)
	transformed["disk_type"] =
		flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParamsDiskType(original["diskType"], d, config)
	transformed["labels"] =
		flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParamsLabels(original["labels"], d, config)
	return []interface{}{transformed}
}
func flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParamsDescription(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParamsDiskName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParamsDiskSizeGb(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := stringToFixed64(strVal); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParamsDiskType(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParamsLabels(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInterface(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskKind(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskLicenses(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskMode(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskSource(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskType(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigContainerImages(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	l := v.([]interface{})
	transformed := make([]interface{}, 0, len(l))
	for _, raw := range l {
		original := raw.(map[string]interface{})
		if len(original) < 1 {
			// Do not include empty json objects coming back from the api
			continue
		}
		transformed = append(transformed, map[string]interface{}{
			"repository": flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigContainerImagesRepository(original["repository"], d, config),
			"tag":        flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigContainerImagesTag(original["tag"], d, config),
		})
	}
	return transformed
}
func flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigContainerImagesRepository(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigContainerImagesTag(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigEncryptionConfig(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["kms_key"] =
		flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigEncryptionConfigKmsKey(original["kmsKey"], d, config)
	return []interface{}{transformed}
}
func flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigEncryptionConfigKmsKey(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfig(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["enable_secure_boot"] =
		flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfigEnableSecureBoot(original["enableSecureBoot"], d, config)
	transformed["enable_vtpm"] =
		flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfigEnableVtpm(original["enableVtpm"], d, config)
	transformed["enable_integrity_monitoring"] =
		flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfigEnableIntegrityMonitoring(original["enableIntegrityMonitoring"], d, config)
	return []interface{}{transformed}
}
func flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfigEnableSecureBoot(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfigEnableVtpm(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfigEnableIntegrityMonitoring(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigAcceleratorConfig(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["type"] =
		flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigAcceleratorConfigType(original["type"], d, config)
	transformed["core_count"] =
		flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigAcceleratorConfigCoreCount(original["coreCount"], d, config)
	return []interface{}{transformed}
}
func flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigAcceleratorConfigType(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigAcceleratorConfigCoreCount(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := stringToFixed64(strVal); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigNetwork(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigSubnet(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigInternalIpOnly(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigTags(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigGuestAttributes(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigMetadata(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigLabels(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigNicType(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeVirtualMachineVirtualMachineConfigReservedIpRange(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeState(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeHealthState(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeAccessConfig(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["access_type"] =
		flattenNotebooksRuntimeAccessConfigAccessType(original["accessType"], d, config)
	transformed["runtime_owner"] =
		flattenNotebooksRuntimeAccessConfigRuntimeOwner(original["runtimeOwner"], d, config)
	transformed["proxy_uri"] =
		flattenNotebooksRuntimeAccessConfigProxyUri(original["proxyUri"], d, config)
	return []interface{}{transformed}
}
func flattenNotebooksRuntimeAccessConfigAccessType(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeAccessConfigRuntimeOwner(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeAccessConfigProxyUri(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeSoftwareConfig(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["notebook_upgrade_schedule"] =
		flattenNotebooksRuntimeSoftwareConfigNotebookUpgradeSchedule(original["notebookUpgradeSchedule"], d, config)
	transformed["enable_health_monitoring"] =
		flattenNotebooksRuntimeSoftwareConfigEnableHealthMonitoring(original["enableHealthMonitoring"], d, config)
	transformed["idle_shutdown"] =
		flattenNotebooksRuntimeSoftwareConfigIdleShutdown(original["idleShutdown"], d, config)
	transformed["idle_shutdown_timeout"] =
		flattenNotebooksRuntimeSoftwareConfigIdleShutdownTimeout(original["idleShutdownTimeout"], d, config)
	transformed["install_gpu_driver"] =
		flattenNotebooksRuntimeSoftwareConfigInstallGpuDriver(original["installGpuDriver"], d, config)
	transformed["upgradeable"] =
		flattenNotebooksRuntimeSoftwareConfigUpgradeable(original["upgradeable"], d, config)
	transformed["custom_gpu_driver_path"] =
		flattenNotebooksRuntimeSoftwareConfigCustomGpuDriverPath(original["customGpuDriverPath"], d, config)
	transformed["post_startup_script"] =
		flattenNotebooksRuntimeSoftwareConfigPostStartupScript(original["postStartupScript"], d, config)
	transformed["post_startup_script_behavior"] =
		flattenNotebooksRuntimeSoftwareConfigPostStartupScriptBehavior(original["postStartupScriptBehavior"], d, config)
	transformed["kernels"] =
		flattenNotebooksRuntimeSoftwareConfigKernels(original["kernels"], d, config)
	return []interface{}{transformed}
}
func flattenNotebooksRuntimeSoftwareConfigNotebookUpgradeSchedule(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeSoftwareConfigEnableHealthMonitoring(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeSoftwareConfigIdleShutdown(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeSoftwareConfigIdleShutdownTimeout(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := stringToFixed64(strVal); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func flattenNotebooksRuntimeSoftwareConfigInstallGpuDriver(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeSoftwareConfigUpgradeable(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeSoftwareConfigCustomGpuDriverPath(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeSoftwareConfigPostStartupScript(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeSoftwareConfigPostStartupScriptBehavior(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeSoftwareConfigKernels(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	l := v.([]interface{})
	transformed := make([]interface{}, 0, len(l))
	for _, raw := range l {
		original := raw.(map[string]interface{})
		if len(original) < 1 {
			// Do not include empty json objects coming back from the api
			continue
		}
		transformed = append(transformed, map[string]interface{}{
			"repository": flattenNotebooksRuntimeSoftwareConfigKernelsRepository(original["repository"], d, config),
			"tag":        flattenNotebooksRuntimeSoftwareConfigKernelsTag(original["tag"], d, config),
		})
	}
	return transformed
}
func flattenNotebooksRuntimeSoftwareConfigKernelsRepository(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeSoftwareConfigKernelsTag(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNotebooksRuntimeMetrics(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["system_metrics"] =
		flattenNotebooksRuntimeMetricsSystemMetrics(original["systemMetrics"], d, config)
	return []interface{}{transformed}
}
func flattenNotebooksRuntimeMetricsSystemMetrics(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func expandNotebooksRuntimeVirtualMachine(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedInstanceName, err := expandNotebooksRuntimeVirtualMachineInstanceName(original["instance_name"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedInstanceName); val.IsValid() && !isEmptyValue(val) {
		transformed["instanceName"] = transformedInstanceName
	}

	transformedInstanceId, err := expandNotebooksRuntimeVirtualMachineInstanceId(original["instance_id"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedInstanceId); val.IsValid() && !isEmptyValue(val) {
		transformed["instanceId"] = transformedInstanceId
	}

	transformedVirtualMachineConfig, err := expandNotebooksRuntimeVirtualMachineVirtualMachineConfig(original["virtual_machine_config"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedVirtualMachineConfig); val.IsValid() && !isEmptyValue(val) {
		transformed["virtualMachineConfig"] = transformedVirtualMachineConfig
	}

	return transformed, nil
}

func expandNotebooksRuntimeVirtualMachineInstanceName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeVirtualMachineInstanceId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeVirtualMachineVirtualMachineConfig(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedZone, err := expandNotebooksRuntimeVirtualMachineVirtualMachineConfigZone(original["zone"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedZone); val.IsValid() && !isEmptyValue(val) {
		transformed["zone"] = transformedZone
	}

	transformedMachineType, err := expandNotebooksRuntimeVirtualMachineVirtualMachineConfigMachineType(original["machine_type"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedMachineType); val.IsValid() && !isEmptyValue(val) {
		transformed["machineType"] = transformedMachineType
	}

	transformedDataDisk, err := expandNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDisk(original["data_disk"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedDataDisk); val.IsValid() && !isEmptyValue(val) {
		transformed["dataDisk"] = transformedDataDisk
	}

	transformedContainerImages, err := expandNotebooksRuntimeVirtualMachineVirtualMachineConfigContainerImages(original["container_images"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedContainerImages); val.IsValid() && !isEmptyValue(val) {
		transformed["containerImages"] = transformedContainerImages
	}

	transformedEncryptionConfig, err := expandNotebooksRuntimeVirtualMachineVirtualMachineConfigEncryptionConfig(original["encryption_config"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedEncryptionConfig); val.IsValid() && !isEmptyValue(val) {
		transformed["encryptionConfig"] = transformedEncryptionConfig
	}

	transformedShieldedInstanceConfig, err := expandNotebooksRuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfig(original["shielded_instance_config"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedShieldedInstanceConfig); val.IsValid() && !isEmptyValue(val) {
		transformed["shieldedInstanceConfig"] = transformedShieldedInstanceConfig
	}

	transformedAcceleratorConfig, err := expandNotebooksRuntimeVirtualMachineVirtualMachineConfigAcceleratorConfig(original["accelerator_config"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedAcceleratorConfig); val.IsValid() && !isEmptyValue(val) {
		transformed["acceleratorConfig"] = transformedAcceleratorConfig
	}

	transformedNetwork, err := expandNotebooksRuntimeVirtualMachineVirtualMachineConfigNetwork(original["network"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedNetwork); val.IsValid() && !isEmptyValue(val) {
		transformed["network"] = transformedNetwork
	}

	transformedSubnet, err := expandNotebooksRuntimeVirtualMachineVirtualMachineConfigSubnet(original["subnet"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedSubnet); val.IsValid() && !isEmptyValue(val) {
		transformed["subnet"] = transformedSubnet
	}

	transformedInternalIpOnly, err := expandNotebooksRuntimeVirtualMachineVirtualMachineConfigInternalIpOnly(original["internal_ip_only"], d, config)
	if err != nil {
		return nil, err
	} else {
		transformed["internalIpOnly"] = transformedInternalIpOnly
	}

	transformedTags, err := expandNotebooksRuntimeVirtualMachineVirtualMachineConfigTags(original["tags"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedTags); val.IsValid() && !isEmptyValue(val) {
		transformed["tags"] = transformedTags
	}

	transformedGuestAttributes, err := expandNotebooksRuntimeVirtualMachineVirtualMachineConfigGuestAttributes(original["guest_attributes"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedGuestAttributes); val.IsValid() && !isEmptyValue(val) {
		transformed["guestAttributes"] = transformedGuestAttributes
	}

	transformedMetadata, err := expandNotebooksRuntimeVirtualMachineVirtualMachineConfigMetadata(original["metadata"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedMetadata); val.IsValid() && !isEmptyValue(val) {
		transformed["metadata"] = transformedMetadata
	}

	transformedLabels, err := expandNotebooksRuntimeVirtualMachineVirtualMachineConfigLabels(original["labels"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedLabels); val.IsValid() && !isEmptyValue(val) {
		transformed["labels"] = transformedLabels
	}

	transformedNicType, err := expandNotebooksRuntimeVirtualMachineVirtualMachineConfigNicType(original["nic_type"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedNicType); val.IsValid() && !isEmptyValue(val) {
		transformed["nicType"] = transformedNicType
	}

	transformedReservedIpRange, err := expandNotebooksRuntimeVirtualMachineVirtualMachineConfigReservedIpRange(original["reserved_ip_range"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedReservedIpRange); val.IsValid() && !isEmptyValue(val) {
		transformed["reservedIpRange"] = transformedReservedIpRange
	}

	return transformed, nil
}

func expandNotebooksRuntimeVirtualMachineVirtualMachineConfigZone(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeVirtualMachineVirtualMachineConfigMachineType(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDisk(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedAutoDelete, err := expandNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskAutoDelete(original["auto_delete"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedAutoDelete); val.IsValid() && !isEmptyValue(val) {
		transformed["autoDelete"] = transformedAutoDelete
	}

	transformedBoot, err := expandNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskBoot(original["boot"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedBoot); val.IsValid() && !isEmptyValue(val) {
		transformed["boot"] = transformedBoot
	}

	transformedDeviceName, err := expandNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskDeviceName(original["device_name"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedDeviceName); val.IsValid() && !isEmptyValue(val) {
		transformed["deviceName"] = transformedDeviceName
	}

	transformedGuestOsFeatures, err := expandNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskGuestOsFeatures(original["guest_os_features"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedGuestOsFeatures); val.IsValid() && !isEmptyValue(val) {
		transformed["guestOsFeatures"] = transformedGuestOsFeatures
	}

	transformedIndex, err := expandNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskIndex(original["index"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedIndex); val.IsValid() && !isEmptyValue(val) {
		transformed["index"] = transformedIndex
	}

	transformedInitializeParams, err := expandNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParams(original["initialize_params"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedInitializeParams); val.IsValid() && !isEmptyValue(val) {
		transformed["initializeParams"] = transformedInitializeParams
	}

	transformedInterface, err := expandNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInterface(original["interface"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedInterface); val.IsValid() && !isEmptyValue(val) {
		transformed["interface"] = transformedInterface
	}

	transformedKind, err := expandNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskKind(original["kind"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedKind); val.IsValid() && !isEmptyValue(val) {
		transformed["kind"] = transformedKind
	}

	transformedLicenses, err := expandNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskLicenses(original["licenses"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedLicenses); val.IsValid() && !isEmptyValue(val) {
		transformed["licenses"] = transformedLicenses
	}

	transformedMode, err := expandNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskMode(original["mode"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedMode); val.IsValid() && !isEmptyValue(val) {
		transformed["mode"] = transformedMode
	}

	transformedSource, err := expandNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskSource(original["source"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedSource); val.IsValid() && !isEmptyValue(val) {
		transformed["source"] = transformedSource
	}

	transformedType, err := expandNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskType(original["type"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedType); val.IsValid() && !isEmptyValue(val) {
		transformed["type"] = transformedType
	}

	return transformed, nil
}

func expandNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskAutoDelete(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskBoot(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskDeviceName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskGuestOsFeatures(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskIndex(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParams(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedDescription, err := expandNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParamsDescription(original["description"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedDescription); val.IsValid() && !isEmptyValue(val) {
		transformed["description"] = transformedDescription
	}

	transformedDiskName, err := expandNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParamsDiskName(original["disk_name"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedDiskName); val.IsValid() && !isEmptyValue(val) {
		transformed["diskName"] = transformedDiskName
	}

	transformedDiskSizeGb, err := expandNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParamsDiskSizeGb(original["disk_size_gb"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedDiskSizeGb); val.IsValid() && !isEmptyValue(val) {
		transformed["diskSizeGb"] = transformedDiskSizeGb
	}

	transformedDiskType, err := expandNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParamsDiskType(original["disk_type"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedDiskType); val.IsValid() && !isEmptyValue(val) {
		transformed["diskType"] = transformedDiskType
	}

	transformedLabels, err := expandNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParamsLabels(original["labels"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedLabels); val.IsValid() && !isEmptyValue(val) {
		transformed["labels"] = transformedLabels
	}

	return transformed, nil
}

func expandNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParamsDescription(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParamsDiskName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParamsDiskSizeGb(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParamsDiskType(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParamsLabels(v interface{}, d TerraformResourceData, config *Config) (map[string]string, error) {
	if v == nil {
		return map[string]string{}, nil
	}
	m := make(map[string]string)
	for k, val := range v.(map[string]interface{}) {
		m[k] = val.(string)
	}
	return m, nil
}

func expandNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInterface(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskKind(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskLicenses(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskMode(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskSource(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskType(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeVirtualMachineVirtualMachineConfigContainerImages(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	req := make([]interface{}, 0, len(l))
	for _, raw := range l {
		if raw == nil {
			continue
		}
		original := raw.(map[string]interface{})
		transformed := make(map[string]interface{})

		transformedRepository, err := expandNotebooksRuntimeVirtualMachineVirtualMachineConfigContainerImagesRepository(original["repository"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedRepository); val.IsValid() && !isEmptyValue(val) {
			transformed["repository"] = transformedRepository
		}

		transformedTag, err := expandNotebooksRuntimeVirtualMachineVirtualMachineConfigContainerImagesTag(original["tag"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedTag); val.IsValid() && !isEmptyValue(val) {
			transformed["tag"] = transformedTag
		}

		req = append(req, transformed)
	}
	return req, nil
}

func expandNotebooksRuntimeVirtualMachineVirtualMachineConfigContainerImagesRepository(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeVirtualMachineVirtualMachineConfigContainerImagesTag(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeVirtualMachineVirtualMachineConfigEncryptionConfig(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedKmsKey, err := expandNotebooksRuntimeVirtualMachineVirtualMachineConfigEncryptionConfigKmsKey(original["kms_key"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedKmsKey); val.IsValid() && !isEmptyValue(val) {
		transformed["kmsKey"] = transformedKmsKey
	}

	return transformed, nil
}

func expandNotebooksRuntimeVirtualMachineVirtualMachineConfigEncryptionConfigKmsKey(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfig(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedEnableSecureBoot, err := expandNotebooksRuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfigEnableSecureBoot(original["enable_secure_boot"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedEnableSecureBoot); val.IsValid() && !isEmptyValue(val) {
		transformed["enableSecureBoot"] = transformedEnableSecureBoot
	}

	transformedEnableVtpm, err := expandNotebooksRuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfigEnableVtpm(original["enable_vtpm"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedEnableVtpm); val.IsValid() && !isEmptyValue(val) {
		transformed["enableVtpm"] = transformedEnableVtpm
	}

	transformedEnableIntegrityMonitoring, err := expandNotebooksRuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfigEnableIntegrityMonitoring(original["enable_integrity_monitoring"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedEnableIntegrityMonitoring); val.IsValid() && !isEmptyValue(val) {
		transformed["enableIntegrityMonitoring"] = transformedEnableIntegrityMonitoring
	}

	return transformed, nil
}

func expandNotebooksRuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfigEnableSecureBoot(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfigEnableVtpm(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfigEnableIntegrityMonitoring(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeVirtualMachineVirtualMachineConfigAcceleratorConfig(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedType, err := expandNotebooksRuntimeVirtualMachineVirtualMachineConfigAcceleratorConfigType(original["type"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedType); val.IsValid() && !isEmptyValue(val) {
		transformed["type"] = transformedType
	}

	transformedCoreCount, err := expandNotebooksRuntimeVirtualMachineVirtualMachineConfigAcceleratorConfigCoreCount(original["core_count"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedCoreCount); val.IsValid() && !isEmptyValue(val) {
		transformed["coreCount"] = transformedCoreCount
	}

	return transformed, nil
}

func expandNotebooksRuntimeVirtualMachineVirtualMachineConfigAcceleratorConfigType(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeVirtualMachineVirtualMachineConfigAcceleratorConfigCoreCount(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeVirtualMachineVirtualMachineConfigNetwork(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeVirtualMachineVirtualMachineConfigSubnet(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeVirtualMachineVirtualMachineConfigInternalIpOnly(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeVirtualMachineVirtualMachineConfigTags(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeVirtualMachineVirtualMachineConfigGuestAttributes(v interface{}, d TerraformResourceData, config *Config) (map[string]string, error) {
	if v == nil {
		return map[string]string{}, nil
	}
	m := make(map[string]string)
	for k, val := range v.(map[string]interface{}) {
		m[k] = val.(string)
	}
	return m, nil
}

func expandNotebooksRuntimeVirtualMachineVirtualMachineConfigMetadata(v interface{}, d TerraformResourceData, config *Config) (map[string]string, error) {
	if v == nil {
		return map[string]string{}, nil
	}
	m := make(map[string]string)
	for k, val := range v.(map[string]interface{}) {
		m[k] = val.(string)
	}
	return m, nil
}

func expandNotebooksRuntimeVirtualMachineVirtualMachineConfigLabels(v interface{}, d TerraformResourceData, config *Config) (map[string]string, error) {
	if v == nil {
		return map[string]string{}, nil
	}
	m := make(map[string]string)
	for k, val := range v.(map[string]interface{}) {
		m[k] = val.(string)
	}
	return m, nil
}

func expandNotebooksRuntimeVirtualMachineVirtualMachineConfigNicType(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeVirtualMachineVirtualMachineConfigReservedIpRange(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeAccessConfig(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedAccessType, err := expandNotebooksRuntimeAccessConfigAccessType(original["access_type"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedAccessType); val.IsValid() && !isEmptyValue(val) {
		transformed["accessType"] = transformedAccessType
	}

	transformedRuntimeOwner, err := expandNotebooksRuntimeAccessConfigRuntimeOwner(original["runtime_owner"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedRuntimeOwner); val.IsValid() && !isEmptyValue(val) {
		transformed["runtimeOwner"] = transformedRuntimeOwner
	}

	transformedProxyUri, err := expandNotebooksRuntimeAccessConfigProxyUri(original["proxy_uri"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedProxyUri); val.IsValid() && !isEmptyValue(val) {
		transformed["proxyUri"] = transformedProxyUri
	}

	return transformed, nil
}

func expandNotebooksRuntimeAccessConfigAccessType(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeAccessConfigRuntimeOwner(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeAccessConfigProxyUri(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeSoftwareConfig(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedNotebookUpgradeSchedule, err := expandNotebooksRuntimeSoftwareConfigNotebookUpgradeSchedule(original["notebook_upgrade_schedule"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedNotebookUpgradeSchedule); val.IsValid() && !isEmptyValue(val) {
		transformed["notebookUpgradeSchedule"] = transformedNotebookUpgradeSchedule
	}

	transformedEnableHealthMonitoring, err := expandNotebooksRuntimeSoftwareConfigEnableHealthMonitoring(original["enable_health_monitoring"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedEnableHealthMonitoring); val.IsValid() && !isEmptyValue(val) {
		transformed["enableHealthMonitoring"] = transformedEnableHealthMonitoring
	}

	transformedIdleShutdown, err := expandNotebooksRuntimeSoftwareConfigIdleShutdown(original["idle_shutdown"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedIdleShutdown); val.IsValid() && !isEmptyValue(val) {
		transformed["idleShutdown"] = transformedIdleShutdown
	}

	transformedIdleShutdownTimeout, err := expandNotebooksRuntimeSoftwareConfigIdleShutdownTimeout(original["idle_shutdown_timeout"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedIdleShutdownTimeout); val.IsValid() && !isEmptyValue(val) {
		transformed["idleShutdownTimeout"] = transformedIdleShutdownTimeout
	}

	transformedInstallGpuDriver, err := expandNotebooksRuntimeSoftwareConfigInstallGpuDriver(original["install_gpu_driver"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedInstallGpuDriver); val.IsValid() && !isEmptyValue(val) {
		transformed["installGpuDriver"] = transformedInstallGpuDriver
	}

	transformedUpgradeable, err := expandNotebooksRuntimeSoftwareConfigUpgradeable(original["upgradeable"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedUpgradeable); val.IsValid() && !isEmptyValue(val) {
		transformed["upgradeable"] = transformedUpgradeable
	}

	transformedCustomGpuDriverPath, err := expandNotebooksRuntimeSoftwareConfigCustomGpuDriverPath(original["custom_gpu_driver_path"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedCustomGpuDriverPath); val.IsValid() && !isEmptyValue(val) {
		transformed["customGpuDriverPath"] = transformedCustomGpuDriverPath
	}

	transformedPostStartupScript, err := expandNotebooksRuntimeSoftwareConfigPostStartupScript(original["post_startup_script"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedPostStartupScript); val.IsValid() && !isEmptyValue(val) {
		transformed["postStartupScript"] = transformedPostStartupScript
	}

	transformedPostStartupScriptBehavior, err := expandNotebooksRuntimeSoftwareConfigPostStartupScriptBehavior(original["post_startup_script_behavior"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedPostStartupScriptBehavior); val.IsValid() && !isEmptyValue(val) {
		transformed["postStartupScriptBehavior"] = transformedPostStartupScriptBehavior
	}

	transformedKernels, err := expandNotebooksRuntimeSoftwareConfigKernels(original["kernels"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedKernels); val.IsValid() && !isEmptyValue(val) {
		transformed["kernels"] = transformedKernels
	}

	return transformed, nil
}

func expandNotebooksRuntimeSoftwareConfigNotebookUpgradeSchedule(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeSoftwareConfigEnableHealthMonitoring(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeSoftwareConfigIdleShutdown(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeSoftwareConfigIdleShutdownTimeout(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeSoftwareConfigInstallGpuDriver(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeSoftwareConfigUpgradeable(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeSoftwareConfigCustomGpuDriverPath(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeSoftwareConfigPostStartupScript(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeSoftwareConfigPostStartupScriptBehavior(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeSoftwareConfigKernels(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	req := make([]interface{}, 0, len(l))
	for _, raw := range l {
		if raw == nil {
			continue
		}
		original := raw.(map[string]interface{})
		transformed := make(map[string]interface{})

		transformedRepository, err := expandNotebooksRuntimeSoftwareConfigKernelsRepository(original["repository"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedRepository); val.IsValid() && !isEmptyValue(val) {
			transformed["repository"] = transformedRepository
		}

		transformedTag, err := expandNotebooksRuntimeSoftwareConfigKernelsTag(original["tag"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedTag); val.IsValid() && !isEmptyValue(val) {
			transformed["tag"] = transformedTag
		}

		req = append(req, transformed)
	}
	return req, nil
}

func expandNotebooksRuntimeSoftwareConfigKernelsRepository(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNotebooksRuntimeSoftwareConfigKernelsTag(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}
