"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mockGanttProps = exports.mockEditorProps = exports.MockStateParams = void 0;

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const MockStateParams = {
  colors: '#6092C0',
  durationField: 'duration',
  labelField: 'spanID',
  legendOrientation: 'v',
  showLegend: true,
  size: 10,
  startTimeField: 'startTime',
  timeFormat: 'hh:mm:ss.SSS A',
  xAxisPosition: 'bottom',
  xAxisShow: true,
  xAxisShowGrid: true,
  xAxisShowLine: true,
  xAxisShowTitle: true,
  xAxisTitle: '',
  xAxisType: 'linear',
  yAxisPosition: 'left',
  yAxisShow: true,
  yAxisShowGrid: false,
  yAxisShowLine: true,
  yAxisShowTitle: true,
  yAxisTitle: ''
};
exports.MockStateParams = MockStateParams;
const MockAggs = {
  indexPattern: {
    fields: [{
      name: 'test-field-1'
    }, {
      name: 'test-field-2'
    }, {
      name: 'test-field-3'
    }, {
      name: 'test-field-4'
    }, {
      name: 'test-field-5'
    }, {
      name: 'test-field-6'
    }, {
      name: 'test-field-7'
    }]
  }
};

const mockEditorProps = setValue => ({ ...{
    setValue,
    stateParams: MockStateParams,
    aggs: MockAggs
  }
});

exports.mockEditorProps = mockEditorProps;

const mockGanttProps = () => ({
  visData: {
    total: 25,
    source: [{
      spanID: '57f46877f868af92',
      startTime: 1590695963803408,
      duration: 51929
    }, {
      spanID: '68daf6ca76398de9',
      startTime: 1590695963786548,
      duration: 45766
    }, {
      spanID: '439a27333a6e8893',
      startTime: 1590695963786541,
      duration: 45777
    }]
  },
  visParams: MockStateParams
});

exports.mockGanttProps = mockGanttProps;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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