/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.DrawableSequence;
import jalview.Format;
import jalview.RotatableMatrix;
import jalview.Sequence;
import jalview.SequencePoint;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Vector;

public class RotatableCanvas
extends Canvas {
    RotatableMatrix idmat = new RotatableMatrix(3, 3);
    RotatableMatrix objmat = new RotatableMatrix(3, 3);
    RotatableMatrix rotmat = new RotatableMatrix(3, 3);
    boolean redrawneeded = true;
    boolean drawAxes = true;
    int omx;
    int mx;
    int omy;
    int my;
    Image img;
    Graphics ig;
    Dimension prefsize;
    float[] centre = new float[3];
    float[] width = new float[3];
    float[] max = new float[3];
    float[] min = new float[3];
    float maxwidth;
    float scale;
    int npoint;
    Vector points;
    float[][] orig;
    float[][] axes;
    Vector selected;
    Object parent;
    int startx;
    int starty;
    int lastx;
    int lasty;
    int rectx1;
    int recty1;
    int rectx2;
    int recty2;
    float scalefactor = 1.0f;
    Sequence[] sequence;

    public RotatableCanvas(Object object, Vector vector, int n) {
        int n2;
        this.parent = object;
        this.points = vector;
        this.npoint = n;
        this.prefsize = this.getPreferredSize();
        this.orig = new float[n][3];
        int n3 = 0;
        while (n3 < n) {
            SequencePoint sequencePoint = (SequencePoint)vector.elementAt(n3);
            n2 = 0;
            while (n2 < 3) {
                this.orig[n3][n2] = sequencePoint.coord[n2];
                ++n2;
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < 3) {
            n2 = 0;
            while (n2 < 3) {
                if (n4 != n2) {
                    this.idmat.addElement(n4, n2, 0.0f);
                    this.objmat.addElement(n4, n2, 0.0f);
                    this.rotmat.addElement(n4, n2, 0.0f);
                } else {
                    this.idmat.addElement(n4, n2, 0.0f);
                    this.objmat.addElement(n4, n2, 0.0f);
                    this.rotmat.addElement(n4, n2, 0.0f);
                }
                ++n2;
            }
            ++n4;
        }
        this.axes = new float[3][3];
        this.initAxes();
        this.findCentre();
        this.findWidth();
        this.scale = this.findScale();
        this.selected = new Vector();
        if (object instanceof AlignFrame) {
            AlignFrame alignFrame = (AlignFrame)object;
            this.selected = alignFrame.ap.sel;
        }
    }

    public void initAxes() {
        int n = 0;
        while (n < 3) {
            int n2 = 0;
            while (n2 < 3) {
                this.axes[n][n2] = n != n2 ? 0.0f : 1.0f;
                ++n2;
            }
            ++n;
        }
    }

    public void findWidth() {
        this.max = new float[3];
        this.min = new float[3];
        this.max[0] = -1.0E30f;
        this.max[1] = -1.0E30f;
        this.max[2] = -1.0E30f;
        this.min[0] = 1.0E30f;
        this.min[1] = 1.0E30f;
        this.min[2] = 1.0E30f;
        int n = 0;
        while (n < 3) {
            int n2 = 0;
            while (n2 < this.npoint) {
                SequencePoint sequencePoint = (SequencePoint)this.points.elementAt(n2);
                if (sequencePoint.coord[n] >= this.max[n]) {
                    this.max[n] = sequencePoint.coord[n];
                }
                if (sequencePoint.coord[n] <= this.min[n]) {
                    this.min[n] = sequencePoint.coord[n];
                }
                ++n2;
            }
            ++n;
        }
        this.width[0] = Math.abs(this.max[0] - this.min[0]);
        this.width[1] = Math.abs(this.max[1] - this.min[1]);
        this.width[2] = Math.abs(this.max[2] - this.min[2]);
        this.maxwidth = this.width[0];
        if (this.width[1] > this.width[0]) {
            this.maxwidth = this.width[1];
        }
        if (this.width[2] > this.width[1]) {
            this.maxwidth = this.width[2];
        }
    }

    public float findScale() {
        int n;
        int n2;
        if (this.size().width != 0) {
            n2 = this.size().width;
            n = this.size().height;
        } else {
            n2 = this.prefsize.width;
            n = this.prefsize.height;
        }
        int n3 = n2 < n ? n2 : n;
        return (float)n3 * this.scalefactor / (2.0f * this.maxwidth);
    }

    public void findCentre() {
        this.findWidth();
        this.centre[0] = (this.max[0] + this.min[0]) / 2.0f;
        this.centre[1] = (this.max[1] + this.min[1]) / 2.0f;
        this.centre[2] = (this.max[2] + this.min[2]) / 2.0f;
    }

    public Dimension getPreferredSize() {
        if (this.prefsize != null) {
            return this.prefsize;
        }
        return new Dimension(400, 400);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void paint(Graphics graphics) {
        if (this.img == null || this.prefsize.width != this.size().width || this.prefsize.height != this.size().height) {
            this.prefsize.width = this.size().width;
            this.prefsize.height = this.size().height;
            this.scale = this.findScale();
            this.img = this.createImage(this.size().width, this.size().height);
            this.ig = this.img.getGraphics();
            this.redrawneeded = true;
        }
        if (this.redrawneeded) {
            this.drawBackground(this.ig, Color.black);
            this.drawScene(this.ig);
            if (this.drawAxes) {
                this.drawAxes(this.ig);
            }
            this.redrawneeded = false;
        } else {
            this.ig = this.img.getGraphics();
        }
        graphics.drawImage(this.img, 0, 0, this);
    }

    public void drawAxes(Graphics graphics) {
        graphics.setColor(Color.yellow);
        int n = 0;
        while (n < 3) {
            graphics.drawLine(this.size().width / 2, this.size().height / 2, (int)(this.axes[n][0] * this.scale * this.max[0] + (float)(this.size().width / 2)), (int)(this.axes[n][1] * this.scale * this.max[1] + (float)(this.size().height / 2)));
            ++n;
        }
    }

    public void drawBackground(Graphics graphics, Color color) {
        graphics.setColor(color);
        graphics.fillRect(0, 0, this.prefsize.width, this.prefsize.height);
    }

    public Sequence findPoint(int n, int n2) {
        int n3 = this.size().width / 2;
        int n4 = this.size().height / 2;
        int n5 = -1;
        int n6 = 0;
        while (n6 < this.npoint) {
            SequencePoint sequencePoint = (SequencePoint)this.points.elementAt(n6);
            int n7 = (int)((sequencePoint.coord[0] - this.centre[0]) * this.scale) + n3;
            int n8 = (int)((sequencePoint.coord[1] - this.centre[1]) * this.scale) + n4;
            if (Math.abs(n7 - n) < 3 && Math.abs(n8 - n2) < 3) {
                n5 = n6;
            }
            ++n6;
        }
        if (n5 != -1) {
            return ((SequencePoint)this.points.elementAt((int)n5)).sequence;
        }
        return null;
    }

    public void drawScene(Graphics graphics) {
        int n = this.size().width / 2;
        int n2 = this.size().height / 2;
        int n3 = 0;
        while (n3 < this.npoint) {
            SequencePoint sequencePoint = (SequencePoint)this.points.elementAt(n3);
            int n4 = (int)((sequencePoint.coord[0] - this.centre[0]) * this.scale) + n;
            int n5 = (int)((sequencePoint.coord[1] - this.centre[1]) * this.scale) + n2;
            float f = sequencePoint.coord[1] - this.centre[2];
            if (sequencePoint.sequence instanceof DrawableSequence) {
                if (((DrawableSequence)sequencePoint.sequence).color == Color.black) {
                    graphics.setColor(Color.white);
                } else {
                    graphics.setColor(((DrawableSequence)sequencePoint.sequence).color);
                }
            } else {
                graphics.setColor(Color.red);
            }
            if (this.parent instanceof AlignFrame && this.selected.contains(((SequencePoint)this.points.elementAt((int)n3)).sequence)) {
                graphics.setColor(Color.gray);
            }
            if (f < 0.0f) {
                graphics.setColor(graphics.getColor().darker());
            }
            graphics.fillRect(n4 - 3, n5 - 3, 6, 6);
            graphics.setColor(Color.red);
            ++n3;
        }
        if (this.rectx2 != -1 && this.recty2 != -1) {
            graphics.setColor(Color.white);
            graphics.drawRect(this.rectx1, this.recty1, this.rectx2 - this.rectx1, this.recty2 - this.recty1);
        }
    }

    public Dimension minimumsize() {
        return this.prefsize;
    }

    public Dimension preferredsize() {
        return this.prefsize;
    }

    public boolean keyDown(Event event, int n) {
        this.requestFocus();
        if (n == 1004) {
            this.scalefactor = (float)((double)this.scalefactor * 1.1);
            this.scale = this.findScale();
            this.redrawneeded = true;
            this.repaint();
            return true;
        }
        if (n == 1005) {
            this.scalefactor = (float)((double)this.scalefactor * 0.9);
            this.scale = this.findScale();
            this.redrawneeded = true;
            this.repaint();
            return true;
        }
        if (n == 115) {
            if (this.rectx2 != -1 && this.recty2 != -1) {
                this.rectSelect(this.rectx1, this.recty1, this.rectx2, this.recty2);
                this.redrawneeded = true;
                this.repaint();
            }
            return true;
        }
        return true;
    }

    public void printPoints() {
        int n = 0;
        while (n < this.npoint) {
            SequencePoint sequencePoint = (SequencePoint)this.points.elementAt(n);
            Format.print(System.out, "%5d ", n);
            int n2 = 0;
            while (n2 < 3) {
                Format.print(System.out, "%13.3f  ", sequencePoint.coord[n2]);
                ++n2;
            }
            System.out.println();
            ++n;
        }
    }

    public boolean mouseDown(Event event, int n, int n2) {
        this.mx = n;
        this.my = n2;
        this.omx = this.mx;
        this.omy = this.my;
        this.startx = n;
        this.starty = n2;
        this.rectx1 = n;
        this.recty1 = n2;
        this.rectx2 = -1;
        this.recty2 = -1;
        Sequence sequence = this.findPoint(n, n2);
        if (sequence != null) {
            if (this.parent instanceof AlignFrame) {
                AlignFrame alignFrame = (AlignFrame)this.parent;
                if (alignFrame.ap.sel.contains(sequence)) {
                    alignFrame.ap.sel.removeElement(sequence);
                } else {
                    alignFrame.ap.sel.addElement(sequence);
                }
                alignFrame.ap.idPanel.idCanvas.paintFlag = true;
                alignFrame.ap.idPanel.idCanvas.repaint();
                if (alignFrame.tt != null) {
                    alignFrame.tt.tf.p.mc.repaint();
                }
            }
            System.out.println("Sequence found = " + sequence.name);
        }
        this.redrawneeded = true;
        this.repaint();
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        this.mx = n;
        this.my = n2;
        if ((event.modifiers & 4) != 0) {
            this.rectx2 = n;
            this.recty2 = n2;
        } else {
            this.rotmat.setIdentity();
            this.rotmat.rotate(this.my - this.omy, 'x');
            this.rotmat.rotate(this.mx - this.omx, 'y');
            int n3 = 0;
            while (n3 < this.npoint) {
                SequencePoint sequencePoint = (SequencePoint)this.points.elementAt(n3);
                sequencePoint.coord[0] = sequencePoint.coord[0] - this.centre[0];
                sequencePoint.coord[1] = sequencePoint.coord[1] - this.centre[1];
                sequencePoint.coord[2] = sequencePoint.coord[2] - this.centre[2];
                sequencePoint.coord = this.rotmat.vectorMultiply(sequencePoint.coord);
                sequencePoint.coord[0] = sequencePoint.coord[0] + this.centre[0];
                sequencePoint.coord[1] = sequencePoint.coord[1] + this.centre[1];
                sequencePoint.coord[2] = sequencePoint.coord[2] + this.centre[2];
                ++n3;
            }
            int n4 = 0;
            while (n4 < 3) {
                this.axes[n4] = this.rotmat.vectorMultiply(this.axes[n4]);
                ++n4;
            }
        }
        this.omx = this.mx;
        this.omy = this.my;
        this.redrawneeded = true;
        this.paint(this.getGraphics());
        return true;
    }

    public void rectSelect(int n, int n2, int n3, int n4) {
        int n5 = 0;
        while (n5 < this.npoint) {
            SequencePoint sequencePoint = (SequencePoint)this.points.elementAt(n5);
            int n6 = (int)((sequencePoint.coord[0] - this.centre[0]) * this.scale + (float)(this.size().width / 2));
            int n7 = (int)((sequencePoint.coord[1] - this.centre[1]) * this.scale + (float)(this.size().width / 2));
            boolean bl = n6 > n && n6 < n3 && n7 > n2 && n7 < n4;
            ++n5;
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

