/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.model;

import com.github.ajalt.colormath.internal.Matrix;
import com.github.ajalt.colormath.model.SRGB;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000e\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002J\"\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\t0\b2\u0006\u0010\n\u001a\u00020\u0004H\u0002J(\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J \u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J\u0016\u0010\u0014\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004J\u000e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004\u00a8\u0006\u0017"}, d2={"Lcom/github/ajalt/colormath/model/HUSLColorConverter;", "", "()V", "distanceFromPole", "", "x", "y", "getBounds", "", "Lkotlin/Pair;", "L", "intersectLineLine", "x1", "y1", "x2", "y2", "lengthOfRayUntilIntersect", "theta", "a", "b", "maxChromaForLH", "H", "maxSafeChromaForL", "colormath"})
public final class HUSLColorConverter {
    @NotNull
    public static final HUSLColorConverter INSTANCE = new HUSLColorConverter();

    private HUSLColorConverter() {
    }

    public final double maxSafeChromaForL(double L) {
        Iterable iterable = this.getBounds(L);
        boolean bl = false;
        Iterator iterator2 = iterable.iterator();
        if (!iterator2.hasNext()) {
            throw (Throwable)new NoSuchElementException();
        }
        Pair $dstr$m1$b1 = (Pair)iterator2.next();
        boolean bl2 = false;
        double m1 = ((Number)$dstr$m1$b1.component1()).doubleValue();
        double b1 = ((Number)$dstr$m1$b1.component2()).doubleValue();
        double x = INSTANCE.intersectLineLine(m1, b1, (double)-1 / m1, 0.0);
        double d = INSTANCE.distanceFromPole(x, b1 + x * m1);
        while (iterator2.hasNext()) {
            Pair $dstr$m1$b12 = (Pair)iterator2.next();
            $i$a$-minOf-HUSLColorConverter$maxSafeChromaForL$1 = false;
            double m12 = ((Number)$dstr$m1$b12.component1()).doubleValue();
            double b12 = ((Number)$dstr$m1$b12.component2()).doubleValue();
            double x2 = INSTANCE.intersectLineLine(m12, b12, (double)-1 / m12, 0.0);
            double d2 = INSTANCE.distanceFromPole(x2, b12 + x2 * m12);
            boolean bl3 = false;
            d = Math.min(d, d2);
        }
        return d;
    }

    public final double maxChromaForLH(double L, double H) {
        double hrad = H / (double)360 * Math.PI * (double)2;
        Iterable iterable = this.getBounds(L);
        boolean bl = false;
        Iterator iterator2 = iterable.iterator();
        if (!iterator2.hasNext()) {
            throw (Throwable)new NoSuchElementException();
        }
        Pair $dstr$mi$hi = (Pair)iterator2.next();
        boolean bl2 = false;
        double mi = ((Number)$dstr$mi$hi.component1()).doubleValue();
        double hi = ((Number)$dstr$mi$hi.component2()).doubleValue();
        double d = INSTANCE.lengthOfRayUntilIntersect(hrad, mi, hi);
        boolean bl3 = false;
        boolean bl4 = false;
        double it = d;
        boolean bl5 = false;
        double d2 = it < 0.0 ? Double.MAX_VALUE : it;
        while (iterator2.hasNext()) {
            Pair $dstr$mi$hi2 = (Pair)iterator2.next();
            $i$a$-minOf-HUSLColorConverter$maxChromaForLH$1 = false;
            double mi2 = ((Number)$dstr$mi$hi2.component1()).doubleValue();
            double hi2 = ((Number)$dstr$mi$hi2.component2()).doubleValue();
            double d3 = INSTANCE.lengthOfRayUntilIntersect(hrad, mi2, hi2);
            boolean bl6 = false;
            boolean bl7 = false;
            double it2 = d3;
            $i$a$-let-HUSLColorConverter$maxChromaForLH$1$1 = false;
            double d4 = it2 < 0.0 ? Double.MAX_VALUE : it2;
            boolean bl8 = false;
            d2 = Math.min(d2, d4);
        }
        return d2;
    }

    private final List<Pair<Double, Double>> getBounds(double L) {
        ArrayList<Pair<Double, Double>> result = new ArrayList<Pair<Double, Double>>(6);
        double d = L + (double)16;
        int n = 3;
        boolean bl = false;
        double sub1 = Math.pow(d, n) / (double)1560896;
        double sub2 = sub1 > 0.008856451679035631 ? sub1 : L / 903.2962962962963;
        n = 0;
        do {
            int c = n++;
            float m1 = Matrix.get-impl(Matrix.constructor-impl(SRGB.INSTANCE.getMatrixFromXyz()), 0, c);
            float m2 = Matrix.get-impl(Matrix.constructor-impl(SRGB.INSTANCE.getMatrixFromXyz()), 1, c);
            float m3 = Matrix.get-impl(Matrix.constructor-impl(SRGB.INSTANCE.getMatrixFromXyz()), 2, c);
            int n2 = 0;
            do {
                int t = n2++;
                double top1 = (double)((float)284517 * m1 - (float)94839 * m3) * sub2;
                double top2 = (double)((float)838422 * m3 + (float)769860 * m2 + (float)731718 * m1) * L * sub2 - (double)(769860 * t) * L;
                double bottom = (double)((float)632260 * m3 - (float)126452 * m2) * sub2 + (double)(126452 * t);
                result.add(TuplesKt.to(top1 / bottom, top2 / bottom));
            } while (n2 <= 1);
        } while (n <= 2);
        return result;
    }

    private final double intersectLineLine(double x1, double y1, double x2, double y2) {
        return (y1 - y2) / (x2 - x1);
    }

    private final double distanceFromPole(double x, double y) {
        double d = x;
        int n = 2;
        boolean bl = false;
        double d2 = Math.pow(d, n);
        d = y;
        n = 2;
        bl = false;
        d = d2 + Math.pow(d, n);
        n = 0;
        return Math.sqrt(d);
    }

    private final double lengthOfRayUntilIntersect(double theta, double a, double b) {
        boolean bl = false;
        bl = false;
        return b / (Math.sin(theta) - a * Math.cos(theta));
    }
}

