/*! For license information please see settings-vue-settings-admin-ai.js.LICENSE.txt */
(()=>{"use strict";var e,n={11975:(e,n,s)=>{var i=s(20144),r=s(4820),a=s(20571),o=s.n(a),c=s(13299),p=s.n(c),l=s(36456),d=s.n(l),g=s(10861),v=s.n(g),u=s(9980),m=s.n(u),h=s(24939),f=s(76236),y=s(85313),_=s(79954),b=s(79753),A=s(25108);const x={name:"AdminAI",components:{NcCheckboxRadioSwitch:o(),NcSettingsSection:p(),NcSelect:d(),draggable:m(),DragVerticalIcon:h.Z,ArrowDownIcon:f.Z,ArrowUpIcon:y.Z,NcButton:v()},data:()=>({loading:!1,dirty:!1,groups:[],loadingGroups:!1,sttProviders:(0,_.j)("settings","ai-stt-providers"),translationProviders:(0,_.j)("settings","ai-translation-providers"),textProcessingProviders:(0,_.j)("settings","ai-text-processing-providers"),textProcessingTaskTypes:(0,_.j)("settings","ai-text-processing-task-types"),settings:(0,_.j)("settings","ai-settings")}),computed:{hasStt(){return this.sttProviders.length>0},hasTextProcessing(){return Object.keys(this.settings["ai.textprocessing_provider_preferences"]).length>0&&Array.isArray(this.textProcessingTaskTypes)}},methods:{moveUp(t){this.settings["ai.translation_provider_preferences"].splice(Math.min(t-1,0),0,...this.settings["ai.translation_provider_preferences"].splice(t,1)),this.saveChanges()},moveDown(t){this.settings["ai.translation_provider_preferences"].splice(t+1,0,...this.settings["ai.translation_provider_preferences"].splice(t,1)),this.saveChanges()},async saveChanges(){this.loading=!0;const t={settings:this.settings};try{await r.default.put((0,b.generateUrl)("/settings/api/admin/ai"),t)}catch(t){A.error("could not save changes",t)}this.loading=!1},getTaskType(t){return Array.isArray(this.textProcessingTaskTypes)?this.textProcessingTaskTypes.find((e=>e.class===t)):null}}};var S=s(93379),k=s.n(S),T=s(7795),w=s.n(T),C=s(90569),N=s.n(C),P=s(3565),j=s.n(P),O=s(19216),I=s.n(O),D=s(44589),B=s.n(D),U=s(95376),M={};M.styleTagTransform=B(),M.setAttributes=j(),M.insert=N().bind(null,"head"),M.domAPI=w(),M.insertStyleElement=I(),k()(U.Z,M),U.Z&&U.Z.locals&&U.Z.locals;const R=(0,s(51900).Z)(x,(function(){var t=this,e=t._self._c;return e("div",[e("NcSettingsSection",{attrs:{title:t.t("settings","Machine translation"),description:t.t("settings","Machine translation can be implemented by different apps. Here you can define the precedence of the machine translation apps you have installed at the moment.")}},[e("draggable",{on:{change:t.saveChanges},model:{value:t.settings["ai.translation_provider_preferences"],callback:function(e){t.$set(t.settings,"ai.translation_provider_preferences",e)},expression:"settings['ai.translation_provider_preferences']"}},t._l(t.settings["ai.translation_provider_preferences"],(function(n,s){var i;return e("div",{key:n,staticClass:"draggable__item"},[e("DragVerticalIcon"),t._v(" "),e("span",{staticClass:"draggable__number"},[t._v(t._s(s+1))]),t._v(" "+t._s(null===(i=t.translationProviders.find((t=>t.class===n)))||void 0===i?void 0:i.name)+"\n\t\t\t\t"),e("NcButton",{attrs:{"aria-label":"Move up",type:"tertiary"},on:{click:function(e){return t.moveUp(s)}},scopedSlots:t._u([{key:"icon",fn:function(){return[e("ArrowUpIcon")]},proxy:!0}],null,!0)}),t._v(" "),e("NcButton",{attrs:{"aria-label":"Move down",type:"tertiary"},on:{click:function(e){return t.moveDown(s)}},scopedSlots:t._u([{key:"icon",fn:function(){return[e("ArrowDownIcon")]},proxy:!0}],null,!0)})],1)})),0)],1),t._v(" "),e("NcSettingsSection",{attrs:{title:t.t("settings","Speech-To-Text"),description:t.t("settings","Speech-To-Text can be implemented by different apps. Here you can set which app should be used.")}},[t._l(t.sttProviders,(function(n){return[e("NcCheckboxRadioSwitch",{key:n.class,attrs:{checked:t.settings["ai.stt_provider"],value:n.class,name:"stt_provider",type:"radio"},on:{"update:checked":[function(e){return t.$set(t.settings,"ai.stt_provider",e)},t.saveChanges]}},[t._v("\n\t\t\t\t"+t._s(n.name)+"\n\t\t\t")])]})),t._v(" "),t.hasStt?t._e():[e("NcCheckboxRadioSwitch",{attrs:{disabled:"",type:"radio"}},[t._v("\n\t\t\t\t"+t._s(t.t("settings","None of your currently installed apps provide Speech-To-Text functionality"))+"\n\t\t\t")])]],2),t._v(" "),e("NcSettingsSection",{attrs:{title:t.t("settings","Text processing"),description:t.t("settings","Text processing tasks can be implemented by different apps. Here you can set which app should be used for which task.")}},[t._l(Object.keys(t.settings["ai.textprocessing_provider_preferences"]),(function(n){return[e("div",{key:n},[e("h3",[t._v(t._s(t.t("settings","Task:"))+" "+t._s(t.getTaskType(n).name))]),t._v(" "),e("p",[t._v(t._s(t.getTaskType(n).description))]),t._v(" "),e("p",[t._v(" ")]),t._v(" "),e("NcSelect",{attrs:{clearable:!1,options:t.textProcessingProviders.filter((t=>t.taskType===n)).map((t=>t.class))},on:{input:t.saveChanges},scopedSlots:t._u([{key:"option",fn:function(e){var n;let{label:s}=e;return[t._v("\n\t\t\t\t\t\t"+t._s(null===(n=t.textProcessingProviders.find((t=>t.class===s)))||void 0===n?void 0:n.name)+"\n\t\t\t\t\t")]}},{key:"selected-option",fn:function(e){var n;let{label:s}=e;return[t._v("\n\t\t\t\t\t\t"+t._s(null===(n=t.textProcessingProviders.find((t=>t.class===s)))||void 0===n?void 0:n.name)+"\n\t\t\t\t\t")]}}],null,!0),model:{value:t.settings["ai.textprocessing_provider_preferences"][n],callback:function(e){t.$set(t.settings["ai.textprocessing_provider_preferences"],n,e)},expression:"settings['ai.textprocessing_provider_preferences'][type]"}}),t._v(" "),e("p",[t._v(" ")])],1)]})),t._v(" "),t.hasTextProcessing?t._e():[e("p",[t._v(t._s(t.t("settings","None of your currently installed apps provide Text processing functionality")))])]],2)],1)}),[],!1,null,"4a254e0d",null).exports;s.nc=btoa(OC.requestToken),i.default.prototype.t=t,window.OC=window.OC||{},window.OC.Settings=window.OC.Settings||{},(new(i.default.extend(R))).$mount("#ai-settings")},95376:(t,e,n)=>{n.d(e,{Z:()=>o});var s=n(87537),i=n.n(s),r=n(23645),a=n.n(r)()(i());a.push([t.id,"\n.draggable__item[data-v-4a254e0d] {\n\tmargin-bottom: 5px;\n  display: flex;\n  align-items: center;\n}\n.draggable__item[data-v-4a254e0d],\n.draggable__item *[data-v-4a254e0d] {\n  cursor: grab;\n}\n.draggable__number[data-v-4a254e0d] {\n\tborder-radius: 20px;\n\tborder: 2px solid var(--color-primary-default);\n\tcolor: var(--color-primary-default);\n  padding: 0px 7px;\n\tmargin-right: 3px;\n}\n.drag-vertical-icon[data-v-4a254e0d] {\n  float: left;\n}\n","",{version:3,sources:["webpack://./apps/settings/src/components/AdminAI.vue"],names:[],mappings:";AAsJA;CACA,kBAAA;EACA,aAAA;EACA,mBAAA;AACA;AAEA;;EAEA,YAAA;AACA;AAEA;CACA,mBAAA;CACA,8CAAA;CACA,mCAAA;EACA,gBAAA;CACA,iBAAA;AACA;AAEA;EACA,WAAA;AACA",sourcesContent:["<template>\n\t<div>\n\t\t<NcSettingsSection :title=\"t('settings', 'Machine translation')\"\n\t\t\t:description=\"t('settings', 'Machine translation can be implemented by different apps. Here you can define the precedence of the machine translation apps you have installed at the moment.')\">\n\t\t\t<draggable v-model=\"settings['ai.translation_provider_preferences']\" @change=\"saveChanges\">\n\t\t\t\t<div v-for=\"(providerClass, i) in settings['ai.translation_provider_preferences']\" :key=\"providerClass\" class=\"draggable__item\">\n\t\t\t\t\t<DragVerticalIcon /> <span class=\"draggable__number\">{{ i + 1 }}</span> {{ translationProviders.find(p => p.class === providerClass)?.name }}\n\t\t\t\t\t<NcButton aria-label=\"Move up\" type=\"tertiary\" @click=\"moveUp(i)\">\n\t\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t\t<ArrowUpIcon />\n\t\t\t\t\t\t</template>\n\t\t\t\t\t</NcButton>\n\t\t\t\t\t<NcButton aria-label=\"Move down\" type=\"tertiary\" @click=\"moveDown(i)\">\n\t\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t\t<ArrowDownIcon />\n\t\t\t\t\t\t</template>\n\t\t\t\t\t</NcButton>\n\t\t\t\t</div>\n\t\t\t</draggable>\n\t\t</NcSettingsSection>\n\t\t<NcSettingsSection :title=\"t('settings', 'Speech-To-Text')\"\n\t\t\t:description=\"t('settings', 'Speech-To-Text can be implemented by different apps. Here you can set which app should be used.')\">\n\t\t\t<template v-for=\"provider in sttProviders\">\n\t\t\t\t<NcCheckboxRadioSwitch :key=\"provider.class\"\n\t\t\t\t\t:checked.sync=\"settings['ai.stt_provider']\"\n\t\t\t\t\t:value=\"provider.class\"\n\t\t\t\t\tname=\"stt_provider\"\n\t\t\t\t\ttype=\"radio\"\n\t\t\t\t\t@update:checked=\"saveChanges\">\n\t\t\t\t\t{{ provider.name }}\n\t\t\t\t</NcCheckboxRadioSwitch>\n\t\t\t</template>\n\t\t\t<template v-if=\"!hasStt\">\n\t\t\t\t<NcCheckboxRadioSwitch disabled type=\"radio\">\n\t\t\t\t\t{{ t('settings', 'None of your currently installed apps provide Speech-To-Text functionality') }}\n\t\t\t\t</NcCheckboxRadioSwitch>\n\t\t\t</template>\n\t\t</NcSettingsSection>\n\t\t<NcSettingsSection :title=\"t('settings', 'Text processing')\"\n\t\t\t:description=\"t('settings', 'Text processing tasks can be implemented by different apps. Here you can set which app should be used for which task.')\">\n\t\t\t<template v-for=\"type in Object.keys(settings['ai.textprocessing_provider_preferences'])\">\n\t\t\t\t<div :key=\"type\">\n\t\t\t\t\t<h3>{{ t('settings', 'Task:') }} {{ getTaskType(type).name }}</h3>\n\t\t\t\t\t<p>{{ getTaskType(type).description }}</p>\n\t\t\t\t\t<p>&nbsp;</p>\n\t\t\t\t\t<NcSelect v-model=\"settings['ai.textprocessing_provider_preferences'][type]\"\n\t\t\t\t\t\t:clearable=\"false\"\n\t\t\t\t\t\t:options=\"textProcessingProviders.filter(p => p.taskType === type).map(p => p.class)\"\n\t\t\t\t\t\t@input=\"saveChanges\">\n\t\t\t\t\t\t<template #option=\"{label}\">\n\t\t\t\t\t\t\t{{ textProcessingProviders.find(p => p.class === label)?.name }}\n\t\t\t\t\t\t</template>\n\t\t\t\t\t\t<template #selected-option=\"{label}\">\n\t\t\t\t\t\t\t{{ textProcessingProviders.find(p => p.class === label)?.name }}\n\t\t\t\t\t\t</template>\n\t\t\t\t\t</NcSelect>\n\t\t\t\t\t<p>&nbsp;</p>\n\t\t\t\t</div>\n\t\t\t</template>\n\t\t\t<template v-if=\"!hasTextProcessing\">\n\t\t\t\t<p>{{ t('settings', 'None of your currently installed apps provide Text processing functionality') }}</p>\n\t\t\t</template>\n\t\t</NcSettingsSection>\n\t</div>\n</template>\n\n<script>\nimport axios from '@nextcloud/axios'\nimport NcCheckboxRadioSwitch from '@nextcloud/vue/dist/Components/NcCheckboxRadioSwitch.js'\nimport NcSettingsSection from '@nextcloud/vue/dist/Components/NcSettingsSection.js'\nimport NcSelect from '@nextcloud/vue/dist/Components/NcSelect.js'\nimport NcButton from '@nextcloud/vue/dist/Components/NcButton.js'\nimport draggable from 'vuedraggable'\nimport DragVerticalIcon from 'vue-material-design-icons/DragVertical.vue'\nimport ArrowDownIcon from 'vue-material-design-icons/ArrowDown.vue'\nimport ArrowUpIcon from 'vue-material-design-icons/ArrowUp.vue'\nimport { loadState } from '@nextcloud/initial-state'\n\nimport { generateUrl } from '@nextcloud/router'\n\nexport default {\n\tname: 'AdminAI',\n\tcomponents: {\n\t\tNcCheckboxRadioSwitch,\n\t\tNcSettingsSection,\n\t\tNcSelect,\n\t\tdraggable,\n\t\tDragVerticalIcon,\n\t\tArrowDownIcon,\n\t\tArrowUpIcon,\n\t\tNcButton\n\t},\n\tdata() {\n\t\treturn {\n\t\t\tloading: false,\n\t\t\tdirty: false,\n\t\t\tgroups: [],\n\t\t\tloadingGroups: false,\n\t\t\tsttProviders: loadState('settings', 'ai-stt-providers'),\n\t\t\ttranslationProviders: loadState('settings', 'ai-translation-providers'),\n\t\t\ttextProcessingProviders: loadState('settings', 'ai-text-processing-providers'),\n\t\t\ttextProcessingTaskTypes: loadState('settings', 'ai-text-processing-task-types'),\n\t\t\tsettings: loadState('settings', 'ai-settings'),\n\t\t}\n\t},\n\tcomputed: {\n\t\thasStt() {\n\t\t\treturn this.sttProviders.length > 0\n\t\t},\n\t\thasTextProcessing() {\n\t\t\treturn Object.keys(this.settings['ai.textprocessing_provider_preferences']).length > 0 && Array.isArray(this.textProcessingTaskTypes)\n\t\t},\n\t},\n\tmethods: {\n\t  moveUp(i) {\n\t\t\tthis.settings['ai.translation_provider_preferences'].splice(\n\t\t\t  Math.min(i - 1, 0),\n\t\t\t\t0,\n\t\t\t\t...this.settings['ai.translation_provider_preferences'].splice(i, 1)\n\t\t\t)\n\t\t\tthis.saveChanges()\n\t\t},\n\t\tmoveDown(i) {\n\t\t\tthis.settings['ai.translation_provider_preferences'].splice(\n\t\t\t\ti + 1,\n\t\t\t\t0,\n\t\t\t\t...this.settings['ai.translation_provider_preferences'].splice(i, 1)\n\t\t\t)\n\t\t\tthis.saveChanges()\n\t\t},\n\t\tasync saveChanges() {\n\t\t\tthis.loading = true\n\t\t\tconst data = { settings: this.settings }\n\t\t\ttry {\n\t\t\t\tawait axios.put(generateUrl('/settings/api/admin/ai'), data)\n\t\t\t} catch (err) {\n\t\t\t\tconsole.error('could not save changes', err)\n\t\t\t}\n\t\t\tthis.loading = false\n\t\t},\n\t\tgetTaskType(type) {\n\t\t  if (!Array.isArray(this.textProcessingTaskTypes)) {\n\t\t\t\treturn null\n\t\t\t}\n\t\t\treturn this.textProcessingTaskTypes.find(taskType => taskType.class === type)\n\t\t},\n\t},\n}\n<\/script>\n<style scoped>\n.draggable__item {\n\tmargin-bottom: 5px;\n  display: flex;\n  align-items: center;\n}\n\n.draggable__item,\n.draggable__item * {\n  cursor: grab;\n}\n\n.draggable__number {\n\tborder-radius: 20px;\n\tborder: 2px solid var(--color-primary-default);\n\tcolor: var(--color-primary-default);\n  padding: 0px 7px;\n\tmargin-right: 3px;\n}\n\n.drag-vertical-icon {\n  float: left;\n}\n</style>\n"],sourceRoot:""}]);const o=a}},s={};function i(t){var e=s[t];if(void 0!==e)return e.exports;var r=s[t]={id:t,loaded:!1,exports:{}};return n[t].call(r.exports,r,r.exports,i),r.loaded=!0,r.exports}i.m=n,e=[],i.O=(t,n,s,r)=>{if(!n){var a=1/0;for(l=0;l<e.length;l++){n=e[l][0],s=e[l][1],r=e[l][2];for(var o=!0,c=0;c<n.length;c++)(!1&r||a>=r)&&Object.keys(i.O).every((t=>i.O[t](n[c])))?n.splice(c--,1):(o=!1,r<a&&(a=r));if(o){e.splice(l--,1);var p=s();void 0!==p&&(t=p)}}return t}r=r||0;for(var l=e.length;l>0&&e[l-1][2]>r;l--)e[l]=e[l-1];e[l]=[n,s,r]},i.n=t=>{var e=t&&t.__esModule?()=>t.default:()=>t;return i.d(e,{a:e}),e},i.d=(t,e)=>{for(var n in e)i.o(e,n)&&!i.o(t,n)&&Object.defineProperty(t,n,{enumerable:!0,get:e[n]})},i.e=()=>Promise.resolve(),i.g=function(){if("object"==typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(t){if("object"==typeof window)return window}}(),i.o=(t,e)=>Object.prototype.hasOwnProperty.call(t,e),i.r=t=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(t,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(t,"__esModule",{value:!0})},i.nmd=t=>(t.paths=[],t.children||(t.children=[]),t),i.j=1104,(()=>{i.b=document.baseURI||self.location.href;var t={1104:0};i.O.j=e=>0===t[e];var e=(e,n)=>{var s,r,a=n[0],o=n[1],c=n[2],p=0;if(a.some((e=>0!==t[e]))){for(s in o)i.o(o,s)&&(i.m[s]=o[s]);if(c)var l=c(i)}for(e&&e(n);p<a.length;p++)r=a[p],i.o(t,r)&&t[r]&&t[r][0](),t[r]=0;return i.O(l)},n=self.webpackChunknextcloud=self.webpackChunknextcloud||[];n.forEach(e.bind(null,0)),n.push=e.bind(null,n.push.bind(n))})(),i.nc=void 0;var r=i.O(void 0,[7874],(()=>i(11975)));r=i.O(r)})();
//# sourceMappingURL=settings-vue-settings-admin-ai.js.map?v=4e882c8c4c2cd526a8de