/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec.pattern;

import org.jparsec.pattern.Pattern;

class ManyPattern
extends Pattern {
    private final Pattern pattern;

    ManyPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    static int matchMany(Pattern pattern, CharSequence src, int len, int from, int acc) {
        int i = from;
        int l;
        while (-1 != (l = pattern.match(src, i, len))) {
            if (l == 0) {
                return i - from + acc;
            }
            i += l;
        }
        return i - from + acc;
    }

    @Override
    public int match(CharSequence src, int begin, int end) {
        return ManyPattern.matchMany(this.pattern, src, end, begin, 0);
    }

    public String toString() {
        return this.pattern + "*";
    }
}

