/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec;

import java.util.function.Function;
import org.jparsec.NumberLiteralsTranslator;
import org.jparsec.StringLiteralsTranslator;
import org.jparsec.Tokens;

final class TokenizerMaps {
    static final Function<String, Tokens.Fragment> RESERVED_FRAGMENT = TokenizerMaps.fragment((Object)Tokens.Tag.RESERVED);
    static final Function<String, Tokens.Fragment> IDENTIFIER_FRAGMENT = TokenizerMaps.fragment((Object)Tokens.Tag.IDENTIFIER);
    static final Function<String, Tokens.Fragment> INTEGER_FRAGMENT = TokenizerMaps.fragment((Object)Tokens.Tag.INTEGER);
    static final Function<String, Tokens.Fragment> DECIMAL_FRAGMENT = TokenizerMaps.fragment((Object)Tokens.Tag.DECIMAL);
    static final Function<String, Tokens.ScientificNotation> SCIENTIFIC_NOTATION = new Function<String, Tokens.ScientificNotation>(){

        @Override
        public Tokens.ScientificNotation apply(String text) {
            int e = text.indexOf(101);
            if (e < 0) {
                e = text.indexOf(69);
            }
            String significand = text.substring(0, e);
            String exponent = text.substring(e + (text.charAt(e + 1) == '+' ? 2 : 1), text.length());
            return Tokens.scientificNotation(significand, exponent);
        }

        public String toString() {
            return "SCIENTIFIC_NOTATION";
        }
    };
    static final Function<String, String> DOUBLE_QUOTE_STRING = new Function<String, String>(){

        @Override
        public String apply(String text) {
            return StringLiteralsTranslator.tokenizeDoubleQuote(text);
        }

        public String toString() {
            return "DOUBLE_QUOTE_STRING";
        }
    };
    static final Function<String, String> SINGLE_QUOTE_STRING = new Function<String, String>(){

        @Override
        public String apply(String text) {
            return StringLiteralsTranslator.tokenizeSingleQuote(text);
        }

        public String toString() {
            return "SINGLE_QUOTE_STRING";
        }
    };
    static final Function<String, Character> SINGLE_QUOTE_CHAR = new Function<String, Character>(){

        @Override
        public Character apply(String text) {
            int len = text.length();
            if (len == 3) {
                return Character.valueOf(text.charAt(1));
            }
            if (len == 4) {
                return Character.valueOf(text.charAt(2));
            }
            throw new IllegalStateException("illegal char");
        }

        public String toString() {
            return "SINGLE_QUOTE_CHAR";
        }
    };
    static final Function<String, Long> DEC_AS_LONG = new Function<String, Long>(){

        @Override
        public Long apply(String text) {
            return NumberLiteralsTranslator.tokenizeDecimalAsLong(text);
        }

        public String toString() {
            return "DEC_AS_LONG";
        }
    };
    static final Function<String, Long> OCT_AS_LONG = new Function<String, Long>(){

        @Override
        public Long apply(String text) {
            return NumberLiteralsTranslator.tokenizeOctalAsLong(text);
        }

        public String toString() {
            return "OCT_AS_LONG";
        }
    };
    static final Function<String, Long> HEX_AS_LONG = new Function<String, Long>(){

        @Override
        public Long apply(String text) {
            return NumberLiteralsTranslator.tokenizeHexAsLong(text);
        }

        public String toString() {
            return "HEX_AS_LONG";
        }
    };

    TokenizerMaps() {
    }

    static Function<String, Tokens.Fragment> fragment(final Object tag) {
        return new Function<String, Tokens.Fragment>(){

            @Override
            public Tokens.Fragment apply(String text) {
                return Tokens.fragment(text, tag);
            }

            public String toString() {
                return String.valueOf(tag);
            }
        };
    }
}

