/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec;

import org.jparsec.ParseContext;
import org.jparsec.Parser;

final class NestableBlockCommentScanner
extends Parser<Void> {
    private final Parser<?> openQuote;
    private final Parser<?> closeQuote;
    private final Parser<?> commented;

    NestableBlockCommentScanner(Parser<?> openQuote, Parser<?> closeQuote, Parser<?> commented) {
        this.openQuote = openQuote;
        this.closeQuote = closeQuote;
        this.commented = commented;
    }

    @Override
    boolean apply(ParseContext ctxt) {
        if (!this.openQuote.apply(ctxt)) {
            return false;
        }
        int level = 1;
        while (level > 0) {
            int step = ctxt.step;
            int at = ctxt.at;
            if (this.closeQuote.apply(ctxt)) {
                if (at == ctxt.at) {
                    throw new IllegalStateException("closing comment scanner not consuming input.");
                }
                --level;
                continue;
            }
            if (this.openQuote.apply(ctxt)) {
                if (at == ctxt.at) {
                    throw new IllegalStateException("opening comment scanner not consuming input.");
                }
                ++level;
                continue;
            }
            if (!ctxt.stillThere(at, step)) {
                return false;
            }
            if (this.commented.apply(ctxt)) {
                if (at != ctxt.at) continue;
                throw new IllegalStateException("commented scanner not consuming input.");
            }
            return false;
        }
        ctxt.result = null;
        return true;
    }

    public String toString() {
        return "nestable block comment";
    }
}

