/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.reports.common;

import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.tools.generic.DateTool;
import org.apache.velocity.tools.generic.NumberTool;
import org.jxls.area.Area;
import org.jxls.builder.xls.XlsCommentAreaBuilder;
import org.jxls.common.CellRef;
import org.jxls.common.Context;
import org.jxls.formula.FormulaProcessor;
import org.jxls.formula.StandardFormulaProcessor;
import org.jxls.transform.Transformer;
import org.jxls.transform.poi.PoiTransformer;
import org.jxls.util.TransformerFactory;
import org.traccar.api.security.PermissionsService;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.geocoder.Geocoder;
import org.traccar.helper.UnitsConverter;
import org.traccar.helper.model.AttributeUtil;
import org.traccar.helper.model.PositionUtil;
import org.traccar.helper.model.UserUtil;
import org.traccar.model.BaseModel;
import org.traccar.model.Device;
import org.traccar.model.Driver;
import org.traccar.model.Event;
import org.traccar.model.Position;
import org.traccar.model.Server;
import org.traccar.model.User;
import org.traccar.reports.common.TripsConfig;
import org.traccar.reports.model.BaseReportItem;
import org.traccar.reports.model.StopReportItem;
import org.traccar.reports.model.TripReportItem;
import org.traccar.session.state.MotionProcessor;
import org.traccar.session.state.MotionState;
import org.traccar.storage.Storage;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Order;
import org.traccar.storage.query.Request;

public class ReportUtils {
    private final Config config;
    private final Storage storage;
    private final PermissionsService permissionsService;
    private final VelocityEngine velocityEngine;
    private final Geocoder geocoder;

    @Inject
    public ReportUtils(Config config, Storage storage, PermissionsService permissionsService, VelocityEngine velocityEngine, @Nullable Geocoder geocoder) {
        this.config = config;
        this.storage = storage;
        this.permissionsService = permissionsService;
        this.velocityEngine = velocityEngine;
        this.geocoder = geocoder;
    }

    public <T extends BaseModel> T getObject(long userId, Class<T> clazz, long objectId) throws StorageException, SecurityException {
        return (T)((BaseModel)this.storage.getObject(clazz, new Request((Columns)new Columns.All(), new Condition.And(new Condition.Equals("id", objectId), new Condition.Permission(User.class, userId, clazz)))));
    }

    public void checkPeriodLimit(Date from, Date to) {
        long limit = this.config.getLong(Keys.REPORT_PERIOD_LIMIT) * 1000L;
        if (limit > 0L && to.getTime() - from.getTime() > limit) {
            throw new IllegalArgumentException("Time period exceeds the limit");
        }
    }

    public double calculateFuel(Position firstPosition, Position lastPosition) {
        if (firstPosition.getAttributes().get("fuel") != null && lastPosition.getAttributes().get("fuel") != null) {
            BigDecimal value = BigDecimal.valueOf(firstPosition.getDouble("fuel") - lastPosition.getDouble("fuel"));
            return value.setScale(1, RoundingMode.HALF_EVEN).doubleValue();
        }
        return 0.0;
    }

    public String findDriver(Position firstPosition, Position lastPosition) {
        if (firstPosition.hasAttribute("driverUniqueId")) {
            return firstPosition.getString("driverUniqueId");
        }
        if (lastPosition.hasAttribute("driverUniqueId")) {
            return lastPosition.getString("driverUniqueId");
        }
        return null;
    }

    public String findDriverName(String driverUniqueId) throws StorageException {
        Driver driver;
        if (driverUniqueId != null && (driver = this.storage.getObject(Driver.class, new Request((Columns)new Columns.All(), new Condition.Equals("uniqueId", driverUniqueId)))) != null) {
            return driver.getName();
        }
        return null;
    }

    public Context initializeContext(long userId) throws StorageException {
        Server server = this.permissionsService.getServer();
        User user = this.permissionsService.getUser(userId);
        Context context = PoiTransformer.createInitialContext();
        context.putVar("distanceUnit", (Object)UserUtil.getDistanceUnit(server, user));
        context.putVar("speedUnit", (Object)UserUtil.getSpeedUnit(server, user));
        context.putVar("volumeUnit", (Object)UserUtil.getVolumeUnit(server, user));
        context.putVar("webUrl", this.velocityEngine.getProperty("web.url"));
        context.putVar("dateTool", (Object)new DateTool());
        context.putVar("numberTool", (Object)new NumberTool());
        context.putVar("timezone", (Object)UserUtil.getTimezone(server, user));
        context.putVar("locale", (Object)Locale.getDefault());
        context.putVar("bracketsRegex", (Object)"[\\{\\}\"]");
        return context;
    }

    public void processTemplateWithSheets(InputStream templateStream, OutputStream targetStream, Context context) throws IOException {
        Transformer transformer = TransformerFactory.createTransformer((InputStream)templateStream, (OutputStream)targetStream);
        List xlsAreas = new XlsCommentAreaBuilder(transformer).build();
        for (Area xlsArea : xlsAreas) {
            xlsArea.applyAt(new CellRef(xlsArea.getStartCellRef().getCellName()), context);
            xlsArea.setFormulaProcessor((FormulaProcessor)new StandardFormulaProcessor());
            xlsArea.processFormulas();
        }
        transformer.deleteSheet(((Area)xlsAreas.get(0)).getStartCellRef().getSheetName());
        transformer.write();
    }

    private TripReportItem calculateTrip(Device device, Position startTrip, Position endTrip, double maxSpeed, boolean ignoreOdometer) throws StorageException {
        TripReportItem trip = new TripReportItem();
        long tripDuration = endTrip.getFixTime().getTime() - startTrip.getFixTime().getTime();
        long deviceId = startTrip.getDeviceId();
        trip.setDeviceId(deviceId);
        trip.setDeviceName(device.getName());
        trip.setStartPositionId(startTrip.getId());
        trip.setStartLat(startTrip.getLatitude());
        trip.setStartLon(startTrip.getLongitude());
        trip.setStartTime(startTrip.getFixTime());
        String startAddress = startTrip.getAddress();
        if (startAddress == null && this.geocoder != null && this.config.getBoolean(Keys.GEOCODER_ON_REQUEST)) {
            startAddress = this.geocoder.getAddress(startTrip.getLatitude(), startTrip.getLongitude(), null);
        }
        trip.setStartAddress(startAddress);
        trip.setEndPositionId(endTrip.getId());
        trip.setEndLat(endTrip.getLatitude());
        trip.setEndLon(endTrip.getLongitude());
        trip.setEndTime(endTrip.getFixTime());
        String endAddress = endTrip.getAddress();
        if (endAddress == null && this.geocoder != null && this.config.getBoolean(Keys.GEOCODER_ON_REQUEST)) {
            endAddress = this.geocoder.getAddress(endTrip.getLatitude(), endTrip.getLongitude(), null);
        }
        trip.setEndAddress(endAddress);
        trip.setDistance(PositionUtil.calculateDistance(startTrip, endTrip, !ignoreOdometer));
        trip.setDuration(tripDuration);
        if (tripDuration > 0L) {
            trip.setAverageSpeed(UnitsConverter.knotsFromMps(trip.getDistance() * 1000.0 / (double)tripDuration));
        }
        trip.setMaxSpeed(maxSpeed);
        trip.setSpentFuel(this.calculateFuel(startTrip, endTrip));
        trip.setDriverUniqueId(this.findDriver(startTrip, endTrip));
        trip.setDriverName(this.findDriverName(trip.getDriverUniqueId()));
        if (!ignoreOdometer && startTrip.getDouble("odometer") != 0.0 && endTrip.getDouble("odometer") != 0.0) {
            trip.setStartOdometer(startTrip.getDouble("odometer"));
            trip.setEndOdometer(endTrip.getDouble("odometer"));
        } else {
            trip.setStartOdometer(startTrip.getDouble("totalDistance"));
            trip.setEndOdometer(endTrip.getDouble("totalDistance"));
        }
        return trip;
    }

    private StopReportItem calculateStop(Device device, Position startStop, Position endStop, boolean ignoreOdometer) {
        StopReportItem stop = new StopReportItem();
        long deviceId = startStop.getDeviceId();
        stop.setDeviceId(deviceId);
        stop.setDeviceName(device.getName());
        stop.setPositionId(startStop.getId());
        stop.setLatitude(startStop.getLatitude());
        stop.setLongitude(startStop.getLongitude());
        stop.setStartTime(startStop.getFixTime());
        String address = startStop.getAddress();
        if (address == null && this.geocoder != null && this.config.getBoolean(Keys.GEOCODER_ON_REQUEST)) {
            address = this.geocoder.getAddress(stop.getLatitude(), stop.getLongitude(), null);
        }
        stop.setAddress(address);
        stop.setEndTime(endStop.getFixTime());
        long stopDuration = endStop.getFixTime().getTime() - startStop.getFixTime().getTime();
        stop.setDuration(stopDuration);
        stop.setSpentFuel(this.calculateFuel(startStop, endStop));
        if (startStop.hasAttribute("hours") && endStop.hasAttribute("hours")) {
            stop.setEngineHours(endStop.getLong("hours") - startStop.getLong("hours"));
        }
        if (!ignoreOdometer && startStop.getDouble("odometer") != 0.0 && endStop.getDouble("odometer") != 0.0) {
            stop.setStartOdometer(startStop.getDouble("odometer"));
            stop.setEndOdometer(endStop.getDouble("odometer"));
        } else {
            stop.setStartOdometer(startStop.getDouble("totalDistance"));
            stop.setEndOdometer(endStop.getDouble("totalDistance"));
        }
        return stop;
    }

    private <T extends BaseReportItem> T calculateTripOrStop(Device device, Position startPosition, Position endPosition, double maxSpeed, boolean ignoreOdometer, Class<T> reportClass) throws StorageException {
        if (reportClass.equals(TripReportItem.class)) {
            return (T)this.calculateTrip(device, startPosition, endPosition, maxSpeed, ignoreOdometer);
        }
        return (T)this.calculateStop(device, startPosition, endPosition, ignoreOdometer);
    }

    private boolean isMoving(List<Position> positions, int index, TripsConfig tripsConfig) {
        if (tripsConfig.getMinimalNoDataDuration() > 0L) {
            boolean afterGap;
            boolean beforeGap = index < positions.size() - 1 && positions.get(index + 1).getFixTime().getTime() - positions.get(index).getFixTime().getTime() >= tripsConfig.getMinimalNoDataDuration();
            boolean bl = afterGap = index > 0 && positions.get(index).getFixTime().getTime() - positions.get(index - 1).getFixTime().getTime() >= tripsConfig.getMinimalNoDataDuration();
            if (beforeGap || afterGap) {
                return false;
            }
        }
        return positions.get(index).getBoolean("motion");
    }

    public <T extends BaseReportItem> List<T> detectTripsAndStops(Device device, Date from, Date to, Class<T> reportClass) throws StorageException {
        long threshold = this.config.getLong(Keys.REPORT_FAST_THRESHOLD);
        if (Duration.between(from.toInstant(), to.toInstant()).toSeconds() > threshold) {
            return this.fastTripsAndStops(device, from, to, reportClass);
        }
        return this.slowTripsAndStops(device, from, to, reportClass);
    }

    public <T extends BaseReportItem> List<T> slowTripsAndStops(Device device, Date from, Date to, Class<T> reportClass) throws StorageException {
        ArrayList<T> result = new ArrayList<T>();
        TripsConfig tripsConfig = new TripsConfig(new AttributeUtil.StorageProvider(this.config, this.storage, this.permissionsService, device));
        boolean ignoreOdometer = this.config.getBoolean(Keys.REPORT_IGNORE_ODOMETER);
        List<Position> positions = PositionUtil.getPositions(this.storage, device.getId(), from, to);
        if (!positions.isEmpty()) {
            boolean trips = reportClass.equals(TripReportItem.class);
            MotionState motionState = new MotionState();
            boolean initialValue = this.isMoving(positions, 0, tripsConfig);
            motionState.setMotionStreak(initialValue);
            motionState.setMotionState(initialValue);
            boolean detected = trips == motionState.getMotionState();
            double maxSpeed = 0.0;
            int startEventIndex = detected ? 0 : -1;
            int startNoEventIndex = -1;
            for (int i = 0; i < positions.size(); ++i) {
                boolean motion = this.isMoving(positions, i, tripsConfig);
                if (motionState.getMotionState() != motion) {
                    if (motion == trips) {
                        if (!detected) {
                            startEventIndex = i;
                            maxSpeed = positions.get(i).getSpeed();
                        }
                        startNoEventIndex = -1;
                    } else {
                        startNoEventIndex = i;
                    }
                } else {
                    maxSpeed = Math.max(maxSpeed, positions.get(i).getSpeed());
                }
                MotionProcessor.updateState(motionState, positions.get(i), motion, tripsConfig);
                if (motionState.getEvent() == null) continue;
                if (motion == trips) {
                    detected = true;
                    startNoEventIndex = -1;
                    continue;
                }
                if (startEventIndex < 0 || startNoEventIndex < 0) continue;
                result.add(this.calculateTripOrStop(device, positions.get(startEventIndex), positions.get(startNoEventIndex), maxSpeed, ignoreOdometer, reportClass));
                detected = false;
                startEventIndex = -1;
                startNoEventIndex = -1;
            }
            if (detected & startEventIndex >= 0 && startEventIndex < positions.size() - 1) {
                int endIndex = startNoEventIndex >= 0 ? startNoEventIndex : positions.size() - 1;
                result.add(this.calculateTripOrStop(device, positions.get(startEventIndex), positions.get(endIndex), maxSpeed, ignoreOdometer, reportClass));
            }
        }
        return result;
    }

    public <T extends BaseReportItem> List<T> fastTripsAndStops(Device device, Date from, Date to, Class<T> reportClass) throws StorageException {
        ArrayList<T> result = new ArrayList<T>();
        boolean ignoreOdometer = this.config.getBoolean(Keys.REPORT_IGNORE_ODOMETER);
        boolean trips = reportClass.equals(TripReportItem.class);
        Set<String> filter = Set.of("deviceMoving", "deviceStopped");
        List<Event> events = this.storage.getObjects(Event.class, new Request(new Columns.All(), new Condition.And(new Condition.Equals("deviceId", device.getId()), new Condition.Between("eventTime", "from", from, "to", to)), new Order("eventTime")));
        List filteredEvents = events.stream().filter(event -> filter.contains(event.getType())).collect(Collectors.toList());
        Event startEvent = null;
        for (Event event2 : filteredEvents) {
            boolean motion = event2.getType().equals("deviceMoving");
            if (motion == trips) {
                startEvent = event2;
                continue;
            }
            if (startEvent == null) continue;
            Position startPosition = this.storage.getObject(Position.class, new Request((Columns)new Columns.All(), new Condition.Equals("id", startEvent.getPositionId())));
            Position endPosition = this.storage.getObject(Position.class, new Request((Columns)new Columns.All(), new Condition.Equals("id", event2.getPositionId())));
            if (startPosition != null && endPosition != null) {
                result.add(this.calculateTripOrStop(device, startPosition, endPosition, 0.0, ignoreOdometer, reportClass));
            }
            startEvent = null;
        }
        return result;
    }
}

