/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.Date;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Checksum;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.DateUtil;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class TaipProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().groupBegin().expression("R[EP]V").groupBegin().number("(dd)").number("(dddd)").number("(d)").groupEnd("?").number("(d{5})").or().expression("(?:RGP|RCQ|RCV|RBR|RUS00),?").number("(dd)?").number("(dd)(dd)(dd)").number("(dd)(dd)(dd)").groupEnd().groupBegin().number("([-+]dd)(d{5})").number("([-+]ddd)(d{5})").or().number("([-+])(dd)(dd.dddd)").number("([-+])(ddd)(dd.dddd)").groupEnd().number("(ddd)").number("(ddd)").groupBegin().number("([023])").number("xx").number("(xx)").groupBegin().number(",d+").number(",(d+)").number(",(d{4})(d{4})").number(",(d+)").groupBegin().number(",([-+]?d+.?d*)").number(",([-+]?d+.?d*)").groupEnd("?").number(",(xx)").or().number("(dd)").number("(dd)").groupEnd().or().groupBegin().number("(xx)").number("(xx)").number("(ddd)").number("(x{8})").number("[01]").groupBegin().number("([023])").number("(dd)").number("dd").number("xxxx").number("[01]").number("[0-5]").number("(dd)").number("([-+]dddd)").number("xx").number("([-+]dddd)").number("xx").groupEnd("?").groupEnd("?").groupEnd().any().compile();

    public TaipProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private Date getTime(long week, long day, long seconds) {
        DateBuilder dateBuilder = new DateBuilder().setDate(1980, 1, 6).addMillis(((week * 7L + day) * 24L * 60L * 60L + seconds) * 1000L);
        return dateBuilder.getDate();
    }

    private Date getTime(long seconds) {
        DateBuilder dateBuilder = new DateBuilder(new Date()).setTime(0, 0, 0, 0).addMillis(seconds * 1000L);
        return DateUtil.correctDay(dateBuilder.getDate());
    }

    private String decodeAlarm(int value) {
        switch (value) {
            case 1: {
                return "sos";
            }
            case 2: {
                return "powerCut";
            }
        }
        return null;
    }

    private String decodeAlarm2(int value) {
        switch (value) {
            case 22: {
                return "hardAcceleration";
            }
            case 23: {
                return "hardBraking";
            }
            case 24: {
                return "accident";
            }
            case 26: 
            case 28: {
                return "hardCornering";
            }
        }
        return null;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser;
        String sentence = (String)msg;
        int beginIndex = sentence.indexOf(62);
        if (beginIndex != -1) {
            sentence = sentence.substring(beginIndex + 1);
        }
        if (!(parser = new Parser(PATTERN, sentence)).matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        Boolean valid = null;
        Integer event = null;
        if (parser.hasNext(3)) {
            event = parser.nextInt();
            position.setTime(this.getTime(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0)));
        } else if (parser.hasNext()) {
            position.setTime(this.getTime(parser.nextInt(0)));
        }
        if (parser.hasNext()) {
            event = parser.nextInt();
        }
        if (parser.hasNext(6)) {
            position.setTime(parser.nextDateTime(Parser.DateTimeFormat.DMY_HMS));
        }
        if (parser.hasNext(4)) {
            position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_DEG));
            position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_DEG));
        }
        if (parser.hasNext(6)) {
            position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG_MIN));
            position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG_MIN));
        }
        position.setSpeed(this.convertSpeed(parser.nextDouble(0.0), "mph"));
        position.setCourse(parser.nextDouble(0.0));
        if (parser.hasNext(2)) {
            valid = parser.nextInt() > 0;
            int input = parser.nextHexInt();
            position.set("ignition", BitUtil.check(input, 7));
            position.set("input", input);
        }
        if (parser.hasNext(7)) {
            position.set("odometer", parser.nextInt());
            position.set("power", (double)parser.nextInt().intValue() * 0.01);
            position.set("battery", (double)parser.nextInt().intValue() * 0.01);
            position.set("rpm", parser.nextInt());
            position.set("temp1", parser.nextDouble());
            position.set("temp2", parser.nextDouble());
            event = parser.nextHexInt();
        }
        if (parser.hasNext(2)) {
            event = parser.nextInt();
            position.set("hdop", parser.nextInt());
        }
        if (parser.hasNext(4)) {
            position.set("input", parser.nextHexInt(0));
            position.set("sat", parser.nextHexInt(0));
            position.set("battery", parser.nextInt(0));
            position.set("odometer", parser.nextLong(16, 0L));
        }
        if (parser.hasNext(4)) {
            valid = parser.nextInt() > 0;
            position.set("pdop", parser.nextInt());
            position.set("rssi", parser.nextInt());
            position.set("temp1", (double)parser.nextInt().intValue() * 0.01);
            position.set("temp2", (double)parser.nextInt().intValue() * 0.01);
        }
        position.setValid(valid == null || valid != false);
        if (event != null) {
            position.set("event", event);
            if (sentence.charAt(5) == ',') {
                position.set("alarm", this.decodeAlarm2(event));
            } else {
                position.set("alarm", this.decodeAlarm(event));
            }
        }
        String[] attributes = null;
        beginIndex = sentence.indexOf(59);
        if (beginIndex != -1) {
            int endIndex = sentence.indexOf(60, beginIndex);
            if (endIndex == -1) {
                endIndex = sentence.length();
            }
            attributes = sentence.substring(beginIndex, endIndex).split(";");
        }
        return this.decodeAttributes(channel, remoteAddress, position, attributes);
    }

    private Position decodeAttributes(Channel channel, SocketAddress remoteAddress, Position position, String[] attributes) {
        String uniqueId = null;
        DeviceSession deviceSession = null;
        String messageIndex = null;
        if (attributes != null) {
            block18: for (String attribute : attributes) {
                int index = attribute.indexOf(61);
                if (index != -1) {
                    String key = attribute.substring(0, index).toLowerCase();
                    String value = attribute.substring(index + 1);
                    switch (key) {
                        case "id": {
                            uniqueId = value;
                            deviceSession = this.getDeviceSession(channel, remoteAddress, value);
                            if (deviceSession == null) continue block18;
                            position.setDeviceId(deviceSession.getDeviceId());
                            break;
                        }
                        case "io": {
                            position.set("ignition", BitUtil.check(value.charAt(0) - 48, 0));
                            position.set("charge", BitUtil.check(value.charAt(0) - 48, 1));
                            position.set("output", value.charAt(1) - 48);
                            position.set("input", value.charAt(2) - 48);
                            break;
                        }
                        case "ix": {
                            position.set("io1", value);
                            break;
                        }
                        case "ad": {
                            position.set("adc1", Integer.parseInt(value));
                            break;
                        }
                        case "sv": {
                            position.set("sat", Integer.parseInt(value));
                            break;
                        }
                        case "bl": {
                            position.set("battery", (double)Integer.parseInt(value) * 0.001);
                            break;
                        }
                        case "vo": {
                            position.set("odometer", Long.parseLong(value));
                            break;
                        }
                        default: {
                            position.set(key, value);
                            break;
                        }
                    }
                    continue;
                }
                if (!attribute.startsWith("#")) continue;
                messageIndex = attribute;
            }
        }
        if (deviceSession != null) {
            if (channel != null) {
                if (messageIndex != null) {
                    String response;
                    if (messageIndex.startsWith("#IP")) {
                        response = ">SAK;ID=" + uniqueId + ";" + messageIndex + "<";
                    } else {
                        response = ">ACK;ID=" + uniqueId + ";" + messageIndex + ";*";
                        response = response + String.format("%02X", Checksum.xor(response)) + "<";
                    }
                    channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
                } else {
                    channel.writeAndFlush((Object)new NetworkMessage(uniqueId, remoteAddress));
                }
            }
            return position;
        }
        return null;
    }
}

