/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import java.util.Date;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.config.Keys;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.helper.model.AttributeUtil;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class T55ProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN_GPRMC = new PatternBuilder().text("$GPRMC,").number("(dd)(dd)(dd).?d*,").expression("([AV]),").number("(dd)(dd.d+),").expression("([NS]),").number("(d{2,3})(dd.d+),").expression("([EW]),").number("(d+.?d*)?,").number("(d+.?d*)?,").number("(dd)(dd)(dd),").expression("[^*]+").text("*").expression("[^,]+").number(",(d+)").number(",(d+)").expression(",([01])").number(",(d+)").number(",(d+)").optional(7).number("((?:,d+)+)?").any().compile();
    private static final Pattern PATTERN_GPGGA = new PatternBuilder().text("$GPGGA,").number("(dd)(dd)(dd).?d*,").number("(d+)(dd.d+),").expression("([NS]),").number("(d+)(dd.d+),").expression("([EW]),").any().compile();
    private static final Pattern PATTERN_GPRMA = new PatternBuilder().text("$GPRMA,").expression("([AV]),").number("(dd)(dd.d+),").expression("([NS]),").number("(ddd)(dd.d+),").expression("([EW]),,,").number("(d+.?d*)?,").number("(d+.?d*)?,").any().compile();
    private static final Pattern PATTERN_TRCCR = new PatternBuilder().text("$TRCCR,").number("(dddd)(dd)(dd)").number("(dd)(dd)(dd).?d*,").expression("([AV]),").number("(-?d+.d+),").number("(-?d+.d+),").number("(d+.d+),").number("(d+.d+),").number("(-?d+.d+),").number("(d+.?d*),").any().compile();
    private static final Pattern PATTERN_GPIOP = new PatternBuilder().text("$GPIOP,").number("[01]{8},").number("[01]{8},").number("d+.d+,").number("d+.d+,").number("d+.d+,").number("d+.d+,").number("(d+.d+),").number("(d+.d+)").any().compile();
    private static final Pattern PATTERN_QZE = new PatternBuilder().text("QZE,").number("(d{15}),").number("(d+),").number("(dd)(dd)(dddd),").number("(dd)(dd)(dd),").number("(-?d+.d+),").number("(-?d+.d+),").number("(d+),").number("(d+),").expression("([AV]),").expression("([01])").compile();
    private static final Pattern PATTERN_PUBX = new PatternBuilder().text("$PUBX,").number("(d+),").number("(dd)(dd)(dd).d+,").number("(dd)(dd.d+),([NS]),").number("(ddd)(dd.d+),([EW]),").number("(-?d+.d+),").expression("(..),").number("(d+.d+),").number("d+.d+,").number("(d+.d+),").number("(d+.d+),").number("-?d+.d+,").expression("[^,]*,").number("(d+.d+),").number("(d+.d+),").number("d+.d+,").number("(d+),").number("(d+),").number("d+").text("*").number("xx").compile();
    private static final Pattern PATTERN_GPTXT = new PatternBuilder().text("$GPTXT,").text("NET,").number("(d+),").expression("([^,]+),").number("(-d+),").number("(d+) ").number("(d+)").text("*").number("xx").compile();
    private Position position = null;

    public T55ProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private Position decodeGprmc(DeviceSession deviceSession, String sentence, SocketAddress remoteAddress, Channel channel) {
        Parser parser;
        boolean ack;
        if (deviceSession != null && channel != null && !(channel instanceof DatagramChannel) && (ack = AttributeUtil.lookup(this.getCacheManager(), Keys.PROTOCOL_ACK.withPrefix(this.getProtocolName()), deviceSession.getDeviceId()).booleanValue())) {
            channel.writeAndFlush((Object)new NetworkMessage("OK1\r\n", remoteAddress));
        }
        if (!(parser = new Parser(PATTERN_GPRMC, sentence)).matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        if (deviceSession != null) {
            position.setDeviceId(deviceSession.getDeviceId());
        }
        DateBuilder dateBuilder = new DateBuilder().setTime(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
        position.setValid(parser.next().equals("A"));
        position.setLatitude(parser.nextCoordinate());
        position.setLongitude(parser.nextCoordinate());
        position.setSpeed(parser.nextDouble(0.0));
        position.setCourse(parser.nextDouble(0.0));
        dateBuilder.setDateReverse(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
        position.setTime(dateBuilder.getDate());
        if (parser.hasNext(5)) {
            position.set("sat", parser.nextInt());
            deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
            if (deviceSession == null) {
                return null;
            }
            position.setDeviceId(deviceSession.getDeviceId());
            position.set("ignition", parser.hasNext() && parser.next().equals("1"));
            position.set("fuel", parser.nextInt(0));
            position.set("battery", parser.nextInt());
        }
        if (parser.hasNext()) {
            String[] parameters = parser.next().split(",");
            for (int i = 1; i < parameters.length; ++i) {
                position.set("io" + i, parameters[i]);
            }
        }
        if (deviceSession != null) {
            return position;
        }
        this.position = position;
        return null;
    }

    private Position decodeGpgga(DeviceSession deviceSession, String sentence) {
        Parser parser = new Parser(PATTERN_GPGGA, sentence);
        if (!parser.matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        DateBuilder dateBuilder = new DateBuilder().setCurrentDate().setTime(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
        position.setTime(dateBuilder.getDate());
        position.setValid(true);
        position.setLatitude(parser.nextCoordinate());
        position.setLongitude(parser.nextCoordinate());
        return position;
    }

    private Position decodeGprma(DeviceSession deviceSession, String sentence) {
        Parser parser = new Parser(PATTERN_GPRMA, sentence);
        if (!parser.matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setTime(new Date());
        position.setValid(parser.next().equals("A"));
        position.setLatitude(parser.nextCoordinate());
        position.setLongitude(parser.nextCoordinate());
        position.setSpeed(parser.nextDouble(0.0));
        position.setCourse(parser.nextDouble(0.0));
        return position;
    }

    private Position decodeTrccr(DeviceSession deviceSession, String sentence) {
        Parser parser = new Parser(PATTERN_TRCCR, sentence);
        if (!parser.matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setTime(parser.nextDateTime());
        position.setValid(parser.next().equals("A"));
        position.setLatitude(parser.nextDouble(0.0));
        position.setLongitude(parser.nextDouble(0.0));
        position.setSpeed(parser.nextDouble(0.0));
        position.setCourse(parser.nextDouble(0.0));
        position.setAltitude(parser.nextDouble(0.0));
        position.set("battery", parser.nextDouble(0.0));
        return position;
    }

    private Position decodeGpiop(DeviceSession deviceSession, String sentence) {
        Parser parser = new Parser(PATTERN_GPIOP, sentence);
        if (!parser.matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        this.getLastLocation(position, null);
        position.set("power", parser.nextDouble());
        position.set("battery", parser.nextDouble());
        return position;
    }

    private Position decodeQze(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser = new Parser(PATTERN_QZE, sentence);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("event", parser.nextInt());
        position.setTime(parser.nextDateTime(Parser.DateTimeFormat.DMY_HMS));
        position.setLatitude(parser.nextDouble());
        position.setLongitude(parser.nextDouble());
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextInt().intValue()));
        position.setCourse(parser.nextInt().intValue());
        position.setValid(parser.next().equals("A"));
        position.set("ignition", parser.nextInt() > 0);
        return position;
    }

    private Position decodeGptxt(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser = new Parser(PATTERN_GPTXT, sentence);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        this.getLastLocation(position, null);
        position.set("operator", parser.next());
        position.set("rssi", parser.nextInt());
        position.set("mcc", parser.nextInt());
        position.set("mnc", parser.nextInt());
        return position;
    }

    private Position decodePubx(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser = new Parser(PATTERN_PUBX, sentence);
        if (!parser.matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.set("index", parser.nextInt());
        position.setTime(parser.nextDateTime(Parser.DateTimeFormat.HMS));
        position.setLatitude(parser.nextCoordinate());
        position.setLongitude(parser.nextCoordinate());
        position.setAltitude(parser.nextDouble());
        position.setValid(!parser.next().equals("NF"));
        position.setAccuracy(parser.nextDouble());
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble()));
        position.setCourse(parser.nextDouble());
        position.set("hdop", parser.nextDouble());
        position.set("vdop", parser.nextDouble());
        position.set("sat", parser.nextInt());
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession != null) {
            position.setDeviceId(deviceSession.getDeviceId());
            return position;
        }
        return null;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        DeviceSession deviceSession;
        String sentence = ((String)msg).trim();
        if (!sentence.startsWith("$") && sentence.contains("$")) {
            int index = sentence.indexOf("$");
            String id = sentence.substring(0, index);
            if (id.endsWith(",")) {
                id = id.substring(0, id.length() - 1);
            } else if (id.endsWith("/")) {
                id = id.substring(id.indexOf(47) + 1, id.length() - 1);
            }
            deviceSession = this.getDeviceSession(channel, remoteAddress, id);
            sentence = sentence.substring(index);
        } else {
            deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
            if (deviceSession == null && remoteAddress instanceof InetSocketAddress) {
                String host = ((InetSocketAddress)remoteAddress).getHostString();
                deviceSession = this.getDeviceSession(channel, remoteAddress, host);
            }
        }
        if (sentence.startsWith("$PGID")) {
            this.getDeviceSession(channel, remoteAddress, sentence.substring(6, sentence.length() - 3));
        } else if (sentence.startsWith("$DEVID")) {
            this.getDeviceSession(channel, remoteAddress, sentence.substring(7, sentence.lastIndexOf(42)));
        } else if (sentence.startsWith("$PCPTI")) {
            this.getDeviceSession(channel, remoteAddress, sentence.substring(7, sentence.indexOf(",", 7)));
        } else if (sentence.startsWith("IMEI")) {
            this.getDeviceSession(channel, remoteAddress, sentence.substring(5));
        } else if (sentence.startsWith("$IMEI")) {
            this.getDeviceSession(channel, remoteAddress, sentence.substring(6));
        } else if (sentence.startsWith("$GPFID")) {
            deviceSession = this.getDeviceSession(channel, remoteAddress, sentence.substring(7));
            if (deviceSession != null && this.position != null) {
                Position position = this.position;
                position.setDeviceId(deviceSession.getDeviceId());
                this.position = null;
                return position;
            }
        } else if (sentence.matches("^[0-9A-F]+$")) {
            this.getDeviceSession(channel, remoteAddress, sentence);
        } else {
            if (sentence.startsWith("$GPRMC")) {
                return this.decodeGprmc(deviceSession, sentence, remoteAddress, channel);
            }
            if (sentence.startsWith("$GPGGA") && deviceSession != null) {
                return this.decodeGpgga(deviceSession, sentence);
            }
            if (sentence.startsWith("$GPRMA") && deviceSession != null) {
                return this.decodeGprma(deviceSession, sentence);
            }
            if (sentence.startsWith("$TRCCR") && deviceSession != null) {
                return this.decodeTrccr(deviceSession, sentence);
            }
            if (sentence.startsWith("$GPIOP")) {
                return this.decodeGpiop(deviceSession, sentence);
            }
            if (sentence.startsWith("QZE")) {
                return this.decodeQze(channel, remoteAddress, sentence);
            }
            if (sentence.startsWith("$PUBX")) {
                return this.decodePubx(channel, remoteAddress, sentence);
            }
            if (sentence.startsWith("$GPTXT")) {
                return this.decodeGptxt(channel, remoteAddress, sentence);
            }
        }
        return null;
    }
}

