/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator.extension;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.ECPointFormat;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ECPointFormatExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.ECPointFormatExtensionSerializer;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.io.ByteArrayOutputStream;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ECPointFormatExtensionPreparator
extends ExtensionPreparator<ECPointFormatExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ECPointFormatExtensionMessage msg;

    public ECPointFormatExtensionPreparator(Chooser chooser, ECPointFormatExtensionMessage message, ECPointFormatExtensionSerializer serializer) {
        super(chooser, message, serializer);
        this.msg = message;
    }

    @Override
    public void prepareExtensionContent() {
        LOGGER.debug("Preparing ECPointFormatExtensionMessage");
        this.preparePointFormats(this.msg);
        this.preparePointFormatsLength(this.msg);
    }

    private void preparePointFormats(ECPointFormatExtensionMessage msg) {
        msg.setPointFormats(this.createPointFormatsByteArray());
        LOGGER.debug("PointFormats: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getPointFormats().getValue())));
    }

    private byte[] createPointFormatsByteArray() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        List<ECPointFormat> pointFormatList = this.chooser.getConnectionEndType() == ConnectionEndType.CLIENT ? this.chooser.getClientSupportedPointFormats() : this.chooser.getServerSupportedPointFormats();
        for (ECPointFormat format : pointFormatList) {
            stream.write(format.getValue());
        }
        return stream.toByteArray();
    }

    private void preparePointFormatsLength(ECPointFormatExtensionMessage msg) {
        msg.setPointFormatsLength(((byte[])msg.getPointFormats().getValue()).length);
        LOGGER.debug("PointFormatsLength: " + msg.getPointFormatsLength().getValue());
    }
}

