/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.StringUtils;
import org.apache.solr.common.annotation.JsonProperty;
import org.apache.solr.common.cloud.BeforeReconnect;
import org.apache.solr.common.cloud.ConnectionManager;
import org.apache.solr.common.cloud.DefaultConnectionStrategy;
import org.apache.solr.common.cloud.DefaultZkACLProvider;
import org.apache.solr.common.cloud.DefaultZkCredentialsInjector;
import org.apache.solr.common.cloud.DefaultZkCredentialsProvider;
import org.apache.solr.common.cloud.OnReconnect;
import org.apache.solr.common.cloud.ZkACLProvider;
import org.apache.solr.common.cloud.ZkClientConnectionStrategy;
import org.apache.solr.common.cloud.ZkCmdExecutor;
import org.apache.solr.common.cloud.ZkCredentialsInjector;
import org.apache.solr.common.cloud.ZkCredentialsProvider;
import org.apache.solr.common.cloud.ZkMaintenanceUtils;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.util.Compressor;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.ObjectReleaseTracker;
import org.apache.solr.common.util.ReflectMapWriter;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.common.util.ZLibCompressor;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrZkClient
implements Closeable {
    static final String NEWL = System.getProperty("line.separator");
    static final int DEFAULT_CLIENT_CONNECT_TIMEOUT = 30000;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ConnectionManager connManager;
    private volatile ZooKeeper keeper;
    private ZkCmdExecutor zkCmdExecutor;
    private final ZkMetrics metrics = new ZkMetrics();
    private Compressor compressor;
    private final ExecutorService zkCallbackExecutor = ExecutorUtil.newMDCAwareCachedThreadPool((ThreadFactory)new SolrNamedThreadFactory("zkCallback"));
    private final ExecutorService zkConnManagerCallbackExecutor = ExecutorUtil.newMDCAwareSingleThreadExecutor((ThreadFactory)new SolrNamedThreadFactory("zkConnectionManagerCallback"));
    private volatile boolean isClosed = false;
    private ZkClientConnectionStrategy zkClientConnectionStrategy;
    private int zkClientTimeout;
    private ZkACLProvider zkACLProvider;
    private ZkCredentialsInjector zkCredentialsInjector;
    private String zkServerAddress;
    private ConnectionManager.IsClosed higherLevelIsClosed;
    public static final String ZK_CRED_PROVIDER_CLASS_NAME_VM_PARAM_NAME = "zkCredentialsProvider";
    public static final String ZK_ACL_PROVIDER_CLASS_NAME_VM_PARAM_NAME = "zkACLProvider";
    public static final String ZK_CREDENTIALS_INJECTOR_CLASS_NAME_VM_PARAM_NAME = "zkCredentialsInjector";

    public MapWriter getMetrics() {
        return this.metrics::writeMap;
    }

    public int getZkClientTimeout() {
        return this.zkClientTimeout;
    }

    public SolrZkClient(Builder builder) {
        this(builder.zkServerAddress, builder.zkClientTimeout, builder.zkClientConnectTimeout, builder.connectionStrategy, builder.onReconnect, builder.beforeReconnect, builder.zkACLProvider, builder.higherLevelIsClosed, builder.compressor);
    }

    private SolrZkClient(String zkServerAddress, int zkClientTimeout, int clientConnectTimeout, ZkClientConnectionStrategy strat, OnReconnect onReconnect, BeforeReconnect beforeReconnect, ZkACLProvider zkACLProvider, ConnectionManager.IsClosed higherLevelIsClosed, Compressor compressor) {
        if (zkServerAddress == null) {
            return;
        }
        this.zkServerAddress = zkServerAddress;
        this.higherLevelIsClosed = higherLevelIsClosed;
        if (strat == null) {
            String connectionStrategy = System.getProperty("solr.zookeeper.connectionStrategy");
            strat = ZkClientConnectionStrategy.forName(connectionStrategy, new DefaultConnectionStrategy());
        }
        this.zkClientConnectionStrategy = strat;
        if (!strat.hasZkCredentialsToAddAutomatically()) {
            this.zkCredentialsInjector = this.createZkCredentialsInjector();
            ZkCredentialsProvider zkCredentialsToAddAutomatically = this.createZkCredentialsToAddAutomatically();
            strat.setZkCredentialsToAddAutomatically(zkCredentialsToAddAutomatically);
        }
        this.zkClientTimeout = zkClientTimeout;
        this.zkCmdExecutor = new ZkCmdExecutor(zkClientTimeout, this::isClosed);
        this.connManager = new ConnectionManager("ZooKeeperConnection Watcher:" + zkServerAddress, this, zkServerAddress, strat, onReconnect, beforeReconnect, this::isClosed);
        try {
            strat.connect(zkServerAddress, zkClientTimeout, this.wrapWatcher(this.connManager), zooKeeper -> {
                ZooKeeper oldKeeper = this.keeper;
                this.keeper = zooKeeper;
                try {
                    this.closeKeeper(oldKeeper);
                }
                finally {
                    if (this.isClosed) {
                        this.closeKeeper(this.keeper);
                    }
                }
            });
        }
        catch (Exception e) {
            this.connManager.close();
            if (this.keeper != null) {
                try {
                    this.keeper.close();
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        try {
            this.connManager.waitForConnected(clientConnectTimeout);
        }
        catch (Exception e) {
            this.connManager.close();
            try {
                this.keeper.close();
            }
            catch (InterruptedException e1) {
                Thread.currentThread().interrupt();
            }
            this.zkConnManagerCallbackExecutor.shutdown();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        assert (ObjectReleaseTracker.track((Object)this));
        this.zkACLProvider = zkACLProvider == null ? this.createZkACLProvider() : zkACLProvider;
        this.compressor = compressor == null ? new ZLibCompressor() : compressor;
    }

    public ConnectionManager getConnectionManager() {
        return this.connManager;
    }

    public ZkClientConnectionStrategy getZkClientConnectionStrategy() {
        return this.zkClientConnectionStrategy;
    }

    protected ZkCredentialsProvider createZkCredentialsToAddAutomatically() {
        String zkCredentialsProviderClassName = System.getProperty(ZK_CRED_PROVIDER_CLASS_NAME_VM_PARAM_NAME);
        if (!StringUtils.isEmpty((String)zkCredentialsProviderClassName)) {
            try {
                log.info("Using ZkCredentialsProvider: {}", (Object)zkCredentialsProviderClassName);
                ZkCredentialsProvider zkCredentialsProvider = Class.forName(zkCredentialsProviderClassName).asSubclass(ZkCredentialsProvider.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                zkCredentialsProvider.setZkCredentialsInjector(this.zkCredentialsInjector);
                return zkCredentialsProvider;
            }
            catch (Exception e) {
                log.warn("VM param zkCredentialsProvider does not point to a class implementing ZkCredentialsProvider and with a non-arg constructor", (Throwable)e);
            }
        }
        log.debug("Using default ZkCredentialsProvider");
        return new DefaultZkCredentialsProvider();
    }

    protected ZkACLProvider createZkACLProvider() {
        String zkACLProviderClassName = System.getProperty(ZK_ACL_PROVIDER_CLASS_NAME_VM_PARAM_NAME);
        if (!StringUtils.isEmpty((String)zkACLProviderClassName)) {
            try {
                log.info("Using ZkACLProvider: {}", (Object)zkACLProviderClassName);
                ZkACLProvider zkACLProvider = Class.forName(zkACLProviderClassName).asSubclass(ZkACLProvider.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                zkACLProvider.setZkCredentialsInjector(this.zkCredentialsInjector);
                return zkACLProvider;
            }
            catch (Exception e) {
                log.warn("VM param zkACLProvider does not point to a class implementing ZkACLProvider and with a non-arg constructor", (Throwable)e);
            }
        }
        log.warn("Using default ZkACLProvider. DefaultZkACLProvider is not secure, it creates 'OPEN_ACL_UNSAFE' ACLs to Zookeeper nodes");
        return new DefaultZkACLProvider();
    }

    protected ZkCredentialsInjector createZkCredentialsInjector() {
        String zkCredentialsInjectorClassName = System.getProperty(ZK_CREDENTIALS_INJECTOR_CLASS_NAME_VM_PARAM_NAME);
        if (!StringUtils.isEmpty((String)zkCredentialsInjectorClassName)) {
            try {
                log.info("Using ZkCredentialsInjector: {}", (Object)zkCredentialsInjectorClassName);
                return Class.forName(zkCredentialsInjectorClassName).asSubclass(ZkCredentialsInjector.class).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                log.warn("VM param ZkCredentialsInjector does not point to a class implementing ZkCredentialsInjector and with a non-arg constructor", (Throwable)e);
            }
        }
        log.warn("Using default ZkCredentialsInjector. ZkCredentialsInjector is not secure, it creates an empty list of credentials which leads to 'OPEN_ACL_UNSAFE' ACLs to Zookeeper nodes");
        return new DefaultZkCredentialsInjector();
    }

    public boolean isConnected() {
        return this.keeper != null && this.keeper.getState() == ZooKeeper.States.CONNECTED;
    }

    public void delete(String path, int version, boolean retryOnConnLoss) throws InterruptedException, KeeperException {
        if (retryOnConnLoss) {
            this.zkCmdExecutor.retryOperation(() -> {
                this.keeper.delete(path, version);
                return null;
            });
        } else {
            this.keeper.delete(path, version);
        }
        this.metrics.deletes.increment();
    }

    public Watcher wrapWatcher(Watcher watcher) {
        if (watcher == null || watcher instanceof ProcessWatchWithExecutor) {
            return watcher;
        }
        return new ProcessWatchWithExecutor(watcher);
    }

    public Stat exists(String path, Watcher watcher, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        Stat result = null;
        result = retryOnConnLoss ? this.zkCmdExecutor.retryOperation(() -> this.keeper.exists(path, this.wrapWatcher(watcher))) : this.keeper.exists(path, this.wrapWatcher(watcher));
        this.metrics.existsChecks.increment();
        return result;
    }

    public Boolean exists(String path, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        Boolean result = null;
        result = retryOnConnLoss ? this.zkCmdExecutor.retryOperation(() -> this.keeper.exists(path, null) != null) : Boolean.valueOf(this.keeper.exists(path, null) != null);
        this.metrics.existsChecks.increment();
        return result;
    }

    public List<String> getChildren(String path, Watcher watcher, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        List result = null;
        if (retryOnConnLoss) {
            return this.zkCmdExecutor.retryOperation(() -> this.keeper.getChildren(path, this.wrapWatcher(watcher)));
        }
        result = this.keeper.getChildren(path, this.wrapWatcher(watcher));
        this.metrics.childFetches.increment();
        if (result != null) {
            this.metrics.cumulativeChildrenFetched.add(result.size());
        }
        return result;
    }

    public List<String> getChildren(String path, Watcher watcher, Stat stat, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        List result = null;
        result = retryOnConnLoss ? this.zkCmdExecutor.retryOperation(() -> this.keeper.getChildren(path, this.wrapWatcher(watcher), stat)) : this.keeper.getChildren(path, this.wrapWatcher(watcher), stat);
        this.metrics.childFetches.increment();
        if (result != null) {
            this.metrics.cumulativeChildrenFetched.add(result.size());
        }
        return result;
    }

    public byte[] getData(String path, Watcher watcher, Stat stat, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        byte[] result = null;
        result = retryOnConnLoss ? this.zkCmdExecutor.retryOperation(() -> this.keeper.getData(path, this.wrapWatcher(watcher), stat)) : this.keeper.getData(path, this.wrapWatcher(watcher), stat);
        if (this.compressor.isCompressedBytes(result)) {
            log.debug("Zookeeper data at path {} is compressed", (Object)path);
            try {
                result = this.compressor.decompressBytes(result);
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, String.format(Locale.ROOT, "Unable to decompress data at path: %s from zookeeper", path), (Throwable)e);
            }
        }
        this.metrics.reads.increment();
        if (result != null) {
            this.metrics.bytesRead.add(result.length);
        }
        return result;
    }

    public NodeData getNode(String path, Watcher watcher, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        Stat stat = new Stat();
        return new NodeData(stat, this.getData(path, watcher, stat, retryOnConnLoss));
    }

    public Stat setData(String path, byte[] data, int version, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        Stat result = null;
        result = retryOnConnLoss ? this.zkCmdExecutor.retryOperation(() -> this.keeper.setData(path, data, version)) : this.keeper.setData(path, data, version);
        this.metrics.writes.increment();
        if (data != null) {
            this.metrics.bytesWritten.add(data.length);
        }
        return result;
    }

    public void atomicUpdate(String path, Function<byte[], byte[]> editor) throws KeeperException, InterruptedException {
        this.atomicUpdate(path, (Stat stat, byte[] bytes) -> (byte[])editor.apply((byte[])bytes));
    }

    public void atomicUpdate(String path, BiFunction<Stat, byte[], byte[]> editor) throws KeeperException, InterruptedException {
        while (true) {
            byte[] modified = null;
            byte[] zkData = null;
            Stat s = new Stat();
            try {
                if (this.exists(path, true).booleanValue()) {
                    zkData = this.getData(path, null, s, true);
                    modified = editor.apply(s, zkData);
                    if (modified == null) {
                        return;
                    }
                    this.setData(path, modified, s.getVersion(), true);
                    break;
                }
                modified = editor.apply(s, null);
                if (modified == null) {
                    return;
                }
                this.create(path, modified, CreateMode.PERSISTENT, true);
            }
            catch (KeeperException.BadVersionException | KeeperException.NodeExistsException e) {
                continue;
            }
            break;
        }
    }

    public String create(String path, byte[] data, CreateMode createMode, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        String result = null;
        if (retryOnConnLoss) {
            result = this.zkCmdExecutor.retryOperation(() -> this.keeper.create(path, data, this.zkACLProvider.getACLsToAdd(path), createMode));
        } else {
            List<ACL> acls = this.zkACLProvider.getACLsToAdd(path);
            result = this.keeper.create(path, data, acls, createMode);
        }
        this.metrics.writes.increment();
        if (data != null) {
            this.metrics.bytesWritten.add(data.length);
        }
        return result;
    }

    public void makePath(String path, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        this.makePath(path, null, CreateMode.PERSISTENT, retryOnConnLoss);
    }

    public void makePath(String path, boolean failOnExists, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        this.makePath(path, null, CreateMode.PERSISTENT, null, failOnExists, retryOnConnLoss, 0);
    }

    public void makePath(String path, Path data, boolean failOnExists, boolean retryOnConnLoss) throws IOException, KeeperException, InterruptedException {
        this.makePath(path, Files.readAllBytes(data), CreateMode.PERSISTENT, null, failOnExists, retryOnConnLoss, 0);
    }

    public void makePath(String path, Path data, boolean retryOnConnLoss) throws IOException, KeeperException, InterruptedException {
        this.makePath(path, Files.readAllBytes(data), retryOnConnLoss);
    }

    public void makePath(String path, CreateMode createMode, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        this.makePath(path, null, createMode, retryOnConnLoss);
    }

    public void makePath(String path, byte[] data, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        this.makePath(path, data, CreateMode.PERSISTENT, retryOnConnLoss);
    }

    public void makePath(String path, byte[] data, CreateMode createMode, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        this.makePath(path, data, createMode, null, retryOnConnLoss);
    }

    public void makePath(String path, byte[] data, CreateMode createMode, Watcher watcher, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        this.makePath(path, data, createMode, watcher, true, retryOnConnLoss, 0);
    }

    public void makePath(String path, byte[] data, CreateMode createMode, Watcher watcher, boolean failOnExists, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        this.makePath(path, data, createMode, watcher, failOnExists, retryOnConnLoss, 0);
    }

    public void makePath(String path, byte[] data, CreateMode createMode, Watcher watcher, boolean failOnExists, boolean retryOnConnLoss, int skipPathParts) throws KeeperException, InterruptedException {
        log.debug("makePath: {}", (Object)path);
        this.metrics.writes.increment();
        if (data != null) {
            this.metrics.bytesWritten.add(data.length);
        }
        boolean retry = true;
        if (path.startsWith("/")) {
            path = path.substring(1, path.length());
        }
        String[] paths = path.split("/");
        StringBuilder sbPath = new StringBuilder();
        for (int i = 0; i < paths.length; ++i) {
            String pathPiece = paths[i];
            sbPath.append("/").append(pathPiece);
            if (i < skipPathParts) continue;
            byte[] bytes = null;
            String currentPath = sbPath.toString();
            CreateMode mode = CreateMode.PERSISTENT;
            if (i == paths.length - 1) {
                mode = createMode;
                bytes = data;
                if (!retryOnConnLoss) {
                    retry = false;
                }
            }
            try {
                if (retry) {
                    CreateMode finalMode = mode;
                    byte[] finalBytes = bytes;
                    this.zkCmdExecutor.retryOperation(() -> {
                        this.keeper.create(currentPath, finalBytes, this.zkACLProvider.getACLsToAdd(currentPath), finalMode);
                        return null;
                    });
                    continue;
                }
                this.keeper.create(currentPath, bytes, this.zkACLProvider.getACLsToAdd(currentPath), mode);
                continue;
            }
            catch (KeeperException.NoAuthException e) {
                if (i != paths.length - 1 && this.exists(currentPath, retryOnConnLoss).booleanValue()) continue;
                throw e;
            }
            catch (KeeperException.NodeExistsException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Node exists: {}", (Object)e.getPath());
                }
                if (!failOnExists && i == paths.length - 1) {
                    this.setData(currentPath, data, -1, retryOnConnLoss);
                    this.exists(currentPath, watcher, retryOnConnLoss);
                    return;
                }
                if (i != paths.length - 1) continue;
                throw e;
            }
        }
    }

    public void makePath(String zkPath, CreateMode createMode, Watcher watcher, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        this.makePath(zkPath, null, createMode, watcher, retryOnConnLoss);
    }

    public Stat setData(String path, byte[] data, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        return this.setData(path, data, -1, retryOnConnLoss);
    }

    public Stat setData(String path, Path data, boolean retryOnConnLoss) throws IOException, KeeperException, InterruptedException {
        if (log.isDebugEnabled()) {
            log.debug("Write to ZooKeeper: {} to {}", (Object)data.toAbsolutePath(), (Object)path);
        }
        return this.setData(path, Files.readAllBytes(data), retryOnConnLoss);
    }

    public List<OpResult> multi(Iterable<Op> ops, boolean retryOnConnLoss) throws InterruptedException, KeeperException {
        List result = null;
        result = retryOnConnLoss ? this.zkCmdExecutor.retryOperation(() -> this.keeper.multi(ops)) : this.keeper.multi(ops);
        this.metrics.multiOps.increment();
        if (result != null) {
            this.metrics.cumulativeMultiOps.add(result.size());
        }
        return result;
    }

    public void printLayout(String path, int indent, StringBuilder string) throws KeeperException, InterruptedException {
        byte[] data = this.getData(path, null, null, true);
        List<String> children = this.getChildren(path, null, true);
        StringBuilder dent = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            dent.append(" ");
        }
        string.append((CharSequence)dent).append(path).append(" (").append(children.size()).append(")").append(NEWL);
        if (data != null) {
            String dataString = new String(data, StandardCharsets.UTF_8);
            if (!path.endsWith(".txt") && !path.endsWith(".xml")) {
                string.append((CharSequence)dent).append("DATA:\n").append((CharSequence)dent).append("    ").append(dataString.replaceAll("\n", "\n" + dent + "    ")).append(NEWL);
            } else {
                string.append((CharSequence)dent).append("DATA: ...supressed...").append(NEWL);
            }
        }
        for (String child : children) {
            if (child.equals("quota")) continue;
            try {
                this.printLayout(path + (path.equals("/") ? "" : "/") + child, indent + 1, string);
            }
            catch (KeeperException.NoNodeException noNodeException) {}
        }
    }

    public void printLayoutToStream(PrintStream out) throws KeeperException, InterruptedException {
        StringBuilder sb = new StringBuilder();
        this.printLayout("/", 0, sb);
        out.println(sb.toString());
    }

    @Override
    public void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        try {
            this.closeCallbackExecutor();
        }
        finally {
            this.connManager.close();
            this.closeKeeper(this.keeper);
        }
        assert (ObjectReleaseTracker.release((Object)this));
    }

    public boolean isClosed() {
        return this.isClosed || this.higherLevelIsClosed != null && this.higherLevelIsClosed.isClosed();
    }

    void updateKeeper(ZooKeeper keeper) throws InterruptedException {
        ZooKeeper oldKeeper = this.keeper;
        this.keeper = keeper;
        if (oldKeeper != null) {
            oldKeeper.close();
        }
        if (this.isClosed) {
            this.keeper.close();
        }
    }

    public ZooKeeper getZooKeeper() {
        return this.keeper;
    }

    private void closeKeeper(ZooKeeper keeper) {
        if (keeper != null) {
            try {
                keeper.close();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error("", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", e);
            }
        }
    }

    private void closeCallbackExecutor() {
        try {
            ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.zkCallbackExecutor);
        }
        catch (Exception e) {
            SolrException.log((Logger)log, (Throwable)e);
        }
        try {
            ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.zkConnManagerCallbackExecutor);
        }
        catch (Exception e) {
            SolrException.log((Logger)log, (Throwable)e);
        }
    }

    public static boolean containsChroot(String zkHost) {
        return zkHost.contains("/");
    }

    public static Throwable checkInterrupted(Throwable e) {
        if (e instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        return e;
    }

    public String getZkServerAddress() {
        return this.zkServerAddress;
    }

    public String getConfig() {
        try {
            Stat stat = new Stat();
            this.keeper.sync("/zookeeper/config", null, null);
            byte[] data = this.keeper.getConfig(false, stat);
            if (data == null || data.length == 0) {
                return "";
            }
            return new String(data, StandardCharsets.UTF_8);
        }
        catch (KeeperException.NoNodeException nne) {
            log.debug("Zookeeper does not have the /zookeeper/config znode, assuming old ZK version");
            return "";
        }
        catch (InterruptedException | KeeperException ex) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to get config from zookeeper", ex);
        }
    }

    public ZkACLProvider getZkACLProvider() {
        return this.zkACLProvider;
    }

    public List<ACL> getACL(String path, Stat stat, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        if (retryOnConnLoss) {
            return this.zkCmdExecutor.retryOperation(() -> this.keeper.getACL(path, stat));
        }
        return this.keeper.getACL(path, stat);
    }

    public Stat setACL(String path, List<ACL> acls, boolean retryOnConnLoss) throws InterruptedException, KeeperException {
        if (retryOnConnLoss) {
            return this.zkCmdExecutor.retryOperation(() -> this.keeper.setACL(path, acls, -1));
        }
        return this.keeper.setACL(path, acls, -1);
    }

    public void updateACLs(String root) throws KeeperException, InterruptedException {
        ZkMaintenanceUtils.traverseZkTree(this, root, ZkMaintenanceUtils.VISIT_ORDER.VISIT_POST, path -> {
            try {
                this.setACL(path, this.getZkACLProvider().getACLsToAdd(path), true);
                log.debug("Updated ACL on {}", (Object)path);
            }
            catch (KeeperException.NoNodeException noNodeException) {
                // empty catch block
            }
        });
    }

    public void clean(String path) throws InterruptedException, KeeperException {
        ZkMaintenanceUtils.clean(this, path);
    }

    public void clean(String path, Predicate<String> nodeFilter) throws InterruptedException, KeeperException {
        ZkMaintenanceUtils.clean(this, path, nodeFilter);
    }

    public void upConfig(Path confPath, String confName) throws IOException {
        ZkMaintenanceUtils.uploadToZK(this, confPath, "/configs/" + confName, ZkMaintenanceUtils.UPLOAD_FILENAME_EXCLUDE_PATTERN);
    }

    public String listZnode(String path, Boolean recurse) throws KeeperException, InterruptedException, SolrServerException {
        return ZkMaintenanceUtils.listZnode(this, path, recurse);
    }

    public void downConfig(String confName, Path confPath) throws IOException {
        ZkMaintenanceUtils.downloadFromZK(this, "/configs/" + confName, confPath);
    }

    public void zkTransfer(String src, Boolean srcIsZk, String dst, Boolean dstIsZk, Boolean recurse) throws SolrServerException, KeeperException, InterruptedException, IOException {
        ZkMaintenanceUtils.zkTransfer(this, src, srcIsZk, dst, dstIsZk, recurse);
    }

    public void moveZnode(String src, String dst) throws SolrServerException, KeeperException, InterruptedException {
        ZkMaintenanceUtils.moveZnode(this, src, dst);
    }

    public void uploadToZK(Path rootPath, String zkPath, Pattern filenameExclusions) throws IOException {
        ZkMaintenanceUtils.uploadToZK(this, rootPath, zkPath, filenameExclusions);
    }

    public void downloadFromZK(String zkPath, Path dir) throws IOException {
        ZkMaintenanceUtils.downloadFromZK(this, zkPath, dir);
    }

    public static class Builder {
        public String zkServerAddress;
        public int zkClientTimeout = 30000;
        public int zkClientConnectTimeout = 30000;
        public OnReconnect onReconnect;
        public BeforeReconnect beforeReconnect;
        public ZkClientConnectionStrategy connectionStrategy;
        public ZkACLProvider zkACLProvider;
        public ConnectionManager.IsClosed higherLevelIsClosed;
        public Compressor compressor;

        public Builder withUrl(String server) {
            this.zkServerAddress = server;
            return this;
        }

        public Builder withTimeout(int i, TimeUnit unit) {
            this.zkClientTimeout = (int)unit.toMillis(i);
            return this;
        }

        public Builder withConnTimeOut(int i, TimeUnit unit) {
            this.zkClientConnectTimeout = (int)unit.toMillis(i);
            return this;
        }

        public Builder withReconnectListener(OnReconnect onReconnect) {
            this.onReconnect = onReconnect;
            return this;
        }

        public Builder withConnStrategy(ZkClientConnectionStrategy strat) {
            this.connectionStrategy = strat;
            return this;
        }

        public Builder withBeforeConnect(BeforeReconnect beforeReconnect) {
            this.beforeReconnect = beforeReconnect;
            return this;
        }

        public Builder withAclProvider(ZkACLProvider zkACLProvider) {
            this.zkACLProvider = zkACLProvider;
            return this;
        }

        public Builder withClosedCheck(ConnectionManager.IsClosed higherLevelIsClosed) {
            this.higherLevelIsClosed = higherLevelIsClosed;
            return this;
        }

        public Builder withCompressor(Compressor c) {
            this.compressor = c;
            return this;
        }

        public SolrZkClient build() {
            return new SolrZkClient(this);
        }
    }

    public static class NodeData {
        public final Stat stat;
        public final byte[] data;

        public NodeData(Stat stat, byte[] data) {
            this.stat = stat;
            this.data = data;
        }
    }

    public static class ZkMetrics
    implements ReflectMapWriter {
        @JsonProperty
        public final LongAdder watchesFired = new LongAdder();
        @JsonProperty
        public final LongAdder reads = new LongAdder();
        @JsonProperty
        public final LongAdder writes = new LongAdder();
        @JsonProperty
        public final LongAdder bytesRead = new LongAdder();
        @JsonProperty
        public final LongAdder bytesWritten = new LongAdder();
        @JsonProperty
        public final LongAdder multiOps = new LongAdder();
        @JsonProperty
        public final LongAdder cumulativeMultiOps = new LongAdder();
        @JsonProperty
        public final LongAdder childFetches = new LongAdder();
        @JsonProperty
        public final LongAdder cumulativeChildrenFetched = new LongAdder();
        @JsonProperty
        public final LongAdder existsChecks = new LongAdder();
        @JsonProperty
        public final LongAdder deletes = new LongAdder();

        public void writeMap(final MapWriter.EntryWriter ew) throws IOException {
            super.writeMap(new MapWriter.EntryWriter(){

                public MapWriter.EntryWriter put(CharSequence k, Object v) throws IOException {
                    if (v instanceof LongAdder) {
                        ew.put(k, ((LongAdder)v).longValue());
                    } else {
                        ew.put(k, v);
                    }
                    return this;
                }
            });
        }
    }

    private final class ProcessWatchWithExecutor
    implements Watcher {
        private final Watcher watcher;

        ProcessWatchWithExecutor(Watcher watcher) {
            if (watcher == null) {
                throw new IllegalArgumentException("Watcher must not be null");
            }
            this.watcher = watcher;
        }

        public void process(WatchedEvent event) {
            block4: {
                log.debug("Submitting job to respond to event {}", (Object)event);
                try {
                    if (this.watcher instanceof ConnectionManager) {
                        SolrZkClient.this.zkConnManagerCallbackExecutor.submit(() -> this.watcher.process(event));
                    } else {
                        SolrZkClient.this.zkCallbackExecutor.submit(() -> {
                            SolrZkClient.this.metrics.watchesFired.increment();
                            this.watcher.process(event);
                        });
                    }
                }
                catch (RejectedExecutionException e) {
                    if (SolrZkClient.this.isClosed()) break block4;
                    throw e;
                }
            }
        }

        public int hashCode() {
            return this.watcher.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ProcessWatchWithExecutor) {
                return this.watcher.equals(((ProcessWatchWithExecutor)obj).watcher);
            }
            return false;
        }
    }
}

