/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.spelling;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.solr.spelling.QueryConverter;
import org.apache.solr.spelling.Token;

public class SpellingQueryConverter
extends QueryConverter {
    static final String[] NAMESTARTCHAR_PARTS = new String[]{"A-Z_a-z", "\\xc0-\\xd6", "\\xd8-\\xf6", "\\xf8-\\u02ff", "\\u0370-\\u037d", "\\u037f-\\u1fff", "\\u200c-\\u200d", "\\u2070-\\u218f", "\\u2c00-\\u2fef", "\\u2001-\\ud7ff", "\\uf900-\\ufdcf", "\\ufdf0-\\ufffd"};
    static final String[] ADDITIONAL_NAMECHAR_PARTS = new String[]{"\\-.0-9\\xb7", "\\u0300-\\u036f", "\\u203f-\\u2040"};
    static final String SURROGATE_PAIR = "\\p{Cs}{2}";
    static final String NMTOKEN;
    static final String PATTERN;
    protected Pattern QUERY_REGEX = Pattern.compile(PATTERN);

    @Override
    public Collection<Token> convert(String original) {
        if (original == null) {
            return Collections.emptyList();
        }
        boolean mightContainRangeQuery = !(original.indexOf(91) == -1 && original.indexOf(123) == -1 || original.indexOf(93) == -1 && original.indexOf(125) == -1);
        ArrayList<Token> result = new ArrayList<Token>();
        Matcher matcher = this.QUERY_REGEX.matcher(original);
        String nextWord = null;
        int nextStartIndex = 0;
        String lastBooleanOp = null;
        while (nextWord != null || matcher.find()) {
            String word = null;
            int startIndex = 0;
            if (nextWord != null) {
                word = nextWord;
                startIndex = nextStartIndex;
                nextWord = null;
            } else {
                word = matcher.group(0);
                startIndex = matcher.start();
            }
            if (matcher.find()) {
                nextWord = matcher.group(0);
                nextStartIndex = matcher.start();
            }
            if (mightContainRangeQuery && "TO".equals(word)) continue;
            if ("AND".equals(word) || "OR".equals(word) || "NOT".equals(word)) {
                lastBooleanOp = word;
                continue;
            }
            if ("AND".equals(nextWord) && original.length() > nextStartIndex + 7 && original.substring(nextStartIndex, nextStartIndex + 7).equals("AND NOT")) {
                nextWord = "NOT";
            }
            int flagValue = 0;
            if (word.charAt(0) == '-' || startIndex > 0 && original.charAt(startIndex - 1) == '-') {
                flagValue = 16384;
            } else if (word.charAt(0) == '+' || startIndex > 0 && original.charAt(startIndex - 1) == '+') {
                flagValue = 32768;
            } else if (nextWord != null && lastBooleanOp != null && !nextWord.equals(lastBooleanOp) && ("AND".equals(nextWord) || "OR".equals(nextWord) || "NOT".equals(nextWord))) {
                flagValue = 65536;
            } else if (nextWord != null && lastBooleanOp == null && !nextWord.equals(lastBooleanOp) && "NOT".equals(nextWord)) {
                flagValue = 65536;
            }
            try {
                this.analyze(result, word, startIndex, flagValue);
            }
            catch (IOException iOException) {}
        }
        if (lastBooleanOp != null) {
            for (Token t : result) {
                int f = t.getFlags();
                t.setFlags(f |= 0x20000);
            }
        }
        return result;
    }

    protected void analyze(Collection<Token> result, String text, int offset, int flagsAttValue) throws IOException {
        TokenStream stream = this.analyzer.tokenStream("", text);
        CharTermAttribute termAtt = (CharTermAttribute)stream.addAttribute(CharTermAttribute.class);
        TypeAttribute typeAtt = (TypeAttribute)stream.addAttribute(TypeAttribute.class);
        PayloadAttribute payloadAtt = (PayloadAttribute)stream.addAttribute(PayloadAttribute.class);
        PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)stream.addAttribute(PositionIncrementAttribute.class);
        OffsetAttribute offsetAtt = (OffsetAttribute)stream.addAttribute(OffsetAttribute.class);
        stream.reset();
        while (stream.incrementToken()) {
            Token token = new Token();
            token.copyBuffer(termAtt.buffer(), 0, termAtt.length());
            token.setOffset(offset + offsetAtt.startOffset(), offset + offsetAtt.endOffset());
            token.setFlags(flagsAttValue);
            token.setType(typeAtt.type());
            token.setPayload(payloadAtt.getPayload());
            token.setPositionIncrement(posIncAtt.getPositionIncrement());
            result.add(token);
        }
        stream.end();
        stream.close();
    }

    static {
        StringBuilder sb = new StringBuilder();
        for (String part : NAMESTARTCHAR_PARTS) {
            sb.append(part);
        }
        for (String part : ADDITIONAL_NAMECHAR_PARTS) {
            sb.append(part);
        }
        NMTOKEN = "([" + sb.toString() + "]|\\p{Cs}{2})+";
        PATTERN = "(?:(?!(" + NMTOKEN + ":|[\\^.]\\d+)))[^^.:(\\s][\\p{L}_\\-0-9]+";
    }
}

