/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiTerms;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.StringHelper;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.ZkShardTerms;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.CompositeIdRouter;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.SolrIndexSplitter;
import org.apache.solr.update.SplitIndexCommand;
import org.apache.solr.util.RTimer;
import org.apache.solr.util.RefCounted;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SplitOp
implements CoreAdminHandler.CoreAdminOp {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    SplitOp() {
    }

    @Override
    public void execute(CoreAdminHandler.CallInfo it) throws Exception {
        SolrParams params = it.req.getParams();
        String splitKey = params.get("split.key");
        String[] newCoreNames = params.getParams("targetCore");
        String cname = params.get("core", "");
        if (params.getBool("getRanges", false)) {
            this.handleGetRanges(it, cname);
            return;
        }
        ArrayList<DocRouter.Range> ranges = null;
        String[] pathsArr = params.getParams("path");
        String rangesStr = params.get("ranges");
        if (rangesStr != null) {
            String[] rangesArr = rangesStr.split(",");
            if (rangesArr.length == 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "There must be at least one range specified to split an index");
            }
            ranges = new ArrayList<DocRouter.Range>(rangesArr.length);
            for (String r : rangesArr) {
                try {
                    ranges.add(DocRouter.DEFAULT.fromString(r));
                }
                catch (Exception e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Exception parsing hexadecimal hash range: " + r, (Throwable)e);
                }
            }
        }
        if (!(pathsArr != null && pathsArr.length != 0 || newCoreNames != null && newCoreNames.length != 0)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Either path or targetCore param must be specified");
        }
        log.info("Invoked split action for core: {}", (Object)cname);
        String methodStr = params.get("splitMethod", SolrIndexSplitter.SplitMethod.REWRITE.toLower());
        SolrIndexSplitter.SplitMethod splitMethod = SolrIndexSplitter.SplitMethod.get(methodStr);
        if (splitMethod == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unsupported value of 'splitMethod': " + methodStr);
        }
        SolrCore parentCore = it.handler.coreContainer.getCore(cname);
        ArrayList<SolrCore> newCores = null;
        SolrQueryRequest req = null;
        try {
            Object paths = null;
            int partitions = pathsArr != null ? pathsArr.length : newCoreNames.length;
            DocRouter router = null;
            String routeFieldName = null;
            if (it.handler.coreContainer.isZooKeeperAware()) {
                Object routerObj;
                log.trace("SplitOp: Determine which router is associated with the shard for core");
                String[] clusterState = it.handler.coreContainer.getZkController().getClusterState();
                String collectionName = parentCore.getCoreDescriptor().getCloudDescriptor().getCollectionName();
                DocCollection collection = clusterState.getCollection(collectionName);
                String sliceName = parentCore.getCoreDescriptor().getCloudDescriptor().getShardId();
                Slice slice = collection.getSlice(sliceName);
                DocRouter docRouter = router = collection.getRouter() != null ? collection.getRouter() : DocRouter.DEFAULT;
                if (ranges == null) {
                    DocRouter.Range currentRange = slice.getRange();
                    ArrayList<DocRouter.Range> arrayList = ranges = currentRange != null ? router.partitionRange(partitions, currentRange) : null;
                }
                if ((routerObj = collection.get("router")) instanceof Map) {
                    Map routerProps = (Map)routerObj;
                    routeFieldName = (String)routerProps.get("field");
                }
            }
            if (pathsArr == null) {
                log.trace("SplitOp: Create array of paths for sub-shards of core");
                newCores = new ArrayList<SolrCore>(partitions);
                for (String newCoreName : newCoreNames) {
                    SolrCore newcore = it.handler.coreContainer.getCore(newCoreName);
                    if (newcore != null) {
                        newCores.add(newcore);
                        if (!it.handler.coreContainer.isZooKeeperAware()) continue;
                        CloudDescriptor cd = newcore.getCoreDescriptor().getCloudDescriptor();
                        ClusterState clusterState = it.handler.coreContainer.getZkController().getClusterState();
                        if (clusterState.getCollection(cd.getCollectionName()).getSlice(cd.getShardId()).getReplicas().size() == 1) continue;
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core with core name " + newCoreName + " must be the only replica in shard " + cd.getShardId());
                    }
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core with core name " + newCoreName + " expected but doesn't exist.");
                }
            } else {
                paths = Arrays.asList(pathsArr);
            }
            req = new LocalSolrQueryRequest(parentCore, params);
            SplitIndexCommand cmd = new SplitIndexCommand(req, it.rsp, (List<String>)paths, (List<SolrCore>)newCores, (List<DocRouter.Range>)ranges, router, routeFieldName, splitKey, splitMethod);
            parentCore.getUpdateHandler().split(cmd);
            if (it.handler.coreContainer.isZooKeeperAware()) {
                log.trace("SplitOp: Create cloud descriptors for sub-shards of core");
                for (SolrCore newcore : newCores) {
                    CloudDescriptor cd = newcore.getCoreDescriptor().getCloudDescriptor();
                    ZkShardTerms zkShardTerms = it.handler.coreContainer.getZkController().getShardTerms(cd.getCollectionName(), cd.getShardId());
                    zkShardTerms.ensureHighestTermsAreNotZero();
                }
            }
        }
        catch (Exception e) {
            log.error("ERROR executing split: ", (Throwable)e);
            throw e;
        }
        finally {
            if (req != null) {
                req.close();
            }
            if (parentCore != null) {
                parentCore.close();
            }
            if (newCores != null) {
                for (SolrCore newCore : newCores) {
                    newCore.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleGetRanges(CoreAdminHandler.CallInfo it, String coreName) throws Exception {
        SolrCore parentCore = it.handler.coreContainer.getCore(coreName);
        if (parentCore == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown core " + coreName);
        }
        RefCounted<SolrIndexSearcher> searcherHolder = parentCore.getRealtimeSearcher();
        try {
            Collection<DocRouter.Range> splits;
            String splitString;
            Collection<RangeCount> counts;
            if (!it.handler.coreContainer.isZooKeeperAware()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Shard splitByPrefix requires SolrCloud mode.");
            }
            SolrIndexSearcher searcher = searcherHolder.get();
            String routeFieldName = null;
            String prefixField = "id_prefix";
            ClusterState clusterState = it.handler.coreContainer.getZkController().getClusterState();
            String collectionName = parentCore.getCoreDescriptor().getCloudDescriptor().getCollectionName();
            DocCollection collection = clusterState.getCollection(collectionName);
            String sliceName = parentCore.getCoreDescriptor().getCloudDescriptor().getShardId();
            Slice slice = collection.getSlice(sliceName);
            CompositeIdRouter router = (CompositeIdRouter)(collection.getRouter() != null ? collection.getRouter() : DocRouter.DEFAULT);
            DocRouter.Range currentRange = slice.getRange();
            Object routerObj = collection.get("router");
            if (routerObj instanceof Map) {
                Map routerProps = (Map)routerObj;
                routeFieldName = (String)routerProps.get("field");
            }
            if (routeFieldName == null) {
                routeFieldName = searcher.getSchema().getUniqueKeyField().getName();
            }
            if ((counts = SplitOp.getHashHistogram(searcher, prefixField, router, collection)).size() == 0) {
                counts = SplitOp.getHashHistogramFromId(searcher, searcher.getSchema().getUniqueKeyField().getName(), router, collection);
            }
            if ((splitString = SplitOp.toSplitString(splits = SplitOp.getSplits(counts, currentRange))) == null) {
                return;
            }
            it.rsp.add("ranges", splitString);
        }
        finally {
            if (searcherHolder != null) {
                searcherHolder.decref();
            }
            if (parentCore != null) {
                parentCore.close();
            }
        }
    }

    static String toSplitString(Collection<DocRouter.Range> splits) throws Exception {
        if (splits == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (DocRouter.Range range : splits) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(range);
        }
        return sb.toString();
    }

    static Collection<RangeCount> getHashHistogram(SolrIndexSearcher searcher, String prefixField, CompositeIdRouter router, DocCollection collection) throws IOException {
        BytesRef term;
        RTimer timer = new RTimer();
        TreeMap<DocRouter.Range, RangeCount> counts = new TreeMap<DocRouter.Range, RangeCount>();
        Terms terms = MultiTerms.getTerms((IndexReader)searcher.getIndexReader(), (String)prefixField);
        if (terms == null) {
            return counts.values();
        }
        int numPrefixes = 0;
        int numTriLevel = 0;
        int numCollisions = 0;
        long sumBuckets = 0L;
        TermsEnum termsEnum = terms.iterator();
        while ((term = termsEnum.next()) != null) {
            String termStr;
            ++numPrefixes;
            int routeKeyLen = router.getRouteKeyWithSeparator(term.bytes, term.offset, term.length);
            if (routeKeyLen == 0 || routeKeyLen == term.length) {
                termStr = term.utf8ToString();
            } else {
                int prevLen = term.length;
                term.length = routeKeyLen;
                termStr = term.utf8ToString();
                term.length = prevLen;
            }
            DocRouter.Range range = router.getSearchRangeSingle(termStr, null, collection);
            int numDocs = termsEnum.docFreq();
            sumBuckets += (long)numDocs;
            RangeCount rangeCount = new RangeCount(range, numDocs);
            RangeCount prev = counts.put(rangeCount.range, rangeCount);
            if (prev == null) continue;
            rangeCount.count += prev.count;
            ++numCollisions;
        }
        if (log.isInfoEnabled()) {
            log.info("Split histogram: ms={}, numBuckets={} sumBuckets={} numPrefixes={} numTriLevel={} numCollisions={}", new Object[]{timer.getTime(), counts.size(), sumBuckets, numPrefixes, numTriLevel, numCollisions});
        }
        return counts.values();
    }

    static Collection<RangeCount> getHashHistogramFromId(SolrIndexSearcher searcher, String idField, CompositeIdRouter router, DocCollection collection) throws IOException {
        RTimer timer = new RTimer();
        TreeMap<DocRouter.Range, RangeCount> counts = new TreeMap<DocRouter.Range, RangeCount>();
        Terms terms = MultiTerms.getTerms((IndexReader)searcher.getIndexReader(), (String)idField);
        if (terms == null) {
            return counts.values();
        }
        int numPrefixes = 0;
        int numCollisions = 0;
        long sumBuckets = 0L;
        TermsEnum termsEnum = terms.iterator();
        BytesRef currPrefix = new BytesRef();
        int bucketCount = 0;
        while (true) {
            BytesRef term;
            if ((term = termsEnum.next()) != null && currPrefix.length > 0 && StringHelper.startsWith((BytesRef)term, (BytesRef)currPrefix)) {
                ++bucketCount;
                continue;
            }
            if (currPrefix.length > 0) {
                ++numPrefixes;
                sumBuckets += (long)bucketCount;
                String currPrefixStr = currPrefix.utf8ToString();
                DocRouter.Range range = router.getSearchRangeSingle(currPrefixStr, null, collection);
                RangeCount rangeCount = new RangeCount(range, bucketCount);
                bucketCount = 0;
                RangeCount prev = counts.put(rangeCount.range, rangeCount);
                if (prev != null) {
                    rangeCount.count += prev.count;
                    ++numCollisions;
                }
            }
            if (term == null) break;
            currPrefix.length = router.getRouteKeyWithSeparator(term.bytes, term.offset, term.length);
            if (currPrefix.length <= 0) continue;
            if (currPrefix.length > currPrefix.bytes.length) {
                currPrefix.bytes = new byte[currPrefix.length + 10];
            }
            System.arraycopy(term.bytes, term.offset, currPrefix.bytes, 0, currPrefix.length);
            ++bucketCount;
        }
        if (log.isInfoEnabled()) {
            log.info("Split histogram from idField {}: ms={}, numBuckets={} sumBuckets={} numPrefixes={} numCollisions={}", new Object[]{idField, timer.getTime(), counts.size(), sumBuckets, numPrefixes, numCollisions});
        }
        return counts.values();
    }

    static Collection<DocRouter.Range> getSplits(Collection<RangeCount> rawCounts, DocRouter.Range currentRange) throws Exception {
        int overError;
        int underError;
        int totalCount = 0;
        RangeCount biggest = null;
        RangeCount last = null;
        ArrayList<RangeCount> counts = new ArrayList<RangeCount>(rawCounts.size());
        for (RangeCount rangeCount : rawCounts) {
            if (!rangeCount.range.overlaps(currentRange)) continue;
            totalCount += rangeCount.count;
            if (biggest == null || rangeCount.count > biggest.count) {
                biggest = rangeCount;
            }
            counts.add(rangeCount);
            last = rangeCount;
        }
        if (counts.size() == 0) {
            return null;
        }
        ArrayList<DocRouter.Range> targetRanges = new ArrayList<DocRouter.Range>();
        if (counts.size() == 1) {
            int upper;
            int lower = Math.max(last.range.min, currentRange.min);
            int mid = lower + ((upper = Math.min(last.range.max, currentRange.max)) - lower) / 2;
            if (mid == lower || mid == upper) {
                return null;
            }
            DocRouter.Range lowerRange = new DocRouter.Range(currentRange.min, mid);
            DocRouter.Range upperRange = new DocRouter.Range(mid + 1, currentRange.max);
            targetRanges.add(lowerRange);
            targetRanges.add(upperRange);
            return targetRanges;
        }
        int targetCount = totalCount / 2;
        RangeCount middle = null;
        RangeCount prev = null;
        int currCount = 0;
        for (RangeCount rangeCount : counts) {
            if ((currCount += rangeCount.count) >= targetCount) {
                middle = rangeCount;
                break;
            }
            prev = rangeCount;
        }
        if ((underError = targetCount - (currCount - middle.count)) < (overError = currCount - targetCount)) {
            middle = prev;
        }
        assert (!Objects.equals(middle, last));
        DocRouter.Range lowerRange = new DocRouter.Range(currentRange.min, middle.range.max);
        DocRouter.Range upperRange = new DocRouter.Range(middle.range.max + 1, currentRange.max);
        targetRanges.add(lowerRange);
        targetRanges.add(upperRange);
        return targetRanges;
    }

    static class RangeCount
    implements Comparable<RangeCount> {
        DocRouter.Range range;
        int count;

        public RangeCount(DocRouter.Range range, int count) {
            this.range = range;
            this.count = count;
        }

        public int hashCode() {
            return this.range.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof RangeCount)) {
                return false;
            }
            return this.range.equals((Object)((RangeCount)obj).range);
        }

        @Override
        public int compareTo(RangeCount o) {
            return this.range.compareTo(o.range);
        }

        public String toString() {
            return this.range.toString() + "=" + this.count;
        }
    }
}

