/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.api.AnnotatedApi;
import org.apache.solr.api.Api;
import org.apache.solr.api.JerseyResource;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.response.RequestStatusState;
import org.apache.solr.client.solrj.util.SolrIdentifierValidator;
import org.apache.solr.cloud.OverseerSolrResponse;
import org.apache.solr.cloud.OverseerSolrResponseSerializer;
import org.apache.solr.cloud.OverseerTaskQueue;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.ZkShardTerms;
import org.apache.solr.cloud.api.collections.DistributedCollectionConfigSetCommandRunner;
import org.apache.solr.cloud.api.collections.RoutedAlias;
import org.apache.solr.cloud.overseer.SliceMutator;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterProperties;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.CollectionProperties;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkCmdExecutor;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionAdminParams;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.RequiredSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Pair;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CloudConfig;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.core.backup.BackupFilePaths;
import org.apache.solr.core.backup.BackupId;
import org.apache.solr.core.backup.BackupProperties;
import org.apache.solr.core.backup.repository.BackupRepository;
import org.apache.solr.core.snapshots.CollectionSnapshotMetaData;
import org.apache.solr.core.snapshots.SolrSnapshotManager;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.admin.ClusterStatus;
import org.apache.solr.handler.admin.ColStatus;
import org.apache.solr.handler.admin.RebalanceLeaders;
import org.apache.solr.handler.admin.api.AddReplicaAPI;
import org.apache.solr.handler.admin.api.AddReplicaPropertyAPI;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.handler.admin.api.BalanceShardUniqueAPI;
import org.apache.solr.handler.admin.api.CollectionStatusAPI;
import org.apache.solr.handler.admin.api.CreateShardAPI;
import org.apache.solr.handler.admin.api.DeleteCollectionAPI;
import org.apache.solr.handler.admin.api.DeleteNodeAPI;
import org.apache.solr.handler.admin.api.DeleteReplicaAPI;
import org.apache.solr.handler.admin.api.DeleteReplicaPropertyAPI;
import org.apache.solr.handler.admin.api.DeleteShardAPI;
import org.apache.solr.handler.admin.api.ForceLeaderAPI;
import org.apache.solr.handler.admin.api.ListAliasesAPI;
import org.apache.solr.handler.admin.api.MigrateDocsAPI;
import org.apache.solr.handler.admin.api.ModifyCollectionAPI;
import org.apache.solr.handler.admin.api.MoveReplicaAPI;
import org.apache.solr.handler.admin.api.RebalanceLeadersAPI;
import org.apache.solr.handler.admin.api.ReloadCollectionAPI;
import org.apache.solr.handler.admin.api.RenameCollectionAPI;
import org.apache.solr.handler.admin.api.ReplaceNodeAPI;
import org.apache.solr.handler.admin.api.SetCollectionPropertyAPI;
import org.apache.solr.handler.admin.api.SplitShardAPI;
import org.apache.solr.handler.admin.api.SyncShardAPI;
import org.apache.solr.handler.api.V2ApiUtils;
import org.apache.solr.jersey.SolrJerseyResponse;
import org.apache.solr.logging.MDCLoggingContext;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.util.tracing.TraceUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionsHandler
extends RequestHandlerBase
implements PermissionNameProvider {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final CoreContainer coreContainer;
    private final Optional<DistributedCollectionConfigSetCommandRunner> distributedCollectionConfigSetCommandRunner;
    static final Set<String> KNOWN_ROLES = ImmutableSet.of((Object)"overseer");
    public static long DEFAULT_COLLECTION_OP_TIMEOUT = 180000L;

    public CollectionsHandler() {
        this(null);
    }

    public CollectionsHandler(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
        this.distributedCollectionConfigSetCommandRunner = coreContainer != null ? coreContainer.getDistributedCollectionCommandRunner() : Optional.empty();
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext ctx) {
        String action = ctx.getParams().get("action");
        if (action == null) {
            return PermissionNameProvider.Name.COLL_READ_PERM;
        }
        CollectionParams.CollectionAction collectionAction = CollectionParams.CollectionAction.get((String)action);
        if (collectionAction == null) {
            return null;
        }
        return collectionAction.isWrite ? PermissionNameProvider.Name.COLL_EDIT_PERM : PermissionNameProvider.Name.COLL_READ_PERM;
    }

    @Override
    public final void init(NamedList<?> args) {
    }

    public CoreContainer getCoreContainer() {
        return this.coreContainer;
    }

    protected void copyFromClusterProp(Map<String, Object> props, String prop) throws IOException {
        if (props.get(prop) != null) {
            return;
        }
        Object defVal = new ClusterProperties(this.coreContainer.getZkController().getZkStateReader().getZkClient()).getClusterProperty((List)ImmutableList.of((Object)"defaults", (Object)"collection", (Object)prop), null);
        if (defVal != null) {
            props.put(prop, String.valueOf(defVal));
        }
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        CoreContainer cores = this.checkErrors();
        SolrParams params = req.getParams();
        String a = params.get("action");
        if (a == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "action is a required param");
        }
        CollectionParams.CollectionAction action = CollectionParams.CollectionAction.get((String)a);
        if (action == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown action: " + a);
        }
        String collection = params.get("collection");
        MDCLoggingContext.setCollection(collection);
        TraceUtils.setDbInstance(req, collection);
        if (log.isDebugEnabled()) {
            log.debug("Invoked Collection Action: {} with params {}", (Object)action.toLower(), (Object)req.getParamString());
        }
        CollectionOperation operation = CollectionOperation.get(action);
        this.invokeAction(req, rsp, cores, action, operation);
        rsp.setHttpCaching(false);
    }

    protected CoreContainer checkErrors() {
        CoreContainer cores = this.getCoreContainer();
        AdminAPIBase.validateZooKeeperAwareCoreContainer(cores);
        return cores;
    }

    void invokeAction(SolrQueryRequest req, SolrQueryResponse rsp, CoreContainer cores, CollectionParams.CollectionAction action, CollectionOperation operation) throws Exception {
        if (!this.coreContainer.isZooKeeperAware()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid request. collections can be accessed only in SolrCloud mode");
        }
        Map<String, Object> props = operation.execute(req, rsp, this);
        if (props == null) {
            return;
        }
        String asyncId = req.getParams().get("async");
        if (asyncId != null) {
            props.put("async", asyncId);
        }
        props.put("operation", operation.action.toLower());
        ZkNodeProps zkProps = new ZkNodeProps(props);
        SolrResponse overseerResponse = this.submitCollectionApiCommand(zkProps, operation.action, operation.timeOut);
        rsp.getValues().addAll(overseerResponse.getResponse());
        Exception exp = overseerResponse.getException();
        if (exp != null) {
            rsp.setException(exp);
        }
        if (action.equals((Object)CollectionParams.CollectionAction.CREATE) && asyncId == null && rsp.getException() == null) {
            CollectionsHandler.waitForActiveCollection(zkProps.getStr("name"), cores, overseerResponse);
        }
    }

    public SolrResponse submitCollectionApiCommand(ZkNodeProps m, CollectionParams.CollectionAction action) throws KeeperException, InterruptedException {
        return this.submitCollectionApiCommand(m, action, DEFAULT_COLLECTION_OP_TIMEOUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SolrResponse submitCollectionApiCommand(CoreContainer coreContainer, Optional<DistributedCollectionConfigSetCommandRunner> distributedCollectionConfigSetCommandRunner, ZkNodeProps m, CollectionParams.CollectionAction action, long timeout) throws KeeperException, InterruptedException {
        if (distributedCollectionConfigSetCommandRunner.isPresent()) {
            return distributedCollectionConfigSetCommandRunner.get().runCollectionCommand(m, action, timeout);
        }
        String operation = m.getStr("operation");
        if (operation == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "missing key operation");
        }
        if (m.get("async") != null) {
            String asyncId = m.getStr("async");
            NamedList r = new NamedList();
            if (coreContainer.getZkController().claimAsyncId(asyncId)) {
                boolean success = false;
                try {
                    coreContainer.getZkController().getOverseerCollectionQueue().offer((MapWriter)m);
                    success = true;
                }
                finally {
                    if (!success) {
                        try {
                            coreContainer.getZkController().clearAsyncId(asyncId);
                        }
                        catch (Exception e) {
                            log.error("Unable to release async ID={}", (Object)asyncId, (Object)e);
                            SolrZkClient.checkInterrupted((Throwable)e);
                        }
                    }
                }
            }
            r.add("error", (Object)("Task with the same requestid already exists. (" + asyncId + ")"));
            r.add("requestid", m.get("async"));
            return new OverseerSolrResponse((NamedList<Object>)r);
        }
        long time = System.nanoTime();
        OverseerTaskQueue.QueueEvent event = coreContainer.getZkController().getOverseerCollectionQueue().offer(Utils.toJSON((Object)m), timeout);
        if (event.getBytes() != null) {
            return OverseerSolrResponseSerializer.deserialize(event.getBytes());
        }
        if (System.nanoTime() - time >= TimeUnit.NANOSECONDS.convert(timeout, TimeUnit.MILLISECONDS)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, operation + " the collection time out:" + timeout / 1000L + "s");
        }
        if (event.getWatchedEvent() != null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, operation + " the collection error [Watcher fired on path: " + event.getWatchedEvent().getPath() + " state: " + event.getWatchedEvent().getState() + " type " + event.getWatchedEvent().getType() + "]");
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, operation + " the collection unknown case");
    }

    public SolrResponse submitCollectionApiCommand(ZkNodeProps m, CollectionParams.CollectionAction action, long timeout) throws KeeperException, InterruptedException {
        return CollectionsHandler.submitCollectionApiCommand(this.coreContainer, this.distributedCollectionConfigSetCommandRunner, m, action, timeout);
    }

    private boolean overseerCollectionQueueContains(String asyncId) throws KeeperException, InterruptedException {
        OverseerTaskQueue collectionQueue = this.coreContainer.getZkController().getOverseerCollectionQueue();
        return collectionQueue.containsTaskWithRequestId("async", asyncId);
    }

    private static Map<String, Object> copyPropertiesWithPrefix(SolrParams params, Map<String, Object> props, String prefix) {
        Iterator iter = params.getParameterNamesIterator();
        while (iter.hasNext()) {
            String param = (String)iter.next();
            if (!param.startsWith(prefix)) continue;
            String[] values = params.getParams(param);
            if (values.length != 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Only one value can be present for parameter " + param);
            }
            props.put(param, values[0]);
        }
        return props;
    }

    public static ModifiableSolrParams params(String ... params) {
        ModifiableSolrParams msp = new ModifiableSolrParams();
        for (int i = 0; i < params.length; i += 2) {
            msp.add(params[i], new String[]{params[i + 1]});
        }
        return msp;
    }

    @Override
    public String getDescription() {
        return "Manage SolrCloud Collections";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.ADMIN;
    }

    private static void createSysConfigSet(CoreContainer coreContainer) throws KeeperException, InterruptedException {
        SolrZkClient zk = coreContainer.getZkController().getZkStateReader().getZkClient();
        ZkCmdExecutor cmdExecutor = new ZkCmdExecutor(zk.getZkClientTimeout());
        cmdExecutor.ensureExists("/configs", zk);
        cmdExecutor.ensureExists("/configs/.system", zk);
        try {
            String path = "/configs/.system/schema.xml";
            byte[] data = IOUtils.toByteArray((InputStream)CollectionsHandler.class.getResourceAsStream("/SystemCollectionSchema.xml"));
            assert (data != null && data.length > 0);
            cmdExecutor.ensureExists(path, data, CreateMode.PERSISTENT, zk);
            path = "/configs/.system/solrconfig.xml";
            data = IOUtils.toByteArray((InputStream)CollectionsHandler.class.getResourceAsStream("/SystemCollectionSolrConfig.xml"));
            assert (data != null && data.length > 0);
            cmdExecutor.ensureExists(path, data, CreateMode.PERSISTENT, zk);
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    private static void addStatusToResponse(NamedList<Object> results, RequestStatusState state, String msg) {
        SimpleOrderedMap status = new SimpleOrderedMap();
        status.add("state", (Object)state.getKey());
        status.add("msg", (Object)msg);
        results.add("status", (Object)status);
    }

    private static void forceLeaderElection(SolrQueryRequest req, CollectionsHandler handler) {
        ZkController zkController = handler.coreContainer.getZkController();
        ClusterState clusterState = zkController.getClusterState();
        String extCollectionName = req.getParams().required().get("collection");
        String collectionName = zkController.zkStateReader.getAliases().resolveSimpleAlias(extCollectionName);
        String sliceId = req.getParams().required().get("shard");
        log.info("Force leader invoked, state: {}", (Object)clusterState);
        DocCollection collection = clusterState.getCollection(collectionName);
        Slice slice = collection.getSlice(sliceId);
        if (slice == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No shard with name " + sliceId + " exists for collection " + collectionName);
        }
        try (ZkShardTerms zkShardTerms = new ZkShardTerms(collectionName, slice.getName(), zkController.getZkClient());){
            Replica leader = slice.getLeader();
            if (leader != null && leader.getState() == Replica.State.ACTIVE) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "The shard already has an active leader. Force leader is not applicable. State: " + slice);
            }
            Set liveNodes = clusterState.getLiveNodes();
            List liveReplicas = slice.getReplicas().stream().filter(rep -> liveNodes.contains(rep.getNodeName())).collect(Collectors.toList());
            boolean shouldIncreaseReplicaTerms = liveReplicas.stream().noneMatch(rep -> zkShardTerms.registered(rep.getName()) && zkShardTerms.canBecomeLeader(rep.getName()));
            if (shouldIncreaseReplicaTerms) {
                liveReplicas.stream().filter(rep -> zkShardTerms.registered(rep.getName())).forEach(rep -> zkShardTerms.setTermEqualsToLeader(rep.getName()));
            }
            boolean success = false;
            for (int i = 0; i < 9; ++i) {
                Thread.sleep(5000L);
                clusterState = handler.coreContainer.getZkController().getClusterState();
                collection = clusterState.getCollection(collectionName);
                slice = collection.getSlice(sliceId);
                if (slice.getLeader() != null && slice.getLeader().getState() == Replica.State.ACTIVE) {
                    success = true;
                    break;
                }
                log.warn("Force leader attempt {}. Waiting 5 secs for an active leader. State of the slice: {}", (Object)(i + 1), (Object)slice);
            }
            if (success) {
                log.info("Successfully issued FORCELEADER command for collection: {}, shard: {}", (Object)collectionName, (Object)sliceId);
            } else {
                log.info("Couldn't successfully force leader, collection: {}, shard: {}. Cluster state: {}", new Object[]{collectionName, sliceId, clusterState});
            }
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error executing FORCELEADER operation for collection: " + collectionName + " shard: " + sliceId, (Throwable)e);
        }
    }

    public static void waitForActiveCollection(String collectionName, CoreContainer cc, SolrResponse createCollResponse) throws KeeperException, InterruptedException {
        if (createCollResponse.getResponse().get("exception") != null) {
            if (log.isInfoEnabled()) {
                log.info("Not waiting for active collection due to exception: {}", createCollResponse.getResponse().get("exception"));
            }
            return;
        }
        int replicaFailCount = createCollResponse.getResponse().get("failure") != null ? ((NamedList)createCollResponse.getResponse().get("failure")).size() : 0;
        CloudConfig ccfg = cc.getConfig().getCloudConfig();
        Integer seconds = ccfg.getCreateCollectionWaitTimeTillActive();
        Boolean checkLeaderOnly = ccfg.isCreateCollectionCheckLeaderActive();
        if (log.isInfoEnabled()) {
            log.info("Wait for new collection to be active for at most {} seconds. Check all shard {}", (Object)seconds, (Object)(checkLeaderOnly != false ? "leaders" : "replicas"));
        }
        try {
            cc.getZkController().getZkStateReader().waitForState(collectionName, (long)seconds.intValue(), TimeUnit.SECONDS, (n, c) -> {
                if (c == null) {
                    return true;
                }
                if (c.getSlices() != null) {
                    Collection shards = c.getSlices();
                    int replicaNotAliveCnt = 0;
                    for (Slice shard : shards) {
                        ArrayList<Replica> replicas;
                        if (!checkLeaderOnly.booleanValue()) {
                            replicas = shard.getReplicas();
                        } else {
                            replicas = new ArrayList<Replica>();
                            replicas.add(shard.getLeader());
                        }
                        for (Replica replica : replicas) {
                            Replica.State state = replica.getState();
                            if (log.isDebugEnabled()) {
                                log.debug("Checking replica status, collection={} replica={} state={}", new Object[]{collectionName, replica.getCoreUrl(), state});
                            }
                            if (n.contains(replica.getNodeName()) && state.equals((Object)Replica.State.ACTIVE)) continue;
                            ++replicaNotAliveCnt;
                            return false;
                        }
                    }
                    return replicaNotAliveCnt == 0 || replicaNotAliveCnt <= replicaFailCount;
                }
                return false;
            });
        }
        catch (InterruptedException | TimeoutException e) {
            String error = "Timeout waiting for active collection " + collectionName + " with timeout=" + seconds;
            throw new ZkController.NotInClusterStateException(SolrException.ErrorCode.SERVER_ERROR, error);
        }
    }

    private static void verifyShardsParam(String shardsParam) {
        for (String shard : shardsParam.split(",")) {
            SolrIdentifierValidator.validateShardName((String)shard);
        }
    }

    @Override
    public Boolean registerV2() {
        return Boolean.TRUE;
    }

    @Override
    public Collection<Class<? extends JerseyResource>> getJerseyResources() {
        return List.of(AddReplicaPropertyAPI.class, DeleteReplicaPropertyAPI.class, ReplaceNodeAPI.class, DeleteNodeAPI.class, ListAliasesAPI.class);
    }

    @Override
    public Collection<Api> getApis() {
        ArrayList<Api> apis = new ArrayList<Api>();
        apis.addAll(AnnotatedApi.getApis(new SplitShardAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new CreateShardAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new AddReplicaAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new DeleteShardAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new SyncShardAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new ForceLeaderAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new DeleteReplicaAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new BalanceShardUniqueAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new DeleteCollectionAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new MigrateDocsAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new ModifyCollectionAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new MoveReplicaAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new RebalanceLeadersAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new ReloadCollectionAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new SetCollectionPropertyAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new CollectionStatusAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new RenameCollectionAPI(this)));
        return apis;
    }

    static Map<String, Object> copy(SolrParams source, Map<String, Object> sink, Collection<String> paramNames) {
        if (sink == null) {
            sink = new LinkedHashMap<String, Object>();
        }
        for (String param : paramNames) {
            String[] v = source.getParams(param);
            if (v == null || v.length <= 0) continue;
            if (v.length == 1) {
                sink.put(param, v[0]);
                continue;
            }
            sink.put(param, v);
        }
        return sink;
    }

    static Map<String, Object> copy(SolrParams source, Map<String, Object> sink, String ... paramNames) {
        return CollectionsHandler.copy(source, sink, paramNames == null ? Collections.emptyList() : Arrays.asList(paramNames));
    }

    static interface CollectionOp {
        public Map<String, Object> execute(SolrQueryRequest var1, SolrQueryResponse var2, CollectionsHandler var3) throws Exception;
    }

    public static final class CollectionOperation
    extends Enum<CollectionOperation>
    implements CollectionOp {
        public static final /* enum */ CollectionOperation CREATE_OP = new CollectionOperation(CollectionParams.CollectionAction.CREATE, (req, rsp, h) -> {
            int nrtReplicas;
            int replicationFactor;
            Map<String, Object> props = CollectionsHandler.copy((SolrParams)req.getParams().required(), null, "name");
            props.put("fromApi", "true");
            CollectionsHandler.copy(req.getParams(), props, "replicationFactor", "collection.configName", "numShards", "createNodeSet", "createNodeSet.shuffle", "shards", "pullReplicas", "tlogReplicas", "nrtReplicas", "waitForFinalState", "perReplicaState", "alias");
            if (props.get("replicationFactor") != null && props.get("nrtReplicas") != null && (replicationFactor = Integer.parseInt((String)props.get("replicationFactor"))) != (nrtReplicas = Integer.parseInt((String)props.get("nrtReplicas")))) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot specify both replicationFactor and nrtReplicas as they mean the same thing");
            }
            if (props.get("replicationFactor") != null) {
                props.put("nrtReplicas", props.get("replicationFactor"));
            } else if (props.get("nrtReplicas") != null) {
                props.put("replicationFactor", props.get("nrtReplicas"));
            }
            String collectionName = SolrIdentifierValidator.validateCollectionName((String)((String)props.get("name")));
            String shardsParam = (String)props.get("shards");
            if (StringUtils.isNotEmpty((CharSequence)shardsParam)) {
                CollectionsHandler.verifyShardsParam(shardsParam);
            }
            if (".system".equals(collectionName)) {
                props.put("numShards", 1);
                props.remove("shards");
                CollectionsHandler.createSysConfigSet(h.coreContainer);
            }
            if (shardsParam == null) {
                h.copyFromClusterProp(props, "numShards");
            }
            for (String prop : ImmutableSet.of((Object)"nrtReplicas", (Object)"pullReplicas", (Object)"tlogReplicas")) {
                h.copyFromClusterProp(props, prop);
            }
            CollectionsHandler.copyPropertiesWithPrefix(req.getParams(), props, "property.");
            return CollectionsHandler.copyPropertiesWithPrefix(req.getParams(), props, "router.");
        });
        public static final /* enum */ CollectionOperation COLSTATUS_OP = new CollectionOperation(CollectionParams.CollectionAction.COLSTATUS, (req, rsp, h) -> {
            Map<String, Object> props = CollectionsHandler.copy(req.getParams(), null, "collection", "coreInfo", "segments", "fieldInfo", "rawSize", "rawSizeSummary", "rawSizeDetails", "rawSizeSamplingPercent", "sizeInfo");
            new ColStatus(h.coreContainer.getSolrClientCache(), h.coreContainer.getZkController().getZkStateReader().getClusterState(), new ZkNodeProps(props)).getColStatus(rsp.getValues());
            return null;
        });
        public static final /* enum */ CollectionOperation DELETE_OP = new CollectionOperation(CollectionParams.CollectionAction.DELETE, (req, rsp, h) -> {
            Map<String, Object> map = CollectionsHandler.copy((SolrParams)req.getParams().required(), null, "name");
            return CollectionsHandler.copy(req.getParams(), map, "followAliases");
        });
        public static final /* enum */ CollectionOperation RELOAD_OP = new CollectionOperation(CollectionParams.CollectionAction.RELOAD, (req, rsp, h) -> {
            Map<String, Object> map = CollectionsHandler.copy((SolrParams)req.getParams().required(), null, "name");
            return CollectionsHandler.copy(req.getParams(), map, new String[0]);
        });
        public static final /* enum */ CollectionOperation RENAME_OP = new CollectionOperation(CollectionParams.CollectionAction.RENAME, (req, rsp, h) -> {
            Map<String, Object> map = CollectionsHandler.copy((SolrParams)req.getParams().required(), null, "name", "target");
            return CollectionsHandler.copy(req.getParams(), map, "followAliases");
        });
        public static final /* enum */ CollectionOperation REINDEXCOLLECTION_OP = new CollectionOperation(CollectionParams.CollectionAction.REINDEXCOLLECTION, (req, rsp, h) -> {
            Map<String, Object> m = CollectionsHandler.copy((SolrParams)req.getParams().required(), null, "name");
            CollectionsHandler.copy(req.getParams(), m, "cmd", "removeSource", "target", "configName", "numShards", "nrtReplicas", "pullReplicas", "tlogReplicas", "replicationFactor", "createNodeSet", "createNodeSet.shuffle", "shards", "rows", "q", "fl", "followAliases");
            if (req.getParams().get("collection.configName") != null) {
                m.put("configName", req.getParams().get("collection.configName"));
            }
            CollectionsHandler.copyPropertiesWithPrefix(req.getParams(), m, "router.");
            return m;
        });
        public static final /* enum */ CollectionOperation SYNCSHARD_OP = new CollectionOperation(CollectionParams.CollectionAction.SYNCSHARD, (req, rsp, h) -> {
            String extCollection = req.getParams().required().get("collection");
            String collection = h.coreContainer.getZkController().getZkStateReader().getAliases().resolveSimpleAlias(extCollection);
            String shard = req.getParams().required().get("shard");
            ClusterState clusterState = h.coreContainer.getZkController().getClusterState();
            DocCollection docCollection = clusterState.getCollection(collection);
            Replica leaderProps = docCollection.getLeader(shard);
            ZkCoreNodeProps nodeProps = new ZkCoreNodeProps((ZkNodeProps)leaderProps);
            try (HttpSolrClient client = ((HttpSolrClient.Builder)((HttpSolrClient.Builder)new HttpSolrClient.Builder(nodeProps.getBaseUrl()).withConnectionTimeout(15000)).withSocketTimeout(60000)).build();){
                CoreAdminRequest.RequestSyncShard reqSyncShard = new CoreAdminRequest.RequestSyncShard();
                reqSyncShard.setCollection(collection);
                reqSyncShard.setShard(shard);
                reqSyncShard.setCoreName(nodeProps.getCoreName());
                client.request((SolrRequest)reqSyncShard);
            }
            return null;
        });
        public static final /* enum */ CollectionOperation CREATEALIAS_OP = new CollectionOperation(CollectionParams.CollectionAction.CREATEALIAS, (req, rsp, h) -> {
            String alias = req.getParams().get("name");
            SolrIdentifierValidator.validateAliasName((String)alias);
            String collections = req.getParams().get("collections");
            RoutedAlias routedAlias = null;
            SolrException ex = null;
            HashMap<String, String> possiblyModifiedParams = new HashMap<String, String>();
            try {
                req.getParams().toMap(possiblyModifiedParams);
                HashMap<String, String> temp = possiblyModifiedParams;
                routedAlias = RoutedAlias.fromProps(alias, temp);
            }
            catch (SolrException e) {
                ex = e;
            }
            ModifiableSolrParams finalParams = new ModifiableSolrParams();
            for (Map.Entry<String, String> entry : possiblyModifiedParams.entrySet()) {
                if (entry.getValue().getClass().isArray()) {
                    for (Object o : (Object[])entry.getValue()) {
                        finalParams.add(entry.getKey(), new String[]{o.toString()});
                    }
                    continue;
                }
                finalParams.add(entry.getKey(), new String[]{entry.getValue().toString()});
            }
            if (collections != null) {
                if (routedAlias != null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collections cannot be specified when creating a routed alias.");
                }
                return CollectionsHandler.copy((SolrParams)finalParams.required(), null, "name", "collections");
            }
            if (ex != null) {
                throw ex;
            }
            assert (routedAlias != null);
            Map<String, Object> result = CollectionsHandler.copy((SolrParams)finalParams, null, routedAlias.getRequiredParams());
            CollectionsHandler.copy((SolrParams)finalParams, result, routedAlias.getOptionalParams());
            ModifiableSolrParams createCollParams = new ModifiableSolrParams();
            for (Map.Entry entry : finalParams) {
                String p = (String)entry.getKey();
                if (!p.startsWith("create-collection.")) continue;
                String[] v = (String[])entry.getValue();
                if (v.length == 1) {
                    result.put(p, v[0]);
                } else {
                    result.put(p, v);
                }
                createCollParams.set(p.substring("create-collection.".length()), v);
            }
            if (createCollParams.get("name") != null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "routed aliases calculate names for their dependent collections, you cannot specify the name.");
            }
            if (createCollParams.get("collection.configName") == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "We require an explicit collection.configName");
            }
            createCollParams.add("name", new String[]{"TMP_name_TMP_name_TMP"});
            CREATE_OP.execute(new LocalSolrQueryRequest(null, (SolrParams)createCollParams), rsp, h);
            return result;
        });
        public static final /* enum */ CollectionOperation DELETEALIAS_OP = new CollectionOperation(CollectionParams.CollectionAction.DELETEALIAS, (req, rsp, h) -> CollectionsHandler.copy((SolrParams)req.getParams().required(), null, "name"));
        public static final /* enum */ CollectionOperation ALIASPROP_OP = new CollectionOperation(CollectionParams.CollectionAction.ALIASPROP, (req, rsp, h) -> {
            Map<String, Object> params = CollectionsHandler.copy((SolrParams)req.getParams().required(), null, "name");
            return CollectionOperation.convertPrefixToMap(req.getParams(), params, "property");
        });
        public static final /* enum */ CollectionOperation LISTALIASES_OP = new CollectionOperation(CollectionParams.CollectionAction.LISTALIASES, (req, rsp, h) -> {
            ListAliasesAPI getAliasesAPI = new ListAliasesAPI(h.coreContainer, req, rsp);
            ListAliasesAPI.ListAliasesResponse getAliasesResponse = getAliasesAPI.getAliases();
            V2ApiUtils.squashIntoSolrResponseWithoutHeader(rsp, getAliasesResponse);
            return null;
        });
        public static final /* enum */ CollectionOperation SPLITSHARD_OP = new CollectionOperation(CollectionParams.CollectionAction.SPLITSHARD, DEFAULT_COLLECTION_OP_TIMEOUT * 5L, (req, rsp, h) -> {
            String name = req.getParams().required().get("collection");
            String shard = req.getParams().get("shard");
            String rangesStr = req.getParams().get("ranges");
            String splitKey = req.getParams().get("split.key");
            String numSubShards = req.getParams().get("numSubShards");
            String fuzz = req.getParams().get("splitFuzz");
            if (splitKey == null && shard == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "At least one of shard, or split.key should be specified.");
            }
            if (splitKey != null && shard != null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Only one of 'shard' or 'split.key' should be specified");
            }
            if (splitKey != null && rangesStr != null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Only one of 'ranges' or 'split.key' should be specified");
            }
            if (numSubShards != null && (splitKey != null || rangesStr != null)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "numSubShards can not be specified with split.key or ranges parameters");
            }
            if (fuzz != null && (splitKey != null || rangesStr != null)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "fuzz can not be specified with split.key or ranges parameters");
            }
            Map<String, Object> map = CollectionsHandler.copy(req.getParams(), null, "collection", "shard", "split.key", "ranges", "waitForFinalState", "timing", "splitMethod", "numSubShards", "splitFuzz", "splitByPrefix", "followAliases", "createNodeSet");
            return CollectionsHandler.copyPropertiesWithPrefix(req.getParams(), map, "property.");
        });
        public static final /* enum */ CollectionOperation DELETESHARD_OP = new CollectionOperation(CollectionParams.CollectionAction.DELETESHARD, (req, rsp, h) -> {
            Map<String, Object> map = CollectionsHandler.copy((SolrParams)req.getParams().required(), null, "collection", "shard");
            CollectionsHandler.copy(req.getParams(), map, "deleteIndex", "deleteDataDir", "deleteInstanceDir", "followAliases");
            return map;
        });
        public static final /* enum */ CollectionOperation FORCELEADER_OP = new CollectionOperation(CollectionParams.CollectionAction.FORCELEADER, (req, rsp, h) -> {
            CollectionsHandler.forceLeaderElection(req, h);
            return null;
        });
        public static final /* enum */ CollectionOperation CREATESHARD_OP = new CollectionOperation(CollectionParams.CollectionAction.CREATESHARD, (req, rsp, h) -> {
            String collectionName;
            Map<String, Object> map = CollectionsHandler.copy((SolrParams)req.getParams().required(), null, "collection", "shard");
            ClusterState clusterState = h.coreContainer.getZkController().getClusterState();
            String newShardName = SolrIdentifierValidator.validateShardName((String)req.getParams().get("shard"));
            boolean followAliases = req.getParams().getBool("followAliases", false);
            String extCollectionName = req.getParams().get("collection");
            String string = collectionName = followAliases ? h.coreContainer.getZkController().getZkStateReader().getAliases().resolveSimpleAlias(extCollectionName) : extCollectionName;
            if (!"implicit".equals(((Map)clusterState.getCollection(collectionName).get("router")).get("name"))) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "shards can be added only to 'implicit' collections");
            }
            CollectionsHandler.copy(req.getParams(), map, "replicationFactor", "nrtReplicas", "tlogReplicas", "pullReplicas", "createNodeSet", "waitForFinalState", "followAliases");
            return CollectionsHandler.copyPropertiesWithPrefix(req.getParams(), map, "property.");
        });
        public static final /* enum */ CollectionOperation DELETEREPLICA_OP = new CollectionOperation(CollectionParams.CollectionAction.DELETEREPLICA, (req, rsp, h) -> {
            Map<String, Object> map = CollectionsHandler.copy((SolrParams)req.getParams().required(), null, "collection");
            return CollectionsHandler.copy(req.getParams(), map, "deleteIndex", "deleteDataDir", "deleteInstanceDir", "count", "replica", "shard", "onlyIfDown", "followAliases");
        });
        public static final /* enum */ CollectionOperation MIGRATE_OP = new CollectionOperation(CollectionParams.CollectionAction.MIGRATE, (req, rsp, h) -> {
            Map<String, Object> map = CollectionsHandler.copy((SolrParams)req.getParams().required(), null, "collection", "split.key", "target.collection");
            return CollectionsHandler.copy(req.getParams(), map, "forward.timeout", "followAliases");
        });
        public static final /* enum */ CollectionOperation ADDROLE_OP = new CollectionOperation(CollectionParams.CollectionAction.ADDROLE, (req, rsp, h) -> {
            Map<String, Object> map = CollectionsHandler.copy((SolrParams)req.getParams().required(), null, "role", "node");
            if (!KNOWN_ROLES.contains(map.get("role"))) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown role. Supported roles are ," + KNOWN_ROLES);
            }
            return map;
        });
        public static final /* enum */ CollectionOperation REMOVEROLE_OP = new CollectionOperation(CollectionParams.CollectionAction.REMOVEROLE, (req, rsp, h) -> {
            Map<String, Object> map = CollectionsHandler.copy((SolrParams)req.getParams().required(), null, "role", "node");
            if (!KNOWN_ROLES.contains(map.get("role"))) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown role. Supported roles are ," + KNOWN_ROLES);
            }
            return map;
        });
        public static final /* enum */ CollectionOperation CLUSTERPROP_OP = new CollectionOperation(CollectionParams.CollectionAction.CLUSTERPROP, (req, rsp, h) -> {
            String name = req.getParams().required().get("name");
            String val = req.getParams().get("val");
            ClusterProperties cp = new ClusterProperties(h.coreContainer.getZkController().getZkClient());
            cp.setClusterProperty(name, (Object)val);
            return null;
        });
        public static final /* enum */ CollectionOperation COLLECTIONPROP_OP = new CollectionOperation(CollectionParams.CollectionAction.COLLECTIONPROP, (req, rsp, h) -> {
            String extCollection = req.getParams().required().get("name");
            String collection = h.coreContainer.getZkController().getZkStateReader().getAliases().resolveSimpleAlias(extCollection);
            String name = req.getParams().required().get("propertyName");
            String val = req.getParams().get("propertyValue");
            CollectionProperties cp = new CollectionProperties(h.coreContainer.getZkController().getZkClient());
            cp.setCollectionProperty(collection, name, val);
            return null;
        });
        public static final /* enum */ CollectionOperation REQUESTSTATUS_OP = new CollectionOperation(CollectionParams.CollectionAction.REQUESTSTATUS, (req, rsp, h) -> {
            req.getParams().required().check(new String[]{"requestid"});
            CoreContainer coreContainer = h.coreContainer;
            String requestId = req.getParams().get("requestid");
            ZkController zkController = coreContainer.getZkController();
            NamedList status = new NamedList();
            if (coreContainer.getDistributedCollectionCommandRunner().isEmpty()) {
                if (zkController.getOverseerCompletedMap().contains(requestId)) {
                    byte[] mapEntry = zkController.getOverseerCompletedMap().get(requestId);
                    rsp.getValues().addAll(OverseerSolrResponseSerializer.deserialize(mapEntry).getResponse());
                    CollectionsHandler.addStatusToResponse((NamedList<Object>)status, RequestStatusState.COMPLETED, "found [" + requestId + "] in completed tasks");
                } else if (zkController.getOverseerFailureMap().contains(requestId)) {
                    byte[] mapEntry = zkController.getOverseerFailureMap().get(requestId);
                    rsp.getValues().addAll(OverseerSolrResponseSerializer.deserialize(mapEntry).getResponse());
                    CollectionsHandler.addStatusToResponse((NamedList<Object>)status, RequestStatusState.FAILED, "found [" + requestId + "] in failed tasks");
                } else if (zkController.getOverseerRunningMap().contains(requestId)) {
                    CollectionsHandler.addStatusToResponse((NamedList<Object>)status, RequestStatusState.RUNNING, "found [" + requestId + "] in running tasks");
                } else if (h.overseerCollectionQueueContains(requestId)) {
                    CollectionsHandler.addStatusToResponse((NamedList<Object>)status, RequestStatusState.SUBMITTED, "found [" + requestId + "] in submitted tasks");
                } else {
                    CollectionsHandler.addStatusToResponse((NamedList<Object>)status, RequestStatusState.NOT_FOUND, "Did not find [" + requestId + "] in any tasks queue");
                }
            } else {
                String message;
                Pair<RequestStatusState, OverseerSolrResponse> sr = coreContainer.getDistributedCollectionCommandRunner().get().getAsyncTaskRequestStatus(requestId);
                switch ((RequestStatusState)sr.first()) {
                    case COMPLETED: {
                        message = "found [" + requestId + "] in completed tasks";
                        rsp.getValues().addAll(((OverseerSolrResponse)((Object)((Object)sr.second()))).getResponse());
                        break;
                    }
                    case FAILED: {
                        message = "found [" + requestId + "] in failed tasks";
                        rsp.getValues().addAll(((OverseerSolrResponse)((Object)((Object)sr.second()))).getResponse());
                        break;
                    }
                    case RUNNING: {
                        message = "found [" + requestId + "] in running tasks";
                        break;
                    }
                    case SUBMITTED: {
                        message = "found [" + requestId + "] in submitted tasks";
                        break;
                    }
                    default: {
                        message = "Did not find [" + requestId + "] in any tasks queue";
                    }
                }
                CollectionsHandler.addStatusToResponse((NamedList<Object>)status, (RequestStatusState)sr.first(), message);
            }
            rsp.getValues().addAll(status);
            return null;
        });
        public static final /* enum */ CollectionOperation DELETESTATUS_OP = new CollectionOperation(CollectionParams.CollectionAction.DELETESTATUS, new CollectionOp(){

            @Override
            public Map<String, Object> execute(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
                CoreContainer coreContainer = h.coreContainer;
                String requestId = req.getParams().get("requestid");
                ZkController zkController = coreContainer.getZkController();
                boolean flush = req.getParams().getBool("flush", false);
                if (requestId == null && !flush) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Either requestid or flush parameter must be specified.");
                }
                if (requestId != null && flush) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Both requestid and flush parameters can not be specified together.");
                }
                if (coreContainer.getDistributedCollectionCommandRunner().isEmpty()) {
                    if (flush) {
                        Collection<String> completed = zkController.getOverseerCompletedMap().keys();
                        Collection<String> failed = zkController.getOverseerFailureMap().keys();
                        for (String asyncId : completed) {
                            zkController.getOverseerCompletedMap().remove(asyncId);
                            zkController.clearAsyncId(asyncId);
                        }
                        for (String asyncId : failed) {
                            zkController.getOverseerFailureMap().remove(asyncId);
                            zkController.clearAsyncId(asyncId);
                        }
                        rsp.getValues().add("status", (Object)"successfully cleared stored collection api responses");
                    } else if (zkController.getOverseerCompletedMap().remove(requestId)) {
                        zkController.clearAsyncId(requestId);
                        rsp.getValues().add("status", (Object)("successfully removed stored response for [" + requestId + "]"));
                    } else if (zkController.getOverseerFailureMap().remove(requestId)) {
                        zkController.clearAsyncId(requestId);
                        rsp.getValues().add("status", (Object)("successfully removed stored response for [" + requestId + "]"));
                    } else {
                        rsp.getValues().add("status", (Object)("[" + requestId + "] not found in stored responses"));
                    }
                } else if (flush) {
                    coreContainer.getDistributedCollectionCommandRunner().get().deleteAllAsyncIds();
                    rsp.getValues().add("status", (Object)"successfully cleared stored collection api responses");
                } else if (coreContainer.getDistributedCollectionCommandRunner().get().deleteSingleAsyncId(requestId)) {
                    rsp.getValues().add("status", (Object)("successfully removed stored response for [" + requestId + "]"));
                } else {
                    rsp.getValues().add("status", (Object)("[" + requestId + "] not found in stored responses"));
                }
                return null;
            }
        });
        public static final /* enum */ CollectionOperation ADDREPLICA_OP = new CollectionOperation(CollectionParams.CollectionAction.ADDREPLICA, (req, rsp, h) -> {
            Map<String, Object> props = CollectionsHandler.copy(req.getParams(), null, "collection", "node", "shard", "_route_", "name", "instanceDir", "dataDir", "ulogDir", "type", "waitForFinalState", "nrtReplicas", "tlogReplicas", "pullReplicas", "createNodeSet", "followAliases", "skipNodeAssignment");
            return CollectionsHandler.copyPropertiesWithPrefix(req.getParams(), props, "property.");
        });
        public static final /* enum */ CollectionOperation OVERSEERSTATUS_OP = new CollectionOperation(CollectionParams.CollectionAction.OVERSEERSTATUS, (req, rsp, h) -> new LinkedHashMap());
        public static final /* enum */ CollectionOperation DISTRIBUTEDAPIPROCESSING_OP = new CollectionOperation(CollectionParams.CollectionAction.DISTRIBUTEDAPIPROCESSING, (req, rsp, h) -> {
            NamedList results = new NamedList();
            boolean isDistributedApi = h.coreContainer.getDistributedCollectionCommandRunner().isPresent();
            results.add("isDistributedApi", (Object)isDistributedApi);
            rsp.getValues().addAll(results);
            return null;
        });
        public static final /* enum */ CollectionOperation LIST_OP = new CollectionOperation(CollectionParams.CollectionAction.LIST, (req, rsp, h) -> {
            NamedList results = new NamedList();
            Map collections = h.coreContainer.getZkController().getZkStateReader().getClusterState().getCollectionsMap();
            ArrayList collectionList = new ArrayList(collections.keySet());
            Collections.sort(collectionList);
            results.add("collections", collectionList);
            OverseerSolrResponse response = new OverseerSolrResponse((NamedList<Object>)results);
            rsp.getValues().addAll(response.getResponse());
            return null;
        });
        public static final /* enum */ CollectionOperation CLUSTERSTATUS_OP = new CollectionOperation(CollectionParams.CollectionAction.CLUSTERSTATUS, (req, rsp, h) -> {
            Map<String, Object> all = CollectionsHandler.copy(req.getParams(), null, "collection", "shard", "_route_", "prs");
            new ClusterStatus(h.coreContainer.getZkController().getZkStateReader(), new ZkNodeProps(all)).getClusterStatus(rsp.getValues());
            return null;
        });
        public static final /* enum */ CollectionOperation ADDREPLICAPROP_OP = new CollectionOperation(CollectionParams.CollectionAction.ADDREPLICAPROP, (req, rsp, h) -> {
            RequiredSolrParams requiredParams = req.getParams().required();
            AddReplicaPropertyAPI.AddReplicaPropertyRequestBody requestBody = new AddReplicaPropertyAPI.AddReplicaPropertyRequestBody();
            requestBody.value = requiredParams.get("property.value");
            requestBody.shardUnique = req.getParams().getBool("shardUnique");
            String propName = requiredParams.get("property");
            String trimmedPropName = propName.startsWith("property.") ? propName.substring("property.".length()) : propName;
            AddReplicaPropertyAPI addReplicaPropertyAPI = new AddReplicaPropertyAPI(h.coreContainer, req, rsp);
            SolrJerseyResponse addReplicaPropResponse = addReplicaPropertyAPI.addReplicaProperty(requiredParams.get("collection"), requiredParams.get("shard"), requiredParams.get("replica"), trimmedPropName, requestBody);
            V2ApiUtils.squashIntoSolrResponseWithoutHeader(rsp, addReplicaPropResponse);
            return null;
        });
        public static final /* enum */ CollectionOperation DELETEREPLICAPROP_OP = new CollectionOperation(CollectionParams.CollectionAction.DELETEREPLICAPROP, (req, rsp, h) -> {
            DeleteReplicaPropertyAPI api = new DeleteReplicaPropertyAPI(h.coreContainer, req, rsp);
            SolrJerseyResponse deleteReplicaPropResponse = DeleteReplicaPropertyAPI.invokeUsingV1Inputs(api, req.getParams());
            V2ApiUtils.squashIntoSolrResponseWithoutHeader(rsp, deleteReplicaPropResponse);
            return null;
        });
        public static final /* enum */ CollectionOperation BALANCESHARDUNIQUE_OP = new CollectionOperation(CollectionParams.CollectionAction.BALANCESHARDUNIQUE, (req, rsp, h) -> {
            Map<String, Object> map = CollectionsHandler.copy((SolrParams)req.getParams().required(), null, "collection", "property");
            Boolean shardUnique = Boolean.parseBoolean(req.getParams().get("shardUnique"));
            Object prop = req.getParams().get("property").toLowerCase(Locale.ROOT);
            if (!StringUtils.startsWith((CharSequence)prop, (CharSequence)"property.")) {
                prop = "property." + (String)prop;
            }
            if (!shardUnique.booleanValue() && !SliceMutator.SLICE_UNIQUE_BOOLEAN_PROPERTIES.contains(prop)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Balancing properties amongst replicas in a slice requires that the property be pre-defined as a unique property (e.g. 'preferredLeader') or that 'shardUnique' be set to 'true'.  Property: " + (String)prop + " shardUnique: " + shardUnique);
            }
            return CollectionsHandler.copy(req.getParams(), map, "onlyactivenodes", "shardUnique");
        });
        public static final /* enum */ CollectionOperation REBALANCELEADERS_OP = new CollectionOperation(CollectionParams.CollectionAction.REBALANCELEADERS, (req, rsp, h) -> {
            new RebalanceLeaders(req, rsp, h).execute();
            return null;
        });
        public static final /* enum */ CollectionOperation MODIFYCOLLECTION_OP = new CollectionOperation(CollectionParams.CollectionAction.MODIFYCOLLECTION, (req, rsp, h) -> {
            Map<String, Object> m = CollectionsHandler.copy(req.getParams(), null, CollectionAdminRequest.MODIFIABLE_COLLECTION_PROPERTIES);
            CollectionsHandler.copyPropertiesWithPrefix(req.getParams(), m, "property.");
            if (m.isEmpty()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, StrUtils.formatString((String)"no supported values provided {0}", (Object[])new Object[]{CollectionAdminRequest.MODIFIABLE_COLLECTION_PROPERTIES.toString()}));
            }
            CollectionsHandler.copy((SolrParams)req.getParams().required(), m, "collection");
            for (Map.Entry<String, Object> entry : m.entrySet()) {
                String prop = entry.getKey();
                if ("".equals(entry.getValue())) {
                    entry.setValue(null);
                }
                DocCollection.verifyProp(m, (String)prop);
            }
            if (m.get("replicationFactor") != null) {
                m.put("nrtReplicas", m.get("replicationFactor"));
            }
            return m;
        });
        public static final /* enum */ CollectionOperation BACKUP_OP = new CollectionOperation(CollectionParams.CollectionAction.BACKUP, (req, rsp, h) -> {
            req.getParams().required().check(new String[]{"name", "collection"});
            String extCollectionName = req.getParams().get("collection");
            boolean followAliases = req.getParams().getBool("followAliases", false);
            String collectionName = followAliases ? h.coreContainer.getZkController().getZkStateReader().getAliases().resolveSimpleAlias(extCollectionName) : extCollectionName;
            ClusterState clusterState = h.coreContainer.getZkController().getClusterState();
            if (!clusterState.hasCollection(collectionName)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection '" + collectionName + "' does not exist, no action taken.");
            }
            CoreContainer cc = h.coreContainer;
            String repo = req.getParams().get("repository");
            BackupRepository repository = cc.newBackupRepository(repo);
            String location = repository.getBackupLocation(req.getParams().get("location"));
            if (location == null && (location = (String)new ClusterProperties(h.coreContainer.getZkController().getZkClient()).getClusterProperty("location", null)) == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'location' is not specified as a query parameter or as a default repository property or as a cluster property.");
            }
            boolean incremental = req.getParams().getBool("incremental", true);
            URI uri = repository.createDirectoryURI(location);
            try {
                if (!repository.exists(uri)) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "specified location " + uri + " does not exist.");
                }
            }
            catch (IOException ex) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to check the existence of " + uri + ". Is it valid?", (Throwable)ex);
            }
            String strategy = req.getParams().get("indexBackup", "copy-files");
            if (!CollectionAdminParams.INDEX_BACKUP_STRATEGIES.contains(strategy)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown index backup strategy " + strategy);
            }
            Map<String, Object> params = CollectionsHandler.copy(req.getParams(), null, "name", "collection", "followAliases", "commitName", "maxNumBackupPoints");
            params.put("location", location);
            if (repo != null) {
                params.put("repository", repo);
            }
            params.put("indexBackup", strategy);
            params.put("incremental", incremental);
            return params;
        });
        public static final /* enum */ CollectionOperation RESTORE_OP = new CollectionOperation(CollectionParams.CollectionAction.RESTORE, (req, rsp, h) -> {
            req.getParams().required().check(new String[]{"name", "collection"});
            String collectionName = SolrIdentifierValidator.validateCollectionName((String)req.getParams().get("collection"));
            if (h.coreContainer.getZkController().getZkStateReader().getAliases().hasAlias(collectionName)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection '" + collectionName + "' is an existing alias, no action taken.");
            }
            CoreContainer cc = h.coreContainer;
            String repo = req.getParams().get("repository");
            BackupRepository repository = cc.newBackupRepository(repo);
            String location = repository.getBackupLocation(req.getParams().get("location"));
            if (location == null && (location = (String)new ClusterProperties(h.coreContainer.getZkController().getZkClient()).getClusterProperty("location", null)) == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'location' is not specified as a query parameter or as a default repository property or as a cluster property.");
            }
            URI uri = repository.createDirectoryURI(location);
            try {
                if (!repository.exists(uri)) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "specified location " + uri + " does not exist.");
                }
            }
            catch (IOException ex) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to check the existence of " + uri + ". Is it valid?", (Throwable)ex);
            }
            String createNodeArg = req.getParams().get("createNodeSet");
            if ("EMPTY".equals(createNodeArg)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot restore with a CREATE_NODE_SET of CREATE_NODE_SET_EMPTY.");
            }
            if (req.getParams().get("nrtReplicas") != null && req.getParams().get("replicationFactor") != null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot set both replicationFactor and nrtReplicas as they mean the same thing");
            }
            Map<String, Object> params = CollectionsHandler.copy(req.getParams(), null, "name", "collection");
            params.put("location", location);
            if (repo != null) {
                params.put("repository", repo);
            }
            CollectionsHandler.copy(req.getParams(), params, "collection.configName", "replicationFactor", "nrtReplicas", "tlogReplicas", "pullReplicas", "createNodeSet", "createNodeSet.shuffle", "backupId");
            CollectionsHandler.copyPropertiesWithPrefix(req.getParams(), params, "property.");
            return params;
        });
        public static final /* enum */ CollectionOperation DELETEBACKUP_OP = new CollectionOperation(CollectionParams.CollectionAction.DELETEBACKUP, (req, rsp, h) -> {
            req.getParams().required().check(new String[]{"name"});
            CoreContainer cc = h.coreContainer;
            String repo = req.getParams().get("repository");
            try (BackupRepository repository = cc.newBackupRepository(repo);){
                String location = repository.getBackupLocation(req.getParams().get("location"));
                if (location == null && (location = (String)new ClusterProperties(h.coreContainer.getZkController().getZkClient()).getClusterProperty("location", null)) == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'location' is not specified as a query parameter or as a default repository property or as a cluster property.");
                }
                URI uri = repository.createDirectoryURI(location);
                try {
                    if (!repository.exists(uri)) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "specified location " + uri + " does not exist.");
                    }
                }
                catch (IOException ex) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to check the existence of " + uri + ". Is it valid?", (Throwable)ex);
                }
                int deletionModesProvided = 0;
                if (req.getParams().get("maxNumBackupPoints") != null) {
                    ++deletionModesProvided;
                }
                if (req.getParams().get("purgeUnused") != null) {
                    ++deletionModesProvided;
                }
                if (req.getParams().get("backupId") != null) {
                    ++deletionModesProvided;
                }
                if (deletionModesProvided != 1) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, String.format(Locale.ROOT, "Exactly one of %s, %s, and %s parameters must be provided", "maxNumBackupPoints", "purgeUnused", "backupId"));
                }
                Map<String, Object> params = CollectionsHandler.copy(req.getParams(), null, "name", "repository", "location", "backupId", "maxNumBackupPoints", "purgeUnused");
                params.put("location", location);
                if (repo != null) {
                    params.put("repository", repo);
                }
                Map<String, Object> map = params;
                return map;
            }
        });
        public static final /* enum */ CollectionOperation LISTBACKUP_OP = new CollectionOperation(CollectionParams.CollectionAction.LISTBACKUP, (req, rsp, h) -> {
            req.getParams().required().check(new String[]{"name"});
            CoreContainer cc = h.coreContainer;
            String repo = req.getParams().get("repository");
            try (BackupRepository repository = cc.newBackupRepository(repo);){
                String location = repository.getBackupLocation(req.getParams().get("location"));
                if (location == null && (location = (String)new ClusterProperties(h.coreContainer.getZkController().getZkClient()).getClusterProperty("location", null)) == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'location' is not specified as a query parameter or as a default repository property or as a cluster property.");
                }
                String backupName = req.getParams().get("name");
                URI locationURI = repository.createDirectoryURI(location);
                try {
                    if (!repository.exists(locationURI)) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "specified location " + locationURI + " does not exist.");
                    }
                }
                catch (IOException ex) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to check the existence of " + locationURI + ". Is it valid?", (Throwable)ex);
                }
                URI backupLocation = BackupFilePaths.buildExistingBackupLocationURI(repository, locationURI, backupName);
                if (repository.exists(repository.resolve(backupLocation, "backup.properties"))) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The backup name [" + backupName + "] at location [" + location + "] holds a non-incremental (legacy) backup, but backup-listing is only supported on incremental backups");
                }
                String[] subFiles = repository.listAllOrEmpty(backupLocation);
                List<BackupId> propsFiles = BackupFilePaths.findAllBackupIdsFromFileListing(subFiles);
                NamedList results = new NamedList();
                ArrayList<Map<Object, Object>> backups = new ArrayList<Map<Object, Object>>();
                String collectionName = null;
                for (BackupId backupId : propsFiles) {
                    BackupProperties properties = BackupProperties.readFrom(repository, backupLocation, BackupFilePaths.getBackupPropsName(backupId));
                    if (collectionName == null) {
                        collectionName = properties.getCollection();
                        results.add("collection", (Object)collectionName);
                    }
                    Map<Object, Object> details = properties.getDetails();
                    details.put("backupId", backupId.id);
                    backups.add(details);
                }
                results.add("backups", backups);
                OverseerSolrResponse response = new OverseerSolrResponse((NamedList<Object>)results);
                rsp.getValues().addAll(response.getResponse());
                Map map = null;
                return map;
            }
        });
        public static final /* enum */ CollectionOperation CREATESNAPSHOT_OP = new CollectionOperation(CollectionParams.CollectionAction.CREATESNAPSHOT, (req, rsp, h) -> {
            req.getParams().required().check(new String[]{"collection", "commitName"});
            String extCollectionName = req.getParams().get("collection");
            boolean followAliases = req.getParams().getBool("followAliases", false);
            String collectionName = followAliases ? h.coreContainer.getZkController().getZkStateReader().getAliases().resolveSimpleAlias(extCollectionName) : extCollectionName;
            String commitName = req.getParams().get("commitName");
            ClusterState clusterState = h.coreContainer.getZkController().getClusterState();
            if (!clusterState.hasCollection(collectionName)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection '" + collectionName + "' does not exist, no action taken.");
            }
            SolrZkClient client = h.coreContainer.getZkController().getZkClient();
            if (SolrSnapshotManager.snapshotExists(client, collectionName, commitName)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Snapshot with name '" + commitName + "' already exists for collection '" + collectionName + "', no action taken.");
            }
            Map<String, Object> params = CollectionsHandler.copy(req.getParams(), null, "collection", "followAliases", "commitName");
            return params;
        });
        public static final /* enum */ CollectionOperation DELETESNAPSHOT_OP = new CollectionOperation(CollectionParams.CollectionAction.DELETESNAPSHOT, (req, rsp, h) -> {
            req.getParams().required().check(new String[]{"collection", "commitName"});
            String extCollectionName = req.getParams().get("collection");
            String collectionName = h.coreContainer.getZkController().getZkStateReader().getAliases().resolveSimpleAlias(extCollectionName);
            ClusterState clusterState = h.coreContainer.getZkController().getClusterState();
            if (!clusterState.hasCollection(collectionName)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection '" + collectionName + "' does not exist, no action taken.");
            }
            Map<String, Object> params = CollectionsHandler.copy(req.getParams(), null, "collection", "followAliases", "commitName");
            return params;
        });
        public static final /* enum */ CollectionOperation LISTSNAPSHOTS_OP = new CollectionOperation(CollectionParams.CollectionAction.LISTSNAPSHOTS, (req, rsp, h) -> {
            req.getParams().required().check(new String[]{"collection"});
            String extCollectionName = req.getParams().get("collection");
            String collectionName = h.coreContainer.getZkController().getZkStateReader().getAliases().resolveSimpleAlias(extCollectionName);
            ClusterState clusterState = h.coreContainer.getZkController().getClusterState();
            if (!clusterState.hasCollection(collectionName)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection '" + collectionName + "' does not exist, no action taken.");
            }
            NamedList snapshots = new NamedList();
            SolrZkClient client = h.coreContainer.getZkController().getZkClient();
            Collection<CollectionSnapshotMetaData> m = SolrSnapshotManager.listSnapshots(client, collectionName);
            for (CollectionSnapshotMetaData meta : m) {
                snapshots.add(meta.getName(), meta.toNamedList());
            }
            rsp.add("snapshots", snapshots);
            return null;
        });
        public static final /* enum */ CollectionOperation REPLACENODE_OP = new CollectionOperation(CollectionParams.CollectionAction.REPLACENODE, (req, rsp, h) -> {
            SolrParams params = req.getParams();
            RequiredSolrParams requiredParams = req.getParams().required();
            ReplaceNodeAPI.ReplaceNodeRequestBody requestBody = new ReplaceNodeAPI.ReplaceNodeRequestBody();
            requestBody.targetNodeName = params.get("targetNode");
            requestBody.waitForFinalState = params.getBool("waitForFinalState");
            requestBody.async = params.get("async");
            ReplaceNodeAPI replaceNodeAPI = new ReplaceNodeAPI(h.coreContainer, req, rsp);
            SolrJerseyResponse replaceNodeResponse = replaceNodeAPI.replaceNode(requiredParams.get("sourceNode"), requestBody);
            V2ApiUtils.squashIntoSolrResponseWithoutHeader(rsp, replaceNodeResponse);
            return null;
        });
        public static final /* enum */ CollectionOperation MOVEREPLICA_OP = new CollectionOperation(CollectionParams.CollectionAction.MOVEREPLICA, (req, rsp, h) -> {
            Map<String, Object> map = CollectionsHandler.copy((SolrParams)req.getParams().required(), null, "collection");
            return CollectionsHandler.copy(req.getParams(), map, "fromNode", "sourceNode", "targetNode", "waitForFinalState", "inPlaceMove", "replica", "shard", "followAliases");
        });
        public static final /* enum */ CollectionOperation DELETENODE_OP = new CollectionOperation(CollectionParams.CollectionAction.DELETENODE, (req, rsp, h) -> {
            DeleteNodeAPI deleteNodeAPI = new DeleteNodeAPI(h.coreContainer, req, rsp);
            SolrJerseyResponse deleteNodeResponse = DeleteNodeAPI.invokeUsingV1Inputs(deleteNodeAPI, req.getParams());
            V2ApiUtils.squashIntoSolrResponseWithoutHeader(rsp, deleteNodeResponse);
            return null;
        });
        public static final /* enum */ CollectionOperation MOCK_COLL_TASK_OP = new CollectionOperation(CollectionParams.CollectionAction.MOCK_COLL_TASK, (req, rsp, h) -> {
            Map<String, Object> map = CollectionsHandler.copy((SolrParams)req.getParams().required(), null, "collection");
            return CollectionsHandler.copy(req.getParams(), map, "sleep");
        });
        public final CollectionOp fun;
        final CollectionParams.CollectionAction action;
        final long timeOut;
        private static final /* synthetic */ CollectionOperation[] $VALUES;

        public static CollectionOperation[] values() {
            return (CollectionOperation[])$VALUES.clone();
        }

        public static CollectionOperation valueOf(String name) {
            return Enum.valueOf(CollectionOperation.class, name);
        }

        private static Map<String, Object> convertPrefixToMap(SolrParams params, Map<String, Object> sink, String prefix) {
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            Iterator iter = params.getParameterNamesIterator();
            while (iter.hasNext()) {
                String param = (String)iter.next();
                if (!param.startsWith(prefix)) continue;
                result.put(param.substring(prefix.length() + 1), params.get(param));
            }
            if (sink == null) {
                sink = new LinkedHashMap<String, Object>();
            }
            sink.put(prefix, result);
            return sink;
        }

        private CollectionOperation(CollectionParams.CollectionAction action, CollectionOp fun) {
            this(action, DEFAULT_COLLECTION_OP_TIMEOUT, fun);
        }

        private CollectionOperation(CollectionParams.CollectionAction action, long timeOut, CollectionOp fun) {
            this.action = action;
            this.timeOut = timeOut;
            this.fun = fun;
        }

        public static CollectionOperation get(CollectionParams.CollectionAction action) {
            for (CollectionOperation op : CollectionOperation.values()) {
                if (op.action != action) continue;
                return op;
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No such action " + action);
        }

        @Override
        public Map<String, Object> execute(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
            return this.fun.execute(req, rsp, h);
        }

        static {
            $VALUES = new CollectionOperation[]{CREATE_OP, COLSTATUS_OP, DELETE_OP, RELOAD_OP, RENAME_OP, REINDEXCOLLECTION_OP, SYNCSHARD_OP, CREATEALIAS_OP, DELETEALIAS_OP, ALIASPROP_OP, LISTALIASES_OP, SPLITSHARD_OP, DELETESHARD_OP, FORCELEADER_OP, CREATESHARD_OP, DELETEREPLICA_OP, MIGRATE_OP, ADDROLE_OP, REMOVEROLE_OP, CLUSTERPROP_OP, COLLECTIONPROP_OP, REQUESTSTATUS_OP, DELETESTATUS_OP, ADDREPLICA_OP, OVERSEERSTATUS_OP, DISTRIBUTEDAPIPROCESSING_OP, LIST_OP, CLUSTERSTATUS_OP, ADDREPLICAPROP_OP, DELETEREPLICAPROP_OP, BALANCESHARDUNIQUE_OP, REBALANCELEADERS_OP, MODIFYCOLLECTION_OP, BACKUP_OP, RESTORE_OP, DELETEBACKUP_OP, LISTBACKUP_OP, CREATESNAPSHOT_OP, DELETESNAPSHOT_OP, LISTSNAPSHOTS_OP, REPLACENODE_OP, MOVEREPLICA_OP, DELETENODE_OP, MOCK_COLL_TASK_OP};
        }
    }
}

