/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.TransientSolrCoreCache;
import org.apache.solr.core.TransientSolrCores;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(since="9.2")
public class TransientSolrCoreCacheDefault
extends TransientSolrCoreCache {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final int DEFAULT_TRANSIENT_CACHE_SIZE = Integer.MAX_VALUE;
    public static final String TRANSIENT_CACHE_SIZE = "transientCacheSize";
    private final TransientSolrCores solrCores;
    protected final Cache<String, SolrCore> transientCores;
    protected final Map<String, CoreDescriptor> transientDescriptors;

    public TransientSolrCoreCacheDefault(TransientSolrCores solrCores, int cacheMaxSize) {
        this.solrCores = solrCores;
        int initialCapacity = Math.min(cacheMaxSize, 1024);
        log.info("Allocating transient core cache for max {} cores with initial capacity of {}", (Object)cacheMaxSize, (Object)initialCapacity);
        Caffeine transientCoresCacheBuilder = Caffeine.newBuilder().initialCapacity(initialCapacity).executor(Runnable::run).removalListener((coreName, core, cause) -> {
            if (core != null && cause.wasEvicted()) {
                this.onEvict((SolrCore)core);
            }
        });
        if (cacheMaxSize != Integer.MAX_VALUE) {
            transientCoresCacheBuilder.maximumSize((long)cacheMaxSize);
        }
        this.transientCores = transientCoresCacheBuilder.build();
        this.transientDescriptors = new LinkedHashMap<String, CoreDescriptor>(initialCapacity);
    }

    private void onEvict(SolrCore core) {
        assert (Thread.holdsLock(this.solrCores.getModifyLock()));
        if (this.solrCores.hasPendingCoreOps(core.getName())) {
            if (log.isInfoEnabled()) {
                log.info("NOT evicting transient core [{}]; it's loading or something else.  Size: {}", (Object)core.getName(), (Object)this.transientCores.estimatedSize());
            }
            this.transientCores.put((Object)core.getName(), (Object)core);
        } else if (core.getOpenCount() > 1) {
            if (log.isInfoEnabled()) {
                log.info("NOT evicting transient core [{}]; it's still in use.  Size: {}", (Object)core.getName(), (Object)this.transientCores.estimatedSize());
            }
            this.transientCores.put((Object)core.getName(), (Object)core);
        } else {
            if (log.isInfoEnabled()) {
                log.info("Closing transient core [{}] evicted from the cache", (Object)core.getName());
            }
            this.solrCores.queueCoreToClose(core);
        }
    }

    @Override
    public void close() {
        this.transientCores.invalidateAll();
        this.transientCores.cleanUp();
    }

    @Override
    public SolrCore addCore(String name, SolrCore core) {
        return this.transientCores.asMap().put(name, core);
    }

    @Override
    public Set<String> getAllCoreNames() {
        return Collections.unmodifiableSet(this.transientDescriptors.keySet());
    }

    @Override
    public Set<String> getLoadedCoreNames() {
        return Collections.unmodifiableSet(this.transientCores.asMap().keySet());
    }

    @Override
    public SolrCore removeCore(String name) {
        return (SolrCore)this.transientCores.asMap().remove(name);
    }

    @Override
    public SolrCore getCore(String name) {
        return name == null ? null : (SolrCore)this.transientCores.getIfPresent((Object)name);
    }

    @Override
    public boolean containsCore(String name) {
        return name != null && this.transientCores.asMap().containsKey(name);
    }

    @Override
    public void addTransientDescriptor(String rawName, CoreDescriptor cd) {
        this.transientDescriptors.put(rawName, cd);
    }

    @Override
    public CoreDescriptor getTransientDescriptor(String name) {
        return this.transientDescriptors.get(name);
    }

    @Override
    public Collection<CoreDescriptor> getTransientDescriptors() {
        return Collections.unmodifiableCollection(this.transientDescriptors.values());
    }

    @Override
    public CoreDescriptor removeTransientDescriptor(String name) {
        return this.transientDescriptors.remove(name);
    }

    @Override
    public int getStatus(String coreName) {
        return 0;
    }

    @Override
    public void setStatus(String coreName, int status) {
    }
}

