/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.transaction.xa.Xid;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.CacheTopologyInfo;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.event.impl.ClientListenerNotifier;
import org.infinispan.client.hotrod.impl.ClientStatistics;
import org.infinispan.client.hotrod.impl.ClientTopology;
import org.infinispan.client.hotrod.impl.InternalRemoteCache;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHash;
import org.infinispan.client.hotrod.impl.iteration.KeyTracker;
import org.infinispan.client.hotrod.impl.operations.AddBloomNearCacheClientListenerOperation;
import org.infinispan.client.hotrod.impl.operations.AddClientListenerOperation;
import org.infinispan.client.hotrod.impl.operations.AdminOperation;
import org.infinispan.client.hotrod.impl.operations.AuthMechListOperation;
import org.infinispan.client.hotrod.impl.operations.AuthOperation;
import org.infinispan.client.hotrod.impl.operations.BulkGetKeysOperation;
import org.infinispan.client.hotrod.impl.operations.ClearOperation;
import org.infinispan.client.hotrod.impl.operations.ContainsKeyOperation;
import org.infinispan.client.hotrod.impl.operations.ExecuteOperation;
import org.infinispan.client.hotrod.impl.operations.FaultTolerantPingOperation;
import org.infinispan.client.hotrod.impl.operations.GetAllParallelOperation;
import org.infinispan.client.hotrod.impl.operations.GetOperation;
import org.infinispan.client.hotrod.impl.operations.GetStreamOperation;
import org.infinispan.client.hotrod.impl.operations.GetWithMetadataOperation;
import org.infinispan.client.hotrod.impl.operations.IterationEndOperation;
import org.infinispan.client.hotrod.impl.operations.IterationNextOperation;
import org.infinispan.client.hotrod.impl.operations.IterationStartOperation;
import org.infinispan.client.hotrod.impl.operations.PingOperation;
import org.infinispan.client.hotrod.impl.operations.PutAllParallelOperation;
import org.infinispan.client.hotrod.impl.operations.PutIfAbsentOperation;
import org.infinispan.client.hotrod.impl.operations.PutOperation;
import org.infinispan.client.hotrod.impl.operations.PutStreamOperation;
import org.infinispan.client.hotrod.impl.operations.QueryOperation;
import org.infinispan.client.hotrod.impl.operations.RemoveClientListenerOperation;
import org.infinispan.client.hotrod.impl.operations.RemoveIfUnmodifiedOperation;
import org.infinispan.client.hotrod.impl.operations.RemoveOperation;
import org.infinispan.client.hotrod.impl.operations.ReplaceIfUnmodifiedOperation;
import org.infinispan.client.hotrod.impl.operations.ReplaceOperation;
import org.infinispan.client.hotrod.impl.operations.SizeOperation;
import org.infinispan.client.hotrod.impl.operations.StatsOperation;
import org.infinispan.client.hotrod.impl.operations.UpdateBloomFilterOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.query.RemoteQuery;
import org.infinispan.client.hotrod.impl.transaction.entry.Modification;
import org.infinispan.client.hotrod.impl.transaction.operations.PrepareTransactionOperation;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.client.hotrod.telemetry.impl.TelemetryService;
import org.infinispan.commons.util.IntSet;

@Immutable
public class OperationsFactory
implements HotRodConstants {
    private static final Log log = LogFactory.getLog(OperationsFactory.class, Log.class);
    private final ThreadLocal<Integer> flagsMap = new ThreadLocal();
    private final ChannelFactory channelFactory;
    private final byte[] cacheNameBytes;
    private final AtomicReference<ClientTopology> clientTopologyRef;
    private final boolean forceReturnValue;
    private final ClientListenerNotifier listenerNotifier;
    private final String cacheName;
    private final Configuration cfg;
    private final ClientStatistics clientStatistics;
    private final TelemetryService telemetryService;

    public OperationsFactory(ChannelFactory channelFactory, String cacheName, boolean forceReturnValue, ClientListenerNotifier listenerNotifier, Configuration cfg, ClientStatistics clientStatistics) {
        AtomicReference<ClientTopology> atomicReference;
        this.channelFactory = channelFactory;
        this.cacheNameBytes = cacheName == null ? DEFAULT_CACHE_NAME_BYTES : RemoteCacheManager.cacheNameBytes(cacheName);
        this.cacheName = cacheName;
        if (channelFactory != null) {
            atomicReference = channelFactory.createTopologyId(this.cacheNameBytes);
        } else {
            AtomicReference<ClientTopology> atomicReference2;
            atomicReference = atomicReference2;
            super(new ClientTopology(-1, cfg.clientIntelligence()));
        }
        this.clientTopologyRef = atomicReference;
        this.forceReturnValue = forceReturnValue;
        this.listenerNotifier = listenerNotifier;
        this.cfg = cfg;
        this.clientStatistics = clientStatistics;
        TelemetryService telemetryService = null;
        try {
            if (cfg.tracingPropagationEnabled()) {
                telemetryService = TelemetryService.create();
                log.openTelemetryPropagationEnabled();
            } else {
                log.openTelemetryPropagationDisabled();
            }
        }
        catch (Throwable e) {
            log.noOpenTelemetryAPI(e);
        }
        this.telemetryService = telemetryService;
    }

    public OperationsFactory(ChannelFactory channelFactory, ClientListenerNotifier listenerNotifier, Configuration cfg) {
        this(channelFactory, null, false, listenerNotifier, cfg, null);
    }

    public ClientListenerNotifier getListenerNotifier() {
        return this.listenerNotifier;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public ChannelFactory getChannelFactory() {
        return this.channelFactory;
    }

    public Codec getCodec() {
        return this.channelFactory.getNegotiatedCodec();
    }

    public <V> GetOperation<V> newGetKeyOperation(Object key, byte[] keyBytes, DataFormat dataFormat) {
        return new GetOperation(this.getCodec(), this.channelFactory, key, keyBytes, this.cacheNameBytes, this.clientTopologyRef, this.flags(), this.cfg, dataFormat, this.clientStatistics);
    }

    public <K, V> GetAllParallelOperation<K, V> newGetAllOperation(Set<byte[]> keys, DataFormat dataFormat) {
        return new GetAllParallelOperation(this.getCodec(), this.channelFactory, keys, this.cacheNameBytes, this.clientTopologyRef, this.flags(), this.cfg, dataFormat, this.clientStatistics);
    }

    public <V> RemoveOperation<V> newRemoveOperation(Object key, byte[] keyBytes, DataFormat dataFormat) {
        return new RemoveOperation(this.getCodec(), this.channelFactory, key, keyBytes, this.cacheNameBytes, this.clientTopologyRef, this.flags(), this.cfg, dataFormat, this.clientStatistics, this.telemetryService);
    }

    public <V> RemoveIfUnmodifiedOperation<V> newRemoveIfUnmodifiedOperation(Object key, byte[] keyBytes, long version, DataFormat dataFormat) {
        return new RemoveIfUnmodifiedOperation(this.getCodec(), this.channelFactory, key, keyBytes, this.cacheNameBytes, this.clientTopologyRef, this.flags(), this.cfg, version, dataFormat, this.clientStatistics, this.telemetryService);
    }

    public ReplaceIfUnmodifiedOperation newReplaceIfUnmodifiedOperation(Object key, byte[] keyBytes, byte[] value, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit, long version, DataFormat dataFormat) {
        return new ReplaceIfUnmodifiedOperation(this.getCodec(), this.channelFactory, key, keyBytes, this.cacheNameBytes, this.clientTopologyRef, this.flags(lifespan, maxIdle), this.cfg, value, lifespan, lifespanTimeUnit, maxIdle, maxIdleTimeUnit, version, dataFormat, this.clientStatistics, this.telemetryService);
    }

    public <V> GetWithMetadataOperation<V> newGetWithMetadataOperation(Object key, byte[] keyBytes, DataFormat dataFormat) {
        return this.newGetWithMetadataOperation(key, keyBytes, dataFormat, null);
    }

    public <V> GetWithMetadataOperation<V> newGetWithMetadataOperation(Object key, byte[] keyBytes, DataFormat dataFormat, SocketAddress listenerServer) {
        return new GetWithMetadataOperation(this.getCodec(), this.channelFactory, key, keyBytes, this.cacheNameBytes, this.clientTopologyRef, this.flags(), this.cfg, dataFormat, this.clientStatistics, listenerServer);
    }

    public StatsOperation newStatsOperation() {
        return new StatsOperation(this.getCodec(), this.channelFactory, this.cacheNameBytes, this.clientTopologyRef, this.flags(), this.cfg);
    }

    public <V> PutOperation<V> newPutKeyValueOperation(Object key, byte[] keyBytes, byte[] value, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit, DataFormat dataFormat) {
        return new PutOperation(this.getCodec(), this.channelFactory, key, keyBytes, this.cacheNameBytes, this.clientTopologyRef, this.flags(lifespan, maxIdle), this.cfg, value, lifespan, lifespanTimeUnit, maxIdle, maxIdleTimeUnit, dataFormat, this.clientStatistics, this.telemetryService);
    }

    public PutAllParallelOperation newPutAllOperation(Map<byte[], byte[]> map, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit, DataFormat dataFormat) {
        return new PutAllParallelOperation(this.getCodec(), this.channelFactory, map, this.cacheNameBytes, this.clientTopologyRef, this.flags(lifespan, maxIdle), this.cfg, lifespan, lifespanTimeUnit, maxIdle, maxIdleTimeUnit, dataFormat, this.clientStatistics, this.telemetryService);
    }

    public <V> PutIfAbsentOperation<V> newPutIfAbsentOperation(Object key, byte[] keyBytes, byte[] value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit, DataFormat dataFormat) {
        return new PutIfAbsentOperation(this.getCodec(), this.channelFactory, key, keyBytes, this.cacheNameBytes, this.clientTopologyRef, this.flags(lifespan, maxIdleTime), this.cfg, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit, dataFormat, this.clientStatistics, this.telemetryService);
    }

    public <V> ReplaceOperation<V> newReplaceOperation(Object key, byte[] keyBytes, byte[] values, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit, DataFormat dataFormat) {
        return new ReplaceOperation(this.getCodec(), this.channelFactory, key, keyBytes, this.cacheNameBytes, this.clientTopologyRef, this.flags(lifespan, maxIdle), this.cfg, values, lifespan, lifespanTimeUnit, maxIdle, maxIdleTimeUnit, dataFormat, this.clientStatistics, this.telemetryService);
    }

    public ContainsKeyOperation newContainsKeyOperation(Object key, byte[] keyBytes, DataFormat dataFormat) {
        return new ContainsKeyOperation(this.getCodec(), this.channelFactory, key, keyBytes, this.cacheNameBytes, this.clientTopologyRef, this.flags(), this.cfg, dataFormat, this.clientStatistics);
    }

    public ClearOperation newClearOperation() {
        return new ClearOperation(this.getCodec(), this.channelFactory, this.cacheNameBytes, this.clientTopologyRef, this.flags(), this.cfg, this.telemetryService);
    }

    public <K> BulkGetKeysOperation<K> newBulkGetKeysOperation(int scope, DataFormat dataFormat) {
        return new BulkGetKeysOperation(this.getCodec(), this.channelFactory, this.cacheNameBytes, this.clientTopologyRef, this.flags(), this.cfg, scope, dataFormat, this.clientStatistics);
    }

    public AddClientListenerOperation newAddClientListenerOperation(Object listener, DataFormat dataFormat) {
        return new AddClientListenerOperation(this.getCodec(), this.channelFactory, this.cacheName, this.clientTopologyRef, this.flags(), this.cfg, this.listenerNotifier, listener, null, null, dataFormat, null, this.telemetryService);
    }

    public AddClientListenerOperation newAddClientListenerOperation(Object listener, byte[][] filterFactoryParams, byte[][] converterFactoryParams, DataFormat dataFormat) {
        return new AddClientListenerOperation(this.getCodec(), this.channelFactory, this.cacheName, this.clientTopologyRef, this.flags(), this.cfg, this.listenerNotifier, listener, filterFactoryParams, converterFactoryParams, dataFormat, null, this.telemetryService);
    }

    public RemoveClientListenerOperation newRemoveClientListenerOperation(Object listener) {
        return new RemoveClientListenerOperation(this.getCodec(), this.channelFactory, this.cacheNameBytes, this.clientTopologyRef, this.flags(), this.cfg, this.listenerNotifier, listener);
    }

    public AddBloomNearCacheClientListenerOperation newAddNearCacheListenerOperation(Object listener, DataFormat dataFormat, int bloomFilterBits, InternalRemoteCache<?, ?> remoteCache) {
        return new AddBloomNearCacheClientListenerOperation(this.getCodec(), this.channelFactory, this.cacheName, this.clientTopologyRef, this.flags(), this.cfg, this.listenerNotifier, listener, dataFormat, bloomFilterBits, remoteCache);
    }

    public UpdateBloomFilterOperation newUpdateBloomFilterOperation(SocketAddress address, byte[] bloomBytes) {
        return new UpdateBloomFilterOperation(this.getCodec(), this.channelFactory, this.cacheNameBytes, this.clientTopologyRef, this.flags(), this.cfg, address, bloomBytes);
    }

    public PingOperation newPingOperation(boolean releaseChannel) {
        return new PingOperation(this.getCodec(), this.clientTopologyRef, this.cfg, this.cacheNameBytes, this.channelFactory, releaseChannel);
    }

    public FaultTolerantPingOperation newFaultTolerantPingOperation() {
        return new FaultTolerantPingOperation(this.getCodec(), this.channelFactory, this.cacheNameBytes, this.clientTopologyRef, this.flags(), this.cfg);
    }

    public QueryOperation newQueryOperation(RemoteQuery<?> remoteQuery, DataFormat dataFormat, boolean withHitCount) {
        return new QueryOperation(this.getCodec(), this.channelFactory, this.cacheNameBytes, this.clientTopologyRef, this.flags(), this.cfg, remoteQuery, dataFormat, withHitCount);
    }

    public SizeOperation newSizeOperation() {
        return new SizeOperation(this.getCodec(), this.channelFactory, this.cacheNameBytes, this.clientTopologyRef, this.flags(), this.cfg, this.telemetryService);
    }

    public <T> ExecuteOperation<T> newExecuteOperation(String taskName, Map<String, byte[]> marshalledParams, Object key, DataFormat dataFormat) {
        return new ExecuteOperation(this.getCodec(), this.channelFactory, this.cacheNameBytes, this.clientTopologyRef, this.flags(), this.cfg, taskName, marshalledParams, key, dataFormat);
    }

    public AdminOperation newAdminOperation(String taskName, Map<String, byte[]> marshalledParams) {
        return new AdminOperation(this.getCodec(), this.channelFactory, this.cacheNameBytes, this.clientTopologyRef, this.flags(), this.cfg, taskName, marshalledParams);
    }

    private int flags(long lifespan, long maxIdle) {
        int intFlags = this.flags();
        if (lifespan == 0L) {
            intFlags |= Flag.DEFAULT_LIFESPAN.getFlagInt();
        }
        if (maxIdle == 0L) {
            intFlags |= Flag.DEFAULT_MAXIDLE.getFlagInt();
        }
        return intFlags;
    }

    public int flags() {
        Integer threadLocalFlags = this.flagsMap.get();
        this.flagsMap.remove();
        int intFlags = 0;
        if (threadLocalFlags != null) {
            intFlags |= threadLocalFlags.intValue();
        }
        if (this.forceReturnValue) {
            intFlags |= Flag.FORCE_RETURN_VALUE.getFlagInt();
        }
        return intFlags;
    }

    public void setFlags(Flag[] flags) {
        int intFlags = 0;
        for (Flag flag : flags) {
            intFlags |= flag.getFlagInt();
        }
        this.flagsMap.set(intFlags);
    }

    public void setFlags(int intFlags) {
        this.flagsMap.set(intFlags);
    }

    public boolean hasFlag(Flag flag) {
        Integer threadLocalFlags = this.flagsMap.get();
        return threadLocalFlags != null && (threadLocalFlags & flag.getFlagInt()) != 0;
    }

    public CacheTopologyInfo getCacheTopologyInfo() {
        return this.channelFactory.getCacheTopologyInfo(this.cacheNameBytes);
    }

    public Map<SocketAddress, Set<Integer>> getPrimarySegmentsByAddress() {
        return this.channelFactory.getPrimarySegmentsByAddress(this.cacheNameBytes);
    }

    public ConsistentHash getConsistentHash() {
        return this.channelFactory.getConsistentHash(this.cacheNameBytes);
    }

    public int getTopologyId() {
        return this.clientTopologyRef.get().getTopologyId();
    }

    public IterationStartOperation newIterationStartOperation(String filterConverterFactory, byte[][] filterParameters, IntSet segments, int batchSize, boolean metadata, DataFormat dataFormat, SocketAddress targetAddress) {
        return new IterationStartOperation(this.getCodec(), this.flags(), this.cfg, this.cacheNameBytes, this.clientTopologyRef, filterConverterFactory, filterParameters, segments, batchSize, this.channelFactory, metadata, dataFormat, targetAddress);
    }

    public IterationEndOperation newIterationEndOperation(byte[] iterationId, Channel channel) {
        return new IterationEndOperation(this.getCodec(), this.flags(), this.cfg, this.cacheNameBytes, this.clientTopologyRef, iterationId, this.channelFactory, channel);
    }

    public <K, E> IterationNextOperation<K, E> newIterationNextOperation(byte[] iterationId, Channel channel, KeyTracker segmentKeyTracker, DataFormat dataFormat) {
        return new IterationNextOperation(this.getCodec(), this.flags(), this.cfg, this.cacheNameBytes, this.clientTopologyRef, iterationId, channel, this.channelFactory, segmentKeyTracker, dataFormat);
    }

    public <K> GetStreamOperation newGetStreamOperation(K key, byte[] keyBytes, int offset) {
        return new GetStreamOperation(this.getCodec(), this.channelFactory, key, keyBytes, offset, this.cacheNameBytes, this.clientTopologyRef, this.flags(), this.cfg, this.clientStatistics);
    }

    public <K> PutStreamOperation newPutStreamOperation(K key, byte[] keyBytes, long version, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return new PutStreamOperation(this.getCodec(), this.channelFactory, key, keyBytes, this.cacheNameBytes, this.clientTopologyRef, this.flags(), this.cfg, version, lifespan, lifespanUnit, maxIdle, maxIdleUnit, this.clientStatistics, this.telemetryService);
    }

    public <K> PutStreamOperation newPutStreamOperation(K key, byte[] keyBytes, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return new PutStreamOperation(this.getCodec(), this.channelFactory, key, keyBytes, this.cacheNameBytes, this.clientTopologyRef, this.flags(), this.cfg, 0L, lifespan, lifespanUnit, maxIdle, maxIdleUnit, this.clientStatistics, this.telemetryService);
    }

    public <K> PutStreamOperation newPutIfAbsentStreamOperation(K key, byte[] keyBytes, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return new PutStreamOperation(this.getCodec(), this.channelFactory, key, keyBytes, this.cacheNameBytes, this.clientTopologyRef, this.flags(), this.cfg, -1L, lifespan, lifespanUnit, maxIdle, maxIdleUnit, this.clientStatistics, this.telemetryService);
    }

    public AuthMechListOperation newAuthMechListOperation(Channel channel) {
        return new AuthMechListOperation(this.getCodec(), this.clientTopologyRef, this.cfg, channel, this.channelFactory);
    }

    public AuthOperation newAuthOperation(Channel channel, String saslMechanism, byte[] response) {
        return new AuthOperation(this.getCodec(), this.clientTopologyRef, this.cfg, channel, this.channelFactory, saslMechanism, response);
    }

    public PrepareTransactionOperation newPrepareTransactionOperation(Xid xid, boolean onePhaseCommit, List<Modification> modifications, boolean recoverable, long timeoutMs) {
        return new PrepareTransactionOperation(this.getCodec(), this.channelFactory, this.cacheNameBytes, this.clientTopologyRef, this.cfg, xid, onePhaseCommit, modifications, recoverable, timeoutMs);
    }
}

